<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.migrate"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.postgres"></cv:cvMessages>
</script>
<span class="{{ctrl.serverMessage.type}}"
	data-ng-bind="ctrl.serverMessage.message"></span>

<div class="setup-title">
	<h1>
		<cv:msg key="label.registerInstance" bundle="migrate" />
	</h1>
</div>
<div class="setup-content"
	data-ng-controller="cloudDBCreateInstanceController as ctrl">
	<form name="discoverCloudInstance" novalidate autocomplete="off"
		data-cv-submit="ctrl.submitData()"
		data-cv-validate="ctrl.validateInputs(discoverCloudInstance)"
		data-ng-init="ctrl.init()" class="add-proxy-form form-horizontal bootstrap-wrapper">
		<div class="panel panel-default">
			<div class="panel-body">
				<div class="form-group">
					<label class="col-xs-12 col-sm-4" for="instanceName">
						<cv:msg key="label.name" bundle="capps" />
					</label>
					<label data-ng-if="!ctrl.instanceLoaded" class="col-xs-12 col-sm-8">
						<cv:msg key="Loading" bundle="messages" />
					</label>
					<div class="col-xs-12 col-sm-8" data-ng-if="ctrl.instanceLoaded">
						<isteven-multi-select
							id="cloudDBCreateInstance_isteven-multi-select_#3674"
							input-model="ctrl.instanceSelection.instances"
							output-model="ctrl.instanceSelection.selectedInstances"
							button-label="instanceName" item-label="instanceName"
							name="instanceName" translation="ctrl.instanceLocal"
							tick-property="selected"
							class="isteven-multi-select user-group-select"
							selection-mode="single"
							on-item-click="ctrl.instanceSelection.selectionChanged(ctrl.instanceSelection.selectedInstances[0])"
							required="true" helper-elements="filter"
							title="{{ctrl.instanceSelection.selectedInstances[0].instanceName}}">
						</isteven-multi-select>
						<span class="help-block"
							data-ng-show="cv.discoverCloudInstance.needsAttention(discoverCloudInstance.instanceName) && !ctrl.instanceSelection.validSelection">
							<cv:msg key="error.selectInstance" bundle="postgres" />
						</span>
						<span class="help-block" data-ng-show="ctrl.instanceErrorMessage && ctrl.instanceErrorMessage.length > 0"
							data-ng-bind="ctrl.instanceErrorMessage"> </span>
					</div>
				</div>

				<div class="form-group">
					<label class="col-xs-12 col-sm-4" for="plan">
						<cv:msg key="label.createBackupPlan" bundle="profiles" />
					</label>
					<label class="col-xs-12 col-sm-8" data-ng-if="!ctrl.planLoaded">
						<cv:msg key="Loading" bundle="messages" />
					</label>
					<div class="col-xs-12 col-sm-8" data-ng-if="ctrl.planLoaded">
						<isteven-multi-select
							id="cloudDBCreateInstance_isteven-multi-select_#3342"
							input-model="ctrl.planSelection.plans"
							output-model="ctrl.planSelection.selectedPlans"
							button-label="name" item-label="name" name="plan"
							translation="ctrl.planLocal" tick-property="selected"
							class="isteven-multi-select user-group-select"
							selection-mode="single"
							on-item-click="ctrl.planSelection.selectionChanged(ctrl.planSelection.selectedPlan[0])"
							helper-elements="filter" required="true" group-property="msGroup">
						</isteven-multi-select>
						<span class="help-block"
							data-ng-show="cv.discoverCloudInstance.needsAttention(discoverCloudInstance.plan) && !ctrl.planSelection.validSelection">
							<cv:msg key="error.selectPlan" bundle="profiles" />
						</span>
						<span class="help-block" data-ng-show="ctrl.planErrorMessage && ctrl.planErrorMessage.length > 0"
							data-ng-bind="ctrl.planErrorMessage"> </span>
					</div>
				</div>
				<h4>
					<cv:msg key="title.connectionDetails" bundle="cloudStorageApp" />
				</h4>

				<div data-ng-if="ctrl.isPostgreSQL" class="form-group">
					<label class="col-xs-12 col-sm-4" for="maintenanceDB">
						<cv:msg key="label.MaintenanceDB" bundle="postgres" />
					</label>
					<div class="col-xs-12 col-sm-8">
						<input type="text" name="maintenanceDB" id="maintenanceDB"
							data-ng-model="ctrl.instanceDetails[ctrl.instanceObjectName].MaintainenceDB"
							placeholder="<cv:msg key="error.maintenanceDB" bundle="postgres" />"
							data-ng-required="true" />
						<span class="help-block"
							data-ng-show="cv.discoverCloudInstance.needsAttention(discoverCloudInstance.maintenanceDB)">
							<cv:msg key="error.maintenanceDB" bundle="postgres" />
						</span>
					</div>
				</div>
				<div data-ng-if="ctrl.isMySQL" class="form-group">
					<label class="col-xs-12 col-sm-4" for="SSLCAFile"
						title="<cv:msg key="tooltip.sslCAFile" bundle="postgres" />">
						<cv:msg key="label.SSLCAFile" bundle="mySql" />
						<span class="optional-text">
							<cv:msg key="label.optional" bundle="subscriptions" />
						</span>
					</label>
					<div class="col-xs-12 col-sm-8">
						<input type="text" name="SSLCAFile" id="sslcaFile"
							data-ng-model="ctrl.instanceDetails.mySqlInstance.sslCa"
							data-ng-required="false"
							placeholder="<cv:msg key="error.enterPath" bundle="settingsJs" />"/>
					</div>
				</div>

				<!-- SQL start -->
				<div class="form-group" data-ng-if="ctrl.isSQLAmazon">
					<label class="col-xs-12 col-sm-4" for="s3BucketName">
						<cv:msg key="label.s3bucketName" bundle="sqlserver" />
					</label>
					<div class="col-xs-12 col-md-8">
						<input type="text" id="s3BucketName" name="s3BucketName"
							data-ng-required="!ctrl.data.isSQLCloudConfigured"
							data-ng-model="ctrl.instanceDetails[ctrl.instanceObjectName].awsSqlInfo.s3BucketName"
							placeholder="{{ctrl.data.isSQLCloudConfigured ? ctrl.sqlCloudPlaceholder : '<cv:msg key="error.s3bucketName" bundle="sqlserver" />'}}" />
						<span class="help-block"
							data-ng-show="cv.discoverCloudInstance.needsAttention(discoverCloudInstance.s3BucketName)">
							<cv:msg key="error.s3bucketName" bundle="sqlserver" />
						</span>
					</div>
				</div>
				<div class="form-group " data-ng-if="ctrl.isSQLAzure">
					<label class="col-xs-12 col-sm-4"
						for="azureStorageConnectionString">
						<cv:msg key="label.azureStorageConnectionString"
							bundle="sqlserver" />
					</label>
					<div class="col-xs-12 col-sm-8">
						<textarea class="textarea" id="azureStorageConnectionString"
							name="azureStorageConnectionString"
							data-ng-required="!ctrl.data.isSQLCloudConfigured"
							data-ng-model="ctrl.instanceDetails[ctrl.instanceObjectName].azureInfo.azureStorageConnectionString"
							placeholder="{{ctrl.data.isSQLCloudConfigured ? ctrl.sqlCloudPlaceholder : '<cv:msg key="error.azureStorageConnectionString" bundle="sqlserver" />'}}"></textarea>
						<span class="help-block"
							data-ng-show="cv.discoverCloudInstance.needsAttention(discoverCloudInstance.azureStorageConnectionString)">
							<cv:msg key="error.azureStorageConnectionString" bundle="sqlserver" />
						</span>
					</div>
				</div>
				<!-- SQL END -->

				<div class="form-group">

					<label class="col-xs-12 col-sm-4" for="dbUser">
						<cv:msg key="label.userName" bundle="servers" />
					</label>

					<div class="col-xs-12 col-sm-8">
						<input type="text" name="dbUser" id="dbUser"
							data-ng-model="ctrl.instanceDetails[ctrl.instanceObjectName].SAUser.userName"
							data-ng-required="true"
							placeholder="<cv:msg key="error.userName" bundle="users" />" />
						<span class="help-block"
							data-ng-show="cv.discoverCloudInstance.needsAttention(discoverCloudInstance.dbUser) || ctrl.error.userName">
							<cv:msg key="error.dbUser" bundle="postgres" />
						</span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-sm-4" for="dbPassword">
						<cv:msg key="label.dbPassword" bundle="postgres" />
					</label>
					<div class="col-xs-12 col-sm-8">
						<input type="password" name="dbPassword" id="dbPassword"
							data-ng-model="ctrl.instanceDetails[ctrl.instanceObjectName].SAUser.passwordString"
							data-ng-required="true"
							placeholder="<cv:msg key="error.password" bundle="users" />" />
						<span class="help-block"
							data-ng-show="cv.discoverCloudInstance.needsAttention(discoverCloudInstance.dbPassword) || ctrl.error.passwordString">
							<cv:msg key="error.password" bundle="users" />
						</span>
					</div>
				</div>

				<div class="form-group">
					<label class="col-xs-12 col-sm-4" for="dbConfirmPassword">
						<cv:msg key="label.confirmPassword" bundle="servers" />
					</label>
					<div class="col-xs-12 col-sm-8">
						<input type="password" name="dbConfirmPassword" id="dbConfirmPassword"
							data-ng-model="ctrl.instanceDetails[ctrl.instanceObjectName].SAUser.confirmPasswordString"
							data-ng-required="true"
							placeholder="<cv:msg key="error.confirmPassword" bundle="users" />" />

						<span class="help-block"
							data-ng-show="cv.discoverCloudInstance.needsAttention(discoverCloudInstance.dbConfirmPassword) || ctrl.error.confirmPasswordString">
							<cv:msg key="error.confirmPassword" bundle="users" />
						</span>

						<span class="help-block"
							data-ng-show="ctrl.instanceDetails[ctrl.instanceObjectName].SAUser.passwordString != ctrl.instanceDetails[ctrl.instanceObjectName].SAUser.confirmPasswordString
								&& ctrl.error.passwordMismatch">
							<cv:msg key="error.mismatchedPassword" bundle="users" />
						</span>
					</div>
				</div>

				<div class="button-container padding-top-20 padding-bottom-20">
					<button id="cloudMigrate_button_#5039" type="button"
						class="btn btn-default cvBusyOnAjax" data-ng-click="ctrl.closeDialogBox()">
						<cv:msg key="Cancel" bundle="messages" />
					</button>
					<button id="cloudMigrate_button_#5401" type="submit"
						class="btn btn-primary cvBusyOnAjax">
						<cv:msg key="Add" bundle="messages" />
					</button>
				</div>
			</div>
		</div>
	</form>
</div>