<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.postgres"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.mySql"></cv:cvMessages>
</script>
		<span data-ng-if="!cloudDBInstanceCtrl.isGenericScreen" class="{{cloudDBInstanceCtrl.serverMessage.type}}" data-ng-bind="cloudDBInstanceCtrl.serverMessage.message"></span>
<form name="addPostgreCloudDBSQLInstance" novalidate autocomplete="off"
	data-cv-submit="cloudDBInstanceCtrl.submitData()"
	data-cv-validate="cloudDBInstanceCtrl.validateInputs(addPostgreCloudDBSQLInstance)"
	data-ng-init="cloudDBInstanceCtrl.init()">
	<div class="form-group"
		data-ng-if="!cloudDBInstanceCtrl.isGenericScreen">
		<label class="col-xs-12 col-sm-5" for="accountName"> <cv:msg
				key="label.cloudAccount" bundle="postgres" />
		</label> <label data-ng-if="cloudDBInstanceCtrl.edit"
			class="col-xs-12 col-sm-7" name="accountName">
			{{cloudDBInstanceCtrl.instance.clientName}} </label>
		<div data-ng-if="!cloudDBInstanceCtrl.edit"
			class="col-xs-11 col-sm-6 text-overflow-allowed">
			<isteven-multi-select
				id="cloudDBCreateInstance_isteven-multi-select_#1461"
				input-model="cloudDBInstanceCtrl.clientSelection.clients"
				output-model="cloudDBInstanceCtrl.clientSelection.selectedClients"
				button-label="displayName" item-label="displayName"
				name="accountName" translation="cloudDBInstanceCtrl.clientLocal"
				tick-property="selected"
				class="isteven-multi-select user-group-select"
				selection-mode="single"
				on-item-click="cloudDBInstanceCtrl.clientSelection.selectionChanged(cloudDBInstanceCtrl.clientSelection.selectedClients[0])"
				required="true" helper-elements="filter"> </isteven-multi-select>
			<span class="help-block"
				data-ng-show="cv.addPostgreCloudDBSQLInstance.needsAttention(addPostgreCloudDBSQLInstance.accountName) && !cloudDBInstanceCtrl.clientSelection.validSelection">
				<cv:msg key="error.selectCloudDb" bundle="postgres" />
			</span>
		</div>
		<div data-ng-if="!cloudDBInstanceCtrl.edit"
			class="col-xs-1 margin-top-10">
			<a href="" data-ng-click="cloudDBInstanceCtrl.addHypervisorDialog()"><cv:msg
					key="Add" bundle="messages" /></a>
		</div>
	</div>
	<div class="form-group">
		<label class="col-xs-12 col-sm-5" for="instanceName"> <cv:msg
				key="label.instanceName" bundle="postgres" />
		</label> <label data-ng-show="!cloudDBInstanceCtrl.instanceLoaded"
			class="col-xs-12 col-sm-7"> <cv:msg key="Loading"
				bundle="messages" />
		</label> <label data-ng-if="cloudDBInstanceCtrl.edit"
			class="col-xs-12 col-sm-7" name="instanceName">
			{{cloudDBInstanceCtrl.instance.instanceName}} </label>
		<div
			data-ng-show="!cloudDBInstanceCtrl.edit && cloudDBInstanceCtrl.instanceLoaded"
			class="col-xs-12 col-sm-7"
			data-ng-disabled="cloudDBInstanceCtrl.clientSelection.selectedClients.length===0">
			<isteven-multi-select
				id="cloudDBCreateInstance_isteven-multi-select_#3674"
				input-model="cloudDBInstanceCtrl.instanceSelection.instances"
				output-model="cloudDBInstanceCtrl.instanceSelection.selectedInstances"
				button-label="instanceName" item-label="instanceName"
				name="instanceName" translation="cloudDBInstanceCtrl.instanceLocal"
				tick-property="selected"
				class="isteven-multi-select user-group-select"
				selection-mode="single"
				on-item-click="cloudDBInstanceCtrl.instanceSelection.selectionChanged(cloudDBInstanceCtrl.instanceSelection.selectedInstances[0])"
				required="true" helper-elements="filter"
				title="{{cloudDBInstanceCtrl.instanceSelection.selectedInstances[0].instanceName}}">
			</isteven-multi-select>
			<span class="help-block"
				data-ng-show="cloudDBInstanceCtrl.error.instance">
				<cv:msg key="error.selectInstance" bundle="postgres" />
			</span>
			<span class="help-block"
				data-ng-show="cloudDBInstanceCtrl.instanceErrorMessage && cloudDBInstanceCtrl.instanceErrorMessage.length > 0" data-ng-bind="cloudDBInstanceCtrl.instanceErrorMessage">
			</span>
		</div>
	</div>
	<div class="form-group"
		data-ng-if="!cloudDBInstanceCtrl.isGenericScreen">
		<label class="col-xs-12 col-sm-5" for="plan"> <cv:msg
				key="label.plan" bundle="postgres" />
		</label>

		<label class="col-xs-12 col-sm-7" data-ng-if="!cloudDBInstanceCtrl.planLoaded">
						<cv:msg key="Loading" bundle="messages" />
					</label>

		<div class="col-xs-12 col-sm-7" data-ng-if="cloudDBInstanceCtrl.planLoaded">
			<isteven-multi-select
				id="cloudDBCreateInstance_isteven-multi-select_#3342"
				input-model="cloudDBInstanceCtrl.planSelection.plans"
				output-model="cloudDBInstanceCtrl.planSelection.selectedPlans"
				button-label="name" item-label="name" name="plan"
				translation="cloudDBInstanceCtrl.planLocal" tick-property="selected"
				class="isteven-multi-select user-group-select"
				selection-mode="single"
				on-item-click="cloudDBInstanceCtrl.planSelection.selectionChanged(cloudDBInstanceCtrl.planSelection.selectedPlan[0])"
				helper-elements="filter" required="true" group-property="msGroup">
			</isteven-multi-select>
			<span class="help-block"
				data-ng-show="cv.addPostgreCloudDBSQLInstance.needsAttention(addPostgreCloudDBSQLInstance.plan) && !cloudDBInstanceCtrl.planSelection.validSelection">
				<cv:msg key="error.selectPlan" bundle="profiles" />
			</span>
			<span class="help-block" data-ng-show="cloudDBInstanceCtrl.planErrorMessage && cloudDBInstanceCtrl.planErrorMessage.length > 0"
							data-ng-bind="ctrl.planErrorMessage"> </span>
		</div>
	</div>

	<div ng-if="cloudDBInstanceCtrl.isGCPSpanner">
		<gcp-staging-bucket-input input-options="cloudDBInstanceCtrl.stagingBucketInputOptions.inputOptions" form-name="addPostgreCloudDBSQLInstance" selected-instance="cloudDBInstanceCtrl.stagingBucketInputOptions.selectedInstance" />
	</div>

	<uib-accordion close-others="false" class="text-left">
	<div uib-accordion-group is-open="cloudDBInstanceCtrl.openAccordion"
		class="panel form-panel-holder" data-scroll-to-when-open ng-if="!cloudDBInstanceCtrl.isGCPSpanner">
		<uib-accordion-heading> <cv:msg
			key="title.connectionDetails" bundle="cloudStorageApp" /> <i
			class="float-right glyphicon"
			data-ng-class="{'glyphicon-chevron-down': cloudDBInstanceCtrl.openAccordion, 'glyphicon-chevron-right': !cloudDBInstanceCtrl.openAccordion}"></i>
		</uib-accordion-heading>

		<!-- SQL start -->
		<div class="form-group" data-ng-if="cloudDBInstanceCtrl.isSQLAmazon">
			<label class="col-xs-12 col-sm-5" for="s3BucketName"> <cv:msg
					key="label.s3bucketName" bundle="sqlserver" />
			</label>
			<div class="col-xs-12 col-md-7">
				<input type="text" id="s3BucketName" name="s3BucketName"
					data-ng-required="!cloudDBInstanceCtrl.data.isSQLCloudConfigured"
					data-ng-model="cloudDBInstanceCtrl.instanceDetails[cloudDBInstanceCtrl.instanceObjectName].awsSqlInfo.s3BucketName"
					placeholder="{{cloudDBInstanceCtrl.data.isSQLCloudConfigured ? cloudDBInstanceCtrl.sqlCloudPlaceholder : '<cv:msg key="error.s3bucketName" bundle="sqlserver" />'}}"/>
				<span class="help-block"
					data-ng-show="cloudDBInstanceCtrl.error.s3BucketName">
					<cv:msg key="error.s3bucketName" bundle="sqlserver" />
				</span>
			</div>
		</div>
		<div class="form-group " data-ng-if="cloudDBInstanceCtrl.isSQLAzure">
			<label class="col-xs-12 col-sm-5" for="azureStorageConnectionString">
				<cv:msg key="label.azureStorageConnectionString" bundle="sqlserver" />
			</label>
			<div class="col-xs-12 col-sm-7">
				<textarea class="textarea" id="azureStorageConnectionString"
					name="azureStorageConnectionString" data-ng-required="!cloudDBInstanceCtrl.data.isSQLCloudConfigured"
					data-ng-model="cloudDBInstanceCtrl.instanceDetails[cloudDBInstanceCtrl.instanceObjectName].azureInfo.azureStorageConnectionString"
					placeholder="{{cloudDBInstanceCtrl.data.isSQLCloudConfigured ? cloudDBInstanceCtrl.sqlCloudPlaceholder : '<cv:msg key="error.azureStorageConnectionString" bundle="sqlserver" />'}}"></textarea>
				<span class="help-block"
					data-ng-show="cloudDBInstanceCtrl.error.azureStorageConnectionString">
					<cv:msg key="error.azureStorageConnectionString" bundle="sqlserver" />
				</span>
			</div>
		</div>
		<!-- SQL END -->

		<!-- ORACLE START -->
		<div class="form-group connection-string" data-ng-if="cloudDBInstanceCtrl.isOracle">
			<input id="dbUserName" name="dbUserName" type="text" placeholder='<cv:msg key="label.userName" bundle="users"/>' data-ng-model="cloudDBInstanceCtrl.instanceDetails[cloudDBInstanceCtrl.instanceObjectName].dbUserName" data-ng-change="validateConnectString()">
			<label for="dbPassword" > / </label>
			<input id="dbPassword" name="dbPassword" type="password" placeholder='<cv:msg key="label.password" bundle="users"/>' data-ng-model="cloudDBInstanceCtrl.instanceDetails[cloudDBInstanceCtrl.instanceObjectName].dbPassword" data-ng-change="validateConnectString()">
			<label for="dbPassword"> @ </label>
			<input data-ng-disabled id="dbInstanceName" name="dbInstanceName" type="text" placeholder='<cv:msg key="label.serviceName" bundle="oracle"/>' title="{{cloudDBInstanceCtrl.instanceDetails[cloudDBInstanceCtrl.instanceObjectName].domainName}}"
				data-ng-model="cloudDBInstanceCtrl.instanceDetails[cloudDBInstanceCtrl.instanceObjectName].domainName" >
			<span class="help-block ng-hide" data-ng-show="cv.addPostgreCloudDBSQLInstance.getAttempted() &&  !cloudDBInstanceCtrl.isConnectValidate">
				<cv:msg key="error.connectString" bundle="oracle"/>
			</span>
		</div>
		<!-- ORACLE END -->

		<div class="form-group" data-ng-if="!cloudDBInstanceCtrl.isOracle">
			<label class="col-xs-12 col-sm-5" for="dbUser" data-ng-if="!cloudDBInstanceCtrl.isSQLServer">
				<cv:msg key="label.dbUser" bundle="postgres" />
			</label>

			<label class="col-xs-12 col-sm-5" for="dbUser" data-ng-if="cloudDBInstanceCtrl.isSQLServer">
				<cv:msg key="label.userName" bundle="servers" />
			</label>

			<div class="col-xs-12 col-sm-7">
				<input type="text" name="dbUser"
					data-ng-model="cloudDBInstanceCtrl.instanceDetails[cloudDBInstanceCtrl.instanceObjectName].SAUser.userName"
					data-ng-required="!cloudDBInstanceCtrl.data.isSQLCloudConfigured"
					placeholder="{{cloudDBInstanceCtrl.data.isSQLCloudConfigured ? cloudDBInstanceCtrl.sqlCloudPlaceholder : '<cv:msg key="error.userName" bundle="users" />'}}" />
				<span class="help-block"
					data-ng-show="cv.addPostgreCloudDBSQLInstance.needsAttention(addPostgreCloudDBSQLInstance.dbUser)
					&& !cloudDBInstanceCtrl.isSQLServer || cloudDBInstanceCtrl.error.userName">
					<cv:msg key="error.dbUser" bundle="postgres" />
				</span>
			</div>
		</div>
		<div class="form-group" data-ng-if="!cloudDBInstanceCtrl.isOracle">
			<label class="col-xs-12 col-sm-5" for="dbPassword"> <cv:msg
					key="label.dbPassword" bundle="postgres" />
			</label>
			<div class="col-xs-12 col-sm-7">
				<input type="password" name="dbPassword"
					data-ng-model="cloudDBInstanceCtrl.instanceDetails[cloudDBInstanceCtrl.instanceObjectName].SAUser.passwordString"
					data-ng-required="!cloudDBInstanceCtrl.edit && !cloudDBInstanceCtrl.data.isSQLCloudConfigured"
					placeholder="{{cloudDBInstanceCtrl.edit ? '<cv:msg key="placeholder.editUserPassword" bundle="users" />' :
					cloudDBInstanceCtrl.data.isSQLCloudConfigured ? cloudDBInstanceCtrl.sqlCloudPlaceholder : '<cv:msg key="error.password" bundle="users" />' }}" />
				<span class="help-block"
					data-ng-show="cv.addPostgreCloudDBSQLInstance.needsAttention(addPostgreCloudDBSQLInstance.dbPassword)
					&& !cloudDBInstanceCtrl.isSQLServer || cloudDBInstanceCtrl.error.passwordString">
					<cv:msg key="error.password" bundle="users" />
				</span>
			</div>
		</div>

		<div class="form-group" data-ng-if="!cloudDBInstanceCtrl.isOracle && !cloudDBInstanceCtrl.edit">
			<label class="col-xs-12 col-sm-5" for="dbConfirmPassword">
				<cv:msg key="label.confirmPassword" bundle="servers" />
			</label>
			<div class="col-xs-12 col-sm-7">
				<input type="password" name="dbConfirmPassword"
					data-ng-model="cloudDBInstanceCtrl.instanceDetails[cloudDBInstanceCtrl.instanceObjectName].SAUser.confirmPasswordString"
					data-ng-required="!cloudDBInstanceCtrl.data.isSQLCloudConfigured"
					placeholder="{{cloudDBInstanceCtrl.data.isSQLCloudConfigured ? cloudDBInstanceCtrl.sqlCloudPlaceholder : '<cv:msg key="error.confirmPassword" bundle="users" />' }}" />
				<span class="help-block"
					data-ng-show="cv.addPostgreCloudDBSQLInstance.needsAttention(addPostgreCloudDBSQLInstance.dbConfirmPassword)
					&& !cloudDBInstanceCtrl.isSQLServer || cloudDBInstanceCtrl.error.confirmPasswordString">
					<cv:msg key="error.confirmPassword" bundle="users" />
				</span>
				<span class="help-block"
					data-ng-show="cloudDBInstanceCtrl.error.passwordMismatch">
					<cv:msg key="error.mismatchedPassword" bundle="users" />
				</span>
			</div>
		</div>

		<div data-ng-if="cloudDBInstanceCtrl.isPostgreSQL" class="form-group">
			<label class="col-xs-12 col-sm-5" for="maintenanceDB"> <cv:msg
					key="label.MaintenanceDB" bundle="postgres" />
			</label>
			<div class="col-xs-12 col-sm-7">
				<input type="text" name="maintenanceDB"
					data-ng-model="cloudDBInstanceCtrl.instanceDetails.postGreSQLInstance.MaintainenceDB"
					data-ng-required="true" /> <span class="help-block"
					data-ng-show="cv.addPostgreCloudDBSQLInstance.needsAttention(addPostgreCloudDBSQLInstance.maintenanceDB)">
					<cv:msg key="error.maintenanceDB" bundle="postgres" />
				</span>
			</div>
		</div>
		<div data-ng-if="cloudDBInstanceCtrl.isMySQL" class="form-group">
			<label class="col-xs-12 col-sm-5" for="SSLCAFile" title="<cv:msg key="tooltip.sslCAFile" bundle="postgres" />">
				<cv:msg key="label.SSLCAFile" bundle="mySql" />
				<span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions" /></span>
			</label>
			<div class="col-xs-12 col-sm-7">
				<input type="text" name="SSLCAFile"
					data-ng-model="cloudDBInstanceCtrl.instanceDetails.mySqlInstance.sslCa" />
			</div>
		</div>
		<div class="form-group" data-ng-if="(cloudDBInstanceCtrl.isMySQL || cloudDBInstanceCtrl.isPostgreSQL)" >
            <label class="col-xs-12 col-sm-5" for="dbPort">
            	<cv-help-text help-label="<cv:msg key="label.Endpoint" bundle="mySql"/>" help-text="'<cv:msg key='info.endPoint' bundle='mySql' />'"></cv-help-text>
				<span data-ng-if="!cloudDBInstanceCtrl.edit" class="optional-text"><cv:msg key="label.optional" bundle="subscriptions" /></span>
            </label>
            <div class="col-xs-12 col-sm-7">
                <input type="text" id="dbPort" uib-tooltip="{{cloudDBInstanceCtrl.instanceDetails.dbPort}}"  name="dbPort" data-ng-model="cloudDBInstanceCtrl.instanceDetails.dbPort" data-ng-required="cloudDBInstanceCtrl.edit" data-ng-pattern="cloudDBInstanceCtrl.portPattern"/>
                <span class="help-block" data-ng-show="cloudDBInstanceCtrl.edit && cv.addPostgreCloudDBSQLInstance.needsAttention(addPostgreCloudDBSQLInstance.dbPort)">
                    <cv:msg key="error.endPoint" bundle="mySql"/>
                </span>
            </div>
        </div>
	</div>
	</uib-accordion>
	<div class="modal-footer">
		<button id="cloudDBCreateInstance_button_#2912" type="button"
			class="btn btn-default cvBusyOnAjax"
			data-ng-click="cloudDBInstanceCtrl.closeDialogBox()">
			<cv:msg key="Cancel" bundle="messages" />
		</button>
		<button id="cloudDBCreateInstance_button_#4049" type="submit"
			class="btn btn-primary cvBusyOnAjax"
			data-ng-show="!cloudDBInstanceCtrl.edit">
			<cv:msg key="Add" bundle="messages" />
		</button>
		<button id="cloudDBCreateInstance_button_#7363" type="submit"
			class="btn btn-primary cvBusyOnAjax"
			data-ng-show="cloudDBInstanceCtrl.edit">
			<cv:msg key="Save" bundle="messages" />
		</button>
	</div>
</form>
