<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="header.backupOptions" bundle="servers"/></h1>
</div>
<div class="setup-content backup-options">
	<span data-ng-show="backupJobId">
		<div class="global-options remove-border-padding">
			<cv:msg key="notification.backup.started" bundle="serversJs"/> {{backupJobId}}.<a data-ng-click='goToJob()'> <cv:msg key="notification.jobDetails" bundle="serversJs"/></a>
		</div>
	</span>
	<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
	<span data-ng-show="!backupMsg">
		<div class="global-options remove-border-padding">
			<label><cv:msg key="label.backupLevel" bundle="servers"/></label>
		</div>
			
		<div class="global-options remove-border-padding form-panel-holder">
			<label class="element-indent-class">
				<input type="radio" ng-model="backupType" value="FULL">
				<cv:msg key="option.full" bundle="schedule"/>
			</label>
				
			<label class="element-indent-class">
				<input type="radio" ng-model="backupType" value="INCREMENTAL">
				<cv:msg key="option.incremental" bundle="schedule"/>
			</label>
				
		</div>
	</span>
			
	<div class="button-container">
		<button id="backupOptions_button_#1421" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-show="backupMsg" data-ng-click="cancel()"><cv:msg key="OK" bundle="messages"/></button> 
		<button id="backupOptions_button_#0404" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-show="!backupMsg" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages"/></button> 
		<button id="backupOptions_button_#4219" type="button" class="btn btn-primary cvBusyOnAjax"  data-ng-class="{'busy':loading}" data-ng-show="!backupMsg" data-ng-click="startBackup()"><cv:msg key="OK" bundle="messages"/></button> 
	</div>
</div>