<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
</script>
<div  class="setup-content" >
<div class="{{backupContentMessage.type}} serverMessage">{{backupContentMessage.message}}</div>
<h1>{{steps[getCurrentStep()].name}}</h1>
<div class="panel form-panel-holder page-detail-column-strap">
<div class="row">
	<cv-tile-component data-ac-id="label_sourDetails-oracle" data-title='<cv:msg key="label.sourDetails" bundle="oracle"/>'>
		<ul class="list-style-secondary" >
			<cv-tile-label-value label='<cv:msg key="label.clientName" bundle="oracle"/>' value="{{entity.clientName}}" ></cv-tile-label-value>
			<cv-tile-label-value label="<cv:msg key="label.appType" bundle="dbs"/>" value="{{entity.appName}}" ></cv-tile-label-value>
			<cv-tile-label-value label='<cv:msg key="label.instanceName" bundle="clients"/>' value="{{entity.instanceName}}" ></cv-tile-label-value>
			<cv-tile-label-value label='<cv:msg key="label.osType" bundle="serversJs"/>' value="{{osInfo.SubType}}" ></cv-tile-label-value>
			<cv-tile-label-value label='<cv:msg key="header.Version" bundle="clients" />' value="{{instanceDetails.version}}" ></cv-tile-label-value>
			<li  class="group" ng-show="isCrossPlatfrom">
				<span class="pageDetailColumn"><cv:msg key="label.convertStaging" bundle="oracle"/></span>
				<span class="pageDetailColumn browse-input-holder">
					<input type="text" id="stagingPath" name="stagingPath" data-ng-required="true" style="width: 65%;"
						data-ng-model="appMigrate.stagingPath"/>
						<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>'
						client-id='{{entity.clientId}}' result-function="stagingPathResuleFunction"/>
				</span>
			</li>
		</ul>
	</cv-tile-component>
	<cv-tile-component data-ac-id="label_destDetails-oracle" data-title='<cv:msg key="label.destDetails" bundle="oracle"/>'>
		<ul class="list-style-secondary" >
			<li class="group">
				<span class="pageDetailColumn">
					<label class="page-detail-label" for="preRegistore">
						<cv:msg key="label.userPreRegister" bundle="oracle"/>
					</label>
				</span>
				<span class="pageDetailColumn">
					<input type="checkbox"
							id="preRegistore"
							name="preRegistore"
							data-ng-change="registoredServerChanged()"
							data-ng-model="appMigrate.preRegistore" /><label for="preRegistore" class="margin-left-0">&nbsp;</label>
				</span>
			</li>
			<li class="group" data-ng-if="appMigrate.preRegistore" data-ng-init="populatProxyClients()">
				<span class="pageDetailColumn"><label class="page-detail-label" for="registoredServers"><cv:msg key="label.regServer" bundle="oracle"/></label></span>
				<span class="pageDetailColumn select-label">
					<select name="registoredServers" id="registoredServers"
						data-ng-options="pClient.label as pClient.label for pClient in proxyClients"
						data-ng-model="appMigrate.cloudMachineName"  >
					</select>
					<span class="help-block" data-ng-show="errors.registoredServers">
						 <cv:msg key="error.regServer" bundle="oracle"/>
					</span>
				</span>
			</li>
			<li class="group" data-ng-if="!appMigrate.preRegistore">
				<span class="pageDetailColumn"><label class="page-detail-label" for="cloudType"><cv:msg key="label.cloudType" bundle="oracle"/></label></span>
				<span class="pageDetailColumn select-label">
					<select name="cloudType" id="cloudType"
						data-ng-options="cloud.cloudId as cloud.name for cloud in cloudTypes"
						data-ng-change="cloudTypechange(appMigrate.cloudType)"
						data-ng-model="appMigrate.cloudType" >
						<option value=""><cv:msg key="options.cloudType" bundle="oracle"/></option>
					</select>
					<span class="help-block" data-ng-show="errors.cloudType">
						<cv:msg key="error.cloudType" bundle="oracle"/>
					</span>
				</span>
			</li>
			<li class="group" data-ng-if="!appMigrate.preRegistore">
				<span class="pageDetailColumn"><label class="page-detail-label" for="AllocPolicyId"><cv:msg key="label.policyName" bundle="oracle"/></label></span>
				<span class="pageDetailColumn select-label">
					<select name="AllocPolicyId" id="AllocPolicyId"
						data-ng-options="policy.entity.vmAllocPolicyId as policy.entity.vmAllocPolicyName for policy in policyList | orderBy:'policy.entity.vmAllocPolicyName'"
						data-ng-change="policyChanged()"
						data-ng-model="appMigrate.policyId"  class="input">
						<option value=""><cv:msg key="options.policyName" bundle="oracle"/></option>
					</select>
					<span class="help-block" data-ng-show="errors.policyName">
						 <cv:msg key="error.policyName" bundle="oracle"/>
					</span>
				</span>
			</li>
			<li class="group" data-ng-if="!appMigrate.preRegistore && !isOracleAsService" >
				<span class="pageDetailColumn">
					<label class="page-detail-label" for="oraHomeText">
						<cv:msg key="label.cloudCompute" bundle="oracle"/>
					</label>
				</span>
				<span class="pageDetailColumn select-label">
					<div uib-dropdown class="uib-dropdown" on-toggle="toggled(open)" style="position: initial;" >
					      <span class="uib-dropdown-toggle" uib-dropdown-toggle>
					      	<input style="cursor: pointer;" title="" type="text" id="oraHomeText" name="oraHomeText" data-ng-model="appMigrate.vmNameText" ng-change="updateOptions(null)" />
					      </span>
					      <ul uib-dropdown-menu class="dropdown-menustorage  dropdown-fixed" >
					      	<li data-ng-repeat="vms in vmsList" data-ng-click="updateOptions(vms)"><a title="{{vms.vm.vmName}}" heref="javascript:void(0);">{{vms.vm.vmName}}</a></li>
					      </ul>
					</div>
					<span class="help-block" data-ng-show="errors.instanceName">
						<span ><cv:msg key="error.instanceName" bundle="oracle"/></span>
					</span>
				</span>
			</li>
			<li class="group" data-ng-if="!appMigrate.preRegistore && isOracleAsService">
				<span class="pageDetailColumn">
					<label class="page-detail-label" for="serviceName">
						<cv:msg key="label.serviceName" bundle="oracle"/>
						<cv-help-component help-text="<cv:msg key="label.serviceNameHint" bundle="oracle" />"></cv-help-component>
					</label>
				</span>
				<span class="pageDetailColumn">
					<input title="" type="text" id="serviceName" name="serviceName" data-ng-model="appMigrate.vmNameText" ng-change="updateOptions(null)" />
					<span class="help-block" data-ng-show="errors.instanceName">
						<span ><cv:msg key="error.serviceName" bundle="oracle"/></span>
					</span>
				</span>
			</li>
			<cv-tile-label-value data-ng-if="!appMigrate.preRegistore" data-ng-hide="isOracleAsService" label="<cv:msg key="label.instanceName" bundle="clients"/>" value="{{entity.instanceName}}" ></cv-tile-label-value>
			<cv-tile-label-value label="<cv:msg key="label.osType" bundle="serversJs"/>" value="{{getDestOsType()}}" ></cv-tile-label-value>
		</ul>
	</cv-tile-component>
<div class="button-container">
	<button id="appMigrationGeneralPage_button_#5866" type="button" title="<cv:msg key='action.next' bundle='profiles' />" data-ng-disabled="disableNext" data-ng-click="saveGeneralPage()" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.next" bundle="profiles" /></button> 
</div>
</div>
</div>
</div>
