<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.db2"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1 ><cv:msg key="heading.addDB2PartitionNode" bundle="db2"/></h1>
</div>
<div class="bootstrap-wrapper form-horizontal" >
	<form name="addDB2Partitions" novalidate data-cv-submit="addDB2PartitionNodeList.addPartitionNode()" autocomplete="off">
		<span class="{{addDB2PartitionNodeList.serverMessage.type}}" data-ng-bind="addDB2PartitionNodeList.serverMessage.message"></span>
		<div class="panel panel-default">
			<div class="panel-body">
				<div class="form-group">
					<label class="col-xs-12 col-lg-5" for="hostName">
						<cv:msg key="label.clientName" bundle="clients"/>
					</label>
					<div class="col-xs-12 col-lg-7 text-overflow-allowed">
						<cv-client-picker selected-clients="addDB2PartitionNodeList.clientSelection.selectedClients" clients-loaded="addDB2PartitionNodeList.clientSelection.clientLoaded(listOfClients)" valide-client-selection="addDB2PartitionNodeList.clientSelection.valideClientSelection" selection-changed="addDB2PartitionNodeList.clientSelection.selectionChanged(clientEntity)" app-id="62"  ></cv-client-picker>
						<span class="help-block" data-ng-show="cv.Oracleinstance.getAttempted() && !addDB2PartitionNodeList.clientSelection.valideClientSelection" >
							<cv:msg key="option.db2MultiNode" bundle="db2"/>
						</span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-5" for="db2Home">
						<cv:msg key="label.db2Home" bundle="db2"/>
					</label>
					<div class="col-xs-12 col-lg-7">
						<div class="input-group">
							<input type="text" id="db2Home" name="db2Home" data-ng-required="true" data-ng-model="addDB2PartitionNodeList.partitionInfo.db2Home"/>
							<span class="input-group-btn">
								<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>'
									client-id='{{addDB2PartitionNodeList.partitionInfo.selectedClient.clientId}}' result-function="addDB2PartitionNodeList.db2HomeResuleFunction"/>
							</span>
						</div>
						<span class="help-block" data-ng-show="cv.addDB2Partitions.needsAttention(addDB2Partitions.db2Home);" >
							<cv:msg key="error.db2Home" bundle="db2"/>
						</span>
					</div>
				</div>
			</div>
		</div>
		<div class="modal-footer">
	  		<button id="addDB2PartitionNodes_Cancel_button" type="button" class="btn cvBusyOnAjax" data-ng-click="addDB2PartitionNodeList.closeDialogBox()">
	  			<cv:msg key="Cancel" bundle="messages"/>
  			</button>
	  		<button id="addDB2PartitionNodes_Add_button" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-class="{'busy':addDB2PartitionNodeList.loading}">
	  			<span > <cv:msg key="Add" bundle="messages"/> </span>
	  		</button>
		</div>
	</form>
</div>
