<div>
    <div class="form-group">
        <label class="col-xs-12 col-sm-5" ng-bind="'label.instance' | cvLoc"></label>
        <div class="col-xs-12 col-sm-7">
            <div ng-show="GCPSpannerCtrl.instances">
                <isteven-multi-select
                    input-model="GCPSpannerCtrl.instances"
                    output-model="GCPSpannerCtrl.selectedInstance"
                    button-label="name"
                    item-label="name"
                    directive-id="gcpInstancesList"
                    tick-property="selected"
                    selection-mode="single"
                    prevent-sort="true"
                    class="isteven-multi-select user-group-select single-select"
                    translation="GCPSpannerCtrl.instancesLoc"
                    is-required="true"
                    on-item-click="GCPSpannerCtrl.onInstanceChanged(data)">
                </isteven-multi-select>
            </div>
            <div ng-show="!GCPSpannerCtrl.instances" class="text-center margin-top-10">
                <img src="img/loading.gif" alt="loader" />
            </div>
            <span class="help-block" ng-if="GCPSpannerCtrl.errorMessages.instances" ng-bind="GCPSpannerCtrl.errorMessages.instances"></span>
            <span class="help-block" ng-if="GCPSpannerCtrl.formName.$submitted && !GCPSpannerCtrl.selectedInstance.length">Please select an instance</span>
        </div>
    </div> 

    <div class="margin-bottom-20" ng-if="GCPSpannerCtrl.showDatabases">
        <gcp-staging-bucket-input input-options="GCPSpannerCtrl.GCPStagingInputOptions" form-name="GCPSpannerCtrl.formName" selected-instance="GCPSpannerCtrl.selectedInstance" />
    </div>

    <div class="form-group" ng-if="GCPSpannerCtrl.showInstances && GCPSpannerCtrl.showDatabases">
        <label class="col-xs-12 col-sm-5" ng-bind="'label.databases' | cvLoc"></label>
        <div class="col-xs-12 col-sm-7">
            <div ng-show="GCPSpannerCtrl.databases">
                <isteven-multi-select
                    input-model="GCPSpannerCtrl.databases"
                    output-model="GCPSpannerCtrl.selectedDatabases"
                    button-label="name"
                    item-label="name"
                    directive-id="gcpDatabasesList"
                    tick-property="selected"
                    prevent-sort="true"
                    class="isteven-multi-select user-group-select single-select"
                    translation="GCPSpannerCtrl.databasesLoc"
                    group-property="databaseGroup"
                    is-required="true"
                    on-item-click="GCPSpannerCtrl.onDatabaseChanged(data)"
                    helper-elements="all filter">
                </isteven-multi-select>
            </div>
            <div ng-show="!GCPSpannerCtrl.databases" class="text-center margin-top-10">
                <img src="img/loading.gif" alt="loader" />
            </div>
            <span class="help-block" ng-if="GCPSpannerCtrl.errorMessages.databases" ng-bind="GCPSpannerCtrl.errorMessages.databases"></span>
        </div>
    </div>
</div>