import { commonAllAgentsModule } from 'common/js/modules';

var app = commonAllAgentsModule;
app.service('sqlService', [
	'$http',
	'$q',
	'$log',
	function($http, $q, $log) {
		this.getSQLDiscoveredDatabases = function(clientId, instanceId) {
			return $http.get('getSQLUnconfiguredDatabases.do?clientId=' + clientId + '&instanceId=' + instanceId);
		};

		this.getUnconfiguredServers = function(clientId) {
			return $http.get('getUnconfiguredServers.do?clientId=' + clientId);
		};

		this.getSqlAzureResourceGroupAndRegions = function(clientId) {
			var response = $http.get(
				appUtil.appRoot + '/api/Client/' + clientId + '/Sql/unconfiguredServers',
				httpHeader['jsonDefaultHeader']
			);
			return response;
		};

		this.getSQLDatabases = function(clientId, instanceId) {
			return $http.get('getSQLDatabases.do?clientId=' + clientId + '&instanceId=' + instanceId);
		};

		this.getSQLServerRestoreOptions = function(params) {
			return $http.post('getSQLRestoreOptions.do', params);
		};

		//used to load azure/aws proxy and AG physical client instance
		this.getSQLProxyClientInstance = function(opType, osType) {
			const CLIENT_PLATFORM_OSTYPE_WINDOWS = 1; //refer OsType.java
			if (!osType) {
				osType = CLIENT_PLATFORM_OSTYPE_WINDOWS;
			}
			var request = $http.get(
				'proxy/Client/SQL?opType=' + opType + '&osType=' + osType,
				httpHeader['jsonDefaultHeader']
			);
			return request;
		};

		this.getSQLClientInfo = function(instanceId) {
			return $http.get('sqlClientInfo.do?instanceId=' + instanceId);
		};

		this.updateSqlSCProps = function(scDetails) {
			var params = {
				entity: angular.toJson(scDetails.genericEntity),
				sqlSubclientProps: angular.toJson(scDetails.mssqlSubclientProp)
			};
			return $http.post('updateSqlSC.do', params);
		};

		this.createSqlAG = function(params) {
			return $http.post('createSQLAG.do', params);
		};

		this.getSQLAvailabilityGroups = function(clientId, instanceId) {
			var response = $http.get(
				'proxy/v2/sql/availabilityGroups/client/' + clientId + '/instance/' + instanceId,
				httpHeader['jsonDefaultHeader']
			);
			return response;
		};

		this.getSQLAvailabilityGroupReplicas = function(clientId, instanceId, agGroupName) {
			var response = $http.get(
				'proxy/v2/sql/availabilityGroupReplicas/client/' +
					clientId +
					'/instance/' +
					instanceId +
					'/availabilityGroup/' +
					agGroupName,
				httpHeader['jsonDefaultHeader']
			);
			return response;
		};

		this.getInstanceDetailsPerClient = function(clientId, applicationId) {
			var response = $http.get(
				'proxy/Instance?clientId=' + clientId + '&applicationId=' + applicationId + '&propertyLevel=30'
			);
			return response;
		};

		this.performInstanceRecovery = function(instanceId) {
			var response = $http.post('proxy/v2/sql/instances/' + instanceId + '/recovery', httpHeader['jsonDefaultHeader']);
			return response;
		};
	}
]);

export default app;
