import 'modules/storage/js/filters/storage.filters.js';
import 'adminConsole/js/directives/acDirectives.js';
import 'capps/js/cappsUtil.js';
import 'modules/ida/js/services/idaService.svc.js';
import 'capps/js/controllers/cappsRestoreOptionsGDrive.ctrl.js';
import 'capps/js/controllers/cappsRestoreOptionsGMail.ctrl.js';
import 'capps/js/controllers/cappsRestoreOptionsDynamoDb.ctrl.js';
import 'capps/js/controllers/cappsRestoreOptionsAmazonDb.ctrl.js';
import 'capps/js/controllers/cappsRestoreOptionsAzureDb.ctrl.js';
import 'capps/js/controllers/cappsCreateSubclientDynamoDb.ctrl.js';
import 'exchange/js/controllers/exchDbCreateRecoveryPointOptions.ctrl.js';
import 'exchange/js/controllers/exchDbRestoreOptions.ctrl.js';
import 'modules/ida/js/controllers/oracleAgent.ctrl.js';
import 'modules/ida/js/controllers/oracleTableLevelRestoreOptions.ctrl.js';
import 'modules/ida/js/controllers/oracleCreateLogicalDumpSubclient.ctrl.js';
import 'modules/ida/js/controllers/oracleUpdateSubclient.ctrl.js';
import 'modules/ida/js/controllers/sapForOracleCreateInstance.ctrl.js';
import 'modules/ida/js/controllers/sapForOracleCreateSubclient.ctrl.js';
import 'modules/ida/js/controllers/sapForOracleRestoreOptions.ctrl.js';
import 'modules/ida/databaseClone/js/controllers/databaseCloneModal.ctrl.js';
import 'modules/ida/js/controllers/appMigrationModal.ctrl.js';
import 'modules/ida/js/controllers/racCreateDatabase.ctrl.js';
import 'modules/ida/js/controllers/saphanaAgent.ctrl.js';
import 'modules/ida/js/controllers/sqlAgent.ctrl.js';
import 'modules/ida/js/controllers/informixBackupOptions.ctrl.js';
import 'modules/ida/js/controllers/informixCreateSubclient.ctrl.js';
import 'modules/ida/js/controllers/informixRestoreOptions.ctrl.js';
import 'modules/ida/js/controllers/informixCreateInstance.ctrl.js';
import 'modules/ida/js/controllers/db2CreateBackupset.ctrl.js';
import 'modules/ida/js/controllers/db2RestoreOptions.ctrl.js';
import 'modules/ida/js/controllers/db2CreateInstance.ctrl.js';
import 'modules/ida/js/controllers/db2dpfCreateInstance.ctrl.js';
import 'modules/ida/js/controllers/addCloudDatabase.ctrl.js';
import 'modules/ida/js/controllers/db2CreateSubclient.ctrl.js';
import 'modules/ida/js/controllers/db2BackupOptions.ctrl.js';
import 'modules/ida/js/controllers/db2SubclientContent.ctrl.js';
import 'modules/ida/js/controllers/amazonRDSRestoreOptions.ctrl.js';
import 'modules/ida/js/controllers/postgresAgent.ctrl.js';
import 'modules/ida/js/controllers/postgresCreateSubclient.ctrl.js';
import 'modules/ida/js/controllers/mySqlCreateInstance.ctrl.js';
import 'modules/ida/js/controllers/mySqlCreateSubclient.ctrl.js';
import 'modules/ida/js/controllers/mySqlBackupOptions.ctrl.js';
import 'modules/ida/js/controllers/mySqlRestoreOptions.ctrl.js';
import 'modules/ida/js/controllers/sybaseCreateInstance.ctrl.js';
import 'modules/ida/js/controllers/sybaseCreateSubclient.ctrl.js';
import 'modules/ida/js/controllers/sybaseBackupOptions.ctrl.js';
import 'modules/ida/js/controllers/sybaseRestoreOptions.ctrl.js';
import 'modules/ida/js/controllers/sybaseSubclientContent.ctrl.js';
import 'modules/ida/js/directives/cv-hardware-revert.js';
import 'bigData/js/controllers/bigDataRestoreOptions.ctrl.js';
import 'adminConsole/js/services/browseForAgents.svc.js';
import 'modules/ida/js/services/idaBrowse.svc.js';
import 'bigData/js/controllers/splunkRestoreOptions.ctrl.js';
import 'bigData/js/controllers/mongoDBRestoreOptions.ctrl.js';
import 'bigData/js/controllers/hadoopRestoreOptions.ctrl.js';
import 'browse/js/services/browse.svc.js';
import 'notesDatabase/js/directives/cv-notesdb-add-partition.js';
import 'common/js/cv-dialog-factory.js';
import 'bigData/js/constants/distributedClusterType.constant.js';
import 'cloudStorageApp/js/controllers/cloudStorageAppRestoreOptions.ctrl.js';
import { commonAllAgentsModule } from 'common/js/modules';
import 'sql/js/controllers/sqlRestore.ctrl.js';
import 'sql/js/controllers/sqlCreateAG.ctrl.js';
import 'capps/js/controllers/cappsRestoreOptions.ctrl.js';

var app = commonAllAgentsModule;

app.factory('idasFactory', [
	'userPrefService',
	'globalCacheFactory',
	'cvLoc',
	'$log',
	'cvToaster',
	'cvUtil',
	'$dialogs',
	'$q',
	'$state',
	'AppTypes',
	'$uibModal',
	'idaService',
	'cvBreadcrumbsTabsFactory',
	'CAPPS_CONSTANTS',
	'dialogFactory',
	'cappsUtil',
	'AppTypesUtil',
	'browseForAgentsService',
	'selectionService',
	'distributedClusterType',
	function(
		userPrefService,
		globalCacheFactory,
		cvLoc,
		$log,
		cvToaster,
		cvUtil,
		$dialogs,
		$q,
		$state,
		AppTypes,
		$modal,
		idaService,
		cvBreadcrumbsTabsFactory,
		CAPPS_CONSTANTS,
		dialogFactory,
		cappsUtil,
		AppTypesUtil,
		browseForAgentsBrowseService,
		selectionService,
		distributedClusterType
	) {
		var factory = {};

		factory.BACKUP_TYPE = 'Backup,SYNTHFULL';

		factory.getAgentType = function(applicationId) {
			var agentType = '';
			/**
			 * Population of node ids based on entityType selection
			 */
			switch (applicationId) {
				case AppTypes.ORACLE:
					agentType = 'oracle';
					break;
				case AppTypes.SQL_SERVER:
					agentType = 'sql';
					break;
				case AppTypes.SAP_HANA:
					agentType = 'saphana';
					break;
				case AppTypes.POSTGRESQL:
					agentType = 'postgres';
					break;
				case AppTypes.DB2_On_Unix:
				case AppTypes.DB2:
					agentType = 'db2';
					break;
				case AppTypes.NAS:
					agentType = 'nas';
					break;
			}

			return agentType;
		};

		factory.loadBreadCrumbs = function(entity, entityType) {
			var breadCrumbs = [];

			/**
			 * entityType will be the node type for which breadCrumbs to load
			 */
			if (angular.isUndefined(entityType)) {
				entityType = 'COMMCELL_ENTITY';
			}

			var appType = cv.sessionContext.acApp;

			var switchEntityType = appType + '_' + entityType;

			/**
			 * Population of breadCrumbs based on entity type
			 */
			switch (switchEntityType) {
				case 'ADMIN_CONSOLE_DBS_SUBCLIENT_ENTITY':
				case 'dbs_SUBCLIENT_ENTITY':
					var instanceNode = {
						title: cvLoc('label.instance'),
						link: '#instances'
					};

					var dbDetails = {
						title: entity.instanceName,
						link: '#databaseDetails' + '/' + entity.instanceId
					};
					breadCrumbs.push(instanceNode);
					breadCrumbs.push(dbDetails);
					if (entity.applicationId === AppTypes.POSTGRESQL) {
						var backupsetSetails = {
							title: entity.backupsetName,
							link: '#databaseDetails' + '/' + entity.instanceId
						};
						breadCrumbs.push(backupsetSetails);
					}
					break;
				case 'ADMIN_CONSOLE_SUBCLIENT_ENTITY':
					breadCrumbs.push({
						title: cvLoc('All_Clients'),
						link: '#clientGroupDetails/'
					});

					breadCrumbs.push({
						title: entity.clientName,
						link: '#clientDetails/' + entity.clientId
					});
					breadCrumbs.push({
						title: entity.appName,
						link: '#agentDetails/' + entity.clientId + '/' + entity.applicationId
					});

					breadCrumbs.push({
						title: entity.instanceName,
						link: '#databaseDetails' + '/' + entity.instanceId
					});
					if (entity.applicationId === AppTypes.POSTGRESQL) {
						var backupsetSetails = {
							title: entity.backupsetName,
							link: '#dbBackupsetDetails' + '/' + entity.backupsetId
						};
						breadCrumbs.push(backupsetSetails);
					}

					break;

				case 'ADMIN_CONSOLE_BACKUPSET_ENTITY':
					breadCrumbs.push({
						title: cvLoc('All_Clients'),
						link: '#clientGroupDetails/'
					});

					breadCrumbs.push({
						title: entity.clientName,
						link: '#clientDetails/' + entity.clientId
					});
					breadCrumbs.push({
						title: entity.appName,
						link: '#agentDetails/' + entity.clientId + '/' + entity.applicationId
					});

					breadCrumbs.push({
						title: entity.instanceName,
						link: '#databaseDetails' + '/' + entity.instanceId
					});

					break;
				case 'ADMIN_CONSOLE_DBS_INSTANCE_ENTITY':
				case 'dbs_INSTANCE_ENTITY':
					var instanceNode = {
						title: cvLoc('label.instance'),
						link: '#instances'
					};
					breadCrumbs.push(instanceNode);
					break;

				case 'ADMIN_CONSOLE_INSTANCE_ENTITY':
					breadCrumbs.push({
						title: cvLoc('All_Clients'),
						link: '#clientGroupDetails/'
					});

					breadCrumbs.push({
						title: entity.clientName,
						link: '#clientDetails/' + entity.clientId
					});
					breadCrumbs.push({
						title: entity.appName,
						link: '#agentDetails/' + entity.clientId + '/' + entity.applicationId
					});

					break;
			}

			cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
		};

		factory.isBackupsetSupported = function(instanceDetails) {
			var appId = instanceDetails.instance.applicationId;
			if (appId === AppTypes.SAP_HANA) {
				var containerMode = instanceDetails.saphanaInstance.containerMode;
				if (containerMode == 1) {
					return true;
				} else {
					return false;
				}
			} else if (appId === AppTypes.POSTGRESQL && instanceDetails.clientAppType === 'CLOUDDB') {
				return false;
			} else if (
				appId === AppTypes.CLOUD_APPS &&
				instanceDetails.cloudAppsInstance &&
				(instanceDetails.cloudAppsInstance.instanceType ===
					CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.key ||
					instanceDetails.cloudAppsInstance.instanceType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_RDS.key ||
					instanceDetails.cloudAppsInstance.instanceType ===
						CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_REDSHIFT.key ||
					instanceDetails.cloudAppsInstance.instanceType ===
						CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DOCUMENTDB.key)
			) {
				return false;
			} else {
				return AppTypesUtil.isBackupsetSupported(appId);
			}
			return false;
		};

		factory.createSubclient = function(entity, subclientDetails, editing, cloudAppsType) {
			var inputParamsToController = function() {
				return {
					entity: entity,
					subclientDetails: subclientDetails,
					editing: editing,
					cloudAppsType: cloudAppsType
				};
			};

			var applicationId = entity.applicationId;
			var baseJspPath = appUtil.appRoot;
			var dialogData = new Object();
			dialogData.backdrop = 'static';
			if (
				applicationId === AppTypes.POSTGRESQL ||
				applicationId === AppTypes.MYSQL ||
				applicationId === AppTypes.CV_APPTYPE_SYBASE
			) {
				dialogData.resolve = {
					createSubclientParams: {
						idaEntity: entity,
						subclientDetails: subclientDetails,
						editing: editing,
						cloudAppsType: cloudAppsType
					}
				};
			} else {
				dialogData.resolve = {
					data: inputParamsToController
				};
			}

			if (
				cloudAppsType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.key ||
				cloudAppsType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_RDS.key ||
				cloudAppsType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_REDSHIFT.key ||
				cloudAppsType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DOCUMENTDB.key ||
				cloudAppsType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_TABLE_STORAGE.key ||
				cloudAppsType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_COSMOS_DB_SQL_API.key
			) {
				dialogData.templateUrl = baseJspPath + 'capps/partials/cappsCreateSubclientDynamoDb.jsp';
				dialogData.controller = 'cappsCreateSubclientDynamoDb';
				dialogData.controllerAs = 'dynamoDbCS';
			} else {
				switch (applicationId) {
					case AppTypes.SQL_SERVER:
						dialogData.templateUrl = baseJspPath + 'modules/ida/partials/sqlCreateSubclient.jsp';
						dialogData.controller = 'sqlCreateSubclientCtrl';
						break;
					case AppTypes.SAP_HANA:
						dialogData.templateUrl = baseJspPath + 'adminConsole/partials/createSapHanaSubclient.jsp';
						dialogData.controller = 'saphanaCreateSubclientCtrl';
						break;
					case AppTypes.POSTGRESQL:
						dialogData.templateUrl = baseJspPath + 'modules/ida/partials/postgresCreateSubclient.jsp';
						dialogData.controller = 'pgSubclientController';
						dialogData.controllerAs = 'pgSubclient';
						break;
					case AppTypes.MYSQL:
						dialogData.templateUrl = baseJspPath + 'modules/ida/partials/mySqlCreateSubclient.jsp';
						dialogData.controller = 'mySqlSubclientController';
						dialogData.controllerAs = 'mySqlSubclient';
						break;
					case AppTypes.CV_APPTYPE_SYBASE:
						dialogData.templateUrl = baseJspPath + 'modules/ida/partials/sybaseCreateSubclient.jsp';
						dialogData.controller = 'sybaseSubclientController';
						dialogData.controllerAs = 'sybaseSubclient';
						break;
					case AppTypes.INFORMIX_DATABASE:
						dialogData.templateUrl = baseJspPath + 'modules/ida/partials/informixCreateSubclient.jsp';
						dialogData.controller = 'informixCreateSubclientCtrl';
						dialogData.controllerAs = 'informixCreateSubclient';
						break;
					case AppTypes.DB2_On_Unix:
					case AppTypes.DB2:
					case AppTypes.DB2_MultiNode:
						dialogData.templateUrl = baseJspPath + 'modules/ida/partials/db2CreateSubclient.jsp';
						dialogData.controller = 'db2CreateSubclientCtrl';
						dialogData.controllerAs = 'db2CreateSubclient';
						break;
					case AppTypes.SAP_FOR_ORACLE:
						dialogData.templateUrl = baseJspPath + 'modules/ida/partials/sapForOracleCreateSubclient.jsp';
						dialogData.controller = 'sapForOracleCreateSubclient';
						dialogData.controllerAs = 'sapOSub';
						break;
					default:
						if (editing) {
							dialogData.templateUrl = baseJspPath + 'modules/ida/partials/oracleUpdateSubclient.jsp';
							dialogData.controller = 'oracleUpdateSubclientCtrl';
							dialogData.controllerAs = 'oraUpdateSub';
						} else {
							dialogData.templateUrl = baseJspPath + 'modules/ida/partials/oracleCreateSubclient.jsp';
							dialogData.controller = 'oracleCreateSubclientCtrl';
						}
						break;
				}
			}

			var modalInstance = $modal.open(dialogData);
		};

		factory.createBackupset = function(entity, editDialog, entityDetails, callBackFun) {
			var inputParamsToController = function() {
				return {
					backupsetEntity: entity,
					editDialog: editDialog,
					backupsetDetails: entityDetails
				};
			};

			var applicationId = entity.applicationId;
			var baseJspPath = appUtil.appRoot;
			var dialogData = new Object();
			dialogData.backdrop = 'static';
			dialogData.resolve = {
				data: inputParamsToController
			};
			switch (applicationId) {
				case AppTypes.SAP_HANA:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/sapHanaCreateBackupsetModal.jsp';
					dialogData.controller = 'saphanaCreateBackupsetCtrl';
					break;

				default:
					if (AppTypesUtil.isDB2Agent(applicationId)) {
						dialogData.templateUrl = baseJspPath + 'modules/ida/partials/db2CreateBackupset.jsp';
						dialogData.controller = 'db2CreateBackupsetCtrl';
						dialogData.controllerAs = 'db2CreateBackupset';
						break;
					}
					return;
			}

			var modalInstance = $modal.open(dialogData);
			if (callBackFun) {
				modalInstance.result.then(callBackFun);
			}
		};

		factory.createCloudDatabase = function(data) {
			return $modal.open({
				backdrop: 'static',
				templateUrl: appUtil.appRoot + 'modules/ida/partials/addCloudDatabase.jsp',
				controller: 'addCloudDatabase',
				controllerAs: 'addCloudDB',
				resolve: {
					data: function() {
						return data;
					}
				}
			});
		};

		factory.createInstance = function(entity, editDialog, entityDetails) {
			var inputParamsToController = function() {
				return {
					idaEntity: entity,
					editDialog: editDialog,
					instanceDetails: entityDetails
				};
			};

			var applicationId = entity.applicationId;
			var baseJspPath = appUtil.appRoot;
			var dialogData = new Object();
			dialogData.backdrop = 'static';
			dialogData.resolve = {
				data: inputParamsToController
			};
			switch (applicationId) {
				case AppTypes.SQL_SERVER:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/sqlCreateInstance.jsp';
					dialogData.controller = 'sqlCreateInstanceCtrl';
					break;
				case AppTypes.SAP_HANA:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/sapHanaCreateInstanceModal.jsp';
					dialogData.controller = 'saphanaCreateInstanceCtrl';
					break;
				case AppTypes.ORACLE_RAC:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/racCreateDatabase.jsp';
					dialogData.controller = 'racCreateDatabaseController';
					dialogData.controllerAs = 'racCD';
					break;
				case AppTypes.SAP_FOR_ORACLE:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/sapForOracleCreateInstance.jsp';
					dialogData.controller = 'sapForOracleCreateInstance';
					dialogData.controllerAs = 'sapOInst';
					break;
				case AppTypes.POSTGRESQL:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/cloudDBCreateInstanceWrapper.jsp';
					dialogData.controller = 'cloudDBInstanceWrapperController';
					dialogData.controllerAs = 'cloudDbInstanceWrapper';
					break;
				case AppTypes.NOTES6_DB:
				case AppTypes.UNIX_LOTUSNOTES6_DB:
					dialogData.templateUrl = baseJspPath + 'notesDatabase/partials/notesDbCreatePartition.jsp';
					dialogData.controller = 'notesdbCreatePartitionCtrl';
					dialogData.controllerAs = 'notesdbPartition';
					break;
				case AppTypes.MYSQL:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/cloudDBCreateInstanceWrapper.jsp';
					dialogData.controller = 'cloudDBInstanceWrapperController';
					dialogData.controllerAs = 'cloudDbInstanceWrapper';
					break;
				case AppTypes.CV_APPTYPE_SYBASE:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/sybaseCreateInstance.jsp';
					dialogData.controller = 'sybaseInstanceController';
					dialogData.controllerAs = 'sybaseInstance';
					break;
				case 9999: //Dummy Application id for SQL_PSEUDO_AG
					dialogData.templateUrl = baseJspPath + 'sql/partials/sqlCreateAGInstances.jsp';
					dialogData.controller = 'sqlCreateAGController';
					dialogData.controllerAs = 'sqlCreateAGCtrl';
					break;
				case AppTypes.DB2_MultiNode:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/db2dpfCreateInstance.jsp';
					dialogData.controller = 'db2dpfCreateInstanceCtrl';
					dialogData.controllerAs = 'db2dpfNewInstance';
					break;
				case AppTypes.INFORMIX_DATABASE:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/informixCreateInstance.jsp';
					dialogData.controller = 'informixCreateInstanceCtrl';
					dialogData.controllerAs = 'informixNewInstance';
					break;
				default:
					if (AppTypesUtil.isDB2Agent(applicationId)) {
						dialogData.templateUrl = baseJspPath + 'modules/ida/partials/db2CreateInstance.jsp';
						dialogData.controller = 'db2CreateInstanceCtrl';
						dialogData.controllerAs = 'db2NewInstance';
					} else {
						dialogData.templateUrl = baseJspPath + 'modules/ida/partials/oracleCreateInstance.jsp';
						dialogData.controller = 'oracleCreateInstanceCtrl';
						dialogData.controllerAs = 'oraCI';
					}
					break;
			}

			var modalInstance = $modal.open(dialogData);
			modalInstance.result.then(function(data) {
				if (data && data.instanceId) {
					$state.go('databaseDetails', {
						instanceId: data.instanceId
					});
				}
			});
		};

		factory.updateSubclientContent = function(subclientDetails, createSubclient, callBackFun) {
			var inputParamsToController = function() {
				return {
					subclientDetails: subclientDetails,
					entity: _.get(subclientDetails, 'subClientEntity'),
					editing: !createSubclient,
					createSubclient: createSubclient
				};
			};
			var applicationId = subclientDetails.subClientEntity.applicationId;
			var baseJspPath = appUtil.appRoot;
			var dialogData = new Object();
			dialogData.backdrop = 'static';
			dialogData.resolve = {
				data: inputParamsToController
			};
			switch (applicationId) {
				case AppTypes.ORACLE_RAC:
				case AppTypes.ORACLE:
					let oraSubclientType = _.get(subclientDetails, 'oracleSubclientProp.dbSubclientType', 0);
					if (oraSubclientType === 2 || oraSubclientType === 'LOGICAL_DUMP') {
						// logical dump subclient flag
						dialogData.templateUrl = appUtil.appRoot + 'modules/ida/partials/oracleCreateLogicalDumpSubclient.jsp';
						dialogData.controller = 'oracleCreateLogicalDumpSubclientCtrl';
						dialogData.controllerAs = 'oLogicalDumpCtrl';
					} else {
						dialogData.templateUrl = baseJspPath + 'modules/ida/partials/oracleUpdateSubclientContent.jsp';
						dialogData.controller = 'oracleUpdateSubclientContentCtrl';
					}
					break;
				case AppTypes.SAP_FOR_ORACLE:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/sapForOracleCreateSubclient.jsp';
					dialogData.controller = 'sapForOracleCreateSubclient';
					dialogData.controllerAs = 'sapOSub';
					break;
				case AppTypes.SQL_SERVER:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/sqlUpdateSubclientContent.jsp';
					dialogData.controller = 'sqlUpdateSubclientContentCtrl';
					break;
				case AppTypes.SAP_HANA:
					dialogData.templateUrl = baseJspPath + 'adminConsole/partials/SapHanaUpdateSubclientContentModal.jsp';
					dialogData.controller = 'saphanaUpdateSubclientContentCtrl';
					break;
				case AppTypes.POSTGRESQL:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/postgresUpdateContentModal.jsp';
					dialogData.controller = 'postgresSubclientContentController';
					dialogData.controllerAs = 'subclientContent';
					break;
				case AppTypes.MYSQL:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/mySqlUpdateContentModal.jsp';
					dialogData.controller = 'mySqlSubclientContentController';
					dialogData.controllerAs = 'subclientContent';
					break;
				case AppTypes.CV_APPTYPE_SYBASE:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/sybaseUpdateContentModal.jsp';
					dialogData.controller = 'sybaseSubclientContentController';
					dialogData.controllerAs = 'subclientContent';
					break;
				case AppTypes.DB2:
				case AppTypes.DB2_On_Unix:
				case AppTypes.DB2_MultiNode:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/db2CreateSubclient.jsp';
					dialogData.controller = 'db2CreateSubclientCtrl';
					dialogData.controllerAs = 'db2CreateSubclient';
					break;
				case AppTypes.INFORMIX_DATABASE:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/informixCreateSubclient.jsp';
					dialogData.controller = 'informixCreateSubclientCtrl';
					dialogData.controllerAs = 'informixCreateSubclient';
					break;
			}

			var modalInstance = $modal.open(dialogData);
			if (createSubclient) {
				modalInstance.result.then(callBackFun);
			}
		};

		factory.showBackupOptions = function(entity) {
			factory.showBackupOptions(entity, 0);
		};
		factory.showBackupOptions = function(entity, flag) {
			factory.showBackupOptions(entity, flag, null);
		};
		factory.showBackupOptions = function(entity, flag, otherOptions) {
			factory.showBackupOptions(entity, flag, null, 'SUBCLIENT_ENTITY');
		};
		factory.showBackupOptions = function(entity, flag, otherOptions, entityType) {
			var deferred = $q.defer();
			var baseJspPath = appUtil.appRoot;
			if (flag == undefined) {
				flag = 0;
			}

			if (!entityType) {
				entityType = 'SUBCLIENT_ENTITY';
			}

			if (!otherOptions) {
				otherOptions = { subclientTypeFlag: flag };
			}
			var inputParamsToController = function() {
				return {
					deferred: deferred,
					entity: entity,
					entityType: entityType,
					otherOptions: otherOptions
				};
			};

			var dialogData = new Object();
			dialogData.backdrop = 'static';
			dialogData.resolve = {
				data: inputParamsToController
			};
			switch (entity.applicationId) {
				case AppTypes.ORACLE_RAC:
				case AppTypes.ORACLE:
				case AppTypes.SAP_FOR_ORACLE:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/oracleBackupOptions.jsp';
					dialogData.controller = 'oracleBackupOptionsCtrl';
					break;
				case AppTypes.DB2_On_Unix:
				case AppTypes.DB2:
				case AppTypes.DB2_MultiNode:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/db2BackupOptions.jsp';
					dialogData.controller = 'db2BackupOptionsCtrl';
					dialogData.controllerAs = 'db2BackupOptions';
					break;
				case AppTypes.INFORMIX_DATABASE:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/informixBackupOptions.jsp';
					dialogData.controller = 'informixBackupOptionsCtrl';
					dialogData.controllerAs = 'informixBackupOptions';
					break;
				case AppTypes.SQL_SERVER:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/sqlBackupOptions.jsp';
					dialogData.controller = 'sqlBackupOptionsCtrl';
					break;
				case AppTypes.SAP_HANA:
					dialogData.templateUrl = baseJspPath + 'adminConsole/partials/SapHanaBackupOptionsModal.jsp';
					dialogData.controller = 'saphanaBackupOptionsCtrl';
					break;
				case AppTypes.POSTGRESQL:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/postgresBackupOptionsModal.jsp';
					dialogData.controller = 'pgBackupController';
					break;
				case AppTypes.MYSQL:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/mySqlBackupOptionsModal.jsp';
					dialogData.controller = 'mySqlBackupController';
					dialogData.controllerAs = 'backupController';
					break;
				case AppTypes.CV_APPTYPE_SYBASE:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/sybaseBackupOptionsModal.jsp';
					dialogData.controller = 'sybaseBackupController';
					dialogData.controllerAs = 'backupController';
					break;
			}
			var modalInstance = $modal.open(dialogData);

			return deferred.promise;
		};

		factory.showRestoreOptions = function(params) {
			var jspFileRelativePath = '';
			var controllerName = '';
			var controllerNameAs = '';
			var baseJspPath = appUtil.appRoot;
			var entity = params.entity;

			var inputParamsToController = function() {
				if (entity.applicationId == AppTypes.SQL_SERVER) {
					const selectedDBs = [];
					angular.forEach(params.selectedRows, function(row, key) {
						selectedDBs.push(row.userObject);
					});

					params.selectedRows = selectedDBs;
				}

				return params;
			};
			var dialogData = new Object();
			dialogData.backdrop = 'static';
			dialogData.resolve = {
				data: inputParamsToController
			};
			switch (entity.applicationId) {
				case AppTypes.ORACLE_RAC:
				case AppTypes.ORACLE:
					if (params.isTableLevelRestore) {
						dialogData.templateUrl = baseJspPath + 'modules/ida/partials/oracleTableLevelRestoreOptions.jsp';
						dialogData.controller = 'oracleTableLevelRestoreOptionsCtrl';
						dialogData.controllerAs = 'otlRestore';
					} else {
						dialogData.templateUrl = baseJspPath + 'modules/ida/partials/oracleRestoreOptions.jsp';
						dialogData.controller = 'oracleRestoreOptionsCtrl';
					}
					break;
				case AppTypes.SAP_FOR_ORACLE:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/sapForOracleRestoreOptions.jsp';
					dialogData.controller = 'sapForOracleRestoreOptions';
					dialogData.controllerAs = 'sapORestore';
					break;
				case AppTypes.DB2_On_Unix:
				case AppTypes.DB2:
				case AppTypes.DB2_MultiNode:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/db2RestoreOptions.jsp';
					dialogData.controller = 'db2RestoreOptionsCtrl';
					dialogData.controllerAs = 'db2RestoreObj';
					break;
				case AppTypes.INFORMIX_DATABASE:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/informixRestoreOptions.jsp';
					dialogData.controller = 'informixRestoreOptionsCtrl';
					dialogData.controllerAs = 'informixRestoreObj';
					break;
				//restore from history also directs to new sql restore model
				case AppTypes.SQL_SERVER:
					dialogData.templateUrl = baseJspPath + 'sql/partials/sqlRestoreOptionsMultipleDBs.jsp';
					dialogData.controller = 'sqlSimplifiedRestoreOptionsCtrl';
					dialogData.controllerAs = 'sqlRestoreCtrl';

					break;
				case AppTypes.SAP_HANA:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/sapHanaRestoreOptions.jsp';
					dialogData.controller = 'saphanaRestoreOptionsCtrl';
					break;
				case AppTypes.POSTGRESQL:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/postgresRestoreOptionsModal.jsp';
					dialogData.controller = 'pgRestoreController';
					dialogData.controllerAs = 'pgRestore';
					break;
				case AppTypes.MYSQL:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/mySqlRestoreOptionsModal.jsp';
					dialogData.controller = 'mySqlRestoreController';
					dialogData.controllerAs = 'mySqlRestore';
					break;
				case AppTypes.CV_APPTYPE_SYBASE:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/sybaseRestoreOptionsModal.jsp';
					dialogData.controller = 'sybaseRestoreController';
					dialogData.controllerAs = 'sybaseRestore';
					break;
				case AppTypes.EXCHANGE_DATABASE:
					if (params.createRecoveryPoint && params.createRecoveryPoint == 1) {
						dialogData.templateUrl = baseJspPath + 'exchange/partials/exchDbCreateRecoveryPointOptions.jsp';
						dialogData.controller = 'exchDbCreateRecoveryPointOptionsController';
						dialogData.controllerAs = 'exchDbCreateRecoveryPointCtrl';
					} else {
						dialogData.templateUrl = baseJspPath + 'exchange/partials/exchDbRestoreOptions.jsp';
						dialogData.controller = 'exchDbRestoreOptionsController';
						dialogData.controllerAs = 'exchDbRestoreCtrl';
					}
					break;
				case AppTypes.CLOUD_APPS:
					var cloudAppType = params.cloudAppType;
					const cloudAppTypeInt = Number.parseInt(cloudAppType);
					if (cloudAppType == CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GOOGLE_DRIVE.value) {
						controllerName = 'cappsRestoreOptionsGDriveController';
						controllerNameAs = 'restoreGDriveCtrl';
						jspFileRelativePath = 'capps/partials/cappsRestoreOptionsGDrive.jsp';
					} else if (cloudAppType == CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GOOGLE_MAIL.value) {
						controllerName = 'cappsRestoreOptionsGMailController';
						controllerNameAs = 'restoreGMailCtrl';
						jspFileRelativePath = 'capps/partials/cappsRestoreOptionsGMail.jsp';
					} else if (
						cloudAppType == CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.ONEDRIVE.value ||
						parseInt(cloudAppType) == CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.ONEDRIVE.value
					) {
						controllerName = 'cappsRestoreOptionsController';
						controllerNameAs = 'restoreCappsCtrl';
						jspFileRelativePath = 'capps/partials/cappsRestoreOptions.jsp';
					} else if (cloudAppType == CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.SALESFORCE.value) {
						cappsUtil.showRestoreOptionsSF(params);
						return;
					} else if (
						cloudAppTypeInt === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DOCUMENTDB.value ||
						cloudAppTypeInt === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_RDS.value ||
						cloudAppTypeInt === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_REDSHIFT.value
					) {
						controllerName = 'cappsRestoreOptionsAmazonDb';
						controllerNameAs = 'amazonDbRestore';
						jspFileRelativePath = 'capps/partials/cappsRestoreOptionsAmazonDb.jsp';
					} else if (cloudAppTypeInt === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.value) {
						controllerName = 'cappsRestoreOptionsDynamoDb';
						controllerNameAs = 'dynamoDbRestore';
						jspFileRelativePath = 'capps/partials/cappsRestoreOptionsDynamoDb.jsp';
					} else if (params.isCloudStorageApp) {
						controllerName = 'cloudStorageAppRestoreController as cloudStorageAppRestoreCtrl';
						jspFileRelativePath = 'cloudStorageApp/partials/restore/cloudStorageAppRestoreOptionsModal.jsp';
					} else if (
						cloudAppTypeInt === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_TABLE_STORAGE.value ||
						cloudAppTypeInt === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_COSMOS_DB_SQL_API.value
					) {
						controllerName = 'cappsRestoreOptionsAzureDb';
						controllerNameAs = 'azureDbRestore';
						jspFileRelativePath = 'capps/partials/cappsRestoreOptionsAzureDb.jsp';
					}
					dialogData.templateUrl = baseJspPath + jspFileRelativePath;
					dialogData.controller = controllerName;
					dialogData.controllerAs = controllerNameAs;
					if (controllerName === 'cappsRestoreOptionsController') {
						dialogData.windowClass = 'medium-size';
					}

					break;
				case AppTypes.NAS:
				case AppTypes.WINDOWS_FILESYSTEM:
				case AppTypes.MAC_FILESYSTEM:
				case AppTypes.UNIX_FILESYSTEM:
					browseForAgentsBrowseService.entity = params.entity;

					selectionService.selectionArray = params.selectedRows;

					dialogData.templateUrl = baseJspPath + 'adminConsole/partials/fsRestoreOptions.jsp';
					dialogData.backdrop = 'static';
					dialogData.controller = [
						'$scope',
						'$uibModalInstance',
						'$state',
						'cvLoc',
						'selectionService',
						'browseForAgentsBrowseService',
						function($scope, $uibModalInstance, $state, cvLoc, selectionService, browseForAgentsBrowseService) {
							$scope.$modalInstance = $uibModalInstance;
							$scope.cancel = function() {
								$uibModalInstance.dismiss();
							};
						}
					];

					break;
				case AppTypes.DISTRIBUTED_APPS:
					var clusterType = params.clusterType;

					if (clusterType == distributedClusterType.CASSANDRA) {
						dialogData.templateUrl = baseJspPath + 'bigData/partials/bigDataRestoreOptionsModal.jsp';
						dialogData.controller = 'bigDataRestoreOptionsController as ctrl';
					} else if (clusterType == distributedClusterType.SPLUNK) {
						dialogData.templateUrl = baseJspPath + 'bigData/partials/splunkRestoreOptionsModal.jsp';
						dialogData.controller = 'splunkRestoreOptionsController as ctrl';
						dialogData.windowClass = 'small-size';
					} else if (clusterType == distributedClusterType.MONGODB) {
						dialogData.templateUrl = baseJspPath + 'bigData/partials/mongoDBRestoreOptionsModal.jsp';
						dialogData.controller = 'mongoDBRestoreOptionsController as ctrl';
						dialogData.windowClass = 'medium-size';
					} else if (clusterType == distributedClusterType.HADOOP) {
						dialogData.templateUrl = baseJspPath + 'bigData/partials/hadoopRestoreOptionsModal.jsp';
						dialogData.controller = 'hadoopRestoreOptionsController as ctrl';
					}
					break;
			}

			var modalInstance = $modal.open(dialogData);
		};

		factory.deleteEntity = function(entity, entityType, successCallBackFunction, dialogLabels) {
			dialogFactory.deleteConfirmDialog(dialogLabels.header, dialogLabels.confirmMessage).result.then(function() {
				idaService
					.deleteEntity(entityType, entity)
					.success(globalCacheFactory.refreshCacheId)
					.success(successCallBackFunction)
					.error(function(errorMessage) {
						errorMessage = errorMessage !== null ? errorMessage : cvLoc('generic_error');
						$log.error(errorMessage);
						cvToaster.showErrorMessage({
							ttl: '10000',
							message: errorMessage
						});
					});
			});
		};

		factory.discoverHanaDatabases = function(instanceId, callBackFunction) {
			idaService
				.discoverHanaDatabases(instanceId)
				.success(function(data) {
					if (data) {
						cvToaster.showSuccessMessage({
							ttl: '10000', //10 sec
							message: cvLoc('message.succesDiscoverDatabases')
						});
						if (callBackFunction) {
							callBackFunction();
						}
					}
				})
				.error(function(data) {
					$log.error('Error while discovering databases' + data);
					cvToaster.showErrorMessage({
						ttl: '10000', //10 sec
						message: data
					});
				});
		};

		factory.discoverInstances = function(entity, callBackFunction) {
			idaService
				.discoverInstances(entity)
				.success(function(data) {
					if (data) {
						let successMessage = cvLoc('message.succesDiscoverInstances');
						if (entity.isBackupsetDiscovery && AppTypesUtil.isDB2Agent(entity.appId)) {
							successMessage = cvLoc('message.succesDiscoverDatabases');
						}
						cvToaster.showSuccessMessage({
							ttl: '10000', //10 sec
							message: successMessage
						});
						if (callBackFunction) {
							callBackFunction();
						}
					}
				})
				.error(function(data) {
					$log.error('Error while discovering instances' + data);
					cvToaster.showErrorMessage({
						ttl: '10000', //10 sec
						message: data
					});
				});
		};

		factory.discoverMySqlInstances = function(clientId, callBackFunction) {
			idaService
				.discoverMySqlInstances(clientId)
				.success(function(data) {
					if (data) {
						cvToaster.showSuccessMessage({
							ttl: '10000', //10 sec
							message: cvLoc('message.succesDiscoverInstances')
						});
						if (callBackFunction) {
							callBackFunction();
						}
					}
				})
				.error(function(data) {
					$log.error('Error while discovering instances' + data);
					cvToaster.showErrorMessage({
						ttl: '10000', //10 sec
						message: data
					});
				});
		};

		factory.manageInstanceDiscovery = function(clientId, appId, isAutoDiscoverEnabled, callBackFunction) {
			idaService
				.setAgentDiscoverFlag(clientId, appId, isAutoDiscoverEnabled)
				.success(function(result) {
					cvToaster.showSuccessMessage({
						ttl: '10000', // 10 sec
						message: cvLoc('message.succesDiscoverFlg')
					});
					if (callBackFunction) {
						callBackFunction();
					}
				})
				.error(function(data) {
					$log.error('Error while updating agent discover flag' + data);
					cvToaster.showErrorMessage({
						ttl: '10000', //10 sec
						message: data
					});
				});
		};

		factory.showCloneModelDilaog = function(value, entityNode, entityType, actionObject, entityId, entityName) {
			factory.showCloneDialog({
				entity: entityNode.instance
			});
		};

		factory.showCloneDialog = function(params) {
			var baseJspPath = appUtil.appRoot;
			var entity = params.entity;

			var inputParamsToController = function() {
				return params;
			};
			var dialogData = new Object();
			dialogData.backdrop = 'static';
			dialogData.resolve = {
				data: inputParamsToController
			};
			switch (entity.applicationId) {
				case AppTypes.ORACLE_RAC:
				case AppTypes.ORACLE:
				case AppTypes.POSTGRESQL:
				case AppTypes.MYSQL:
				case AppTypes.DB2:
				case AppTypes.DB2_On_Unix:
				case AppTypes.SAP_HANA:
				case AppTypes.SQL_SERVER:
					dialogData.templateUrl = baseJspPath + 'modules/ida/databaseClone/partials/databaseCloneModal.jsp';
					dialogData.controller = 'dbCloneModalController';
					dialogData.controllerAs = 'dbClone';
					break;
				default:
					$state.go('databaseClone', {
						applicationId: entity.applicationId,
						instanceId: entity.instanceId
					});
					break;
			}

			$modal.open(dialogData);
		};

		factory.showAppMigrationDialog = function(params) {
			var baseJspPath = appUtil.appRoot;
			var entity = params.entity;

			var inputParamsToController = function() {
				return params;
			};
			var dialogData = new Object();
			dialogData.backdrop = 'static';
			dialogData.resolve = {
				data: inputParamsToController
			};
			switch (entity.applicationId) {
				case AppTypes.ORACLE_RAC:
				case AppTypes.ORACLE:
				case AppTypes.SQL_SERVER:
					dialogData.templateUrl = baseJspPath + 'modules/ida/partials/appMigrationModal.jsp';
					dialogData.controller = 'appMigrationModalCtrl';
					dialogData.controllerAs = 'appMi';
					break;
				default:
					$state.go('appMigration', {
						applicationId: entity.applicationId,
						instanceId: entity.instanceId
					});
					break;
			}

			$modal.open(dialogData);
		};

		factory.setDefaultViewForTable = function(tableName, viewId) {
			userPrefService
				.setViewAsDefault(tableName, viewId)
				.success(function() {
					userPrefService.updateUserPrefs().error(function(e) {
						cvToaster.showErrorMessage({
							message: e
						});
					});
				})
				.error(function(err) {
					cvToaster.showErrorMessage({
						message: err
					});
				});
		};

		factory.pgBrowseAction = function(entity) {
			$state.go('dbsIdaBrowse', {
				applicationId: entity.applicationId,
				entityId: entity.entityId,
				clientId: entity.clientId,
				entityType: entity.entityType,
				toTime: entity.toTimeStr,
				jobId: entity.jobId,
				isCloudDBInstance: entity.isCloudDBInstance,
				restoreType: entity.restoreType,
				isMigrate: entity.isMigrate && entity.isMigrate == true
			});
		};

		factory.performPgBrowse = function(job, selectedNode, toTimeStr, restoreLevel) {
			let entity = {};
			if (selectedNode) {
				Object.assign(entity, selectedNode);
			}
			entity.restoreType = 0;
			//From entity level browse
			if (!job && selectedNode) {
				//For backupset/instance browse: Backupset node has subclient flag
				if (selectedNode.subclientFlag) {
					entity.restoreType = selectedNode.subclientFlag;
				}
				entity.entityType = restoreLevel;
				entity.toTimeStr = toTimeStr;
				entity.entityId = entity.instanceId; //default
				//For cloud DB instance restores we need to set isCloudInstance flag
				if (restoreLevel === 'INSTANCE_ENTITY') {
					idaService.getInstanceDetails(entity.instanceId).success(function(data) {
						if (data.clientAppType === 'CLOUDDB') {
							entity.isCloudDBInstance = true;
						}
						factory.pgBrowseAction(entity);
					});
				} else {
					//for subclient level restores, we need to get the subclient type flag
					if (restoreLevel === 'SUBCLIENT_ENTITY') {
						entity.entityId = entity.subclientId;
						idaService.getSubClientDetails(entity.subclientId).success(function(data) {
							if (entity.applicationId === AppTypes.POSTGRESQL) {
								entity.restoreType = data.postgreSQLSubclientProp.subclientTypeFlag;
							} else if (entity.applicationId === AppTypes.MYSQL) {
								if (data.commonProperties.snapCopyInfo.isSnapBackupEnabled) {
									entity.restoreType = 1;
								}
							}
							factory.pgBrowseAction(entity);
						});
					} else if (restoreLevel === 'BACKUPSET_ENTITY') {
						entity.entityId = entity.backupsetId;
					}
					factory.pgBrowseAction(entity);
				}
			} else if (job) {
				//from calendar component restore
				let subclient = _.get(job, 'jobSummary.subclient');
				//entity.jobId =  _.get(job, 'jobSummary.jobId');
				entity.entityType = restoreLevel;
				entity.restoreType = 0;
				entity.toTimeStr = toTimeStr;
				entity.entityId = entity.instanceId; //default
				if (restoreLevel === 'BACKUPSET_ENTITY') {
					entity.entityId = entity.backupsetId;
				} else if (restoreLevel === 'SUBCLIENT_ENTITY') {
					entity.entityId = entity.subclientId;
				}
				if (subclient) {
					idaService.getSubClientDetails(subclient.subclientId).success(function(data) {
						if (entity.applicationId === AppTypes.POSTGRESQL) {
							entity.restoreType = data.postgreSQLSubclientProp.subclientTypeFlag;
						} else if (entity.applicationId === AppTypes.MYSQL) {
							if (data.commonProperties.snapCopyInfo.isSnapBackupEnabled) {
								entity.restoreType = 1;
							}
						}
						factory.pgBrowseAction(entity);
					});
				}
			}
		};

		return factory;
	}
]);

export default app;
