import 'modules/ida/js/services/idaService.svc.js';

import { commonAllAgentsModule } from 'common/js/modules';

var app = commonAllAgentsModule;

app.factory('idaColumnFactory', [
	'cvLoc',
	'cvUtil',
	'$dialogs',
	'$state',
	'AppTypes',
	'$uibModal',
	'idaService',
	function(cvLoc, cvUtil, $dialogs, $state, AppTypes, $modal, idaService) {
		var factory = {};

		/**
		 * Returns columns based on nodeType for the given entity
		 */
		factory.getColumns = function(nodeType, entity) {
			var columnDefs = [];
			switch (nodeType) {
				case 'SUBCLIENT_ENTITY':
					columnDefs = [
						{
							field: 'subClientEntity.subclientName',
							sort: {
								direction: 'asc',
								priority: 0
							},
							displayName: cvLoc('header.name'),
							cellTemplate:
								'<a class="crop" href="#dbCollectionDetails/{{row.entity.subClientEntity.subclientId}}">{{row.entity.subClientEntity.subclientName}}</a>',
							enableHiding: false,
							cellTooltip: true,
							width: '30%'
						},
						{
							field: 'commonProperties.storageDevice.dataBackupStoragePolicy.storagePolicyName',
							displayName: cvLoc('header.storagePolicy'),
							cellTemplate:
								'<span class="crop">{{row.entity.commonProperties.storageDevice.dataBackupStoragePolicy.storagePolicyName}}</span>',
							cellTooltip: true,
							width: '30%'
						},
						{
							field: 'subClientEntity',
							displayName: cvLoc('header.restore'),
							cellTemplate:
								'<span data-ng-show="{{row.entity.commonProperties.lastBackupTime >0}}"><a class="crop" href="" data-ng-click="grid.appScope.openRestorePage(row.entity.subClientEntity)">' +
								cvLoc('header.restore') +
								'</a></span>',
							width: '20%',
							visible: false,
							advancedVisible: false,
							enableHiding: false
						},
						{
							field: 'subClientEntity,commonProperties',
							displayName: cvLoc('header.actions'),
							cellTemplate:
								'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle ng-disabled="disabled"><span class="grid-action-icon"></span></a><ul uib-dropdown-menu class="dropdown-menu" role="menu">' +
								'<li ng-show="!grid.appScope.isBackupFlagsSupported(row.entity.subClientEntity.applicationId)"><a href="" data-ng-click="grid.appScope.showBackupOptions(row.entity.subClientEntity)">' +
								cvLoc('action.backup') +
								'</a></li>' +
								'<li ng-show="grid.appScope.isBackupFlagsSupported(row.entity.subClientEntity.applicationId)"><a href="" data-ng-click="grid.appScope.showBackupOptions(row.entity.subClientEntity,grid.appScope.getBackupFlag(row.entity))">' +
								cvLoc('action.backup') +
								'</a></li>' +
								'<li cv-jobs entity-type="SUBCLIENT_ENTITY" entity="row.entity.subClientEntity" >' +
								cvLoc('label.BackupHistory') +
								'</li>' +
								'<li data-ng-if="!row.entity.commonProperties.isDefaultSubclient"><a class="crop" href="" data-ng-click="grid.appScope.deleteSubclient(row.entity.subClientEntity)">' +
								cvLoc('Delete') +
								'</a></li></ul></div>',
							enableFiltering: false,
							enableSorting: false,
							enableHiding: false,
							cellTooltip: true,
							width: '20%'
						}
					];

					break;
				case 'INSTANCE_ENTITY':
					columnDefs = [
						{
							field: 'instanceName',
							sort: {
								direction: 'asc',
								priority: 0
							},

							displayName: cvLoc('header.name'),
							cellTemplate:
								'<a class="crop" href="#databaseDetails/{{row.entity.instanceId}}">{{row.entity.instanceName}}</a>',
							width: '35%'
						},
						{
							field: 'applicationName',
							displayName: cvLoc('label.appType'),
							cellTemplate: '<span class="crop">{{row.entity.appName | applicationNameFilter}}</span>',
							width: '35%'
						},
						{
							field: 'subClientEntity,commonProperties',
							displayName: cvLoc('header.actions'),
							cellTemplate:
								'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle ng-disabled="disabled"><span class="grid-action-icon"></span></a><ul uib-dropdown-menu class="dropdown-menu" role="menu">' +
								'<li cv-jobs entity-type="INSTANCE_ENTITY" entity="row.entity" >' +
								cvLoc('label.BackupHistory') +
								'</li>' +
								'<li cv-jobs entity-type="INSTANCE_ENTITY" entity="row.entity" job-type=\'Restore\'>' +
								cvLoc('label.RestoreHistory') +
								'</li>' +
								'<li><a class="crop" href="#idaBrowse/{{row.entity.applicationId}}/{{row.entity.instanceId}}?entityType=INSTANCE_ENTITY">' +
								cvLoc('header.restore') +
								' </a></li>' +
								'<li ng-show="row.entity.applicationId == 22"><a class="crop" href="#appMigration/{{row.entity.applicationId}}/{{row.entity.instanceId}}">' +
								cvLoc('pageHeader.migrateToCloud') +
								' </a></li>' +
								'<li ><a class="crop" href="" data-ng-click="grid.appScope.deleteInstance(row.entity)">' +
								cvLoc('Delete') +
								'</a></li>' +
								'</ul></div>',
							width: '20%'
						}
					];

					break;
				case 'BACKUPSET_ENTITY':
					columnDefs = [
						{
							field: 'backupSetEntity.backupsetName',
							width: '60%',
							sort: {
								direction: 'asc',
								priority: 0
							},
							displayName: cvLoc('header.type'),
							cellTemplate:
								'<a class="crop"href="#dbBackupsetDetails/{{row.entity.backupSetEntity.backupsetId}}">{{row.entity.backupSetEntity.backupsetName}}</a>',
							enableHiding: false
						},
						{
							field: 'backupSetEntity',
							displayName: cvLoc('header.restore'),
							cellTemplate:
								'<span ><a class="crop" href="" data-ng-click="grid.appScope.openRestorePage(row.entity.backupSetEntity)">' +
								cvLoc('header.restore') +
								'</a></span>',
							width: '20%',
							visible: false,
							advancedVisible: false,
							enableHiding: false
						},
						{
							field: 'backupSetEntity.backupsetId',
							displayName: cvLoc('header.actions'),
							cellTemplate:
								'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle ng-disabled="disabled"><span class="grid-action-icon"></span></a><ul uib-dropdown-menu class="dropdown-menu" role="menu">' +
								'<li data-ng-show="grid.appScope.supportAddSubclient(row.entity.backupSetEntity)" ><a ng-click="grid.appScope.createSubclient(row.entity.backupSetEntity)" >' +
								cvLoc('action.subclientCreation') +
								'</a></li><li><a class="crop" href="#jobs?serverId={{row.entity.backupSetEntity.clientId}}&serverName={{row.entity.backupSetEntity.clientName}}&applicationId={{row.entity.backupSetEntity.applicationId}}&backupsetId={{row.entity.backupSetEntity.backupsetId}}&jobType={{\'Backup\'}}&activeJobs=2&view=finishedJobs1">' +
								cvLoc('label.BackupHistory') +
								'</a></li><li><a class="crop" href="#jobs?serverId={{row.entity.backupSetEntity.clientId}}&serverName={{row.entity.backupSetEntity.clientName}}&applicationId={{row.entity.backupSetEntity.applicationId}}&backupsetId={{row.entity.backupSetEntity.backupsetId}}&jobType={{\'Restore\'}}&activeJobs=2&view=finishedJobs1">' +
								cvLoc('label.RestoreHistory') +
								'</a></li><li data-ng-if="grid.appScope.isDeleteBackupsetApplicable(row.entity)"><a class="crop" href="" data-ng-click="grid.appScope.deleteBackupSet(row.entity.backupSetEntity)">' +
								cvLoc('Delete') +
								'</a></li></ul></div>',
							width: '20%',
							enableFiltering: false,
							enableSorting: false,
							enableHiding: false
						}
					];
					break;
			}

			return columnDefs;
		};

		return factory;
	}
]);

export default app;
