import { acAppInstanceModule } from 'common/js/modules';

var dataMaskingMod = acAppInstanceModule;

dataMaskingMod.service('dataMaskingService', [
	'$q',
	'$http',
	function($q, $http) {
		var schemaCache = {};
		var columnCache = {};
		var SEP = '\t';

		this.getSchemasForInstance = function(instanceId, databaseName) {
			if (instanceId + SEP + databaseName in schemaCache) {
				return $q.when(schemaCache[instanceId + SEP + databaseName]);
			}
			return $http
				.get('schemasForInstance.do?instanceId=' + instanceId + '&databaseName=' + databaseName)
				.then(function(resp) {
					schemaCache[instanceId + SEP + databaseName] = resp.data;
					return resp.data;
				});
		};

		this.getColumnsForSchema = function(instanceId, databaseName, schemaName) {
			if (instanceId + SEP + databaseName + SEP + schemaName in columnCache) {
				return $q.when({
					databaseName: databaseName,
					schemaName: schemaName,
					data: columnCache[instanceId + SEP + databaseName + SEP + schemaName]
				});
			}
			//schemaName could contain something like C##HR
			return $http
				.get(
					'columnsForSchema.do?instanceId=' +
						instanceId +
						'&databaseName=' +
						databaseName +
						'&schemaName=' +
						encodeURIComponent(schemaName)
				)
				.then(function(resp) {
					columnCache[instanceId + SEP + databaseName + SEP + schemaName] = resp.data;
					//return schemaName so it can be used to verify this is the currently selected schema
					return {
						databaseName: databaseName,
						schemaName: schemaName,
						data: resp.data
					};
				});
		};

		this.invalidateCache = function() {
			schemaCache = {};
			columnCache = {};
		};

		this.getPoliciesForInstance = function(instanceId) {
			return $http.get('dataMaskingPolicies.do?instanceId=' + instanceId);
		};

		this.createNewPolicyForInstance = function(instanceId, policy) {
			var payload = {
				instanceId: instanceId,
				policy: JSON.stringify(policy)
			};
			return $http.post('createDataMaskingPolicy.do', payload);
		};

		this.modifyPolicyForInstance = function(instanceId, policy) {
			var payload = {
				instanceId: instanceId,
				policy: JSON.stringify(policy)
			};
			return $http.post('modifyDataMaskingPolicy.do', payload);
		};

		this.deletePolicyForInstance = function(instanceId, policy) {
			var payload = {
				instanceId: instanceId,
				policy: JSON.stringify(policy)
			};
			return $http.post('deleteDataMaskingPolicy.do', payload);
		};

		this.getPolicyDetail = function(instanceId, backupsetId, policyId) {
			return $http.get(
				'getPolicyDetail.do?instanceId=' + instanceId + '&backupsetId=' + backupsetId + '&policyId=' + policyId
			);
		};
	}
]);

export default dataMaskingMod;
