import { cappsAppCappsClientModule } from 'common/js/modules';

let inputTemplate = `
    <div>
        <cv-browse-input
            ng-if="GCPStaging.stagingBucketOptions"
            path-obj="GCPStaging.stagingBucketOptions.pathObj"
            input-label="GCPStaging.stagingBucketOptions.pathInput"
            selected-path="GCPStaging.stagingBucketOptions.selectedPath"
            path="GCPStaging.stagingBucketOptions.destLocation"
            browse-func="GCPStaging.browseStagingBucket()" 
            form-name="GCPStaging.formName"
        />
    </div>
`;

class GCPStagingBucketInputController {
	constructor(subclientFactory, REGEX, CAPPS_CONSTANTS) {
		this.subclientFactory = subclientFactory;
		this.REGEX = REGEX;
		this.CAPPS_CONSTANTS = CAPPS_CONSTANTS;
	}

	$onInit() {
		this._setupBrowseDirectiveInputs();
	}

	_setupBrowseDirectiveInputs() {
		let pattern = this.REGEX.UNIX_PATH;

		this.stagingBucketOptions = {
			selectedPath: 'local',
			pathInput: {
				path: 'label.stagingBucketPath'
			},
			destLocation: this.inputOptions.destLocation,
			pathObj: { local: { name: 'stagingBucketPath', id: 'stagingBucketPath', required: true, pattern } }
		};
	}

	browseStagingBucket() {
		let browseParams = {
			clientId: _.get(this.inputOptions, 'accessNodes[0].client.clientId'),
			customTitle: 'label.selectBucket',
			canCreateFolder: false,
			cloudAppsProperties: {
				instance: {
					clientId: this.inputOptions.cloudAccountId
				},
				cloudAppInstanceProps: {
					instanceType: this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GCP_SPANNER.value,
					cloudSpannerInstance: {
						projectId: _.get(this.selectedInstance, '[0].path')
					}
				}
			}
		};

		this.subclientFactory.browseWithParams(browseParams).then(result => {
			this.stagingBucketOptions.destLocation.local = result.path;
		});
	}
}

GCPStagingBucketInputController.$inject = ['subclientFactory', 'REGEX', 'CAPPS_CONSTANTS'];

cappsAppCappsClientModule.directive('gcpStagingBucketInput', () => ({
	restrict: 'E',
	template: inputTemplate,
	bindToController: true,
	replace: true,
	controller: GCPStagingBucketInputController,
	controllerAs: 'GCPStaging',
	scope: {
		inputOptions: '=',
		selectedInstance: '=',
		formName: '='
	}
}));

export default cappsAppCappsClientModule;
