import 'modules/ida/js/services/dataMasking.svc.js';

import { acAppInstanceModule } from 'common/js/modules';

/***
 * Use this directive to show a check box and a drop down for selecting data masking restore options.
 */

var dataMaskingMod = acAppInstanceModule;

dataMaskingMod.directive('cvDataMasking', function() {
	return {
		restrict: 'E',
		//Need cvSubmit and form for validation
		require: ['^^cvSubmit', '^^form'],
		templateUrl: appUtil.appRoot + 'modules/ida/partials/cvDataMasking.jsp',
		bindToController: {
			instanceId: '=',
			//pass result to parent controller
			maskingOptions: '=',
			isStandAlone: '@',
			//Customize label and input width
			leftClass: '@',
			rightClass: '@'
		},
		controller: 'cvDataMaskingController',
		controllerAs: 'cvDMCtrl',
		//Link cvSubmit and form
		link: function(scope, elem, attr, controllers) {
			scope.submitController = controllers[0];
			scope.formController = controllers[1];
		}
	};
});

dataMaskingMod.controller('cvDataMaskingController', [
	'dataMaskingService',
	'cvToaster',
	function(dataMaskingService, cvToaster) {
		var self = this;
		this.$onInit = function() {
			if (!self.leftClass) {
				self.leftClass = 'col-xs-12 col-lg-6';
			}
			if (!self.rightClass) {
				self.rightClass = 'col-xs-12 col-lg-6';
			}
			//JSP should bind to props in model only
			self.model = {
				maskSensitiveData: self.maskingOptions.enabled,
				policyId: self.maskingOptions.dbDMPolicy ? self.maskingOptions.dbDMPolicy.policy.policyId : undefined
			};

			//Load available masking policies
			function loadData() {
				dataMaskingService.getPoliciesForInstance(self.instanceId).then(
					function(resp) {
						self.dataMaskingPolicyList = resp.data;
					},
					function(err) {
						cvToaster.showErrorMessage({
							message: err
						});
					}
				);
			}
			loadData();

			//Hide the options if no policy found
			self.showDataMasking = function() {
				return self.dataMaskingPolicyList && self.dataMaskingPolicyList.length != 0;
			};

			//Pass result to parent controller
			self.changeHandler = function() {
				var options = self.maskingOptions;

				options.enabled = self.model.maskSensitiveData;
				options.isStandalone = self.isStandAlone;
				if (options.enabled && self.dataMaskingPolicyList) {
					self.dataMaskingPolicyList.forEach(function(policy) {
						if (policy.policy.policyId == self.model.policyId) {
							options.dbDMPolicy = angular.copy(policy);
							//We just need entity of the policy for restore/clone, the details are not needed
							delete options.dbDMPolicy.config;
						}
					});
				}
			};
		};
	}
]);

export default dataMaskingMod;
