import { acAppRestoreModule } from 'common/js/modules';

export class restoreStreamsController {
	constructor(AppTypes) {
		this.AppTypes = AppTypes;
	}

	$onInit() {
		if (!this.leftClass) {
			this.leftClass = 'col-xs-12 col-sm-5';
		}
		if (!this.rightClass) {
			this.rightClass = 'col-xs-12 col-sm-7';
		}
	}
	isValidStream() {
		const streams = this.streams;
		return Number.isInteger(streams) && streams <= 100 && streams >= 1;
	}
}

restoreStreamsController.$inject = ['AppTypes'];

const directive = function() {
	return {
		restrict: 'E',
		templateUrl: `${appUtil.appRoot}modules/ida/partials/cv-restore-streams.jsp`,
		bindToController: {
			streams: '=',
			rightClass: '@',
			leftClass: '@',
			helpText: '@'
		},
		controller: restoreStreamsController,
		controllerAs: 'restoreStreams'
	};
};

acAppRestoreModule.directive('cvRestoreStreams', directive);

export default acAppRestoreModule;
