import 'capps/js/services/cappsContent.factory.js';
import 'vsa/js/services/servers.svc.js';
import 'adminConsole/js/directives/cv-isteven-single-select.js';
import 'adminConsole/js/services/instances.svc.js';

import { acAppInstanceModule } from 'common/js/modules';

export class instanceInlineEditController {
	constructor(cvToaster, cvLoc, AppTypes, instanceService, $state, CAPPS_CONSTANTS) {
		this.cvToaster = cvToaster;
		this.cvLoc = cvLoc;
		this.AppTypes = AppTypes;
		this.instanceService = instanceService;
		this.$state = $state;
		this.CAPPS_CONSTANTS = CAPPS_CONSTANTS;
	}

	$onInit() {
		this.entity = this.instanceDetails.instance;
		this.cappsInstanceType = this.instanceDetails.cloudAppsInstance.instanceType;
		this.value = this._readValue(this.instanceDetails);

		if (!this.min) {
			this.min = 0;
		}
		if (!this.max) {
			this.max = Number.MAX_SAFE_INTEGER;
		}
	}

	_readValue(instanceDetails) {
		return _.get(instanceDetails, this.propertyPath);
	}

	_updateValue(instanceDetails, value) {
		_.set(instanceDetails, this.propertyPath, value);
	}

	toggleEdit() {
		this.isEditing = !this.isEditing;
		this.newValue = this.value;
	}

	update() {
		const self = this;
		if (Number.isInteger(this.newValue) && this.newValue <= this.max && this.newValue >= this.min) {
			const instanceInfo = {
				cloudAppsInstance: {
					instanceType: self.cappsInstanceType
				}
			};

			this._updateValue(instanceInfo, self.newValue);

			this.instanceService
				.updateInstance({
					instanceEntity: angular.toJson(self.entity),
					instanceProps: angular.toJson(instanceInfo)
				})
				.success(function(data) {
					self.value = self.newValue;
					self.toggleEdit();
				})
				.error(function(e) {
					self.cvToaster.showErrorMessage({
						message: e
					});
				});
		} else {
			if (self.validationMessage) {
				self.cvToaster.showErrorMessage({
					message: self.validationMessage
				});
			}
		}
	}
}

instanceInlineEditController.$inject = [
	'cvToaster',
	'cvLoc',
	'AppTypes',
	'instanceService',
	'$state',
	'CAPPS_CONSTANTS'
];

const directive = function() {
	return {
		restrict: 'E',
		templateUrl: `${appUtil.appRoot}modules/ida/partials/cv-instance-inline-edit.jsp`,
		bindToController: {
			instanceDetails: '=',
			propertyPath: '@',
			label: '@',
			toolTip: '@',
			unitLabel: '@',
			min: '=',
			max: '=',
			validationMessage: '@'
		},
		controller: instanceInlineEditController,
		controllerAs: 'instInlineEdit'
	};
};

acAppInstanceModule.directive('cvInstanceInlineEdit', directive);

export default acAppInstanceModule;
