import { commonAllAgentsModule } from 'common/js/modules';

var allAgentMod = commonAllAgentsModule;

/**
 * Controller for the date and time picking options
 */
var dateAndTimePickerCtrl = [
	'cvLoc',
	function(cvLoc) {
		var self = this;
		this.$onInit = function() {
			//date-time picker options
			self.dateOptions = {
				dateFormat: 'MM/dd/yyyy HH:mm:ss',
				showWeeks: false,
				showSeconds: true,
				useSeconds: true
			};

			self.timeOptions = {
				min: null,
				showSeconds: true
			};

			if (_.isEmpty(self.pickerId)) {
				self.pickerId = '';
			}
			//Date will be formated with is format, otherwise it uses default one
			if (self.dateFormat) {
				self.dateOptions.dateFormat = self.dateFormat;
			}

			if (self.showWeeks) {
				self.dateOptions.showWeeks = self.showWeeks == 'true' ? true : false;
			}

			//Show the seconds based on this flag
			if (self.showSeconds) {
				self.timeOptions.showSeconds = self.showSeconds == 'true' ? true : false;
			}

			//User selection will be stored in this
			if (self.dateTimeValue) {
				self.dateTive = self.dateTimeValue;
			} else {
				var dateobj = new Date();
				self.dateTive = new Date(
					dateobj.getFullYear(),
					dateobj.getMonth(),
					dateobj.getDate(),
					dateobj.getHours(),
					dateobj.getMinutes(),
					dateobj.getSeconds()
				);
			}

			//Max date value, all the future dates will be disabled
			if (self.maxDate) {
				self.dateOptions.maxDate = self.maxDate;
			} else {
				self.dateOptions.maxDate = new Date();
			}

			//Minimum date value, all the previous dates will be disabled
			if (self.minDate) {
				self.dateOptions.minDate = self.minDate;
			}
			/**
			 * Opens date and time picking
			 */
			self.openDatePicker = function() {
				self.isDatePickerOpen = true;
				self.errorMsg = {
					type: '',
					msg: ''
				};
			};
		};
	}
];

/**
 * Directive for the date and time picker in one button, Pass the date object which user can update Date
 * format to format the date value, with this any common formating can be handled in this
 */
var directive = function() {
	return {
		restrict: 'E', //E = element
		templateUrl: appUtil.appRoot + 'modules/ida/partials/dateTimePickeTemplate.jsp',
		require: ['cvDateTimePicker'],
		scope: {
			openDatePicker: '='
		},
		bindToController: {
			dateTimeValue: '=?',
			dateFormat: '=?',
			maxDate: '=?',
			minDate: '=?',
			pickerId: '@',
			showWeeks: '=?'
		},
		link: function(scope, element, attrs, controllers) {
			var cvDatePicker = controllers[0];
			//watch the openDatePicker value from the calling controller and open the date picker in directive
			scope.$watch('openDatePicker', function(newValue) {
				// Watch given path for changes
				if (newValue) {
					cvDatePicker.openDatePicker();
				}
			});
		},
		controller: dateAndTimePickerCtrl,
		controllerAs: 'dtPickerCtrl'
	};
};

allAgentMod.directive('cvDateTimePicker', directive);

export default allAgentMod;
