import { commonAllAgentsModule } from 'common/js/modules';
import 'modules/ida/js/services/sqlService.svc.js';
var app = commonAllAgentsModule;

app.directive('cvClouddbCreateInstance', function() {
	return {
		restrict: 'AEC',
		scope: true,
		bindToController: {
			data: '=',
			modalInstance: '=',
			isGenericScreen: '=',
			/* Currently used only when isGenericScreen is true */
			planId: '=',
			/* Currently used only when isGenericScreen is true */
			serverMessage: '=',
			/* Currently used only when isGenericScreen is true */
			clientEntity: '=',
			submitAttempted: '='
		},
		templateUrl: appUtil.appRoot + 'modules/ida/partials/cloudDBCreateInstance.jsp',
		controllerAs: 'cloudDBInstanceCtrl',
		controller: 'cloudDBCreateInstanceController'
	};
});

app.controller('cloudDBCreateInstanceController', [
	'$scope',
	'$state',
	'$uibModal',
	'globalCacheFactory',
	'$timeout',
	'$log',
	'cvLoc',
	'cvUtil',
	'idaService',
	'profileService',
	'AppTypes',
	'cvToaster',
	'sqlService',
	function(
		$scope,
		$state,
		$modal,
		globalCacheFactory,
		$timeout,
		$log,
		cvLoc,
		cvUtil,
		idaService,
		profileService,
		AppTypes,
		cvToaster,
		sqlService
	) {
		var self = this;
		this.$onInit = function() {
			self.clientLocal = cvUtil.getIStevenLocLabels();
			self.instanceLocal = cvUtil.getIStevenLocLabels();
			self.planLocal = cvUtil.getIStevenLocLabels();
			self.clientLocal.nothingSelected = cvLoc('placeholder.selectClient');
			self.instanceLocal.nothingSelected = cvLoc('placeholder.selectInstance');
			self.planLocal.nothingSelected = cvLoc('placeholder.selectPlan');
			self.isParentMigrate = false;
			if ($scope.$parent && $scope.$parent.cloudMigrateData) {
				self.data = $scope.$parent.cloudMigrateData;
				self.modalInstance = $scope.$parent.$modalInstance;
				self.clientEntity = {
					clientId: self.data.idaEntity.clientId,
					applicationId: self.data.idaEntity.applicationId,
					vendor: self.data.idaEntity.vendor
				};
				self.isGenericScreen = true;
				self.isParentMigrate = true;
			}

			self.edit = self.data.editDialog === 'Add_Instance' ? false : true;
			self.openAccordion = self.edit ? true : false;
			self.instanceLoaded = true;
			self.isPostgreSQL = self.data.idaEntity.applicationId === AppTypes.POSTGRESQL;
			self.isMySQL = self.data.idaEntity.applicationId === AppTypes.MYSQL;
			self.isSQLServer = self.data.idaEntity.applicationId === AppTypes.SQL_SERVER;
			self.isOracle = self.data.idaEntity.applicationId === AppTypes.ORACLE;
			self.isSQLAzure = self.isSQLServer && self.data.idaEntity.vendor == 'AZURE_V2';
			self.isSQLAmazon = self.isSQLServer && self.data.idaEntity.vendor == 'AMAZON';
			self.cloudDBEngineType = self.data.idaEntity.cloudDBEngineType;
			self.sqlCloudPlaceholder = cvLoc('placeholder.leaveBlankToUseHigherLevelValue');
			//				self.dbPassword = '';
			self.portPattern = '(\\w.+):(\\d+)';
			self.isGCPSpanner = _.get(self.data.instanceDetails, 'cloudAppsInstance.instanceType') === 'GCP_SPANNER';

			var AMAZON = 4,
				AZURE = 7,
				ALIBABA_CLOUD = 18,
				GOOGLE_CLOUD = 16;
			var supportedVendors = [AMAZON, AZURE, ALIBABA_CLOUD, GOOGLE_CLOUD];
			var clientInstanceMap = {};
			var existingInstances = [];

			if (self.isGCPSpanner) {
				self.stagingBucketInputOptions = {
					inputOptions: {
						cloudAccountId: self.data.idaEntity.clientId,
						destLocation: {
							local: _.get(self.data, 'instanceDetails.cloudAppsInstance.cloudSpannerInstance.cloudStagingPath')
						}
					},
					selectedInstance: [
						{
							path: _.get(self.data, 'instanceDetails.cloudAppsInstance.cloudSpannerInstance.projectId')
						}
					]
				};
			}

			switch (self.data.idaEntity.applicationId) {
				case AppTypes.POSTGRESQL:
					self.instanceObjectName = 'postGreSQLInstance';
					break;
				case AppTypes.ORACLE:
					self.instanceObjectName = 'oracleInstance';
					break;
				case AppTypes.MYSQL:
					self.instanceObjectName = 'mySqlInstance';
					break;
				case AppTypes.SQL_SERVER:
					self.instanceObjectName = 'mssqlInstance';
					break;
				default:
					self.instanceObjectName = '';
					break;
			}

			self.init = function() {
				if (self.isSQLServer) {
					return;
				}
				idaService.getPostgreSQLInstances().then(
					function(result) {
						if (result && result.data && result.data.dbInstance) {
							angular.forEach(result.data.dbInstance, function(instanceData) {
								existingInstances.push(
									getClientInstanceItem(instanceData.instance.clientName, instanceData.instance.instanceName)
								);
							});
						}
					},
					function(e) {
						self.serverMessage = cvUtil.errMsg(e);
					}
				);
			};

			function initInstanceData() {
				self.clientSelection = {
					clients: [],
					selectedClients: [],
					selectionChanged: function(clientEntity) {
						if (self.isGenericScreen) {
							self.clientSelection.selectedClients = [clientEntity];
						}
						loadInstances(clientEntity.clientId);
						self.instance.clientId = clientEntity.clientId;
						self.instance.clientName = clientEntity.clientName;
						self.clientSelection.validSelection = true;
						clearErrorMessage();
					},
					validSelection: false
				};

				self.instanceSelection = {
					instances: [],
					selectedInstances: [],
					selectionChanged: function(instance) {
						self.instanceSelection.validSelection = true;
						if (self.isOracle) {
							self.instanceDetails[self.instanceObjectName].domainName =
								_.get(instance, 'port') + '/' + _.get(instance, 'dbName');
						}
						clearErrorMessage();
					},
					validSelection: false
				};

				self.planSelection = {
					plans: [],
					selectedPlans: [],
					selectionChanged: function(instance) {
						self.planSelection.validSelection = true;
						clearErrorMessage();
					},
					validSelection: false
				};

				self.instance = {
					instanceId: -1,
					instanceName: '',
					applicationId: self.data.idaEntity.applicationId,
					appName: self.data.idaEntity.appName,
					clientId: self.data.idaEntity.clientId,
					clientName: self.data.idaEntity.clientName
				};

				self.instanceDetails = {};
				self.instanceDetails.version = '';
				addInstanceDetailData();

				if (self.edit) {
					self.instanceDetails = self.data.instanceDetails;
					self.instance = self.data.instanceDetails.instance;
					self.instancePlanEntity = _.get(self.instanceDetails, 'planEntity');
					if (self.instancePlanEntity && self.instancePlanEntity.planId && self.instancePlanEntity.planId > 0) {
						self.hasInstancePlan = true;
					}
					if (self.isPostgreSQL) {
						self.instanceDetails.dbPort = self.instanceDetails.postGreSQLInstance.port;
					} else if (self.isMySQL) {
						self.instanceDetails.dbPort = self.instanceDetails.mySqlInstance.port;
					}
				} else {
					if (!self.isParentCloudMigrate) {
						loadClients();
						self.openAccordion = true;
					}
					if (self.isPostgreSQL || self.isMySQL) {
						self.instanceDetails.dbPort = ''; //default value
					}
				}

				loadPlans();

				self.newInstanceName = self.instance.instanceName;

				self.serverMessage = {
					message: '',
					type: ''
				};

				if (self.isGenericScreen) {
					self.clientSelection.selectionChanged(self.clientEntity);
				}
			}

			function addInstanceDetailData() {
				if (self.isSQLServer) {
					self.instanceDetails[self.instanceObjectName] = {
						SAUser: {
							userName: '',
							passwordString: '',
							confirmPasswordString: ''
						}
					};

					if (self.isSQLAzure) {
						self.instanceDetails[self.instanceObjectName].overrideHigherSettings = true;
						self.instanceDetails[self.instanceObjectName].azureInfo = {
							azureStorageConnectionString: ''
						};
					} else if (self.isSQLAmazon) {
						self.instanceDetails[self.instanceObjectName].overwriteAwsHigherLevelSettings = true;
						self.instanceDetails[self.instanceObjectName].awsSqlInfo = {
							s3BucketName: ''
						};
					}
				} else {
					self.instanceDetails[self.instanceObjectName] = {
						port: '',
						BinaryDirectory: '',
						LibDirectory: '',
						ArchiveLogDirectory: '',
						SAUser: {
							userName: self.isPostgreSQL ? 'postgres' : '',
							passwordString: '',
							confirmPasswordString: ''
						},
						ArchiveDelete: '',
						logStoragePolicy: {
							storagePolicyId: 1,
							storagePolicyName: ''
						},
						standbyOptions: {
							isStandbyEnabled: false,
							standbyInstance: {},
							useMasterForDataBkp: false,
							useMasterForLogBkp: false
						}
					};
				}

				if (self.isPostgreSQL) {
					self.instanceDetails[self.instanceObjectName].MaintainenceDB = 'postgres';
				}

				if (self.isMySQL) {
					self.instanceDetails[self.instanceObjectName].sslCa = '';
					self.instanceDetails[self.instanceObjectName].EnableAutoDiscovery = true;
				}
			}

			var loadClients = function loadClients() {
				self.clientSelection.clients.splice(0);
				idaService.getVMPSeudoClients().then(
					function(result) {
						if (result && result.data && result.data.VSPseudoClientsList) {
							var clients = [];
							angular.forEach(result.data.VSPseudoClientsList, function(client) {
								if (supportedVendors.indexOf(client.VSInstanceType) !== -1) {
									clients.push({
										clientId: client.client.clientId,
										clientName: client.client.clientName,
										displayName: client.client.displayName
									});
								}
							});
							self.clientSelection.clients = clients;
						}
					},
					function(e) {
						self.serverMessage = cvUtil.errMsg(e);
					}
				);
			};

			function clearErrorMessage() {
				if (self.serverMessage.message !== '') {
					self.serverMessage = {
						message: '',
						type: ''
					};
				}
			}

			function getClientInstanceItem(clientName, instanceName) {
				return clientName + '::' + instanceName;
			}

			function formatInstances(result, clientId) {
				var instances = [];
				self.instanceLoaded = true;
				if (result && result.data && result.data.response && result.data.response.warningCode === 101) {
					self.serverMessage = cvUtil.errMsg(result.data.response.warningMessage);
				}

				if (result && result.data && result.data.rdsDBInstances) {
					if (result.data.rdsDBInstances.length === 0) {
						self.instanceErrorMessage = cvLoc('error.noInstances');
						return;
					}
					var selectedClientName = self.clientSelection.selectedClients[0].clientName;
					angular.forEach(result.data.rdsDBInstances, function(instance) {
						var instanceName = instance.dbInstanceIdentifier + '[' + instance.regionName + ']';
						var instanceItemName = getClientInstanceItem(selectedClientName, instanceName);
						if (existingInstances.indexOf(instanceItemName) === -1) {
							instances.push({
								instanceName: instanceName,
								instanceId: instance.dbInstanceIdentifier,
								port: instance.endPoint + ':' + instance.port,
								version: instance.engineVersion,
								dbName: _.get(instance, 'dbName')
							});
						}
					});

					self.instanceSelection.instances = instances;
					clientInstanceMap[clientId] = instances;
				}
				if (self.instanceSelection.instances.length === 0) {
					self.instanceErrorMessage = cvLoc('error.allInstanceRegistered');
					return;
				}
			}

			function loadInstances(clientId) {
				self.instanceSelection.instances = [];
				var instances = [];
				if (clientInstanceMap[clientId]) {
					self.instanceSelection.instances = clientInstanceMap[clientId];
					return;
				}

				self.instanceLoaded = false;
				self.instanceErrorMessage = '';
				if (self.cloudDBEngineType && (self.isMySQL || self.isPostgreSQL)) {
					idaService.getDBEngineRDSInstances(clientId, self.instance.applicationId, self.cloudDBEngineType).then(
						function(result) {
							formatInstances(result, clientId);
						},
						function(err) {
							self.instanceErrorMessage = err ? err : cvLoc('generic_error');
							self.instanceLoaded = true;
						}
					);
				} else if (!self.isSQLServer) {
					idaService.getRDSInstances(clientId, self.instance.applicationId).then(
						function(result) {
							formatInstances(result, clientId);
						},
						function(err) {
							self.instanceErrorMessage = err ? err : cvLoc('generic_error');
							self.instanceLoaded = true;
						}
					);
				} else {
					sqlService
						.getUnconfiguredServers(clientId)
						.success(function(data) {
							self.instanceLoaded = true;

							if (data.length === 0) {
								self.instanceErrorMessage = cvLoc('error.noInstances');
								return;
							}

							angular.forEach(data, function(instance) {
								instances.push({
									instanceName: instance.servername,
									serverType: instance.serverType,
									version: instance.fullversion
								});
							});
							self.instanceSelection.instances = instances;
							clientInstanceMap[clientId] = instances;
						})
						.error(function(err) {
							self.instanceSelection.selectedInstances = '';
							self.instanceLoaded = true;
							self.instanceErrorMessage = err ? err : cvLoc('generic_error');
						});
				}
			}

			function loadPlans() {
				self.planLoaded = false;
				self.planErrorMessage = '';
				profileService
					.getEligiblePlansForApp(self.data.idaEntity.applicationId)
					.success(function(data) {
						self.planLoaded = true;
						if (data.length > 0) {
							let planListByTypes = {};
							angular.forEach(data, planData => {
								planData = planData.planSummary ? planData.planSummary : planData;
								let planObj = {
									name: planData.plan.planName,
									id: planData.plan.planId,
									type: planData.subtype
								};
								if (planListByTypes[planData.subtype]) {
									planListByTypes[planData.subtype].push(planObj);
								} else {
									planListByTypes[planData.subtype] = [planObj];
								}
							});
							let tempPlanList = [];
							for (let planType in planListByTypes) {
								tempPlanList.push({
									name: planType,
									msGroup: true
								});
								let plansByType = cvUtil.sortAscending(planListByTypes[planType], 'name');
								tempPlanList = tempPlanList.concat(plansByType);
								tempPlanList.push({
									msGroup: false
								});
							}
							self.planSelection.plans = tempPlanList;
						} else {
							self.planSelection.plans = [];
							self.planErrorMessage = cvLoc('error.planNotFound');
						}

						if (self.hasInstancePlan) {
							planSelectonUpdate(self.instancePlanEntity, self.planSelection.plans);
						}
					})
					.error(function(err) {
						self.planLoaded = true;
						self.planErrorMessage = err ? err : cvLoc('generic_error');
					});
			}

			function planSelectonUpdate(selectedPlan, plans) {
				for (let planTypeNode in plans) {
					let planNode = plans[planTypeNode];
					if (planNode && planNode.type) {
						if (selectedPlan.planId === planNode.id) {
							planNode.selected = true;
						} else {
							planNode.selected = false;
						}
					}
				}
			}

			function isvalidEntry(data) {
				if (data == undefined || data == '') {
					return false;
				}
				return true;
			}

			self.validateInputs = function(fromController) {
				var formValid = true;
				self.error = {
					azureStorageConnectionString: false,
					s3BucketName: false,
					userName: false,
					passwordString: false,
					confirmPasswordString: false,
					passwordMismatch: false,
					instance: false
				};
				if (!fromController.$valid && fromController.$error) {
					angular.forEach(fromController.$error.required, function(field) {
						field.$setDirty();
					});
					formValid = false;
				}

				let sqlConnectionDetailsChanged = false;
				self.sqlConnectionDetailsAllSpecified = false;

				if (
					!self.edit &&
					(!self.instanceSelection.selectedInstances || self.instanceSelection.selectedInstances.length == 0)
				) {
					self.error.instance = true;
					return false;
				}

				self.isConnectValidate = true;
				if (self.isOracle) {
					if (
						!self.instanceDetails[self.instanceObjectName].dbUserName ||
						!self.instanceDetails[self.instanceObjectName].dbPassword
					) {
						self.isConnectValidate = false;
						return false;
					}
				}

				if (self.isSQLServer) {
					if (
						(self.isSQLAzure &&
							isvalidEntry(self.instanceDetails[self.instanceObjectName].azureInfo.azureStorageConnectionString)) ||
						(self.isSQLAmazon && isvalidEntry(self.instanceDetails[self.instanceObjectName].awsSqlInfo.s3BucketName)) ||
						isvalidEntry(self.instanceDetails[self.instanceObjectName].SAUser.userName) ||
						isvalidEntry(self.instanceDetails[self.instanceObjectName].SAUser.passwordString) ||
						isvalidEntry(self.instanceDetails[self.instanceObjectName].SAUser.confirmPasswordString)
					) {
						sqlConnectionDetailsChanged = true;
					}

					if (
						((self.isSQLAzure &&
							isvalidEntry(self.instanceDetails[self.instanceObjectName].azureInfo.azureStorageConnectionString)) ||
							(self.isSQLAmazon &&
								isvalidEntry(self.instanceDetails[self.instanceObjectName].awsSqlInfo.s3BucketName))) &&
						isvalidEntry(self.instanceDetails[self.instanceObjectName].SAUser.userName) &&
						isvalidEntry(self.instanceDetails[self.instanceObjectName].SAUser.passwordString) &&
						isvalidEntry(self.instanceDetails[self.instanceObjectName].SAUser.confirmPasswordString)
					) {
						self.sqlConnectionDetailsAllSpecified = true;
					}

					if (
						!self.edit &&
						((self.data.isSQLCloudConfigured &&
							sqlConnectionDetailsChanged &&
							!self.sqlConnectionDetailsAllSpecified) ||
							(!self.data.isSQLCloudConfigured && !self.sqlConnectionDetailsAllSpecified))
					) {
						self.openAccordion = true;

						if (
							self.isSQLAzure &&
							!isvalidEntry(self.instanceDetails[self.instanceObjectName].azureInfo.azureStorageConnectionString)
						) {
							self.error.azureStorageConnectionString = true;
							return false;
						}

						if (
							self.isSQLAmazon &&
							!isvalidEntry(self.instanceDetails[self.instanceObjectName].awsSqlInfo.s3BucketName)
						) {
							self.error.s3BucketName = true;
							return false;
						}

						if (!isvalidEntry(self.instanceDetails[self.instanceObjectName].SAUser.userName)) {
							self.error.userName = true;
							return false;
						}

						if (!isvalidEntry(self.instanceDetails[self.instanceObjectName].SAUser.passwordString)) {
							self.error.passwordString = true;
							return false;
						}

						if (!isvalidEntry(self.instanceDetails[self.instanceObjectName].SAUser.confirmPasswordString)) {
							self.error.confirmPasswordString = true;
							return false;
						}
					}
				} else if (
					!_.isEmpty(self.instanceObjectName) &&
					(!isvalidEntry(self.instanceDetails[self.instanceObjectName].SAUser.userName) ||
						(!self.edit &&
							(!isvalidEntry(self.instanceDetails[self.instanceObjectName].SAUser.passwordString) ||
								!isvalidEntry(self.instanceDetails[self.instanceObjectName].SAUser.confirmPasswordString))) ||
						!isvalidEntry(self.instanceDetails[self.instanceObjectName].MaintainenceDB))
				) {
					self.openAccordion = true;
				}

				if (
					!_.isEmpty(self.instanceObjectName) &&
					!self.edit &&
					self.instanceDetails[self.instanceObjectName].SAUser.passwordString !==
						self.instanceDetails[self.instanceObjectName].SAUser.confirmPasswordString
				) {
					self.error.passwordMismatch = true;
					self.instanceDetails[self.instanceObjectName].SAUser.passwordString = '';
					self.instanceDetails[self.instanceObjectName].SAUser.confirmPasswordString = '';
					return false;
				}

				if (self.isGenericScreen) {
					self.submitAttempted = true;
					if (!isPlanSelected() && !self.isParentMigrate) {
						formValid = false;
					}
					$scope.$apply();
				}

				return formValid;
			};

			function isPlanSelected() {
				return (
					self.data.planPolicyModel &&
					self.data.planPolicyModel.plan &&
					self.data.planPolicyModel.plan.selected &&
					self.data.planPolicyModel.plan.selected.id
				);
			}

			function updateData() {
				//set the password as Byte array
				if (!self.isGCPSpanner) {
					if (self.instanceDetails[self.instanceObjectName].SAUser.passwordString) {
						self.instanceDetails[self.instanceObjectName].SAUser.password = cvUtil.getBytes(
							self.instanceDetails[self.instanceObjectName].SAUser.passwordString
						);
					} else {
						self.instanceDetails[self.instanceObjectName].SAUser.password = null;
					}
				}

				//set mssqlInstance
				if (self.isSQLServer) {
					self.instanceDetails[self.instanceObjectName].serverType =
						self.instanceSelection.selectedInstances[0].serverType;
					if (self.isSQLAzure) {
						self.instanceDetails[self.instanceObjectName].overrideHigherSettings =
							self.sqlConnectionDetailsAllSpecified && self.sqlConnectionDetailsAllSpecified == true;
						self.instanceDetails[self.instanceObjectName].azureInfo.azureSqlInstanceCredentials = {
							userName: self.instanceDetails[self.instanceObjectName].SAUser.userName,
							password: self.instanceDetails[self.instanceObjectName].SAUser.password
						};
					} else if (self.isSQLAmazon) {
						self.instanceDetails[self.instanceObjectName].overwriteAwsHigherLevelSettings =
							self.sqlConnectionDetailsAllSpecified && self.sqlConnectionDetailsAllSpecified == true;
						self.instanceDetails[self.instanceObjectName].awsSqlInfo.sqlInstanceCredentials = {
							userName: self.instanceDetails[self.instanceObjectName].SAUser.userName,
							password: self.instanceDetails[self.instanceObjectName].SAUser.password
						};
					}

					self.instance.instanceId = null;
				}

				if (self.isOracle) {
					let sqlConnect = {
						domainName: self.instanceDetails[self.instanceObjectName].domainName,
						password: cvUtil.getBytes(self.instanceDetails[self.instanceObjectName].dbPassword),
						userName: self.instanceDetails[self.instanceObjectName].dbUserName
					};
					self.instanceDetails.oracleInstance.sqlConnect = sqlConnect;
				} else if (self.isPostgreSQL) {
					self.instanceDetails.postGreSQLInstance.port = self.instanceDetails.dbPort;
				} else if (self.isMySQL) {
					self.instanceDetails.mySqlInstance.port = self.instanceDetails.dbPort;
				}
				//set plan

				if (self.isGenericScreen && !self.isParentMigrate) {
					self.instanceDetails.planEntity = { planId: self.data.planPolicyModel.plan.selected.id };
				} else {
					if (self.planSelection.selectedPlans && self.planSelection.selectedPlans.length > 0) {
						self.instanceDetails.planEntity = { planId: self.planSelection.selectedPlans[0].id };
					}
				}

				//Set service type for amazon cloud db instances
				if (self.cloudDBEngineType && self.isPostgreSQL) {
					self.instanceDetails.postGreSQLInstance.cloudDBEngineType = self.cloudDBEngineType;
				} else if (self.cloudDBEngineType && self.isMySQL) {
					self.instanceDetails.mySqlInstance.cloudDBEngineType = self.cloudDBEngineType;
				}

				if (!self.edit && !self.isGCPSpanner) {
					if (!self.isSQLServer) {
						if (self.isPostgreSQL || self.isMySQL) {
							if (self.instanceDetails[self.instanceObjectName].port.trim().length === 0) {
								self.instanceDetails[self.instanceObjectName].port = self.instanceSelection.selectedInstances[0].port;
							}
						} else {
							self.instanceDetails[self.instanceObjectName].port = self.instanceSelection.selectedInstances[0].port;
						}
					}
					self.instanceDetails.version = self.instanceSelection.selectedInstances[0].version;

					if (self.data.idaEntity.applicationId === AppTypes.MYSQL) {
						self.instanceDetails[self.instanceObjectName].version = self.instanceSelection.selectedInstances[0].version;
					}
				}

				if (self.isGCPSpanner) {
					let stagingPath = _.get(self.stagingBucketInputOptions, 'inputOptions.destLocation.local');
					_.set(self.instanceDetails, 'cloudAppsInstance.cloudSpannerInstance.cloudStagingPath', stagingPath);
				}
			}

			self.submitData = function() {
				updateData();

				//In case of add instance dialog check for the client selection validation
				if (!self.edit) {
					self.instance.clientName = self.clientSelection.selectedClients[0].clientName;
					self.instance.clientId = self.clientSelection.selectedClients[0].clientId;
					self.instance.instanceName = self.instanceSelection.selectedInstances[0].instanceName;
				}

				var reqParams = {
					instanceEntity: angular.toJson(self.instance),
					instanceProps: angular.toJson(self.instanceDetails),
					password: '',
					osUserPassword: ''
				};

				idaService
					.createInstance(reqParams, self.instance.instanceId > 0)
					.success(function(successData) {
						globalCacheFactory.refreshCacheId();
						if (successData.errorCode && successData.errorCode > 0) {
							console.log('Error: ' + successData.errorString);
							cvToaster.showErrorMessage({
								ttl: '7000',
								message: successData.errorString
							});
						}

						if (successData.entity && successData.entity.instanceId >= 0) {
							$scope.$emit('instanceAdded', successData.entity.instanceId);
						}
						self.modalInstance.close();
						if (!self.isParentMigrate) {
							$state.go($state.current, {}, { reload: true });
						}
					})
					.error(function(errorReason) {
						console.log('Error: ' + errorReason);
						cvToaster.showErrorMessage({
							ttl: '7000',
							message: errorReason
						});

						$scope.$emit('instanceAddFailed');
						self.modalInstance.close();
						$state.go($state.current, {}, { reload: true });
					});
			};

			self.closeDialogBox = function() {
				self.modalInstance.close();
				$scope.$emit('instanceAddCancelled');
			};

			self.addHypervisorDialog = function() {
				var modalInstance = $modal.open({
					templateUrl: appUtil.appRoot + 'vsa/partials/addServerContent.jsp',
					windowClass: 'addServerModal',
					backdrop: 'static',
					controller: [
						'params',
						'$scope',
						'$window',
						'$log',
						'$uibModalInstance',
						function(params, $scope, $window, $log, $modalInstance) {
							$scope.isSubModal = params.isSubModal;
							$scope.$on('serverAdded', function(evt, serverId, sqlConnectionDetailsAllSpecified) {
								$log.debug('serverAdded....');
								$scope.data.isSQLCloudConfigured =
									sqlConnectionDetailsAllSpecified && sqlConnectionDetailsAllSpecified === true;
								loadClients();
								$modalInstance.dismiss();
							});

							$scope.$on('serverAddFailed', function() {
								$log.debug('serverAdd Failed....');
							});
							$scope.$on('serverAddCancelled', function() {
								$log.debug('serverAddCancelled....');
								$modalInstance.dismiss();
							});
						}
					],
					resolve: {
						params: {
							isSubModal: true
						}
					}
				});
			};

			initInstanceData();
		};
	}
]);

export default app;
