import 'adminConsole/js/services/clients.svc.js';

import { commonAllAgentsModule } from 'common/js/modules';

var allAgentMod = commonAllAgentsModule;

var clientPickerCtrl = [
	'cvLoc',
	'clientService',
	'$timeout',
	'cvUtil',
	'AppTypes',
	function(cvLoc, clientService, $timeout, cvUtil, AppTypes) {
		var self = this;
		this.$onInit = function() {
			//Holds the list of all the avialabel clients
			self.clientList = [];

			self.selectionMode;
			self.helperElements;
			if (self.mulitiSelection && self.mulitiSelection === true) {
				self.selectionMode = 'multiple';
				self.helperElements = 'all none reset filter';
			} else {
				self.selectionMode = 'single';
				self.helperElements = 'filter';
			}

			if (!self.appId) {
				self.appId = 0;
			}
			//Holds all the labels for the isteven-multi-select component
			self.localLang = cvUtil.getIStevenLocLabels();
			self.localLang.nothingSelected = cvLoc(
				self.nothingSelectedLocKey ? self.nothingSelectedLocKey : 'option.clientName'
			);

			/**
			 * Loads the all the clients on the cs
			 */
			self.loadClients = function() {
				clientService
					.getClientsByAppId(self.appId, true)
					.success(function(data) {
						var selectedClient = { clientEntity: {} };
						self.valideClientSelection = false;
						if (data) {
							var listOfClients = [];
							data.forEach(function(clientInfo) {
								//Filter out os 0 clients if excludePseudoClients is set

								var isDeletedClient = _.get(clientInfo, 'clientProps.IsDeletedClient', false);
								if (self.appId == AppTypes.SQL_SERVER && clientInfo.clientProps.clientStatus & 0x20000000) {
									//filter pseudo ag client
									return;
								} else if ((self.excludePseudoClients && clientInfo.client.osInfo.osId === 0) || isDeletedClient) {
									return;
								}
								let displayName = _.get(clientInfo, 'client.clientEntity.displayName');
								if (_.isEmpty(displayName)) {
									_.set(clientInfo, 'client.clientEntity.displayName', clientInfo.client.clientEntity.clientName);
								}
								listOfClients.push(clientInfo.client.clientEntity);
							});
							if (listOfClients.length > 0) {
								self.clientList = cvUtil.sortAscending(listOfClients, 'clientName');
								var defaultIndex = self.selectNoneByDefault ? -1 : 0;
								if (self.defaultClientId) {
									for (var i = 0; i < self.clientList.length; ++i) {
										if (self.clientList[i].clientId === parseInt(self.defaultClientId)) {
											defaultIndex = i;
										}
									}
								}
								if (defaultIndex >= 0) {
									self.clientList[defaultIndex].ticked = true;
									self.valideClientSelection = true;
									selectedClient = { clientEntity: self.clientList[defaultIndex] };
								}
							}
							if (self.clientsLoaded) {
								self.clientsLoaded({ listOfClients: listOfClients });
							}
						}
						if (self.selectionChanged && !self.selectNoneByDefault) {
							self.selectionChanged(selectedClient);
						}
					})
					.error(function(data) {
						self.serverMessage = cvUtil.errMsgLoc('error.getServers');
					});
			};
			self.loadClients();

			/**
			 * Validates client selection is valid or not
			 */
			self.validateClientSelection = function() {
				var selectedClients = self.clientList.filter(function(curr) {
					return curr['ticked'] === true;
				});
				self.valideClientSelection = selectedClients && selectedClients.length > 0;
				if (self.selectionChanged && self.valideClientSelection) {
					self.selectionChanged({ clientEntity: selectedClients[0] });
				}
				return self.valideClientSelection;
			};
		};
	}
];

var directive = function() {
	return {
		restrict: 'E', //E = element
		templateUrl: appUtil.appRoot + 'modules/ida/partials/clientPickeTemplate.jsp',
		scope: {},
		bindToController: {
			selectedClients: '=',
			mulitiSelection: '=',
			valideClientSelection: '=',
			selectionChanged: '&',
			clientsLoaded: '&',
			defaultClientId: '@',
			excludePseudoClients: '@',
			appId: '@',
			nothingSelectedLocKey: '@',
			selectNoneByDefault: '='
		},
		controller: clientPickerCtrl,
		controllerAs: 'clientPickerCtrl'
	};
};

allAgentMod.directive('cvClientPicker', directive);

export default allAgentMod;
