import { commonAllAgentsModule } from 'common/js/modules';

var mod = commonAllAgentsModule;

/**
 * A directive used to display and control the functionality of the facets for a browse response.
 *
 * @param {Object=}
 *            facets - The facets to display.
 */
mod.directive('cvBrowseFacets', [
	function() {
		return {
			restrict: 'E',
			scope: {
				facets: '=',
				onChange: '&'
			},
			link: function(scope, element, attr) {
				element.addClass('facet-container');
			},
			templateUrl: appUtil.appRoot + 'modules/ida/partials/facets.jsp',
			controller: [function() {}]
		};
	}
]);

/**
 * A directive for displaying the facet parameters for an individual facet.
 *
 * @param {Object[]}
 *            parameters - The facet parameters
 */
mod.directive('cvFacetParameters', [
	function() {
		return {
			require: '^^cvBrowseFacets',
			templateUrl: appUtil.appRoot + 'modules/ida/partials/facetParameters.jsp',
			scope: {
				parameters: '=',
				facetName: '@',
				onChange: '&'
			},
			controllerAs: 'cvFacetParametersController',
			controller: [
				'$scope',
				function($scope) {
					var self = this;
					self.allSelected = true;

					/**
					 * Returns whether or not the "All" option in the facets should be selected by checking if
					 * every other facet has a "selected" value of "false".
					 *
					 * @return True if the "All" option should be selected; False otherwise.
					 */
					self.shouldAllBeSelected = function() {
						if (angular.isArray($scope.parameters)) {
							return $scope.parameters.every(function(param) {
								return !param.selected;
							});
						}
						return true;
					};

					/**
					 * Called when a parameter (besides "All") is selected. Determines whether or not all needs to
					 * be selected or not.
					 */
					self.paramSelected = function() {
						self.allSelected = self.shouldAllBeSelected();
					};

					/**
					 * Deselects all facet parameters given in the directive.
					 */
					self.deselectAll = function() {
						if (angular.isArray($scope.parameters)) {
							angular.forEach($scope.parameters, function(param) {
								param.selected = false;
							});
						}
					};
				}
			]
		};
	}
]);

export default mod;
