import { cappsAppCappsClientModule } from 'common/js/modules';

import 'modules/ida/js/directives/gcp-staging-bucket-input.directive.js';

class GCPSpannerInputsController {
	constructor(
		cvUtil,
		cappsClientService,
		$scope,
		REGEX,
		subclientFactory,
		serverService,
		AppTypes,
		cvLoc,
		CAPPS_CONSTANTS
	) {
		this.cvUtil = cvUtil;
		this.cappsClientService = cappsClientService;
		this.$scope = $scope;
		this.REGEX = REGEX;
		this.subclientFactory = subclientFactory;
		this.serverService = serverService;
		this.AppTypes = AppTypes;
		this.cvLoc = cvLoc;
		this.CAPPS_CONSTANTS = CAPPS_CONSTANTS;

		this.instancesLoc = this.cvUtil.getIStevenLocLabels();
		this.instancesLoc.nothingSelected = this.cvLoc('error.noInstanceSelected');

		this.databasesLoc = this.cvUtil.getIStevenLocLabels();
		this.databasesLoc.nothingSelected = this.cvLoc('label.allDatabases');
		this.databasesLoc.selectAll = this.cvLoc('label.allDatabases');

		this.errorMessages = {
			instances: ''
		};
	}

	$onInit() {
		if (this.inputOptions) {
			console.log(this.inputOptions);
		}
		this._fetchAndDisplayInstances();

		this._setupWatchers();
		this._setupOptions();
	}

	_fetchAndDisplayInstances() {
		this.showInstances = false;

		this.accessNodes = _.map(this.inputOptions.accessNodes, ({ client }) => ({
			client: { clientId: client.clientId }
		}));

		this.cappsClientService.getGoogleSpannerInstances(this.inputOptions.cloudAccountId, this.accessNodes).then(
			response => {
				this.showInstances = true;

				if (response.data && response.data.errorResp && response.data.errorResp.errorCode !== 0) {
					this.errorMessages.instances = response.data.errorResp.errorMessage;
					return;
				}

				this.errorMessages.instances = '';
				this.instances = _.get(response, 'data.cloudDBEntity.children', []);
			},
			error => {
				console.log(error);
			}
		);
	}

	onInstanceChanged(instance) {
		this._fetchAndDisplayDatabases(instance);
	}

	_fetchAndDisplayDatabases(instance) {
		this.showDatabases = false;

		let projectId = instance.path;
		let instanceName = instance.name;

		this.cappsClientService
			.getDatabases(this.inputOptions.cloudAccountId, this.accessNodes, projectId, instanceName)
			.then(
				response => {
					this.showDatabases = true;

					if (response.data && response.data.errorResp && response.data.errorResp.errorCode !== 0) {
						this.errorMessages.databases = response.data.errorResp.errorMessage;
						return;
					}

					this.errorMessages.databases = '';

					this.databases = _.get(response, 'data.cloudDBEntity.children', []);
				},
				error => {
					console.log(error);
				}
			);
	}

	_setupWatchers() {
		this.$scope.$watch('inputOptions.cloudAccountId', (oldvalue, newValue) => {
			if (oldvalue !== newValue) {
				this._setupOptions();
				this._fetchAndDisplayInstances();
			}
		});

		this.$scope.$watch('GCPSpannerCtrl.inputOptions.accessNodes', (oldvalue, newValue) => {
			if (oldvalue !== newValue) {
				this._setupOptions();
				this._fetchAndDisplayInstances();
			}
		});
	}

	_getDatabasesInput() {
		// If all databases are selected, send empty array, empty array signifies all databases
		return this.databases.length !== this.selectedDatabases.length ? this.selectedDatabases : [];
	}

	_getSpannerInputs() {
		return {
			stagingBucketPath: _.get(this.GCPStagingInputOptions, 'destLocation.local'),
			instance: _.get(this.selectedInstance, '[0]'),
			database: this._getDatabasesInput()
		};
	}

	_setupOptions() {
		this.inputOptions.getSpannerInputs = this._getSpannerInputs.bind(this);

		this.GCPStagingInputOptions = {
			...this.inputOptions,
			destLocation: {
				local: ''
			}
		};
	}
}

GCPSpannerInputsController.$inject = [
	'cvUtil',
	'cappsClientService',
	'$scope',
	'REGEX',
	'subclientFactory',
	'serverService',
	'AppTypes',
	'cvLoc',
	'CAPPS_CONSTANTS'
];

cappsAppCappsClientModule.directive('gcpSpannerInputs', () => ({
	restrict: 'E',
	templateUrl: appUtil.appRoot + 'modules/ida/partials/GCPSpannerInputs.jsp',
	bindToController: true,
	replace: true,
	controller: GCPSpannerInputsController,
	controllerAs: 'GCPSpannerCtrl',
	scope: {
		inputOptions: '=',
		formName: '='
	}
}));

export default cappsAppCappsClientModule;
