import 'modules/ida/js/directives/cv-browse-vsa-search-directive.js';
import 'modules/ida/js/directives/cv-browse-directives.js';
import 'modules/ida/js/services/idaService.svc.js';
import 'browse/js/services/browse.svc.js';
import 'vsa/js/controllers/virtualMachineBrowse.ctrl.js';
import 'machineBrowse/js/controllers/machineBrowse.ctrl.js';
import 'adminConsole/js/services/clients.svc.js';
import 'modules/servers/js/services/servers.svc.js';
import 'vsa/js/services/restore.svc.js';
import 'adminConsole/js/services/browseForAgents.svc.js';
import 'vsa/js/factories/downloads.factory.js';

import { commonAllAgentsModule } from 'common/js/modules';

/**
 *
 * @author jtalwar
 *
 */

/**
 * A controller for handling the functionality on the vsa file browse page.
 */
commonAllAgentsModule.controller('vsaFileBrowseController', [
	'$q',
	'$uibModal',
	'idaService',
	'$stateParams',
	'cvLoc',
	'cvUtil',
	'cvBreadcrumbsTabsFactory',
	'uiGridConstants',
	'browseService',
	'$uibModal',
	'selectionService',
	'downloadsFactory',
	'$filter',
	'serverService',
	function(
		$q,
		$uibModal,
		idaService,
		$stateParams,
		cvLoc,
		cvUtil,
		cvBreadcrumbsTabsFactory,
		uiGridConstants,
		browseService,
		$modal,
		selectionService,
		downloadsFactory,
		$filter,
		serverService
	) {
		var self = this;

		var subclient = null;
		self.path = $stateParams['path'];
		self.scid = $stateParams['subclientId'];
		self.vmName = $stateParams['vmname'];
		self.vmGuid = self.vmName ? browseService.getVmGuidFromPath($stateParams['path']) : '';
		//self.owner = $stateParams['owner'] == '1' ? 1 : 0;
		self.vendor = $stateParams['vendor'];
		self.separator = '\\';
		self.copyPrecedence = $stateParams['copyPrecedence'];
		// send request to fetchFileProperties
		self.fetchFileProperties = false;

		self.entityType = 'SUBCLIENT_ENTITY';
		self.entityId = self.scid;
		//		$stateParams['subclientId'] = self.scid;

		self.searchTerm = $stateParams['searchTerm'];
		self.ciDate = $stateParams['ciDate'];

		self.onDownload = function(restoreParams) {
			var selectedPaths = [];
			angular.forEach(restoreParams.items, function(item) {
				selectedPaths.push(item.userObject);
			});

			var downloadSubmitted = downloadsFactory.downloadSelections(
				selectedPaths,
				self.path,
				'vsFileBrowse',
				self.vmName
			);
		};

		// populate the client subclient details for future restore purposes
		if (self.vmGuid) {
			serverService
				.getVmDetails({
					vmGuid: self.vmGuid
				})
				.success(function(data) {
					browseService.entity = {
						clientId: data.vmStatusInfoList[0].pseudoClient.clientId,
						clientName: data.vmStatusInfoList[0].pseudoClient.clientName,
						displayClientName: data.vmStatusInfoList[0].pseudoClient.clientName,
						subclientId: data.vmStatusInfoList[0].subclientId,
						subclientName: data.vmStatusInfoList[0].subclientName
						// also set the vm details so that it is available in restore window
					};
					browseService.entity.vm = data.vmStatusInfoList[0];
				})
				.error(function() {
					//$scope.serverMessage = cvUtil.errMsgLoc('error.getVM.details');
				});
		} else {
			browseService
				.getEntity(self.scid)
				.success(function(data) {
					browseService.entity = data;
				})
				.error(function(e) {
					//$scope.serverMessage = cvUtil.errMsgLoc('error.getServerDetails');
				});
		}

		self.browseOptions = {
			getEntity: idaService.getNodeEntity.bind(undefined, self.entityType, self.entityId),
			getBrowseData: idaService.getIdaBrowseData.bind(undefined, self.entityId, self.entityType),
			/*
			 * Shows the button for collapsing the left tree.
			 */
			showCollapseTreeButton: true,

			/*
			 * Filtering by the date of backups is not supported for the VSA search.
			 */
			showDateFilter: false,

			showResultsHeaderLabel: self.ciDate
				? cvLoc('label.resultsAsOf') + ' ' + $filter('date')(self.ciDate * 1000, 'MMM d, h:mm:ss a')
				: '',

			showDownload: downloadsFactory.showDownloadOption('vsFileBrowse', self.vmName, self.vendor),

			/*
			 * This variable is used to disable actions on the search page
			 */
			disableSearchActions: false,

			/**
			 * Hook for customizing the root label's name.
			 *
			 * @param {Object}
			 *            root - The root entity retrieved for the browse page.
			 */
			rootLabel: function(root) {
				return self.vmName;
			},

			/**
			 * Called when the user selects the "Restore" button above the browse table.
			 *
			 * @param {Object[]}
			 *            items - An array of items that the user wants to restore.
			 */
			onRestore: function(restoreParams) {
				var selectedPaths = [];
				angular.forEach(restoreParams.items, function(item) {
					selectedPaths.push(item.userObject);
				});

				//this is needed by the fileLevelRestoreController
				selectionService.selectionArray = selectedPaths;
				selectionService.selectionCount = selectedPaths.length;

				var doShowRestoreDialogSub = function(browseType, serverVendor, selectedRows) {
					var restoreModal = $modal.open({
						templateUrl: appUtil.appRoot + 'vsa/partials/restoreVM.jsp',
						// windowClass : 'addServerModal',
						backdrop: 'static',
						controller: [
							'$scope',
							'$uibModalInstance',
							'$state',
							'cvLoc',
							function($scope, $modalInstance, $state, cvLoc) {
								$scope.vendor = serverVendor;
								$scope.browseType = browseType;
								$scope.$modalInstance = $modalInstance; //unfortunately $modalInstance is not being injected in modal's controller, so passing it through scope hierarchy
								$scope.cancel = function() {
									$modalInstance.dismiss();
								};

								$scope.buildRestoreModalUrl = function(filePath) {
									return appUtil.appRoot + 'vsa/partials/' + filePath;
								};
							}
						],
						resolve: {
							selectedRows: function() {
								return self.selectedRows;
							}
						}
					});
				};

				doShowRestoreDialogSub('vsFileBrowse', self.vendor, selectedPaths);
			},

			onDownload: function(restoreParams) {
				var selectedPaths = [];
				angular.forEach(restoreParams.items, function(item) {
					selectedPaths.push(item.userObject);
				});

				var downloadSubmitted = downloadsFactory.downloadSelections(
					selectedPaths,
					self.path,
					'vsFileBrowse',
					self.vmName
				);
			},

			/**
			 * Called when the entity from the cv-browse directive is retrieved. We can use this hook to build
			 * our breadcrumbs.
			 *
			 * @param {Object}
			 *            The entity that was retrieved.
			 */
			onEntityRetrieval: function(entity) {
				subclient = entity;
				cvBreadcrumbsTabsFactory.clearBc();
				cvBreadcrumbsTabsFactory.addBreadCrumbs([
					{
						title: cvLoc('label.vms'),
						link: '#virtualization/vms'
					},
					{
						title: self.vmName,
						link: '#/vm/' + self.vmGuid
					}
				]);
			},

			/**
			 * Called before a request is sent to the Browse service for populating the left-hand tree in the
			 * browse directive.
			 *
			 * @param {Object}
			 *            item - An optional item that the user has clicked on and wants to browse.
			 * @return {Object} The parameters to be sent to the browse request.
			 */
			onBeforeBrowseTreeRequest: function(item) {
				var params = {
					subclientId: self.scid,
					vsFileBrowse: true,
					isVSA: true,
					fetchFileProperties: self.fetchFileProperties,
					entityType: self.entityType,
					//explicitly mention appId for VSA as for end user it is not retreived correctly in backend
					appType: '106'
				};

				/*
				 * If the item has a "userObject" property, then it's not the root node.
				 */
				if (angular.isObject(item.userObject)) {
					return angular.extend(params, {
						path: item.userObject.path
					});
				} else {
					return angular.extend(params, {
						path: '\\' + self.vmGuid
					});
				}
			},

			/**
			 * Called before a request is sent to the Browse service for populating the right-hand table in
			 * the browse directive.
			 *
			 * @param {Object}
			 *            item - An optional item that the user has clicked on and wants to browse.
			 * @param {boolean}
			 *            forSearch - Whether or not the request was for a search.
			 * @return {Object} The parameters to be sent to the browse request.
			 */
			onBeforeBrowseTableRequest: function(item, forSearch) {
				var params = {
					subclientId: self.scid,
					vsFileBrowse: true,
					isVSA: true,
					fetchFileProperties: self.fetchFileProperties,
					entityType: self.entityType,
					//explicitly mention appId for VSA as for end user it is not retreived correctly in backend
					appType: '106'
				};

				/*
				 * If the item has a "userObject" property, then it's not the root node.
				 */
				if (angular.isObject(item.userObject)) {
					return angular.extend(params, {
						path: item.userObject.path
					});
				} else {
					return angular.extend(params, {
						path: '\\' + self.vmGuid
					});
				}
			},

			/**
			 * Called when the browse table on the right hand side is going to be built.
			 *
			 * @param {Object}
			 *            params - The parameters for the function
			 * @param {Object}
			 *            params.tableEntity - The entity that was selected to browse for the table.
			 * @param {Object}
			 *            params.gridOptions - The grid options to manipulate if you see fit.
			 * @param {boolean}
			 *            params.forSearch - Whether or not the table will be used for a search response.
			 *
			 *
			 */
			onBeforeBrowseTableBuilt: function(params) {
				var item = params.tableEntity;
				var gridOptions = params.gridOptions;
				var forSearch = params.forSearch;

				var colDefs = [];
				var nameColumn = {
					field: 'label',
					displayName: cvLoc('Name'),
					headerTooltip: true,
					cellTemplate: '<div class="crop" title="{{row.entity.label}}">{{row.entity.label}}</div>',
					width: '25%',
					sortParam: 'FileName',
					sort: {
						direction: uiGridConstants.ASC
					}
				};
				colDefs.push(nameColumn);

				var typeColumn = {
					field: 'fileType',
					displayName: cvLoc('content.header.type'),
					headerTooltip: true,
					cellTemplate: '<div class="crop" title="{{row.entity.fileType}}">{{row.entity.fileType}}</div>',
					width: '*',
					enableSorting: false
				};
				colDefs.push(typeColumn);

				var filePathColumn = {
					field: 'userObject.displayPath',
					displayName: cvLoc('label.path'),
					headerTooltip: true,
					cellTemplate:
						'<div class="crop" title="{{grid.appScope.extractFilePath(row.entity.userObject.displayPath)}}">{{grid.appScope.extractFilePath(row.entity.userObject.displayPath)}}</div>',
					width: '*',
					sortParam: 'Folderpath',
					enableSorting: false
				};

				if (forSearch) {
					colDefs.push(filePathColumn);
				}

				var sizeColumn = {
					field: 'userObject.size',
					displayName: cvLoc('Size'),
					headerTooltip: true,
					cellTemplate:
						'<div data-ng-if="row.entity.userObject.flags.file" class="crop" title="{{row.entity.userObject.size|capacity}}">{{row.entity.userObject.size|capacity}}</div>',
					width: '*',
					sortParam: 'FileSize',
					enableSorting: true
				};
				colDefs.push(sizeColumn);

				var modTimeColumn = {
					field: 'userObject.modificationTime',
					displayName: cvLoc('label.dateModified'),
					headerTooltip: true,
					cellTemplate: '<div class="time crop" val="{{row.entity.userObject.modificationTime}}"></div>',
					width: '*',
					enableSorting: true,
					sortParam: 'ModifiedDate'
				};
				colDefs.push(modTimeColumn);

				gridOptions.gridOptions.columnDefs = colDefs;
			},
			/*
			 * external handler to disable search actions (Restore/download) if there is more than one row
			 * selected
			 */
			gridSelectionHandlerForActions: function(selections) {
				if (selections && selections.length > 1) {
					return false;
				}
				return false;
			}
		};
	}
]);

export default commonAllAgentsModule;
