import { commonAllAgentsModule } from 'common/js/modules';
import 'modules/ida/js/directives/cv-date-time-picker.js';
import 'modules/ida/js/directives/cv-client-picker.js';

var app = commonAllAgentsModule;

app.controller('sybaseInstanceController', [
	'globalCacheFactory',
	'$scope',
	'$state',
	'$uibModalInstance',
	'$log',
	'cvToaster',
	'data',
	'storageService',
	'instanceService',
	'idaService',
	'postgresService',
	'mbService',
	'cvLoc',
	'cvUtil',
	'clientDetailService',
	'profileService',
	'AppTypes',
	function(
		globalCacheFactory,
		$scope,
		$state,
		$modalInstance,
		$log,
		cvToaster,
		data,
		storageService,
		instanceService,
		idaService,
		postgresService,
		mbService,
		cvLoc,
		cvUtil,
		clientDetailService,
		profileService,
		AppTypes
	) {
		var self = this;
		self.data = data;

		//exposed functions
		self.submitData = submitData;
		self.validateInputs = validateInputs;
		self.parseIStevenOutput = parseIStevenOutput;
		self.configFileResuleFunction = configFileResuleFunction;
		self.sybaseHomeResuleFunction = sybaseHomeResuleFunction;
		self.sharedMemoryDirectoryResuleFunction = sharedMemoryDirectoryResuleFunction;
		self.closeDialogBox = function() {
			$modalInstance.close();
		};

		initData();

		// ******************** Functions ***********************

		function parseIStevenOutput() {
			if (self.selectedProfileList && self.selectedProfileList.length === 1) {
				self.showPlanError = false;
			} else {
				self.showPlanError = self.showPlan;
			}
		}

		// Machine browse functions
		function configFileResuleFunction(result) {
			if (result) {
				self.instanceDetails.sybaseInstance.configFile = result.path;
			}
		}

		function sybaseHomeResuleFunction(result) {
			if (result) {
				self.instanceDetails.sybaseInstance.sybaseHome = result.path;
			}
		}

		function sharedMemoryDirectoryResuleFunction(result) {
			if (result) {
				self.instanceDetails.sybaseInstance.sharedMemoryDirectory = result.path;
			}
		}

		/* load plans */
		function loadPlans() {
			profileService
				.getEligiblePlansForApp(AppTypes.CV_APPTYPE_SYBASE)
				.success(function(data) {
					if (data.length > 0) {
						let planListByTypes = {};
						angular.forEach(data, planData => {
							planData = planData.planSummary ? planData.planSummary : planData;
							let planObj = {
								name: planData.plan.planName,
								id: planData.plan.planId,
								type: planData.subtype,
								numAssocEntities: planData.numAssocEntities,
								numCopies: planData.numCopies,
								rpoInMinutes: planData.rpoInMinutes,
								planSummary: _.get(planData, 'plan.planSummary')
							};

							if (planListByTypes[planData.subtype]) {
								planListByTypes[planData.subtype].push(planObj);
							} else {
								planListByTypes[planData.subtype] = [planObj];
							}
						});
						let tempPlanList = [];
						for (let planType in planListByTypes) {
							tempPlanList.push({
								name: planType,
								msGroup: true
							});
							let plansByType = cvUtil.sortAscending(planListByTypes[planType], 'name');
							tempPlanList = tempPlanList.concat(plansByType);
							tempPlanList.push({
								msGroup: false
							});
						}
						self.profileList = tempPlanList;
					} else {
						self.profileList = [];
					}

					if (self.hasInstancePlan) {
						planSelectonUpdate(self.instancePlanEntity, self.profileList);
					}
				})
				.error(function(e) {
					self.serverMessage = cvUtil.errMsg(e);
				});
		}

		function planSelectonUpdate(selectedPlan, profileList) {
			for (let planTypeNode in profileList) {
				let planNode = profileList[planTypeNode];
				if (planNode && planNode.type) {
					if (selectedPlan.planId === planNode.id) {
						planNode.selected = true;
						self.showPlanError = false;
					} else {
						planNode.selected = false;
					}
				}
			}
		}

		function clearPlanSelection() {
			let profileList = self.profileList;
			for (let planTypeNode in profileList) {
				let planNode = profileList[planTypeNode];
				if (planNode && planNode.type && planNode.selected) {
					planNode.selected = false;
				}
			}
			self.showPlanError = self.showPlan;
		}

		function loadClientPlan(clientId) {
			clientDetailService
				.getClientPlan(clientId)
				.success(function(data) {
					let clientPlanEntity = _.get(data, 'summary.plan');
					let hasClientPlan = clientPlanEntity && clientPlanEntity.planId > 0;
					if (self.edit) {
						if (self.hasInstancePlan) {
							self.isShowPlan = true;
							planSelectonUpdate(self.instancePlanEntity, self.profileList);
						} else if (hasClientPlan) {
							self.isShowPlan = true;
							planSelectonUpdate(clientPlanEntity, self.profileList);
						} else {
							self.isShowPlan = false;
							clearPlanSelection();
						}
					} else {
						self.isShowPlan = true;
						if (hasClientPlan) {
							planSelectonUpdate(clientPlanEntity, self.profileList);
						} else {
							clearPlanSelection();
						}
					}
				})
				.error(function(e) {
					self.isShowPlan = false;
				});
		}

		function loadClientOsType(clientId) {
			mbService.getOSType(clientId).then(function successCallBack(response) {
				self.isUnixClient = response.data.toLowerCase() == 'unix';
			});
			loadClientPlan(clientId);
		}

		function initData() {
			self.isUnixClient = true;
			self.isShowPlan = true;
			self.dummypassword = '';
			self.dbPassword = '';
			self.osPassword = '';
			//self.libraries =[];
			self.selectedProfileList = [];
			self.localLang = cvUtil.getIStevenLocLabels();
			self.initAfterLocalization = function() {
				self.localLang.nothingSelected = cvLoc('placeholder.selectPlan');
			};

			//error flags
			self.isShowPasswordError = true;
			self.isShowOsPasswordError = true;
			self.showPlanError = true;
			self.openAccordian1 = true;
			self.openAccordian2 = true;
			self.instanceDetails = {};
			self.hasInstancePlan = false;
			self.addInstance = false;
			if (self.data.editDialog && self.data.editDialog === 'Add_Instance') {
				self.addInstance = true;
				self.edit = false;
				self.clientSelection = {
					selectedClients: [],
					valideClientSelection: false,
					selectionChanged: function(clientEntity) {
						self.instance.clientId = clientEntity.clientId;
						loadClientOsType(clientEntity.clientId);
					}
				};
			} else {
				self.edit = self.data.editDialog;
			}
			self.instance = {
				instanceId: -1,
				instanceName: '',
				applicationId: self.data.idaEntity.applicationId,
				appName: self.data.idaEntity.appName,
				clientId: self.data.idaEntity.clientId,
				clientName: self.data.idaEntity.clientName
			};
			self.instanceDetails.sybaseInstance = {
				sybaseHome: '',
				configFile: '',
				sharedMemoryDirectory: '',
				sybaseASE: '',
				sybaseOCS: '',
				sybaseBlockSize: 64,
				enableAutoDiscovery: true,

				saUser: {
					userName: '',
					password: ''
				},
				localAdministrator: {
					userName: ''
				},
				defaultDatabaseStoragePolicy: {
					storagePolicyId: 1,
					storagePolicyName: ''
				}
			};

			if (self.edit) {
				self.instanceDetails = self.data.instanceDetails;
				self.instance = self.data.instanceDetails.instance;
				self.instanceDetails.sybaseInstance.saUser.password = self.dummypassword;
				self.dbPassword = self.dummypassword;
				self.osPassword = self.dummypassword;
				let blockSize = self.instanceDetails.sybaseInstance.sybaseBlockSize;
				self.instanceDetails.sybaseInstance.sybaseBlockSize = parseInt(blockSize / 1024);

				self.instancePlanEntity = _.get(self.instanceDetails, 'planEntity');
				if (self.instancePlanEntity && self.instancePlanEntity.planId && self.instancePlanEntity.planId > 0) {
					self.hasInstancePlan = true;
				}
				loadClientOsType(self.data.idaEntity.clientId);
			}
			self.newInstanceName = self.instance.instanceName;
			self.serverMessage = {
				message: '',
				type: ''
			};
			loadPlans();
		}

		let isvalidEntry = function(data) {
			if (data == undefined || data == '') {
				return false;
			}
			return true;
		};

		function validateInputs(fromController) {
			var formValid = true;
			if (!fromController.$valid && fromController.$error) {
				angular.forEach(fromController.$error.required, function(field) {
					field.$setDirty();
				});
				formValid = false;
			}

			//update plan error
			if (self.selectedProfileList && self.selectedProfileList.length > 0) {
				self.instanceDetails.planEntity = { planId: self.selectedProfileList[0].id };
				self.showPlanError = false;
			} else {
				self.showPlanError = self.showPlan;
			}

			if (!isvalidEntry(self.instanceDetails.sybaseInstance.saUser.password)) {
				self.isShowPasswordError = false;
			}

			if (!isvalidEntry(self.instanceDetails.sybaseInstance.localAdministrator.password)) {
				self.isShowOsPasswordError = false;
			}

			//check for Accordian1 (Connection details)
			if (!isvalidEntry(self.instanceDetails.sybaseInstance.saUser.userName) || self.isShowPasswordError) {
				self.openAccordian1 = true;
			}
			//check for Accordian2 (Sybase options)
			if (
				!isvalidEntry(self.instanceDetails.sybaseInstance.sybaseHome) ||
				!isvalidEntry(self.instanceDetails.sybaseInstance.configFile) ||
				!isvalidEntry(self.instanceDetails.sybaseInstance.sharedMemoryDirectory) ||
				!isvalidEntry(self.instanceDetails.sybaseInstance.sybaseASE) ||
				!isvalidEntry(self.instanceDetails.sybaseInstance.sybaseOCS) ||
				!isvalidEntry(self.instanceDetails.sybaseInstance.localAdministrator.userName) ||
				self.isShowOsPasswordError ||
				(self.edit && !isvalidEntry(self.instanceDetails.sybaseInstance.sybaseBlockSize))
			) {
				self.openAccordian2 = true;
			}
			return formValid;
		}

		function submitData() {
			// In case of add instance dialog check for the client selection
			if (self.addInstance) {
				if (!self.clientSelection.valideClientSelection) {
					return;
				}
				if (self.clientSelection.selectedClients) {
					self.instance.clientName = self.clientSelection.selectedClients[0].clientName;
					self.instance.clientId = self.clientSelection.selectedClients[0].clientId;
				}
			}

			if (self.showPlanError) {
				return;
			}

			//Instance name update
			if (self.newInstanceName != self.instance.instanceName) {
				if (self.instance.instanceId <= 0) {
					self.instance.instanceName = self.newInstanceName;
				}
			}

			//password update
			if (
				self.instanceDetails.sybaseInstance.saUser.password != undefined &&
				self.instanceDetails.sybaseInstance.saUser.password != self.dummypassword
			) {
				if (self.instanceDetails.sybaseInstance.saUser.password instanceof Array) {
					//Already encrypted
				} else {
					self.dbPassword = self.instanceDetails.sybaseInstance.saUser.password;
					self.instanceDetails.sybaseInstance.saUser.password = cvUtil.getBytes(
						self.instanceDetails.sybaseInstance.saUser.password
					);
				}
			} else {
				self.isShowPasswordError = false;
				self.instanceDetails.sybaseInstance.saUser.password = null;
			}
			//For Os user
			if (
				self.instanceDetails.sybaseInstance.localAdministrator.password != undefined &&
				self.instanceDetails.sybaseInstance.localAdministrator.password != self.dummypassword
			) {
				if (self.instanceDetails.sybaseInstance.localAdministrator.password instanceof Array) {
					//Already encrypted
				} else {
					self.osPassword = self.instanceDetails.sybaseInstance.localAdministrator.password;
					self.instanceDetails.sybaseInstance.localAdministrator.password = cvUtil.getBytes(
						self.instanceDetails.sybaseInstance.localAdministrator.password
					);
				}
			} else {
				self.isShowOsPasswordError = false;
				self.instanceDetails.sybaseInstance.localAdministrator.password = null;
			}

			let blockSize = self.instanceDetails.sybaseInstance.sybaseBlockSize;
			//update block size
			self.instanceDetails.sybaseInstance.sybaseBlockSize = blockSize * 1024;

			let params = {
				instanceEntity: angular.toJson(self.instance),
				instanceProps: angular.toJson(self.instanceDetails),
				password: '',
				osUserPassword: ''
			};

			let isEdit = self.instance.instanceId > 0;
			if (isEdit && self.newInstanceName !== self.instance.instanceName) {
				params.newInstanceName = self.newInstanceName;
			}

			idaService
				.createInstance(params, isEdit)
				.success(function(successData) {
					globalCacheFactory.refreshCacheId();
					if (successData.errorCode && successData.errorCode > 0) {
						cvToaster.showErrorMessage({
							ttl: '10000', //10 sec
							message: successData.errorString
						});
					}
					self.closeDialogBox();
					if (isEdit) {
						$state.forceReload();
					} else {
						let instanceId = _.get(successData, 'entity.instanceId');
						if (instanceId && instanceId > 0) {
							$state.go('databaseDetails', { instanceId: successData.entity.instanceId });
						}
					}
				})
				.error(function(errorReason) {
					//set back block size in KB
					self.instanceDetails.sybaseInstance.sybaseBlockSize = blockSize;
					// On error we need to set password back as it is already encrypted.
					if (self.dbPassword != '' && self.dbPassword != self.dummypassword) {
						self.instanceDetails.sybaseInstance.saUser.password = self.dbPassword;
						self.isShowPasswordError = true;
					}
					// For OS password
					if (self.osPassword != '' && self.osPassword != self.dummypassword) {
						self.instanceDetails.sybaseInstance.localAdministrator.password = self.osPassword;
						self.isShowOsPasswordError = true;
					}

					self.serverMessage = {
						message: errorReason,
						type: 'error'
					};
				});
		}
	}
]);

export default app;
