import 'machineBrowse/js/controllers/machineBrowse.ctrl.js';
import 'adminConsole/js/services/restore.svc.js';
import 'adminConsole/js/services/agents.svc.js';
import 'adminConsole/js/services/backupSets.svc.js';
import 'adminConsole/js/services/clients.svc.js';
import 'modules/ida/js/directives/cv-restore-streams.js';
import 'modules/ida/js/services/sqlService.svc.js';
import 'dlo/js/services/profile.svc.js';
import 'modules/ida/js/services/idaService.svc.js';
import 'storage/js/services/storage.svc.js';
import 'modules/ida/js/directives/cv-client-picker.js';
import 'adminConsole/js/directives/cv-entity-plan-policy-tiles.js';
import 'adminConsole/js/factories/associateSchedulePolicy.factory.js';
import 'adminConsole/js/factories/planPolicyModel.factory.js';
import 'modules/plan/js/directives/cv-plan-summary-dropdown.js';
import 'office365/js/services/office365.svc.js';
import { exchangeConstants } from 'exchangeV2/js/constants/exchangeConstants.js';

import { commonAllAgentsModule } from 'common/js/modules';

var app = commonAllAgentsModule;

app.controller('saphanaCreateSubclientCtrl', [
	'$scope',
	'$log',
	'storageService',
	'idaService',
	'profileService',
	'$state',
	'cvLoc',
	'cvUtil',
	'data',
	'cvTableOptions',
	'associateSchedulePolicy',
	'planPolicyModel',
	function(
		$scope,
		$log,
		storageService,
		idaService,
		profileService,
		$state,
		cvLoc,
		cvUtil,
		data,
		cvTableOptions,
		associateSchedulePolicy,
		planPolicyModel
	) {
		$scope.subclientInfo = {
			content: [],
			storagePoliciesList: [],
			profileList: [],
			storagePolicy: null,
			parallelDatabackupBackIntChannels: 4,
			agentInfo: {
				applicationId: 0,
				agentType: {
					backupsetSupported: false,
					instanceSupported: true
				}
			}
		};
		$scope.model = {
			accordionStatus: {
				contentTab: true
			}
		};
		$scope.showPlan = false;
		$scope.scEnity = angular.copy(data.entity);
		$scope.scEnity.subclientId = -1;
		$scope.scEnity.subClientName = '';

		/** toggle plan/policy ** */
		$scope.planPolicyModel = planPolicyModel.get('Default');

		$scope.createSubclient = function() {
			$scope.showPlan = planPolicyModel.getPlanModeState();
			$scope.serverMessage = {
				message: '',
				type: ''
			};
			$log.log('Creating new subclient.');

			var storageDevice = new Object();
			let selectedStorage = $scope.planPolicyModel.storagePolicy.selected;
			if (selectedStorage && selectedStorage.id) {
				storageDevice.dataBackupStoragePolicy = { storagePolicyId: selectedStorage.id };
			} else {
				storageDevice.dataBackupStoragePolicy = { storagePolicyId: 0 };
			}

			var sapHANASubclientProp = new Object();
			sapHANASubclientProp.numberOfBackupStreams = $scope.subclientInfo.parallelDatabackupBackIntChannels;

			var commonProperties = new Object();
			commonProperties.storageDevice = storageDevice;

			var subPropInfo = new Object();
			subPropInfo.commonProperties = commonProperties;
			subPropInfo.sapHANASubclientProp = sapHANASubclientProp;
			subPropInfo.content = [];
			subPropInfo.contentOperationType = 1;
			//defaulting plan id to 0
			var planEntity = {
				planId: 0
			};
			if ($scope.showPlan) {
				let selectedPlan = $scope.planPolicyModel.plan.selected;
				planEntity = { planId: selectedPlan.id };
			}
			subPropInfo.planEntity = planEntity;
			var subClientEntity = $scope.scEnity;
			var scEntity = angular.toJson(subClientEntity);
			var subInfo = angular.toJson(subPropInfo);

			var content = '';

			idaService
				.createSubclient({
					subClientEntity: scEntity,
					subclientInfo: subInfo,
					content: JSON.stringify(content)
				})
				.success(function(data) {
					if (!$scope.showPlan) {
						/* association obj */
						let subclientDetails = {
							appId: $scope.scEnity.applicaitonId,
							clientId: $scope.scEnity.clientId,
							subclientId: data
						};
						let schedules = $scope.planPolicyModel.schedulePolicy;
						if (schedules && schedules.selected) {
							associateSchedulePolicy
								.associateSchedulePolicyToSubClient(subclientDetails, schedules.selected)
								.success(function(successData) {
									$state.forceReload();
									$scope.closeModal();
								})
								.error(function(errorMessage) {
									$log.error(errorMessage);
								});
						}
					} else {
						$state.forceReload();
						$scope.closeModal();
					}
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		$scope.cancel = function() {
			$scope.$close();
		};
		$scope.closeModal = function(result) {
			$scope.$close();
		};
	}
]);

app.controller('hanaPhysicalClientsGridCtrl', [
	'$scope',
	'cvLoc',
	'$dialogs',
	'cvTableOptions',
	function($scope, cvLoc, $dialogs, cvTableOptions) {
		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

		angular.extend(globalGridOptions, {
			data: 'serversList',
			enableGridMenu: false,
			showGridFooter: true,
			columnDefs: [
				{
					field: 'clientName',
					displayName: cvLoc('label.clientName'),
					enableFiltering: false,
					cellTemplate: '<span class="crop" title="{{row.entity.clientName}}">{{row.entity.clientName}}</span>'
				},
				/*
				 * { field : 'edit', displayName : '', cellTemplate : '<span title="Edit server"
				 * class="edit-volume" data-ng-click="grid.appScope.editServer(row.entity)" >&nbsp;<//span>',
				 * width : '8%' },
				 */ {
					field: 'delete',
					displayName: '',
					cellTemplate:
						'<span title="Delete server"  class="delete-row" data-ng-click="grid.appScope.deleteServer(row.entity)" > × </span>',
					width: '8%'
				}
			]
		});

		$scope.updateValidation = function() {
			$scope.errors.servers = false;
			if ($scope.serversList.length <= 0) {
				$scope.errors.servers = true;
			}
			return $scope.errors.servers;
		};

		$scope.addNewServer = function(serverObj) {
			var templateUrl = 'modules/ida/partials/addHanaServers.jsp';
			var controllerName = 'addHanaServersCtrl';
			var params = new Object();
			var opts = new Object();
			var modelInstnace = $dialogs.create(appUtil.appRoot + templateUrl, controllerName, params, opts);
			modelInstnace.result.then(
				function(data) {
					if (data) {
						$scope.serversList.push(data.client);
					}
					$scope.updateValidation();
				},
				function() {
					$log.info('Cancel clicked: ');
				}
			);
		};

		$scope.deleteServer = function(serverObj) {
			var clientName = serverObj.clientName;
			for (var i = 0; i < $scope.serversList.length; i++) {
				if ($scope.serversList[i].clientName == clientName) {
					$scope.serversList.splice(i, 1);
					$scope.updateValidation();
					return;
				}
			}
		};

		/*
		 * $scope.editServer = function (serverObj){ $scope.addNewServer(serverObj); }
		 */

		$scope.gridOptions = {
			cvTableName: 'updateHanaPhyServers',
			cvHasViews: false,
			cvEnableHidingFilters: false,
			cvIsSearchable: false,
			cvOnGridEmpty: {
				message: 'No servers are added'
			},
			cvPageLinks: [
				{
					label: 'Add new server',
					id: 'tour_add_db',
					onclick: $scope.addNewServer
				}
			],
			cvSearchFields: [],
			gridOptions: globalGridOptions
		};
	}
]);

app.controller('saphanaUpdatePysServersCtrl', [
	'$scope',
	'storageService',
	'idaService',
	'sqlService',
	'$state',
	'$uibModalInstance',
	'cvTableOptions',
	'cvLoc',
	'$log',
	'data',
	function($scope, storageService, idaService, sqlService, $state, $modalInstance, cvTableOptions, cvLoc, $log, data) {
		$scope.createServerMessage = {
			message: '',
			type: ''
		};

		$scope.editDialog = data.editDialog;
		$scope.instanceDetails = data.instanceDetails;

		$scope.errors = {};
		$scope.closeModal = function() {
			$modalInstance.close();
		};

		$scope.serversList = $scope.instanceDetails.saphanaInstance.DBInstances;

		$scope.saveServers = function() {
			var instanceEntity = $scope.instanceDetails.instance;
			var instanceProperties = new Object();
			instanceProperties.saphanaInstance = new Object();
			instanceProperties.saphanaInstance.DBInstances = $scope.serversList;
			var arrgsObject = {
				instanceEntity: angular.toJson(instanceEntity),
				instanceProps: angular.toJson(instanceProperties)
			};

			idaService
				.createInstance(arrgsObject, data.editDialog)
				.success(function(data) {
					if (data != null && data.errorCode != undefined && data.errorCode != 0) {
						var msgStr = data.errorString;
						cvToaster.showErrorMessage({
							ttl: '10000', //10 sec
							message: msgStr
						});
					}
					$state.forceReload();
					$scope.closeModal();
				})
				.error(function(e) {
					$scope.createServerMessage = {
						message: e,
						type: 'error'
					};
				});
		};
	}
]);

app.controller('addHanaServersCtrl', [
	'$scope',
	'clientService',
	'$uibModalInstance',
	function($scope, clientService, $modalInstance) {
		$scope.serverInfo = {
			client: null
		};
		$scope.closeModal = function() {
			$modalInstance.close();
		};

		$scope.addServer = function() {
			$modalInstance.close($scope.serverInfo);
		};

		clientService
			.getHanaPhysicalClients()
			.success(function(data) {
				$scope.hanaClients = data;
				/*
				 * $scope.hanaClients = [{ clientName : 'test', clientId : 2, id : 2 }]
				 */
			})
			.error(function(errorMessage) {
				$scope.serverMessage = {
					message: errorMessage,
					type: 'error'
				};
			});
	}
]);

app.controller('saphanaCreateBackupsetCtrl', [
	'$scope',
	'cvUtil',
	'clientService',
	'backupSetService',
	'$uibModalInstance',
	'data',
	function($scope, cvUtil, clientService, backupSetService, $modalInstance, data) {
		$scope.entity = angular.copy(data.backupsetEntity);
		$scope.backupsetDetails = angular.copy(data.backupsetDetails);
		$scope.sapBacstInfo = $scope.backupsetDetails.sapHanaBackupset;
		$scope.sapBacstInfo.isUseHDBStoreKey = $scope.sapBacstInfo.isUseHDBStoreKey ? 'true' : 'false';

		$scope.closeModal = function() {
			$modalInstance.close(null);
		};
		$scope.saveModel = function() {
			var backupSetEntityJSON = angular.toJson($scope.entity);
			var isDefaultBackupset = $scope.backupsetDetails.commonBackupSet.isDefaultBackupSet;
			if ($scope.sapBacstInfo.isUseHDBStoreKey === 'false') {
				var password = cvUtil.getBytes($scope.sapBacstInfo.dbUser.dbUserPassword);
				$scope.backupsetDetails.sapHanaBackupset.dbUser.password = password;
			}
			var backupsetDetailsJSON = angular.toJson($scope.backupsetDetails);

			backupSetService
				.updateBackupSetDetails(backupSetEntityJSON, isDefaultBackupset, backupsetDetailsJSON)
				.success(function(data) {
					if (data) {
						$modalInstance.close(true);
					}
				})
				.error(function(errorMessage) {
					$scope.serverMessage = {
						message: errorMessage,
						type: 'error'
					};
				});
		};
	}
]);

app.controller('saphanaCreateInstanceCtrl', [
	'$scope',
	'profileService',
	'idaService',
	'AppTypes',
	'$state',
	'cvLoc',
	'cvUtil',
	'$dialogs',
	'cvTableOptions',
	'$uibModalInstance',
	'$log',
	'data',
	function(
		$scope,
		profileService,
		idaService,
		AppTypes,
		$state,
		cvLoc,
		cvUtil,
		$dialogs,
		cvTableOptions,
		$modalInstance,
		$log,
		data
	) {
		$scope.isAddHanaClient = false;
		$scope.editDialog = data.editDialog;
		$scope.dataModel = data;
		$scope.instanceDetails = data.instanceDetails;
		if ($scope.editDialog === 'ADD_CLIENT') {
			$scope.dialogTitle = cvLoc('action.CreateClient');
			$scope.isAddHanaClient = true;
		} else if ($scope.editDialog === 'Add_Instance' || $scope.editDialog === false) {
			$scope.dialogTitle = cvLoc('action.CreateInstance');
		} else {
			$scope.dialogTitle = cvLoc('action.editHanaInstance');
		}
		$scope.serverTemplateUrl = appUtil.appRoot + 'modules/ida/partials/sapHanaCreateInstanceTemplate.jsp';
		$scope.closeModal = function() {
			$modalInstance.close();
		};
	}
]);

app.controller('createHanaInstanceCtrl', [
	'globalCacheFactory',
	'$scope',
	'profileService',
	'idaService',
	'clientService',
	'office365Service',
	'AppTypes',
	'$state',
	'cvLoc',
	'cvUtil',
	'dbsUtil',
	'$dialogs',
	'cvTableOptions',
	'$log',
	'cvToaster',
	'pushInstallSoftwareFactory',
	function(
		globalCacheFactory,
		$scope,
		profileService,
		idaService,
		clientService,
		office365Service,
		AppTypes,
		$state,
		cvLoc,
		cvUtil,
		dbsUtil,
		$dialogs,
		cvTableOptions,
		$log,
		cvToaster,
		pushInstallSoftwareFactory
	) {
		$scope.createServerMessage = {
			message: '',
			type: ''
		};

		$scope.errors = {
			showPlanError: false,
			showPhysicalClients: true,
			showServerName: false
		};

		$scope.addInstance = false;
		if (
			($scope.editDialog && $scope.editDialog === 'Add_Instance') ||
			($scope.dataModel && $scope.dataModel.editDialog && $scope.dataModel.editDialog === 'Add_Instance')
		) {
			$scope.addInstance = true;
			$scope.editDialog = false;
			$scope.errors.showPlanError = true;
		} else if ($scope.dataModel && $scope.dataModel.editDialog && $scope.dataModel.editDialog === 'ADD_CLIENT') {
			$scope.isAddHanaClient = true;
			$scope.editDialog = 'ADD_CLIENT';
		}

		$scope.clientSelection = {
			selectedClients: [],
			valideClientSelection: false,
			clientLoaded: function(listOfClients) {
				if (!listOfClients || listOfClients.length === 0) {
					$scope.newServerSelected();
				}
			},
			selectionChanged: function(clientEntity) {
				/*
				 * if (!clientEntity || !clientEntity.clientId){ $scope.newServerSelected(); }
				 */
			}
		};

		$scope.planLocalLang = cvUtil.getIStevenLocLabels();
		$scope.planLocalLang.nothingSelected = cvLoc('placeholder.selectPlan');

		//hanaInsInfo will contain the instance default values
		$scope.hanaInsInfo = {
			hdbLocation: '',
			osUser: '',
			selectedPlan: null,
			dbInstanceNumber: '00',
			userType: 'DB',
			hdbStoreKey: null,
			dbUserName: null,
			dbUserPassword: null,
			profileList: [],
			selectedProfileList: [],
			newServer: false,
			enableSSL: false,
			sslProvider: 'commoncrypto',
			sslTrustStore: 'sapcli.pse'
		};
		$scope.instanceEntity = {
			applicationId: AppTypes.SAP_HANA,
			instanceName: '',
			clientName: '',
			appName: 'SAP HANA'
		};

		$scope.enableSSLSelection = function() {
			$scope.hanaInsInfo.enableSSL = !$scope.hanaInsInfo.enableSSL;
		};

		$scope.newServerSelected = function() {
			$scope.hanaInsInfo.newServer = !$scope.hanaInsInfo.newServer;
			if ($scope.hanaInsInfo.newServer) {
				$scope.isAddHanaClient = true;
				$scope.addInstance = false;
				$scope.editDialog = 'ADD_CLIENT';
			} else {
				$scope.isAddHanaClient = false;
				$scope.editDialog = false;
				$scope.addInstance = true;
			}
		};

		if ($scope.dataModel.isMetallicSetup) {
			$scope.hanaInsInfo.showNewServerOption = false;
			$scope.newServerSelected();
		} else {
			$scope.hanaInsInfo.showNewServerOption = $scope.isAddHanaClient || $scope.addInstance;
		}
		if (cvConfig.enableMetallicCustomizationForK8s) {
			let orgId = _.get(cv, 'orgId', 0);
			if (orgId > 0 && cv.isTenantAdmin) {
				office365Service.getOrganisationDetails(cv.orgId).then(response => {
					const organizationName = _.get(response.data, 'organizationInfo.organization.connectName', '');
					if (organizationName.length > 0) {
						const orgNamePrefix = organizationName
							.replace(exchangeConstants.STN_REGEX_PATTERNS.REPLACE_WHITESPACES, '_')
							.replace(exchangeConstants.STN_REGEX_PATTERNS.REPLACE_CONSECUTIVE_CHARS, '_')
							.replace(exchangeConstants.STN_REGEX_PATTERNS.REMOVE_SPL_CHARS, '');
						$scope.hanaInsInfo.orgNamePrefix = `${orgNamePrefix}_`;
					}
				});
			}
		}
		$scope.validateClientSelection = function() {
			var isValid = $scope.hanaPhysicalClients.some(function(curr) {
				return curr['ticked'] === true;
			});

			$scope.errors.showPhysicalClients = !isValid;
			return isValid;
		};

		$scope.openAddNewHostDialog = function() {
			var pushInstallParams = {
				useAgent: 'SAPHANA',
				dialogTitle: cvLoc('label.addSAPHANAHost'),
				dialogTitleHelpText: cvLoc('help.addSAPHANAHost'),
				disableInteractiveInstall: true,
				showOsType: false,
				osType: 'UNIX'
			};
			var modalInstance = pushInstallSoftwareFactory.openPushInstallDialog(pushInstallParams);
			modalInstance.result.then(
				function() {
					// on success
				},
				function() {
					// on error
				}
			);
		};

		$scope.hdbSQLLocationUpdate = function() {
			$scope.instanceEntity.instanceName = $scope.instanceEntity.instanceName.toUpperCase();
			$scope.hanaInsInfo.hdbLocation =
				'/usr/sap/' + $scope.instanceEntity.instanceName + '/HDB' + $scope.hanaInsInfo.dbInstanceNumber + '/exe';

			var instanceNameValue = angular.copy($scope.instanceEntity.instanceName);
			$scope.hanaInsInfo.osUser = instanceNameValue.toLowerCase() + 'adm';
		};

		$scope.localLang = cvUtil.getIStevenLocLabels();
		$scope.localLang.nothingSelected = cvLoc('option.physicalClients');

		var loadHanaClients = function() {
			clientService
				.getHanaPhysicalClients()
				.success(function(data) {
					$scope.hanaPhysicalClients = cvUtil.sortAscending(data, 'clientName');
					let serverList = [];
					if ($scope.editDialog === true) {
						serverList = $scope.instanceDetails.saphanaInstance.DBInstances;
						$scope.errors.showPhysicalClients = true;
					} else if ($scope.dataModel.isMetallicSetup && $scope.dataModel.sapHanaHost) {
						let hostList = $scope.dataModel.sapHanaHost.split(',');
						_.forEach(hostList, function(host) {
							serverList.push({
								clientId: parseInt(host)
							});
						});
					}
					if (serverList) {
						for (var i = 0; i < $scope.hanaPhysicalClients.length; i++) {
							for (var j = 0; j < serverList.length; j++) {
								if ($scope.hanaPhysicalClients[i].clientId === serverList[j].clientId) {
									$scope.hanaPhysicalClients[i].ticked = true;
									$scope.errors.showPhysicalClients = false;
								}
							}
						}
					}
				})
				.error(function(errorMessage) {
					$scope.serverMessage = {
						message: errorMessage,
						type: 'error'
					};
				});
		};
		loadHanaClients();

		if ($scope.editDialog && !$scope.isAddHanaClient) {
			$scope.instanceEntity = $scope.instanceDetails.instance;
			$scope.hanaInsInfo.hdbLocation = $scope.instanceDetails.saphanaInstance.hdbsqlLocationDirectory;
			$scope.hanaInsInfo.osUser = $scope.instanceDetails.saphanaInstance.SAPHANAUser.userName;
			$scope.hanaInsInfo.dbInstanceNumber = $scope.instanceDetails.saphanaInstance.dbInstanceNumber;
			$scope.hanaInsInfo.enableSSL = $scope.instanceDetails.saphanaInstance.sslEnabled;
			$scope.hanaInsInfo.sslProvider = $scope.instanceDetails.saphanaInstance.sslProvider;
			$scope.hanaInsInfo.sslTrustStore = $scope.instanceDetails.saphanaInstance.sslTrustStore;

			if ($scope.instanceDetails.saphanaInstance.isUsehdbStoreKey) {
				$scope.hanaInsInfo.userType = 'HDB';
				$scope.hanaInsInfo.hdbStoreKey = $scope.instanceDetails.saphanaInstance.hdbuserstorekey;
			} else {
				$scope.hanaInsInfo.userType = 'DB';
				$scope.hanaInsInfo.dbUserName = $scope.instanceDetails.saphanaInstance.dbUser.userName;
			}
			$scope.hanaInsInfo.hdbLocation = $scope.instanceDetails.saphanaInstance.hdbsqlLocationDirectory;
			$scope.instancePlanEntity = _.get($scope.instanceDetails, 'planEntity');
		} else if ($scope.dataModel.idaEntity) {
			$scope.instanceEntity = $scope.dataModel.idaEntity;
		}

		$scope.loadPlans = function() {
			profileService
				.getEligiblePlansForApp(AppTypes.SAP_HANA)
				.success(function(data) {
					$scope.createServerMessage = cvUtil.emptyMsg();
					if (data.length > 0) {
						var planList = [];
						$scope.planListByTypes = {};
						angular.forEach(data, planData => {
							planData = planData.planSummary ? planData.planSummary : planData;
							const planObj = {
								name: planData.plan.planName,
								id: planData.plan.planId,
								type: planData.subtype,
								numAssocEntities: planData.numAssocEntities,
								numCopies: planData.numCopies,
								rpoInMinutes: planData.rpoInMinutes,
								planSummary: _.get(planData, 'plan.planSummary')
							};

							planList.push(planObj);
							if ($scope.planListByTypes[planObj.type]) {
								$scope.planListByTypes[planObj.type].push(planObj);
							} else {
								$scope.planListByTypes[planObj.type] = [planObj];
							}
						});
						var tempPlanList = [];
						for (var planType in $scope.planListByTypes) {
							tempPlanList.push({
								name: planType,
								msGroup: true
							});
							var plansByType = cvUtil.sortAscending($scope.planListByTypes[planType], 'name');
							tempPlanList = tempPlanList.concat(plansByType);
							tempPlanList.push({
								msGroup: false
							});
						}
						$scope.hanaInsInfo.profileList.push(...tempPlanList);

						if ($scope.instancePlanEntity && $scope.instancePlanEntity.planId) {
							planSelectonUpdate($scope.instancePlanEntity, $scope.hanaInsInfo.profileList);
						}
					} else {
						$scope.showPlan = false;
					}
				})
				.error(function(e) {
					$scope.createServerMessage = {
						message: e,
						type: 'error'
					};
				});
		};
		$scope.loadPlans();

		$scope.showPlanErrorParseIStevenOutput = function() {
			if ($scope.hanaInsInfo.selectedProfileList && $scope.hanaInsInfo.selectedProfileList.length > 0) {
				$scope.errors.showPlanError = false;
			} else {
				$scope.errors.showPlanError = true;
			}
		};

		$scope.serversList = [];

		$scope.populateInstanceProps = function(instanceProperties) {
			instanceProperties.saphanaInstance = new Object();
			instanceProperties.saphanaInstance.dbInstanceNumber = $scope.hanaInsInfo.dbInstanceNumber;
			instanceProperties.saphanaInstance.SAPHANAUser = new Object();
			$scope.serversList = $scope.hanaPhysicalClients.filter(function(group) {
				return group.ticked;
			});
			instanceProperties.saphanaInstance.sslEnabled = $scope.hanaInsInfo.enableSSL;
			instanceProperties.saphanaInstance.sslProvider = $scope.hanaInsInfo.sslProvider;
			instanceProperties.saphanaInstance.sslTrustStore = $scope.hanaInsInfo.sslTrustStore;
			instanceProperties.saphanaInstance.DBInstances = $scope.serversList;
			instanceProperties.saphanaInstance.SAPHANAUser.userName = $scope.hanaInsInfo.osUser;
			instanceProperties.saphanaInstance.hdbsqlLocationDirectory = $scope.hanaInsInfo.hdbLocation;
			if ($scope.hanaInsInfo.userType == 'HDB') {
				instanceProperties.saphanaInstance.dbUser = {};
				instanceProperties.saphanaInstance.isUsehdbStoreKey = true;
				instanceProperties.saphanaInstance.hdbuserstorekey = $scope.hanaInsInfo.hdbStoreKey;
			} else {
				instanceProperties.saphanaInstance.hdbuserstorekey = '';
				instanceProperties.saphanaInstance.dbUser = new Object();
				instanceProperties.saphanaInstance.dbUser.userName = $scope.hanaInsInfo.dbUserName;
				//set the password as Byte array
				if ($scope.hanaInsInfo.dbUserPassword) {
					instanceProperties.saphanaInstance.dbUser.password = cvUtil.getBytes($scope.hanaInsInfo.dbUserPassword);
				}
			}
		};

		let planSelectonUpdate = function(selectedPlan, profileList) {
			for (var planTypeNode in profileList) {
				var planNode = profileList[planTypeNode];
				if (planNode && planNode.type && selectedPlan.planId === planNode.id) {
					planNode.selected = true;
					$scope.hanaInsInfo.selectedProfileList.push(planNode);
				}
			}
		};

		$scope.validateInputs = function(fromController) {
			var formValid = true;
			if (!fromController.$valid && fromController.$error) {
				angular.forEach(fromController.$error.required, function(field) {
					field.$setDirty();
				});
				formValid = false;
			}

			if (!$scope.validateClientSelection()) {
				formValid = false;
				$scope.errors.showPhysicalClients = true;
			} else {
				$scope.errors.showPhysicalClients = false;
			}

			if (
				$scope.editDialog === false &&
				(!$scope.hanaInsInfo.selectedProfileList || $scope.hanaInsInfo.selectedProfileList.length <= 0)
			) {
				formValid = false;
				$scope.errors.showPlanError = true;
			} else {
				$scope.errors.showPlanError = false;
			}

			if ($scope.hanaInsInfo.newServer) {
				if (!$scope.instanceEntity.clientName || _.isEmpty($scope.instanceEntity.clientName)) {
					formValid = false;
					$scope.errors.showServerName = true;
					$scope.errors.showServerNameMesage = cvLoc('error.sapHanaSystem');
				} else if (!$scope.validateClinetName($scope.instanceEntity.clientName)) {
					formValid = false;
				}
			}

			return formValid;
		};

		$scope.validateClinetName = function(clientName) {
			$scope.errors.showServerName = false;
			if (!dbsUtil.isValidClientName(clientName)) {
				$scope.errors.showServerName = true;
				$scope.errors.showServerNameMesage = cvLoc('error.serverNameChars', cvLoc('label.sapHanaSystem'));
				return false;
			}
			return true;
		};
		// method to create the instance.
		$scope.createInstance = function() {
			if (!$scope.validateClientSelection()) {
				return;
			}

			if (
				$scope.editDialog === false &&
				(!$scope.hanaInsInfo.selectedProfileList || $scope.hanaInsInfo.selectedProfileList.length <= 0)
			) {
				return;
			}

			var instanceEntity = $scope.instanceEntity;
			//In case of add instance dialog check for the client selection validation
			if ($scope.addInstance) {
				if (!$scope.clientSelection.valideClientSelection) {
					return;
				}
				if ($scope.clientSelection.selectedClients) {
					instanceEntity.clientName = $scope.clientSelection.selectedClients[0].clientName;
					instanceEntity.clientId = $scope.clientSelection.selectedClients[0].clientId;
				}
			}
			if (cvConfig.enableMetallicCustomizationForK8s && $scope.hanaInsInfo.orgNamePrefix) {
				instanceEntity.clientName = $scope.hanaInsInfo.orgNamePrefix + instanceEntity.clientName;
			}
			var instanceProperties = new Object();

			$scope.populateInstanceProps(instanceProperties);
			if ($scope.hanaInsInfo.selectedProfileList && $scope.hanaInsInfo.selectedProfileList.length > 0) {
				instanceProperties.planEntity = { planId: $scope.hanaInsInfo.selectedProfileList[0].id };
			}

			var arrgsObject = {
				instanceEntity: angular.toJson(instanceEntity),
				instanceProps: angular.toJson(instanceProperties)
			};
			/*
			 * if ($scope.isAddHanaClient) { arrgsObject.planId =
			 * $scope.hanaInsInfo.selectedProfileList[0].id; }
			 */
			$scope.loading = true;

			idaService
				.createInstance(arrgsObject, $scope.editDialog)
				.success(function(data) {
					$scope.loading = false;
					if (data != null && data.errorCode != undefined && data.errorCode != 0) {
						var msgStr = data.errorString;
						cvToaster.showErrorMessage({
							ttl: '15000', //15 sec
							message: msgStr
						});
					}
					if ($scope.isSetup) {
						$scope.$emit('serverAdded');
					} else {
						globalCacheFactory.refreshCacheId();
						$state.forceReload();
						$scope.closeModal();
					}
				})
				.error(function(e) {
					$scope.loading = false;
					cvToaster.showErrorMessage({
						ttl: '15000', //15 sec
						message: e
					});
					globalCacheFactory.refreshCacheId();
					$state.forceReload();
					$scope.closeModal();
				});
		};
	}
]);

app.controller('saphanaRestoreOptionsCtrl', [
	'$scope',
	'$log',
	'dbsUtil',
	'idaService',
	'sqlService',
	'cvToaster',
	'$stateParams',
	'cvLoc',
	'$uibModal',
	'$uibModalInstance',
	'$filter',
	'AppTypesUtil',
	'AppTypes',
	'clientService',
	'agentService',
	'restoreForAgents',
	'$dialogs',
	'data',
	function(
		$scope,
		$log,
		dbsUtil,
		idaService,
		sqlService,
		cvToaster,
		$stateParams,
		cvLoc,
		$modal,
		$modalInstance,
		$filter,
		AppTypesUtil,
		AppTypes,
		clientService,
		agentService,
		restoreForAgents,
		$dialogs,
		data
	) {
		//we give an option to restore this VM if we have a guid
		$scope.dayTypeList = [cvLoc('label.day'), cvLoc('label.hours')];
		$scope.restoreData = {
			globalOptions: {
				sqlDbDeviceItems: [],
				sqlDbDeviceItemsOriginal: [],
				selectedSqlDbdeviceItem: null,
				destinationServerList: [],
				destinationServer: null,
				targetDbName: null,
				restoreCatalog: false,
				restoreCatalogType: '1',
				relativeToSysdateValue: 2,
				relativeToSysdateDays: $scope.dayTypeList[0],
				dbSubnetGroup: null,
				isMultiAZ: false,
				publicAccess: false,
				targetAvailbilityZone: null,
				databaseName: null,
				copyPrec: 0,
				streams: 2
			}
		};

		$scope.sourceBackupsetDataList = [];
		$scope.tabControls = {};
		//selectedEntity
		$scope.entity = data.entity;
		$scope.entityType = 'INSTANCE_ENTITY';
		$scope.entityId = data.entity.instanceId;
		$scope.serverId = data.entity.clientId;
		$scope.serverName = data.entity.clientName;
		$scope.instanceId = data.entity.instanceId;
		$scope.serverDetails = {};
		var applicationId = data.entity.applicaitonId;
		$scope.pitError = false;
		$scope.pitRestoreCtlError = false;
		$scope.isSnapBackupEnabled = false;

		$scope.isMultiNodeApp = false;

		$scope.isBackupSetRestore = false;

		$scope.closeModal = function() {
			$modalInstance.close();
		};
		$scope.dataDirPathResuleFunction = function(result) {
			if (result) {
				$scope.restoreData.globalOptions.dataDir = result.path;
			}
		};

		$scope.restoreCatalogSelected = function() {
			$scope.restoreData.globalOptions.restoreCatalog = !$scope.restoreData.globalOptions.restoreCatalog;
		};

		var checkSnapEnabled = function() {
			idaService.getChildranData('SUBCLIENT_ENTITY', $scope.entity).success(function(data) {
				if (data) {
					for (var i = 0; i < data.length; i++) {
						var snapValue = _.get(data[i], 'commonProperties.snapCopyInfo.isSnapBackupEnabled');
						if (snapValue && snapValue === true) {
							$scope.isSnapBackupEnabled = true;
							break;
						}
					}
				}
			});
		};
		checkSnapEnabled();
		$scope.recoveryTypeChanged = function(backupType) {
			if (backupType && parseInt(backupType) === 2 && $scope.tabControls.getCurrentTabId() === '0') {
				$scope.restoreData.globalOptions.initializeLogArea = false;
			} else {
				$scope.restoreData.globalOptions.initializeLogArea = true;
			}
		};
		$scope.previousTabId = 0;
		$scope.onTabChanged = function() {
			if ($scope.tabControls.getCurrentTabId() != $scope.previousTabId) {
				$scope.previousTabId = $scope.tabControls.getCurrentTabId();
				$scope.recoveryTypeChanged($scope.restoreData.globalOptions.backupType);
			}
		};
		var getSourceBackupSetsForInstance = function(entity) {
			idaService.getChildranData('BACKUPSET_ENTITY', entity).success(function(data) {
				$scope.sourceBackupsetDataList = data;
				if ($scope.sourceBackupsetDataList && $scope.sourceBackupsetDataList.length > 0) {
					if (!$scope.isBackupSetRestore) {
						$scope.entity.backupsetId = $scope.sourceBackupsetDataList[0].backupSetEntity.backupsetId;
						$scope.restoreData.globalOptions.databaseName =
							$scope.sourceBackupsetDataList[0].backupSetEntity.backupsetName;
					}
				}
				//Load the destination details after the source backupset list is populate
				$scope.loadData();
			});
		};

		$scope.loadData = function() {
			//load destination clients
			clientService
				.getHanaClients()
				.success(function(data) {
					$scope.restoreData.globalOptions.destinationServerList = data;
				})
				.error(function(e) {
					$log.error(e);
				});
		};

		var getBackupSetsForInstance = function(entity) {
			idaService
				.getChildranData('BACKUPSET_ENTITY', entity)
				.success(function(data) {
					$scope.backupsetDataList = data;
					if (!$scope.isMultiNodeApp && !$scope.isBackupSetRestore) {
						if ($scope.backupsetDataList && $scope.backupsetDataList.length > 0) {
							$scope.entity.backupsetId = $scope.backupsetDataList[0].backupSetEntity.backupsetId;
						}
					}
					/*
					 * else { if (!$scope.sourceBackupsetList) { $scope.sourceBackupsetList =
					 * angular.copy($scope.backupsetDataList); if (!$scope.isBackupSetRestore) {
					 * $scope.entity.backupsetId = $scope.sourceBackupsetList[0].backupSetEntity.backupsetId;
					 * $scope.restoreData.globalOptions.databaseName =
					 * $scope.sourceBackupsetList[0].backupSetEntity.backupsetName; } }
					 */
					$scope.updateSourceDB($scope.restoreData.globalOptions.databaseName);
				})
				.error(function(e) {
					$log.error(e);
				});
		};

		if ($scope.entity.backupsetName) {
			$scope.isBackupSetRestore = true;
			$scope.restoreData.globalOptions.databaseName = $scope.entity.backupsetName;
			$scope.entityType = 'BACKUPSET_ENTITY';
			$scope.entityId = data.entity.backupsetId;
			$scope.loadData();
		} else {
			getSourceBackupSetsForInstance($scope.entity);
		}

		//This will format the list of source items,as list of strings, from selectionArray and return the same.
		var getSourceItems = function() {
			var sourceItems = [];
			return sourceItems;
		};

		var getBrowseDestinationModal = function() {
			$scope.serverMessage = {
				message: '',
				type: ''
			};
			if (!$scope.restoreData.globalOptions.destinationServer) {
				$scope.serverMessage = {
					message: cvLoc('error.destinationServer'),
					type: 'error'
				};
				return;
			}
			var clientId = $scope.restoreData.globalOptions.destinationServer.clientId;
			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'machineBrowse/partials/machineBrowse.jsp',
				controller: 'mbController',
				resolve: {
					browseParams: function() {
						return {
							clientId: clientId,
							foldersOnly: true
						};
					}
				}
			});
			return modalInstance;
		};

		$scope.updateSourceDB = function(sourceDBName) {
			$scope.tempBackupsetList = $scope.sourceBackupsetDataList.filter(function(srcDB) {
				return srcDB.backupSetEntity.backupsetName === sourceDBName;
			});
			if ($scope.tempBackupsetList && $scope.tempBackupsetList.length > 0) {
				$scope.entity.backupsetId = $scope.tempBackupsetList[0].backupSetEntity.backupsetId;
				$scope.entity.backupsetName = $scope.tempBackupsetList[0].backupSetEntity.backupsetName;
			}

			if (!$scope.backupsetDataList) {
				return;
			}

			$scope.backupsetList = $scope.backupsetDataList.filter(function(destDB) {
				var filterValue = 'SYSTEMDB';
				if (sourceDBName === filterValue) {
					return destDB.backupSetEntity.backupsetName === filterValue;
				} else {
					return destDB.backupSetEntity.backupsetName !== filterValue;
				}
			});

			if ($scope.isBackupSetRestore && $scope.backupsetList && $scope.backupsetList.length > 0) {
				angular.forEach($scope.backupsetList, function(backupSetInfo) {
					if (backupSetInfo.backupSetEntity.backupsetName == $scope.restoreData.globalOptions.databaseName) {
						$scope.restoreData.globalOptions.backupsetId = backupSetInfo.backupSetEntity.backupsetId;
					}
				});
			} else if ($scope.backupsetList && $scope.backupsetList.length > 0) {
				$scope.restoreData.globalOptions.backupsetId = $scope.backupsetList[0].backupSetEntity.backupsetId;
			}

			$scope.setBackupSetInfo($scope.restoreData.globalOptions.backupsetId);
		};

		$scope.shouldDisableInstance = function(instanceId) {
			if ($scope.isMultiNodeApp) {
				return false;
			}
			return instanceId === $scope.entity.instanceId;
		};

		$scope.shouldDisableBackupset = function(backupsetId) {
			return backupsetId === $scope.entity.backupsetId;
		};

		var browseType = 'saphanaBrowse';
		/* SAP HANA specific changes */
		if (browseType == 'saphanaBrowse') {
			//--Start of setting default values
			if (data.toTime) {
				if (typeof data.toTime === 'string') {
					$scope.restoreData.globalOptions.time = new Date(data.toTime + 'Z');
				} else {
					$scope.restoreData.globalOptions.time = data.toTime;
				}
			} else {
				var dateobj = new Date();
				$scope.restoreData.globalOptions.time = new Date(
					dateobj.getFullYear(),
					dateobj.getMonth(),
					dateobj.getDate(),
					dateobj.getHours(),
					dateobj.getMinutes(),
					dateobj.getSeconds()
				);
			}
			$scope.restoreData.globalOptions.restoreCatalogTime = angular.copy($scope.restoreData.globalOptions.time);
			$scope.restoreData.globalOptions.maxPit = moment()
				.add(1, 'day')
				.toDate();

			$scope.restoreData.globalOptions.checkAccess = true;
			$scope.restoreData.globalOptions.deltaBackup = true;
			$scope.restoreData.globalOptions.initializeLogArea = true;
			$scope.restoreData.globalOptions.hardwareRevert = false;
			$scope.restoreType = {
				ByTime: 0,
				ByPreFix: 1
			};
			$scope.restoreTimeType = {
				CurrentTime: 0,
				PointInTime: 1
			};
			$scope.restoreData.globalOptions.backupType = '2';
			$scope.restoreData.globalOptions.restoreType = $scope.restoreType.ByTime;
			$scope.restoreData.globalOptions.restoreTimeType = $scope.restoreTimeType.CurrentTime;
			$scope.restoreData.globalOptions.destinationInstanceId = null;
			$scope.restoreData.globalOptions.destinationInstances = [];
			$scope.restoreData.globalOptions.instanceInfo = [];
			//--End of setting default values

			var getSourceInstanceDetails = function(sourceInstance) {
				idaService.getInstanceDetails(sourceInstance.instanceId).success(function(data) {
					$scope.restoreData.globalOptions.instanceInfo = data; // setting source instance details as destination instance
					let containerMode = _.get(data, 'saphanaInstance.containerMode');
					if (containerMode === 1) {
						$scope.isMultiNodeApp = true;
					}
				});
			};
			getSourceInstanceDetails($scope.entity);

			let isMultiNodeInstance = function(instanceId) {
				let selectedDestInstans = $scope.restoreData.globalOptions.destinationInstances.filter(function(entry) {
					return entry.instance.instanceId == instanceId;
				});
				if (selectedDestInstans && selectedDestInstans.length > 0) {
					let containerMode = _.get(selectedDestInstans[0], 'saphanaInstance.containerMode');
					return containerMode === 1;
				}
				return false;
			};

			$scope.updateDatabaseInfo = function(instanceId) {
				var entity = {
					clientId: $scope.restoreData.globalOptions.destinationServer.clientId,
					applicationId: AppTypes.SAP_HANA,
					instanceId: instanceId
				};
				if (isMultiNodeInstance(instanceId)) {
					getBackupSetsForInstance(entity);
				}
				$scope.setInstanceInfo(instanceId);
			};

			$scope.setBackupSetInfo = function(backupSetId) {
				if (backupSetId == undefined || backupSetId <= 0 || !$scope.backupsetList) {
					return;
				}
				let tempList = $scope.backupsetList.filter(function(entry) {
					return entry.backupSetEntity.backupsetId == backupSetId;
				});
				if (tempList && tempList.length > 0) {
					$scope.restoreData.globalOptions.destBackupSetInfo = tempList[0].backupSetEntity;
				}
			};

			$scope.setInstanceInfo = function(instanceId) {
				if (instanceId == undefined || instanceId <= 0) {
					return;
				}
				$scope.restoreData.globalOptions.instanceInfo = $scope.restoreData.globalOptions.destinationInstances.filter(
					function(entry) {
						return entry.instance.instanceId == instanceId;
					}
				)[0];
			};

			$scope.instanceSelected = function(instanceId) {
				if (instanceId) {
					$scope.restoreData.globalOptions.destinationInstanceId = instanceId;
					$scope.updateDatabaseInfo($scope.restoreData.globalOptions.destinationInstanceId);
				} else {
					$scope.restoreData.globalOptions.destinationInstanceId = null;
				}
			};
			$scope.updateInstcesModel = function(clientId) {
				if (clientId == undefined || clientId <= 0) {
					return;
				}
				agentService
					.getInstances(clientId, AppTypes.SAP_HANA)
					.success(function(data) {
						$scope.restoreData.globalOptions.destinationInstances = data;
						if (data.length <= 0) {
							$scope.restoreData.globalOptions.destinationInstances = [];
							return;
						}
					})
					.error(function(err) {
						$scope.restoreData.globalOptions.destinationInstances = [];
						$log.error(err);
					});
			};
		}

		$scope.isPITValide = function() {
			if (
				$scope.restoreData.globalOptions.backupType == 2 &&
				(!$scope.restoreData.globalOptions.time || new Date($scope.restoreData.globalOptions.time) == 'Invalid Date')
			) {
				return false;
			} else {
				return true;
			}
		};

		$scope.doRestore = function() {
			if (!$scope.isPITValide()) {
				$scope.pitError = true;
				return;
			}

			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					$scope.submitRestore();
				}
			};
			var rstString = '';
			if ($scope.restoreData.globalOptions.backupType == 2) {
				if ($scope.restoreData.globalOptions.backupType == 2) {
					rstString = cvLoc('label.PointInTime') + ' : <B> ' + $scope.restoreData.globalOptions.time + ' </B> ';
				} else {
					rstString = cvLoc('label.CurrentTime');
				}
			} else {
				if ($scope.restoreData.globalOptions.backupType == 1) {
					rstString = cvLoc('label.BackupId') + '  : <B> ' + $scope.restoreData.globalOptions.backupIdValue + ' </B> ';
				} else {
					rstString =
						cvLoc('label.BackupPrefix') + ' : <B> ' + $scope.restoreData.globalOptions.backupPrefixValue + ' </B> ';
				}
			}
			var rstDatabaseName = $scope.entity.instanceName;
			if ($scope.isMultiNodeApp) {
				rstDatabaseName = rstDatabaseName + ' :: ' + $scope.restoreData.globalOptions.databaseName;
			}

			var confirmMessage = cvLoc('message.sapHanaRestore', rstDatabaseName, $scope.serverName, rstString);
			var destDBNode = $scope.restoreData.globalOptions.instanceInfo.instance;
			if (
				$scope.serverName != destDBNode.clientName &&
				$scope.tabControls &&
				$scope.tabControls.getCurrentTabId() === '1'
			) {
				var destDatbaseName = destDBNode.instanceName;
				if ($scope.isMultiNodeApp) {
					destDatbaseName = destDatbaseName + ' :: ' + $scope.restoreData.globalOptions.destBackupSetInfo.backupsetName;
				}
				confirmMessage = cvLoc(
					'message.sapHanaCrossMachinRestore',
					rstDatabaseName,
					$scope.serverName,
					destDatbaseName,
					destDBNode.clientName,
					rstString
				);
			}
			$dialogs.confirm(cvLoc('label.confirm'), confirmMessage, callBackFunctions);
		};
		$scope.submitRestore = function() {
			//cvLoc('label.jobStarted', jobId);

			var entityType = getEntityType();
			var genericEntity = $scope.entity;

			var browseOption = composeBrowseOption();
			var destination = composeDestination();
			var commonOptions = composeCommonOptions();
			var agentSpecificOptions = composeAgentSpecificOptions();
			if (agentSpecificOptions && agentSpecificOptions.pointInTime && agentSpecificOptions.pointInTime.time) {
				browseOption.timeRange.toTime = agentSpecificOptions.pointInTime.time;
				browseOption.timeRange.fromTime = 0;
			}
			var rdsOption = {};
			var sourceItems = getSourceItems();

			restoreForAgents
				.submitRestoreJob({
					entityType: entityType,
					genericEntity: angular.toJson(genericEntity),
					browseOption: angular.toJson(browseOption),
					destination: angular.toJson(destination),
					commonOptions: angular.toJson(commonOptions),
					sourceItemsToRestore: angular.toJson(getSourceItems()),
					agentSpecificOptions: angular.toJson(agentSpecificOptions),
					rdsOption: angular.toJson(rdsOption)
				})
				.success(function(data) {
					dbsUtil.showRestoreToaster(data);

					//selectionService.clearSelection();
					$scope.closeModal();
				})
				.error(function(err) {
					$scope.closeModal();
					cvToaster.showErrorMessage({
						ttl: '15000', //10 sec
						message: err
					});
				});
			return;
		};

		var getEntityType = function() {
			var entityType = 'INSTANCE_ENTITY';
			return entityType;
		};

		var composeCommonOptions = function() {
			var commonOptions = {};
			commonOptions.unconditionalOverwrite = true;
			if ($scope.tabControls && $scope.tabControls.getCurrentTabId() === '0' && $scope.isSnapBackupEnabled) {
				commonOptions.revert = $scope.restoreData.globalOptions.hardwareRevert;
			}
			return commonOptions;
		};

		var composeBrowseOption = function() {
			var browseOption = {
				commCellId: 2,
				timeRange: {
					fromTimeValue: $stateParams['fromTime'] ? $stateParams['fromTime'] : null,
					toTimeValue: $stateParams['toTime'] ? $stateParams['toTime'] : null
				},
				mediaOption: {
					copyPrecedence: {
						copyPrecedenceApplicable: true,
						copyPrecedence: $scope.restoreData.globalOptions.copyPrec
					}
				}
			};

			return browseOption;
		};

		var composeDestination = function() {
			var destination = {};

			var destInstance = $scope.restoreData.globalOptions.instanceInfo.instance;
			var destBackupSet = $scope.restoreData.globalOptions.destBackupSetInfo;
			//For inplace restore we should send the backupset node
			if ($scope.tabControls.getCurrentTabId() === '0' && $scope.isMultiNodeApp && !destBackupSet) {
				destBackupSet = $scope.entity;
			}
			var destClient = {
				clientId: destBackupSet ? destBackupSet.clientId : $scope.entity.clientId,
				clientName: destBackupSet ? destBackupSet.clientName : $scope.entity.clientName
			};
			destination.destClient = destClient;
			destination.destinationInstance = destInstance;
			destination.destinationBackupset = destBackupSet;
			destination.noOfStreams = $scope.restoreData.globalOptions.streams;
			return destination;
		};

		var composeAgentSpecificOptions = function() {
			var agentSpecificOptions = {};
			agentSpecificOptions.destClientName =
				$scope.restoreData.globalOptions.instanceInfo.saphanaInstance.DBInstances[0].clientName;
			agentSpecificOptions.destPseudoClientName = $scope.restoreData.globalOptions.instanceInfo.instance.clientName;
			agentSpecificOptions.destDbName = $scope.restoreData.globalOptions.instanceInfo.instance.instanceName;
			agentSpecificOptions.useHardwareRevert = $scope.restoreData.globalOptions.hardwareRevert;
			if (agentSpecificOptions.useHardwareRevert) {
				agentSpecificOptions.cloneEnv = false;
			}
			if ($scope.isMultiNodeApp && $scope.restoreData.globalOptions.databaseName) {
				agentSpecificOptions.databases = [$scope.restoreData.globalOptions.databaseName];
			}
			if ($scope.restoreData.globalOptions.dataDir) {
				agentSpecificOptions.destinationInstanceDir = $scope.restoreData.globalOptions.dataDir;
			}
			agentSpecificOptions.checkAccess = $scope.restoreData.globalOptions.checkAccess;
			agentSpecificOptions.initializeLogArea = $scope.restoreData.globalOptions.initializeLogArea;
			agentSpecificOptions.ignoreDeltaBackups = !$scope.restoreData.globalOptions.deltaBackup;
			if ($scope.restoreData.globalOptions.backupType == 2) {
				agentSpecificOptions.recoverTime = 1;
				agentSpecificOptions.pointInTime = {};
				agentSpecificOptions.pointInTime.time = $scope.restoreData.globalOptions.time.getTime() / 1000;
			} else {
				agentSpecificOptions.recoverTime = 0;
				if ($scope.restoreData.globalOptions.backupType == 1) {
					agentSpecificOptions.sapInternalBackupId = $scope.restoreData.globalOptions.backupIdValue;
				} else {
					agentSpecificOptions.backupPrefix = $scope.restoreData.globalOptions.backupPrefixValue;
				}
			}

			//catalogPointInTime
			if ($scope.restoreData.globalOptions.restoreCatalog) {
				if ($scope.restoreData.globalOptions.restoreCatalogType === '1') {
					agentSpecificOptions.catalogRecoverTime = 1;
					agentSpecificOptions.catalogPointInTime = {
						time: $scope.restoreData.globalOptions.restoreCatalogTime.getTime() / 1000
					};
				} else {
					agentSpecificOptions.catalogRecoverTime = 2;
					let catRecoverTime = $scope.restoreData.globalOptions.relativeToSysdateValue;
					if ($scope.restoreData.globalOptions.relativeToSysdateDays == $scope.dayTypeList[0]) {
						catRecoverTime = catRecoverTime * 24 * 60;
					} else {
						catRecoverTime = catRecoverTime * 60;
					}
					agentSpecificOptions.recoverTime = catRecoverTime;
				}
			}
			return agentSpecificOptions;
		};
	}
]);
app.controller('saphanaBackupOptionsCtrl', [
	'$q',
	'$rootScope',
	'$scope',
	'$location',
	'idaService',
	'$uibModalInstance',
	'$state',
	'cvLoc',
	'$log',
	'$uibModalStack',
	'data',
	'cvToaster',
	function(
		$q,
		$rootScope,
		$scope,
		$location,
		idaService,
		$modalInstance,
		$state,
		cvLoc,
		$log,
		$modalStack,
		data,
		cvToaster
	) {
		$scope.entityType = data.entityType;
		$scope.genericEntity = data.entity;
		var deferred = data.deferred;
		$scope.backupType = 'FULL';
		$scope.isSnapBackupEnabled = false;

		$scope.cancel = function() {
			$modalInstance.dismiss();
		};

		$scope.closeModal = function(resp) {
			deferred.resolve(resp);
			$modalInstance.dismiss();
		};

		$scope.failAndCloseModal = function(resp) {
			deferred.reject(resp);
		};

		var loadSubclientDetails = function() {
			idaService.getSubClientDetails($scope.genericEntity.subclientId).success(function(data) {
				if (data && data.commonProperties && data.commonProperties.snapCopyInfo) {
					$scope.isSnapBackupEnabled = data.commonProperties.snapCopyInfo.isSnapBackupEnabled;
				}
			});
		};
		loadSubclientDetails();

		var getBackupOption = function() {
			var backupOptions = {
				hanaOptions: {
					backupPrefix: $scope.backupPrefix
				}
			};

			return backupOptions;
		};
		$scope.backup = function() {
			var deferred = $q.defer();
			var backupOptions = getBackupOption();
			idaService
				.backup(
					$scope.entityType,
					angular.toJson($scope.genericEntity),
					$scope.backupType,
					angular.toJson(backupOptions)
				)
				.success(function(wr) {
					var jobIds = wr.jobIds;
					var jobSummary = {
						jobId: jobIds[0],
						percentComplete: 0,
						status: 'Starting',
						sizeOfMediaOnDisk: 0,
						totalNumOfFiles: 0,
						jobElapsedTime: 0
					};
					var job = {
						jobSummary: jobSummary,
						showProgress: true,
						kill: true,
						suspend: true,
						resume: false
					};
					$scope.backupMsg = cvLoc('notification.backup.started');
					deferred.resolve(job);
				})
				.error(function(data, status, headers, config) {
					if (data !== null && data.trim() === 'Backup in progress') {
						$scope.backupMsg = data.trim();
						deferred.reject({
							running: true,
							data: data.trim()
						});
					} else {
						$scope.backupMsg = 'Failed: ' + data.trim();
						deferred.reject({
							running: false,
							data: data.trim()
						});
					}
				});
			return deferred.promise;
		};

		$scope.goToJob = function() {
			var top = $modalStack.getTop();
			if (top) {
				$modalStack.dismiss(top.key);
				event.preventDefault();
			}
			$location.path('jobs/' + $scope.backupJobId);
		};

		$scope.startBackup = function() {
			var result = {};
			result.backupType = $scope.backupType;
			$scope.loading = true;
			$scope.backup().then(
				function(resp) {
					$scope.loading = false;
					$scope.backupJobId = resp.jobSummary.jobId;
					$scope.closeModal(resp);
					var backupMsg = cvLoc('notification.backupJob', $scope.backupJobId);
					var viewMsg = cvLoc('notification.jobDetails');
					cvToaster.showSuccessMessage({
						ttl: '7000',
						message: backupMsg + ' <br><a href=#/jobs/' + $scope.backupJobId + '>' + viewMsg + '</a>'
					});
					$scope.closeModal(resp);
				},
				function(resp) {
					$scope.loading = false;
					$scope.backupMsg = resp.data;
					$scope.serverMessage = {
						type: 'error',
						message: resp.data
					};
					$scope.failAndCloseModal(resp);
				}
			);
		};
	}
]);

export default app;
