import 'adminConsole/js/services/instances.svc.js';
import 'dbs/js/services/server.svc.js';
import 'modules/servers/js/services/servers.svc.js';
import 'capps/js/services/cappsClients.svc.js';
import 'adminConsole/js/services/agents.svc.js';
import 'adminConsole/js/factories/planPolicyModel.factory.js';
import 'modules/ida/js/services/idaService.svc.js';

import { commonAllAgentsModule } from 'common/js/modules';

export class sapForOracleCreateSubclientController {
	constructor(
		cvLoc,
		cvUtil,
		AppTypes,
		$uibModal,
		$uibModalInstance,
		data,
		cvToaster,
		planPolicyModel,
		idaService,
		$state,
		dbServerService
	) {
		this.cvLoc = cvLoc;
		this.cvUtil = cvUtil;
		this.AppTypes = AppTypes;
		this.$uibModal = $uibModal;
		this.$uibModalInstance = $uibModalInstance;
		this.cvToaster = cvToaster;

		this.data = data;
		this._planPolicyModel = planPolicyModel;
		this.planPolicyModel = planPolicyModel.get('Default');
		this.idaService = idaService;
		this.$state = $state;
		this.dbServerService = dbServerService;

		this._init();
	}

	_init() {
		this.entity = angular.copy(this.data.entity);
		this.isEdit = this.data.editing;
		this.subclientDetails = angular.copy(this.data.subclientDetails) || {};

		this.fieldPath = {
			subclientName: 'entity.subclientName',
			numberOfBackupStreams: 'subclientDetails.sapForOracleSubclientProp.numberOfBackupStreams',
			selectiveOnlineFull: 'subclientDetails.sapForOracleSubclientProp.sapSelectiveOnlineFull',
			backupMode: 'subclientDetails.sapForOracleSubclientProp.sapBackupMode',
			backupDevice: 'subclientDetails.sapForOracleSubclientProp.sapBackupDevice',
			logBackup: 'subclientDetails.sapForOracleSubclientProp.sapBackupArchiveLog',
			archiveDelete: 'subclientDetails.sapForOracleSubclientProp.sapArchiveDelete',
			createSecondCopy: 'subclientDetails.sapForOracleSubclientProp.sapArchiveLogSecondCopy',
			dataBackup: 'subclientDetails.sapForOracleSubclientProp.sapData'
		};
		if (!this.isEdit) {
			this.header = this.cvLoc('action.subclientCreation');
			this.setDefaultPlan();
		} else if (this.isEdit === 'BACKUP DEVICE') {
			this.header = this.cvLoc('label.editBackupDevice');

			this.fieldPath = {
				backupDevice: this.fieldPath.backupDevice,
				snapEnabled: 'subclientDetails.commonProperties.snapCopyInfo.isSnapBackupEnabled'
			};
		} else {
			this.header = this.cvLoc('label.EditContent');
			['subclientName', 'numberOfBackupStreams', 'backupDevice'].forEach(field => {
				delete this.fieldPath[field];
			});
		}

		this.defaultValue = {
			numberOfBackupStreams: 2,
			selectiveOnlineFull: false,
			backupMode: 'ONLINE_DB',
			backupDevice: 'UTIL_FILE',
			logBackup: true,
			archiveDelete: true,
			createSecondCopy: false,
			dataBackup: true
		};

		this.model = {};

		Object.keys(this.fieldPath).forEach(key => {
			this.model[key] = this.isEdit ? _.get(this, this.fieldPath[key]) : this.defaultValue[key];
		});

		this.separator = '\\';

		this.tree = {
			id: this.entity.instanceName,
			label: this.entity.instanceName,
			parent: undefined,
			isSelected: !this.isEdit,
			userObject: {},
			state: 'collapsed'
		};

		const contentList = [];
		if (this.subclientDetails.content) {
			this.subclientDetails.content.forEach(function(contentNode) {
				if (contentNode.sapForOracleDBContent) {
					if (!contentNode.sapForOracleDBContent.fileType) {
						if (contentNode.sapForOracleDBContent.sapDataFile) {
							contentNode.sapForOracleDBContent.fileType = 'DATAFILE';
						} else {
							contentNode.sapForOracleDBContent.fileType = 'TABLESPACE';
						}
					}
					contentList.push(contentNode.sapForOracleDBContent);
				}
			});
		}
		this.contentList = contentList;

		this.selectiveOnlineFullChanged();
		this.backupModeChanged();
	}

	setDefaultPlan() {
		const self = this;
		this.dbServerService
			.getInstanceDetails(this.entity.instanceId)
			.success(data => {
				const savedPlanId = _.get(data, 'planEntity.planId') || 0;
				_.set(self.planPolicyModel, 'plan.selected.id', savedPlanId);
			})
			.error(err => {
				self.serverMessage = self.cvUtil.errMsg(err);
			});
	}
	getPath(item) {
		if (!item) {
			return '';
		}
		if (!item.parent) {
			return this.separator;
		}
		var parentPath = this.getPath(item.parent);
		if (parentPath === this.separator) {
			return parentPath + item.id;
		}
		return parentPath + this.separator + item.id;
	}

	backupModeChanged() {
		if (this.model.backupMode === 'ONLINE_SUBSET_DB' && this.tree.state === 'collapsed') {
			this.toggle(this.tree);
		}
	}

	selectiveOnlineFullChanged() {
		if (this.model.selectiveOnlineFull) {
			this.model.dataBackup = true;
			this.model.backupMode = 'ONLINE_DB';
			this.model.logBackup = true;
			this.model.archiveDelete = true;
		}
	}

	updateChildrenStatue(items, state) {
		const self = this;
		items.forEach(function(item) {
			item.isSelected = state;
			if (item.children) {
				self.updateChildrenStatue(item.children, state);
			}
		});
	}
	updateParentStatus(item) {
		const self = this;
		if (item) {
			item.isSelected = true;
			item.children.forEach(function(child) {
				if (!child.isSelected) {
					item.isSelected = false;
				}
			});
			self.updateParentStatus(item.parent);
		}
	}

	folderDrilledDown(item, event) {
		event.preventDefault();
		this.toggle(item);
	}

	folderSelected(item) {
		const nodeState = !item.isSelected;

		item.isSelected = nodeState;
		if (item.children) {
			this.updateChildrenStatue(item.children, nodeState);
		}
		this.updateParentStatus(item.parent);
		this.expand(item);
	}

	getNodeIdValue(contentNode) {
		const fileType = contentNode.fileType;
		if (fileType === 'DATABASE') {
			return contentNode.sapDatabase;
		} else if (fileType === 'TABLESPACE') {
			return contentNode.sapTableSpace;
		} else if (fileType === 'DATAFILE') {
			return contentNode.sapDataFile;
		}
	}

	getFieldNameForFileType(fileType) {
		if (fileType === 'DATABASE') {
			return 'sapDatabase';
		} else if (fileType === 'TABLESPACE') {
			return 'sapTableSpace';
		} else if (fileType === 'DATAFILE') {
			return 'sapDataFile';
		}
	}

	getFileTypeInt(type) {
		let fileType = 0;
		if (type === 'DATABASE') {
			fileType = 1;
		} else if (type === 'TABLESPACE') {
			fileType = 2;
		} else if (type === 'DATAFILE') {
			fileType = 3;
		}
		return fileType;
	}

	toggle(item) {
		if (item.state == 'expanded') {
			item.state = 'collapsed';
		} else {
			this.expand(item);
		}
	}
	expand(item) {
		if (!item.loaded) {
			this.loadChildren(item);
		}
		item.state = 'expanded';
	}

	updateNodeSelected(browseItem) {
		const self = this;
		//In case backup mode is offline db then only we need to process list.
		if (this.model.backupMode === 'ONLINE_SUBSET_DB') {
			this.contentList.forEach(function(contentNode) {
				const idValue = self.getNodeIdValue(contentNode);
				if (browseItem.fileType === contentNode.fileType && browseItem.id === idValue) {
					browseItem.isSelected = true;
				}
				//If children is selected previously, toggle the parent node to show the children.
				if (
					contentNode[self.getFieldNameForFileType(browseItem.fileType)] === browseItem.id &&
					self.getFileTypeInt(contentNode.fileType) > self.getFileTypeInt(browseItem.fileType)
				) {
					self.expand(browseItem);
				}
			});
		}
	}

	getSelectedNodes(treeNode) {
		const self = this;
		const selectedList = [];
		if (treeNode.isSelected && treeNode.parent) {
			//Don't add root node
			selectedList.push(treeNode);
		} else if (treeNode.children) {
			treeNode.children.forEach(function(childTreeNode) {
				if (childTreeNode.isSelected) {
					selectedList.push(childTreeNode);
				} else if (childTreeNode.children) {
					const childSelection = self.getSelectedNodes(childTreeNode);
					childSelection.forEach(function(node) {
						selectedList.push(node);
					});
				}
			});
		}
		return selectedList;
	}

	loadChildren(item) {
		const self = this;
		if (item.fileType && item.fileType == 'DATAFILE') {
			item.loaded = true;
			return;
		}
		const options = {
			path: this.getPath(item)
		};
		this.idaService.getIdaBrowseData(this.entity.instanceId, 'INSTANCE_ENTITY', options).then(function(data) {
			const subItems = data.browseData;
			subItems.forEach(function(browseItem) {
				browseItem.parent = item;
				browseItem.state = 'collapsed';
				if (item.isSelected) {
					browseItem.isSelected = true;
				} else {
					self.updateNodeSelected(browseItem);
				}
			});

			item.children = subItems;
			item.loaded = true;
		});
	}

	cancel() {
		this.$uibModalInstance.dismiss();
	}

	close(data) {
		this.$uibModalInstance.close();
		const detailsState = 'dbCollectionDetails';
		if (detailsState == this.$state.current.name) {
			this.$state.forceReload();
		} else {
			const subclientId = data ? data : this.entity.subclientId;
			this.$state.go(detailsState, { subclientId: subclientId });
		}
	}

	getContentList() {
		const self = this;
		const selectdList = this.getSelectedNodes(this.tree);
		const contentList = [];
		selectdList.forEach(function(nodeData) {
			const sapForOracleDBContent = {};
			const node = nodeData.userObject;
			if (!node) {
				return;
			}
			if (node.tableSpace) {
				sapForOracleDBContent.sapTableSpace = node.tableSpace;
			}
			if (node.dataFile) {
				sapForOracleDBContent.sapDataFile = node.dataFile;
			}
			//sapForOracleDBContent.fileType = self.getFileTypeInt(node.fileType);

			contentList.push({
				sapForOracleDBContent: sapForOracleDBContent
			});
		});
		return contentList;
	}
	submit() {
		const self = this;
		const showPlan = this._planPolicyModel.getPlanModeState();

		if (!self.isEdit) {
			if (showPlan) {
				this.planPolicyModel.plan.showError = false;
				if (!this.planPolicyModel.plan.selected) {
					this.planPolicyModel.plan.showError = true;
					return;
				}
			} else {
				this.planPolicyModel.storagePolicy.showError = false;
				if (!this.planPolicyModel.storagePolicy.selected) {
					this.planPolicyModel.storagePolicy.showError = true;
					return;
				}
			}
		}

		const newEntity = angular.copy(this.entity);
		if (!this.isEdit) {
			newEntity.subclientName = this.model.subclientName;
		}

		const subclientInfo = {
			subClientEntity: newEntity
		};

		const tmp = {};
		Object.keys(this.fieldPath).forEach(key => {
			_.set(tmp, this.fieldPath[key], this.model[key]);
		});
		angular.extend(subclientInfo, tmp.subclientDetails);

		if (this.model.dataBackup && this.model.backupMode === 'ONLINE_SUBSET_DB') {
			subclientInfo.content = this.getContentList();
			subclientInfo.contentOperationType = 1;
		}

		if (!self.isEdit) {
			this.idaService.createSubclientWithPlanPolicyModel(
				subclientInfo,
				showPlan,
				this.planPolicyModel,
				function(data) {
					self.close(data);
				},
				function(e) {
					self.serverMessage = self.cvUtil.errMsg(e);
				}
			);
		} else {
			this.idaService
				.updateSubclient({
					subClientEntity: angular.toJson(subclientInfo.subClientEntity),
					subclientInfo: angular.toJson(subclientInfo)
				})
				.success(function(data) {
					self.close();
				})
				.error(function(e) {
					self.serverMessage = self.cvUtil.errMsg(e);
				});
		}
	}
}

sapForOracleCreateSubclientController.$inject = [
	'cvLoc',
	'cvUtil',
	'AppTypes',
	'$uibModal',
	'$uibModalInstance',
	'data',
	'cvToaster',
	'planPolicyModel',
	'idaService',
	'$state',
	'dbServerService'
];

commonAllAgentsModule.controller('sapForOracleCreateSubclient', sapForOracleCreateSubclientController);
export default commonAllAgentsModule;
