import { commonAllAgentsModule } from 'common/js/modules';
import 'machineBrowse/js/services/machineBrowse.svc.js';
import 'dlo/js/services/profile.svc.js';
import 'modules/ida/js/services/idaService.svc.js';
import 'adminConsole/js/controllers/browseForAgents.ctrl.js';
import 'modules/ida/js/services/idas.factory.js';
import 'modules/ida/js/directives/cv-rac-manage-instances.js';
import 'modules/ida/js/directives/cv-rac-manage-streams.js';
import 'modules/ida/js/directives/cv-client-picker.js';
import 'adminConsole/js/services/clients.svc.js';
import 'adminConsole/js/services/instances.svc.js';

var app = commonAllAgentsModule;

app.controller('racCreateDatabaseController', [
	'globalCacheFactory',
	'cvUtil',
	'dbsUtil',
	'cvToaster',
	'cvLoc',
	'idasFactory',
	'cvTableOptions',
	'$state',
	'$scope',
	'$stateParams',
	'profileService',
	'AppTypes',
	'clientService',
	'instanceService',
	'$uibModalInstance',
	'data',
	function(
		globalCacheFactory,
		cvUtil,
		dbsUtil,
		cvToaster,
		cvLoc,
		idasFactory,
		cvTableOptions,
		$state,
		$scope,
		$stateParams,
		profileService,
		AppTypes,
		clientService,
		instanceService,
		$modalInstance,
		data
	) {
		var self = this;

		/* Modal param */
		if (!data.instanceDetails) {
			data.instanceDetails = {
				instance: angular.extend(
					{
						applicationId: AppTypes.ORACLE_RAC
					},
					data.idaEntity
				)
			};
		}

		/* Editing existing instance */
		self.isEdit = !!data.instanceDetails.instance.instanceId;
		self.showServerNameError = false;
		/* Default values */
		if (!self.isEdit) {
			self.model = {
				useCatalog: true,
				catalogConnect: {}
			};
			self.showPlanError = true;
		} else {
			/* Editing case */

			var racInstance = data.instanceDetails.oracleRACInstance;

			self.oldInstanceName = data.instanceDetails.instance.instanceName;
			self.instancePlanEntity = _.get(data.instanceDetails, 'planEntity');
			self.model = {
				//for changing instance name
				instanceName: self.oldInstanceName,
				useCatalog: racInstance.useCatalogConnect,
				catalogConnect: {
					userName: racInstance.connectString.userName,
					domainName: racInstance.connectString.domainName
				}
			};
		}

		self.clientSelection = {
			selectedClients: []
		};
		self.racInstances = [];
		self.entity = data.instanceDetails.instance;

		/* Plan initialization */
		self.model.selectedProfileList = [];
		self.localLang = cvUtil.getIStevenLocLabels();
		self.initAfterLocalization = function() {
			self.localLang.nothingSelected = cvLoc('placeholder.selectPlan');
		};

		self.parseIStevenOutput = function() {
			if (self.model.selectedProfileList && self.model.selectedProfileList.length == 1) {
				self.showPlanError = false;
			} else {
				self.showPlanError = true;
			}
		};

		/* load plans */
		var loadPlans = function() {
			//		profileService.getProfiles("MSP", true, "Database").success(function (data) {
			//			self.profileList = data;
			//		}).error(function (e) {
			//			self.serverMessage = cvUtil.errMsg(e);
			//		});

			profileService
				.getEligiblePlansForApp(AppTypes.ORACLE_RAC)
				.success(function(data) {
					if (data.length > 0) {
						var planListByTypes = {};
						angular.forEach(data, planData => {
							planData = planData.planSummary ? planData.planSummary : planData;
							var planObj = {
								name: planData.plan.planName,
								id: planData.plan.planId,
								type: planData.subtype
							};
							if (planListByTypes[planData.subtype]) {
								planListByTypes[planData.subtype].push(planObj);
							} else {
								planListByTypes[planData.subtype] = [planObj];
							}
						});
						var tempPlanList = [];
						for (var planType in planListByTypes) {
							tempPlanList.push({
								name: planType,
								msGroup: true
							});
							var plansByType = cvUtil.sortAscending(planListByTypes[planType], 'name');
							tempPlanList = tempPlanList.concat(plansByType);
							tempPlanList.push({
								msGroup: false
							});
						}
						self.profileList = tempPlanList;
					} else {
						self.profileList = [];
					}

					if (self.instancePlanEntity && self.instancePlanEntity.planId) {
						planSelectonUpdate(self.instancePlanEntity, self.profileList);
					}
				})
				.error(function(e) {
					self.serverMessage = cvUtil.errMsg(e);
				});
		};
		loadPlans();

		let planSelectonUpdate = function(selectedPlan, profileList) {
			for (var planTypeNode in profileList) {
				var planNode = profileList[planTypeNode];
				if (planNode && planNode.type && selectedPlan.planId === planNode.id) {
					planNode.selected = true;
				}
			}
		};

		/*
		 * Catalog string can be /(root) or with userName,password and service name
		 */
		self.validateCatalogString = function() {
			self.isCatalogInvalidate = true;
			if (self.model.useCatalog) {
				if (
					self.model.catalogConnect.userName &&
					(self.model.catalogConnect.passwordTxt || self.isEdit) &&
					self.model.catalogConnect.domainName
				) {
					self.isCatalogInvalidate = false;
				}
			} else {
				self.isCatalogInvalidate = false;
			}
		};

		/* Cancel clicked */
		self.cancel = function() {
			$modalInstance.dismiss();
		};

		/* Close when operation succeeded */
		self.close = function(params) {
			globalCacheFactory.refreshCacheId();
			$modalInstance.close(params);
			$state.forceReload();
		};

		/* Send request to create/edit instance */
		var sendInstanceRequest = function() {
			var instanceEntity = angular.copy(self.entity);
			if (!instanceEntity.clientId && self.clientSelection.selectedClients.length == 1) {
				instanceEntity.clientId = self.clientSelection.selectedClients[0].clientId;
				instanceEntity.clientName = self.clientSelection.selectedClients[0].clientName;
			}
			var instanceProps = {
				oracleRACInstance: {
					useCatalogConnect: self.model.useCatalog,
					connectString: {
						userName: self.model.catalogConnect.userName,
						domainName: self.model.catalogConnect.domainName
					}
				}
			};

			if (self.model.catalogConnect.passwordTxt) {
				instanceProps.oracleRACInstance.connectString.password = cvUtil.getBytes(self.model.catalogConnect.passwordTxt);
			}

			var request = null;

			/* Create a new instance */
			if (!self.entity.instanceId) {
				instanceEntity.instanceName = self.model.instanceName;
				instanceProps.oracleRACInstance.ctrlFileAutoBackupType = 'CONFIGURE_ON';
				instanceProps.oracleRACInstance.blockSize = 1048576;
				instanceProps.oracleRACInstance.racDBInstance = self.racInstances;
				instanceProps.oracleRACInstance.racDBOperationType = 'ADD';
				request = instanceService.createInstance;
			} else {
				/* Update existing instance */
				request = instanceService.updateInstance;
			}
			if (self.model.selectedProfileList && self.model.selectedProfileList.length > 0) {
				instanceProps.planEntity = { planId: self.model.selectedProfileList[0].id };
			}
			var instInfo = {
				instanceEntity: angular.toJson(instanceEntity),
				instanceProps: angular.toJson(instanceProps)
			};

			if (self.model.selectedProfileList && self.model.selectedProfileList.length > 0) {
				instInfo.planId = self.model.selectedProfileList[0].id; //self.model.planId
			}

			if (self.entity.instanceId && self.model.instanceName != self.oldInstanceName) {
				instInfo.newInstanceName = self.model.instanceName;
			}

			request(instInfo)
				.success(function() {
					if (self.isEdit) {
						//Pass new values when modal is closed.
						var newInstanceDetails = angular.copy(data.instanceDetails);
						angular.extend(newInstanceDetails, instanceProps);
						newInstanceDetails.instance = angular.copy(self.entity);
						newInstanceDetails.instance.instanceName = self.model.instanceName;
						self.close(newInstanceDetails);
					} else {
						self.close();
					}
				})
				.error(function(err) {
					cvToaster.showErrorMessage({ ttl: 10000, message: err });
				});
		};

		/* Send request to create client if needed */
		var sendClientRequest = function() {
			/* Create a new client */
			if (!self.entity.clientId && self.model.newServer) {
				var req = {
					entity: {
						clientName: self.model.newServerName
					},
					clientType: 'RAC'
				};

				clientService
					.createPseudoClient(req)
					.success(function(data) {
						/* Set client ID so if OK clicked again, this step is skipped */
						self.entity.clientId = data;
						self.clientCreationDone = true;
						sendInstanceRequest();
					})
					.error(function(err) {
						cvToaster.showErrorMessage({ ttl: 10000, message: err });
					});
			} else {
				return sendInstanceRequest();
			}
		};

		self.isClientSelectionValide = function() {
			self.showServerNameError = false;
			if (self.model.newServer) {
				if (!self.model.newServerName) {
					return false;
				} else if (!dbsUtil.isValidClientName(self.model.newServerName)) {
					self.showServerNameError = true;
					self.showServerNameMesage = cvLoc('error.serverNameChars', cvLoc('label.racClusterName'));
					return false;
				}
			} else if (!self.entity.clientId && !self.clientSelection.valideClientSelection) {
				return false;
			}
			return true;
		};

		/* OK clicked */
		self.submit = function() {
			/* Validate connect string */
			self.validateCatalogString();
			if (self.isCatalogInvalidate) {
				return;
			}
			/* Validate client selection */
			if (!self.isClientSelectionValide()) {
				return;
			}

			/* Validate plan selection */
			if (self.isEdit == false && (!self.model.selectedProfileList || self.model.selectedProfileList.length < 1)) {
				return;
			}

			/* Validate instance table */
			if (!self.isEdit && self.racInstances.length == 0) {
				cvToaster.showErrorMessage({ message: cvLoc('label.addAtLeastOneInstance') });
				return;
			}

			sendClientRequest();
		};
	}
]);

export default app;
