import { commonAllAgentsModule } from 'common/js/modules';

var app = commonAllAgentsModule;
app.controller('postgresSubclientContentController', [
	'$scope',
	'$state',
	'$rootScope',
	'cvUtil',
	'cvLoc',
	'$uibModalInstance',
	'$stateParams',
	'$uibModal',
	'$log',
	'$dialogs',
	'REGEX',
	'subclientService',
	'data',
	'idaService',
	'cvTableOptions',
	'LIST_OPERATION_TYPES',
	function(
		$scope,
		$state,
		$rootScope,
		cvUtil,
		cvLoc,
		$modalInstance,
		$stateParams,
		$modal,
		$log,
		$dialogs,
		REGEX,
		subclientService,
		data,
		idaService,
		cvTableOptions,
		LIST_OPERATION_TYPES
	) {
		var self = this;
		self.subclientInfo = data.subclientDetails;
		let entity = data.subclientDetails.subClientEntity;
		$scope.databaseList = [];
		self.existingDatabases = [];
		let genericEntity = {
			instanceId: entity.instanceId,
			applicationId: entity.applicationId,
			clientId: entity.clientId
		};

		//populate existing databases
		if (entity.subclientId > 0) {
			let contents = self.subclientInfo.content;
			if (contents && contents.length) {
				contents.forEach(function(pgsqlContent) {
					let dabaseName = pgsqlContent.postgreSQLContent.databaseName.substr(1);
					let contentObject = {
						pgsqlContent: {
							databaseName: dabaseName
						},
						selected: true,
						intialContent: true
					};
					$scope.databaseList.push(contentObject);
					self.existingDatabases.push(dabaseName);
				});
			}
		}

		//we will receive all databases not associated to any subclient
		idaService
			.getDbContentList(angular.toJson(genericEntity))
			.success(function(data) {
				if (data && data.length > 0) {
					data.forEach(function(pgsqlContent) {
						//extra check for not to include duplicate databases
						let dabaseName = pgsqlContent.databaseName.substr(1);
						if (!self.existingDatabases.includes(dabaseName)) {
							let contentObject = {
								pgsqlContent: {
									databaseName: dabaseName
								},
								selected: false,
								intialContent: false
							};
							$scope.databaseList.push(contentObject);
						}
					});
				}
				self.serverMessage1 = cvUtil.emptyMsg();
			})
			.error(function(errorReason) {
				$log.debug('Discover databases failed : ' + errorReason);
				self.serverMessage1 = cvUtil.errMsg(errorReason);
			});

		self.serverMessage1 = cvUtil.infoMsgLoc('Loading');

		/* GRID CONTSTRUCTION */
		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

		angular.extend(globalGridOptions, {
			cvPageLinks: [],
			data: 'databaseList',
			enableGridMenu: false,
			showGridFooter: true,
			enableRowSelection: true,
			enableSelectAll: true,
			multiSelect: true,
			paginationPageSize: 10,
			selectionRowHeaderWidth: '10%',
			columnDefs: [
				{
					field: 'pgsqlContent.databaseName',
					displayName: cvLoc('label.name'),
					enableFiltering: false,
					enableColumnResizing: false,
					cellTemplate:
						'<span class="crop" title="{{row.entity.pgsqlContent.databaseName}}">{{row.entity.pgsqlContent.databaseName}}</span>',
					sort: {
						direction: 'asc',
						priority: 0
					},
					width: '90%'
				}
			],
			onRegisterApi: function(gridApi) {
				gridApi.selection.enableVerticalScrollbar = 0;

				gridApi.selection.on.rowSelectionChangedBatch($scope, function(rows) {
					angular.forEach(rows, function(row) {
						if (row.visible) {
							row.entity.selected = row.isSelected;
						}
					});
				});
				gridApi.grid.rows.forEach(function(row) {
					if (row.entity.selected) {
						row.isSelected = true;
					}
				});
				gridApi.selection.on.rowSelectionChanged($scope, function(row) {
					row.entity.selected = row.isSelected;
				});
				gridApi.grid.registerRowsProcessor(function(renderableRows) {
					renderableRows.forEach(function(row) {
						if (row.entity.selected) {
							row.isSelected = true;
						}
					});
					return renderableRows;
				}, 200);
			}
		});

		$scope.gridOptions = {
			cvGridTitle: cvLoc('pageHeader.databases'),
			cvIsPageTitle: false,
			cvTableName: 'updateSQLSubclientContent',
			cvHasViews: false,
			cvEnableHidingFilters: false,
			cvIsSearchable: true,
			cvGridDirectives: {
				uiGridSelection: true
			},
			cvGridCssClass: {
				'bottom-border-last-child': true,
				'top-bottom-border': true
			},
			cvSearchFields: ['pgsqlContent.databaseName'],
			cvOnGridEmpty: cvUtil.errMsg(cvLoc('label.MySqlNoDatabasesDiscovered')),
			gridOptions: globalGridOptions
		};

		let overrideSubclientContent = function(subclientContent) {
			let subclientContentInfo = {
				contentOperationType: LIST_OPERATION_TYPES.OVERWRITE
			};
			let subInfo = angular.toJson(subclientContentInfo);

			subclientService
				.manageContent({
					subClientEntity: JSON.stringify(entity),
					contentInJson: JSON.stringify(subclientContent),
					subclientInfo: subInfo
				})
				.success(function(data) {
					if (data) {
						$log.debug('Database group content modified');
						$state.forceReload();
						self.closeModal();
					} else {
						$log.debug('Failure in Content Modification');
						$state.forceReload();
						$modalInstance.dismiss('cancel');
					}
				})
				.error(function(e) {
					if (!e) {
						e = cvLoc('generic_error');
					}
					$log.error(e);
					self.serverMessage1 = cvUtil.errMsg(e);
				});
		};

		let deleteSubclientContent = function(deletedContent, content) {
			let subclientContentInfo = {
				contentOperationType: LIST_OPERATION_TYPES.DELETE
			};
			let subInfo = angular.toJson(subclientContentInfo);

			subclientService
				.manageContent({
					subClientEntity: JSON.stringify(entity),
					contentInJson: JSON.stringify(deletedContent),
					subclientInfo: subInfo
				})
				.success(function(data) {
					if (data) {
						$log.debug('Database group content deleted');
						overrideSubclientContent(content);
					} else {
						$log.debug('Failure in content delete');
					}
				})
				.error(function(e) {
					//suppress soft error and continue
					$log.debug('Failure in content delete');
					overrideSubclientContent(content);
				});
		};

		self.modifySubclientContent = function() {
			let subclientContent = [];
			let deletedContent = [];
			$scope.databaseList.map(function(data) {
				if (data.selected) {
					subclientContent.push(data.pgsqlContent);
				} else if (data.intialContent) {
					deletedContent.push(data.pgsqlContent);
				}
			});

			if (subclientContent.length == 0) {
				self.serverMessage1 = cvUtil.errMsg(cvLoc('error.database_group_does_not_have_content'));
				return;
			}

			if (deletedContent.length > 0) {
				deleteSubclientContent(deletedContent, subclientContent);
			} else {
				overrideSubclientContent(subclientContent);
			}
		};

		self.closeModal = function(subclientContent) {
			$log.debug('manage database group content modal closed');
			if (subclientContent != null) {
				$modalInstance.close(subclientContent);
			} else {
				$modalInstance.close();
			}
		};
	}
]);

export default app;
