import { commonAllAgentsModule } from 'common/js/modules';

import 'adminConsole/js/directives/cv-entity-plan-policy-select.js';
import 'adminConsole/js/factories/associateSchedulePolicy.factory.js';
import 'adminConsole/js/factories/planPolicyModel.factory.js';
import 'modules/ida/js/controllers/postgresSubclientContent.ctrl.js';
import 'modules/ida/js/directives/cv-clouddb-create-instance.js';
import 'modules/ida/js/controllers/mySqlCreateInstance.ctrl.js';

var app = commonAllAgentsModule;

app.controller('pgInstanceController', PgInstanceController);
app.controller('cloudDBInstanceWrapperController', CloudDBInstanceWrapperController);
app.controller('pgBackupController', PgBackupController);
app.controller('pgRestoreController', PgRestoreController);

app.directive('cvPostgresInstance', function() {
	return {
		restrict: 'AEC',
		scope: true,
		bindToController: {
			data: '=',
			modalInstance: '='
		},
		templateUrl: appUtil.appRoot + 'modules/ida/partials/postgresCreateInstance.jsp',
		controllerAs: 'pgInstance',
		controller: 'pgInstanceController'
	};
});

app.directive('cvMysqlInstance', function() {
	return {
		restrict: 'AEC',
		scope: true,
		bindToController: {
			data: '=',
			modalInstance: '='
		},
		templateUrl: appUtil.appRoot + 'modules/ida/partials/mySqlCreateInstance.jsp',
		controllerAs: 'mySqlInstance',
		controller: 'mySqlInstanceController'
	};
});

//-----------Restore------------------------------------------------------
PgRestoreController.$inject = [
	'$scope',
	'$log',
	'dbsUtil',
	'$uibModal',
	'$uibModalInstance',
	'$stateParams',
	'cvToaster',
	'cvLoc',
	'AppTypes',
	'$filter',
	'idaService',
	'data',
	'agentService',
	'cvUtil',
	'mbService',
	'$dialogs'
];
function PgRestoreController(
	$scope,
	$log,
	dbsUtil,
	$modal,
	$modalInstance,
	$stateParams,
	cvToaster,
	cvLoc,
	AppTypes,
	$filter,
	idaService,
	data,
	agentService,
	cvUtil,
	mbService,
	$dialogs
) {
	var self = this;
	self.$scope = $scope;
	self.restoreType = data.restoreType;
	self.entity = data.entity;
	self.commCellId = 2;
	self.impersonateEnabledStatus = 'disabled-activity';
	self.isRestoreToDiskSupported = false;
	self.snapBackupEnabled = self.restoreType > 1;
	if (data.jobId && data.jobId > 0) {
		self.isRestoreToDiskSupported = self.restoreType > 0;
		self.jobId = data.jobId;
	}

	self.restoreData = {
		sourceItem: [],
		//pitDate: new Date(),
		//pitSelectedDate: '',
		//openDatePicker: false,
		destinationClients: [],
		destinationInstancesMap: new Map(),
		destinationInstances: [],
		destinationClient: {
			clientId: data.entity.clientId,
			clientName: data.entity.clientName
		},
		dbLogOnlyRestore: false,
		destinationInstance: {
			instanceId: data.entity.instanceId,
			instanceName: data.entity.instanceName
		},
		hardwareRevert: false,
		useImpersonation: false,
		impersonateUserName: '',
		impersonatePassword: '',
		instanceInfo: {},
		postgresRstOption: {
			fsBackupSetRestore: data.restoreType > 0,
			instanceRestore: false,
			isCloneRestore: false,
			pointInTime: false,
			restoreToSameServer: false,
			startServer: false,
			tableLevelRestore: false,
			refTime: {
				time: 0
			},
			fromTime: {
				time: 0
			},
			pointOfTime: {
				time: 0
			}
		},
		proxyClient: {},
		isInplaceRestore: () => self.tabControls.getCurrentTabId() === '0'
	};
	self.tabControls = {};
	self.tabStyle = 'tab-2';
	if (self.restoreType > 0) {
		if (self.isRestoreToDiskSupported) {
			self.tabStyle = 'tab-3';
		}

		self.restoreData.postgresRstOption.fsBackupSetRestore = true;
		self.restoreData.postgresRstOption.startServer = true;
		if (data.toTimeValue) {
			//var dateObject = new Date(parseInt(data.toTime) * 1000);
			//self.restoreData.pitDate = cvUtil.convertUTCDateToLocalDate(dateObject);
			self.restoreData.postgresRstOption.pointInTime = true;
		}
		self.restoreData.sourceItem.push('/data');
	}

	self.toggleImpersonation = function() {
		self.restoreData.useImpersonation = !self.restoreData.useImpersonation;
		self.impersonateEnabledStatus = self.restoreData.useImpersonation ? 'enabled-activity' : 'disabled-activity';
	};
	/*self.pitSelected = function() {
		if (self.restoreData.postgresRstOption.pointInTime) {
			self.restoreData.openDatePicker = true;
		} else {
			self.restoreData.openDatePicker = false;
		}
	};*/

	self.updateInstcesModel = function(clientId) {
		if (parseInt(clientId) <= 0) {
			return;
		}
		self.restoreData.destinationInstances = [];
		if (self.restoreData.destinationInstancesMap.has(clientId)) {
			let instanceList = cvUtil.sortAscending(self.restoreData.destinationInstancesMap.get(clientId), 'instanceName');
			self.restoreData.destinationInstances = instanceList;
			if (instanceList.length > 0 && !instanceList[0].disabled) {
				self.restoreData.destinationInstance = instanceList[0];
			}
		}
	};

	var loadDestinationClientsAndInstances = function() {
		if (parseInt(data.entity.clientId) <= 0) return;
		self.osType = '';
		mbService.getOSType(data.entity.clientId).then(function successCallBack(response) {
			self.osType = response.data;
			let sourceEntity = angular.copy(data.entity);
			if (self.restoreData.postgresRstOption.fsBackupSetRestore) sourceEntity.osType = self.osType;
			let genericEntity = angular.toJson(sourceEntity);
			idaService.getRestoreDestinationsForEntity(genericEntity).then(
				function(result) {
					let serverList = [];
					let instancesMap = new Map();
					for (let i = 0; i < result.data.length; i++) {
						//disable source instance selection
						if (self.entity.instanceId == result.data[i].instanceId) {
							result.data[i].disabled = true;
						}
						if (instancesMap.has(result.data[i].clientId)) {
							instancesMap.get(result.data[i].clientId).push(result.data[i]);
						} else {
							instancesMap.set(result.data[i].clientId, []);
							instancesMap.get(result.data[i].clientId).push(result.data[i]);
							let client = {
								clientId: result.data[i].clientId,
								clientName: result.data[i].clientName,
								displayName: result.data[i].displayName
							};
							serverList.push(client);
						}
						if (result.data[i].clientId == self.entity.clientId) {
							self.inplaceDestinationServer = result.data[i];
						}
					}
					self.restoreData.destinationClients = cvUtil.sortAscending(serverList, 'clientName');
					self.restoreData.destinationInstancesMap = instancesMap;
					//first time loading
					self.updateInstcesModel(data.entity.clientId);
				},
				function(e) {
					$log.error(e);
				}
			);
		});
	};
	loadDestinationClientsAndInstances();

	/*self.setInstanceInfo = function (instanceId) {
			if (parseInt(instanceId) <= 0) {
				return;
			}
			self.restoreData.instanceInfo = self.restoreData.destinationInstances.filter(function (entry) {
				return entry.instance.instanceId == instanceId;
			})[0];
		};*/

	/*self.resultFunction = function(result) {
		if (result != null) {
			self.restoreData.pitDate = cvUtil.formatDate(result.toDateString, 'medium', null);
		}
	};*/

	self.cancel = function() {
		$modalInstance.dismiss();
	};
	self.closeModal = function(result) {
		$modalInstance.close();
	};

	/*	self.isPITValide = function() {
		if (
			self.restoreData.postgresRstOption.pointInTime &&
			(!self.restoreData.pitDate || new Date(self.restoreData.pitDate) == 'Invalid Date')
		)
			return false;
		else return true;
	};*/

	/*		self.shouldDisableInstance = function(instanceId){
			return instanceId === self.entity.instanceId;
		}*/

	self.isDisableBrowse = function() {
		let clientId = _.get(self.restoreData, 'destinationClient.clientId');

		if (clientId && clientId > 0) {
			return false;
		}
		return true;
	};

	self.browseResultFunction = function(result) {
		if (result) {
			self.restoreData.path = result.path;
		}
	};

	self.previousTabId = 0;
	self.onTabChanged = function() {
		if (self.tabControls.getCurrentTabId() != self.previousTabId) {
			self.previousTabId = self.tabControls.getCurrentTabId();
			if (self.tabControls.getCurrentTabId() == 0) {
				self.restoreData.destinationClient = self.inplaceDestinationServer;
				if (self.restoreData.destinationClient && self.restoreData.destinationClient.clientId) {
					self.updateInstcesModel(self.restoreData.destinationClient.clientId);
				}
			} else {
				self.restoreData.destinationInstance = undefined;
			}
		}
	};

	/*
	 * Show restore confirmation since data can be overwritten.
	 */
	self.confirmRestore = function(destination, yesFunction) {
		let sClient = self.entity.clientName;
		let sInstance = self.entity.instanceName;
		let dClient = destination.destClient.clientName;
		let dInstance = destination.destinationInstance.instanceName;
		let isInplace = sClient == dClient && sInstance == dInstance;
		let message = isInplace
			? cvLoc('label.confirmOracleRestoreInPlace', sClient, sInstance)
			: cvLoc('label.confirmOracleRestoreOutOfPlace', sClient, sInstance, dClient, dInstance, dInstance);
		//For restore to disk

		if (self.restoreType > 0 && self.tabControls.getCurrentTabId() != 2) {
			$dialogs.confirm(cvLoc('label.confirm'), message, {
				yesFunction: yesFunction,
				noFunction: function() {}
			});
		} else {
			yesFunction();
		}
	};

	self.doRestore = function() {
		let yesFunctionCall = function() {
			let genericEntity = angular.copy(data.entity);

			let browseOption = composeBrowseOption();
			let destination = composeDestination();
			let commonOptions = composeCommonOptions();
			let agentSpecificOptions = composeAgentSpecificOptions();
			let rdsOption = {};
			let sourceItems = getSourceItems();
			let impersonation = composeImpersonation();

			idaService
				.submitRestoreJob({
					entityType: data.entityType,
					genericEntity: angular.toJson(genericEntity),
					browseOption: angular.toJson(browseOption),
					destination: angular.toJson(destination),
					commonOptions: angular.toJson(commonOptions),
					sourceItemsToRestore: angular.toJson(sourceItems),
					agentSpecificOptions: angular.toJson(agentSpecificOptions),
					rdsOption: angular.toJson(rdsOption),
					impersonation: angular.toJson(impersonation)
				})
				.success(function(result) {
					dbsUtil.showRestoreToaster(result);
					self.cancel();
				})
				.error(function(err) {
					cvToaster.showErrorMessage({
						message: err
					});
				});
		};

		if (_.get(self, '$scope.isAPICall')) {
			yesFunctionCall();
			return;
		}
		self.pitError = false;
		/*		if (!self.isPITValide()) {
			self.pitError = false;
		}*/

		let destination = composeDestination();

		self.confirmRestore(destination, yesFunctionCall);

		return;
	};

	let composeImpersonation = function() {
		let impersonation = {};
		if (self.tabControls.getCurrentTabId() == 2 && self.restoreData.useImpersonation) {
			impersonation = {
				user: {
					userName: self.restoreData.impersonateUserName,
					password: cvUtil.getBytes(self.restoreData.impersonatePassword)
				},
				useImpersonation: true
			};
		}
		return impersonation;
	};

	let composeCommonOptions = function() {
		if (self.tabControls.getCurrentTabId() == 2) {
			let commonOptions = {
				dbLogOnlyRestore: self.restoreData.dbLogOnlyRestore,
				indexFreeRestore: true,
				restoreToDisk: true
			};
			return commonOptions;
		} else {
			let commonOptions = {};
			if (self.tabControls && self.tabControls.getCurrentTabId() === '0' && self.snapBackupEnabled) {
				commonOptions.revert = self.restoreData.hardwareRevert;
			}
			return commonOptions;
		}
	};

	let composeBrowseOption = function() {
		let browseOption = {
			commCellId: self.commCellId,
			timeRange: {
				fromTimeValue: data.fromTimeValue ? data.fromTimeValue : null,
				toTimeValue: data.toTimeValue ? data.toTimeValue : null
			}
		};
		if (self.entity.backupsetId) {
			let backupset = {
				clientId: self.entity.clientId,
				backupsetId: self.entity.backupsetId
			};
			browseOption.backupset = backupset;
		}
		if (self.tabControls.getCurrentTabId() == 2) {
			browseOption.browseJobId = self.jobId;
		}

		/* No Need to set source client as mount MA.
		//For Block level restores we need to set source client as mount MA.
		if (self.restoreType == 7 && self.tabControls.getCurrentTabId() != 2) {
			let mediaOption = {
				mediaAgent: {
					mediaAgentId: self.entity.clientId
				}
			};
			browseOption.mediaOption = mediaOption;
		}
		*/
		//set copy precedence
		if (data.copyPrecedence) {
			angular.extend(browseOption, {
				mediaOption: {
					copyPrecedence: {
						copyPrecedenceApplicable: true,
						copyPrecedence: data.copyPrecedence
					}
				}
			});
		}

		if (self.restoreData.proxyClient && self.restoreData.proxyClient.id) {
			let proxyForSnapClients = {
				clientId: self.restoreData.proxyClient.id,
				clientName: self.restoreData.proxyClient.name
			};
			_.set(browseOption, 'mediaOption.proxyForSnapClients', proxyForSnapClients);
		}
		return browseOption;
	};

	let composeDestination = function() {
		let destination = {};
		let destClient = {};
		let destinationInstance = {};

		if (self.tabControls.getCurrentTabId() == 0) {
			destClient = {
				clientId: self.entity.clientId,
				clientName: self.entity.clientName
			};
			destinationInstance = angular.copy(self.entity);
		} else if (self.tabControls.getCurrentTabId() == 1) {
			destClient = angular.copy(self.restoreData.destinationClient);
			let selectedInstance = self.restoreData.destinationInstance;
			destinationInstance = {
				clientId: selectedInstance.clientId,
				clientName: selectedInstance.clientName,
				applicationId: selectedInstance.applicationId,
				instanceId: selectedInstance.instanceId,
				instanceName: selectedInstance.instanceName
			};
		} else if (self.tabControls.getCurrentTabId() == 2) {
			destClient = angular.copy(self.restoreData.destinationClient);
			let destPath = [];
			destPath.push(self.restoreData.path);
			destination.destPath = destPath;
		}
		destination.destClient = destClient;
		destination.destinationInstance = destinationInstance;
		return destination;
	};

	let composeAgentSpecificOptions = function() {
		let agentSpecificOptions = {};
		if (self.tabControls.getCurrentTabId() == 2) {
			return agentSpecificOptions;
		}
		agentSpecificOptions = angular.copy(self.restoreData.postgresRstOption);
		if (self.restoreType > 0 && self.restoreData.postgresRstOption.pointInTime) {
			/*			let cvDate = new Object();
			let timeValue = cvUtil.formatDate(self.restoreData.pitDate, 'yyyy-MM-ddTHH:mm:ss', 'UTC');
			cvDate.timeValue = timeValue;
			agentSpecificOptions.fromTime = cvDate;
			agentSpecificOptions.refTime = cvDate;*/
			agentSpecificOptions.pointOfTime = {
				timeValue: data.toTimeValue
			};
		}
		return agentSpecificOptions;
	};

	//This will format the list of source items,as list of strings, from selectionArray and return the same.
	let getSourceItems = function() {
		let sourceItems = [];
		if (self.tabControls.getCurrentTabId() == 2) {
			sourceItems.push(self.commCellId + ':' + self.jobId);
			return sourceItems;
		}
		//For FS supports only Full Restores
		if (self.restoreType > 0) {
			return self.restoreData.sourceItem;
		}
		angular.forEach(data.selectedRows, function(selectedItem) {
			sourceItems.push('/' + selectedItem.userObject.displayName);
		});
		return sourceItems;
	};
}

CloudDBInstanceWrapperController.$inject = [
	'globalCacheFactory',
	'$scope',
	'$state',
	'$uibModalInstance',
	'$log',
	'$uibModal',
	'data',
	'cvToaster',
	'storageService',
	'instanceService',
	'idaService',
	'postgresService',
	'mbService',
	'cvLoc',
	'cvUtil',
	'profileService',
	'AppTypes',
	'CAPPS_CONSTANTS'
];
function CloudDBInstanceWrapperController(
	globalCacheFactory,
	$scope,
	$state,
	$modalInstance,
	$log,
	$modal,
	data,
	cvToaster,
	storageService,
	instanceService,
	idaService,
	postgresService,
	mbService,
	cvLoc,
	cvUtil,
	profileService,
	AppTypes,
	CAPPS_CONSTANTS
) {
	var self = this;
	self.data = data;
	self.modalInstance = $modalInstance;

	var toggleControl = {
		enableActivity: 'enabled-activity',
		disableActivity: 'disabled-activity'
	};

	self.isCloudDB =
		self.data.editDialog === true && self.data.instanceDetails.clientAppType === 'CLOUDDB'
			? toggleControl.enableActivity
			: toggleControl.disableActivity;
	self.appId = self.data.idaEntity.applicationId;
	self.modalTitle = cvLoc('action.AddPostgresInstance');

	if (self.appId === AppTypes.POSTGRESQL) {
		if (self.data.editDialog === true) {
			self.modalTitle = cvLoc('action.EditPostgresInstance');
		} else {
			self.modalTitle = cvLoc('action.AddPostgresInstance');
		}
	} else if (self.appId === AppTypes.MYSQL) {
		if (self.data.editDialog === true) {
			self.modalTitle = cvLoc('action.EditMySqlInstance');
		} else {
			self.modalTitle = cvLoc('action.AddMySqlInstance');
		}
	} else if (self.isCloudDB) {
		let cloudAppsType = _.get(self.data.instanceDetails, 'cloudAppsInstance.instanceType');

		if (cloudAppsType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GCP_SPANNER.key) {
			self.isGCPSpannerInstance = true;

			if (self.data.editDialog) self.modalTitle = cvLoc('header.editSpannerInstance');
		}
	}

	self.isPostgreSQL = function() {
		return self.data.idaEntity.applicationId === AppTypes.POSTGRESQL;
	};

	self.isMYSQL = function() {
		return self.data.idaEntity.applicationId === AppTypes.MYSQL;
	};

	self.toggleCloudDB = function() {
		if (self.isCloudDB === toggleControl.disableActivity) {
			self.isCloudDB = toggleControl.enableActivity;
		} else {
			self.isCloudDB = toggleControl.disableActivity;
		}
	};

	self.isCloudDBInstance = function() {
		return self.isCloudDB === toggleControl.enableActivity;
	};

	self.isEditInstance = function() {
		return self.data.editDialog === true;
	};
}

//-----------Instance------------------------------------------------------
PgInstanceController.$inject = [
	'globalCacheFactory',
	'$scope',
	'$state',
	'$log',
	'$uibModal',
	'cvToaster',
	'storageService',
	'instanceService',
	'idaService',
	'postgresService',
	'clientDetailService',
	'mbService',
	'idasFactory',
	'cvLoc',
	'cvUtil',
	'profileService',
	'AppTypes'
];
function PgInstanceController(
	globalCacheFactory,
	$scope,
	$state,
	$log,
	$modal,
	cvToaster,
	storageService,
	instanceService,
	idaService,
	postgresService,
	clientDetailService,
	mbService,
	idasFactory,
	cvLoc,
	cvUtil,
	profileService,
	AppTypes
) {
	var self = this;
	this.$onInit = function() {
		self.setInstanceData = setInstanceData;
		self.updateData = updateData;
		self.submitData = submitData;
		self.updateStandbySettings = updateStandbySettings;
		self.isUnixClient = false;
		self.hasBlocklevelSubclient = false;
		self.isStandbyInstanceLoaded = false;
		self.dummypassword = cvLoc('label.keepSamePassword');
		self.dbPassword = '';
		self.isShowPasswordError = true;
		self.standbyInstances = [];
		self.standbyEnabledStatus = 'disabled-activity';
		self.localLang1 = cvUtil.getIStevenLocLabels();
		self.initAfterLocalization1 = function() {
			self.localLang1.nothingSelected = cvLoc('placeholder.ProxyInstance');
		};
		self.showStandbyError = true;
		self.libraries = [];
		self.selectedProfileList = [];
		self.localLang = cvUtil.getIStevenLocLabels();
		self.initAfterLocalization = function() {
			self.localLang.nothingSelected = cvLoc('placeholder.selectPlan');
		};
		self.openAccordian1 = false;
		self.openAccordian2 = false;
		/* load plans */
		let loadPlans = function() {
			profileService
				.getEligiblePlansForApp(AppTypes.POSTGRESQL)
				.success(function(data) {
					if (data.length > 0) {
						let planListByTypes = {};
						angular.forEach(data, planData => {
							planData = planData.planSummary ? planData.planSummary : planData;
							let planObj = {
								name: planData.plan.planName,
								id: planData.plan.planId,
								type: planData.subtype,
								numAssocEntities: planData.numAssocEntities,
								numCopies: planData.numCopies,
								rpoInMinutes: planData.rpoInMinutes,
								planSummary: _.get(planData, 'plan.planSummary')
							};

							if (planListByTypes[planData.subtype]) {
								planListByTypes[planData.subtype].push(planObj);
							} else {
								planListByTypes[planData.subtype] = [planObj];
							}
						});
						let tempPlanList = [];
						for (let planType in planListByTypes) {
							tempPlanList.push({
								name: planType,
								msGroup: true
							});
							let plansByType = cvUtil.sortAscending(planListByTypes[planType], 'name');
							tempPlanList = tempPlanList.concat(plansByType);
							tempPlanList.push({
								msGroup: false
							});
						}
						self.profileList = tempPlanList;
					} else {
						self.profileList = [];
					}

					if (self.hasInstancePlan) {
						planSelectonUpdate(self.instancePlanEntity, self.profileList);
					}
				})
				.error(function(e) {
					self.serverMessage = cvUtil.errMsg(e);
				});
		};

		let planSelectonUpdate = function(selectedPlan, profileList) {
			for (let planTypeNode in profileList) {
				let planNode = profileList[planTypeNode];
				if (planNode && planNode.type) {
					if (selectedPlan.planId === planNode.id) {
						planNode.selected = true;
					} else {
						planNode.selected = false;
					}
				}
			}
		};

		let clearPlanSelection = function() {
			let profileList = self.profileList;
			for (let planTypeNode in profileList) {
				let planNode = profileList[planTypeNode];
				if (planNode && planNode.type && planNode.selected) {
					planNode.selected = false;
				}
			}
		};

		let loadClientPlan = function(clientId) {
			clientDetailService
				.getClientPlan(clientId)
				.success(function(data) {
					let clientPlanEntity = _.get(data, 'summary.plan');
					let hasClientPlan = clientPlanEntity && clientPlanEntity.planId > 0;
					if (self.edit) {
						if (self.hasInstancePlan) {
							planSelectonUpdate(self.instancePlanEntity, self.profileList);
						} else if (hasClientPlan) {
							planSelectonUpdate(clientPlanEntity, self.profileList);
						} else {
							clearPlanSelection();
						}
					} else {
						if (hasClientPlan) {
							planSelectonUpdate(clientPlanEntity, self.profileList);
						} else {
							clearPlanSelection();
						}
					}
				})
				.error(function(e) {});
		};
		self.setInstanceData();
		var loadClientOsType = function(clientId) {
			mbService.getOSType(clientId).then(function successCallBack(response) {
				self.isUnixClient = response.data.toLowerCase() == 'unix';
				if (self.edit && self.isUnixClient) {
					self.updateStandbySettings();
				}
			});
			loadClientPlan(clientId);
		};
		if (!self.addInstance) {
			loadClientOsType(self.data.idaEntity.clientId);
		}

		//Machine browse functions
		self.binBrowseResuleFunction = function(result) {
			if (result) {
				self.instanceDetails.postGreSQLInstance.BinaryDirectory = result.path;
			}
		};

		self.libBrowseResuleFunction = function(result) {
			if (result) {
				self.instanceDetails.postGreSQLInstance.LibDirectory = result.path;
			}
		};

		self.archiveBrowseResuleFunction = function(result) {
			if (result) {
				self.instanceDetails.postGreSQLInstance.ArchiveLogDirectory = result.path;
			}
		};

		self.closeDialogBox = function() {
			self.modalInstance.close();
		};

		self.isStandbySettingApplicable = function() {
			return (
				self.edit &&
				self.isUnixClient &&
				!self.instanceDetails.postGreSQLInstance.isStandBy &&
				!self.hasBlocklevelSubclient
			);
		};

		self.openCloudDbDialog = function() {
			self.modalInstance.close();
			idasFactory.createCloudDatabase();
		};

		//functions
		function updateStandbySettings() {
			if (self.isStandbyInstanceLoaded) return;

			if (self.isUnixClient) {
				instanceService
					.getSubClients(self.instance.clientId, self.instance.applicationId, self.instance.instanceId)
					.success(function(subclients) {
						for (var i in subclients) {
							//For Block level subclients stand by settings are not applicable
							if (subclients[i].postgreSQLSubclientProp.subclientTypeFlag == 7) {
								self.hasBlocklevelSubclient = true;
								break;
							}
						}

						if (!self.hasBlocklevelSubclient) {
							let sourceEntity = angular.copy(self.instance);
							sourceEntity.osType = 'unix';
							postgresService.getStandbyInstances(sourceEntity).then(
								function(result) {
									self.isStandbyInstanceLoaded = true;
									let serverMap = {};
									for (let i = 0; i < result.data.length; i++) {
										let node = result.data[i];
										node.name = node.instanceName;
										if (serverMap[node.clientName]) {
											serverMap[node.clientName].push(node);
										} else {
											serverMap[node.clientName] = [node];
										}
									}
									let tmpServerList = [];
									for (let clientName in serverMap) {
										tmpServerList.push({
											name: clientName,
											msGroup: true
										});
										let instancesByClient = cvUtil.sortAscending(serverMap[clientName], 'name');
										tmpServerList = tmpServerList.concat(instancesByClient);
										tmpServerList.push({
											msGroup: false
										});
									}
									self.standbyInstances = tmpServerList;
									if (self.edit && self.instanceDetails.postGreSQLInstance.standbyOptions.isStandbyEnabled) {
										self.standbyEnabledStatus = 'enabled-activity';
										self.standbyInstances.forEach(function(instance) {
											if (
												instance.instanceId &&
												instance.instanceId ==
													self.instanceDetails.postGreSQLInstance.standbyOptions.standbyInstance.instanceId
											) {
												instance.selected = true;
												self.showStandbyError = false;
											}
										});
									}
								},
								function(e) {
									$log.error(e);
								}
							);
						}
					});
			}
		}

		self.parseIStevenOutput1 = function() {
			if (self.selectedStandbyList && self.selectedStandbyList.length == 1) {
				self.showStandbyError = false;
			} else {
				if (self.instanceDetails.mySqlInstance.proxySettings.isProxyEnabled) {
					self.showStandbyError = true;
				} else {
					self.showStandbyError = false;
				}
			}
		};

		self.toggleStandbyEnabledStatus = function() {
			self.instanceDetails.postGreSQLInstance.standbyOptions.isStandbyEnabled = !self.instanceDetails.postGreSQLInstance
				.standbyOptions.isStandbyEnabled;
			self.standbyEnabledStatus = self.instanceDetails.postGreSQLInstance.standbyOptions.isStandbyEnabled
				? 'enabled-activity'
				: 'disabled-activity';
		};

		function setInstanceData() {
			self.instanceDetails = {};

			self.addInstance = false;
			if (self.data.editDialog && self.data.editDialog === 'Add_Instance') {
				self.addInstance = true;
				self.edit = false;
				self.clientSelection = {
					selectedClients: [],
					valideClientSelection: false,
					selectionChanged: function(clientEntity) {
						loadClientOsType(clientEntity.clientId);
						self.instance.clientId = clientEntity.clientId;
						self.instance.clientName = clientEntity.clientName;
					}
				};
			} else {
				self.edit = self.data.editDialog;
			}
			self.instance = {
				instanceId: -1,
				instanceName: '',
				applicationId: self.data.idaEntity.applicationId,
				appName: self.data.idaEntity.appName,
				clientId: self.data.idaEntity.clientId,
				clientName: self.data.idaEntity.clientName
			};
			self.instanceDetails.postGreSQLInstance = {
				MaintainenceDB: 'postgres',
				BinaryDirectory: '',
				LibDirectory: '',
				ArchiveLogDirectory: '',
				port: '5432',
				SAUser: {
					userName: 'postgres',
					password: ''
				},
				osUser: {
					userName: ''
				},
				ArchiveDelete: '',
				isStandBy: false,
				standbyOptions: {
					isStandbyEnabled: false,
					standbyInstance: {},
					useMasterForDataBkp: false,
					useMasterForLogBkp: false
				}
			};
			self.showPlanError = !self.edit;
			loadPlans();
			if (self.edit) {
				self.instanceDetails = self.data.instanceDetails;
				self.instance = self.data.instanceDetails.instance;
				self.instancePlanEntity = _.get(self.instanceDetails, 'planEntity');
				if (self.instancePlanEntity && self.instancePlanEntity.planId && self.instancePlanEntity.planId > 0) {
					self.hasInstancePlan = true;
				}
			}
			//set plan
			if (self.selectedProfileList && self.selectedProfileList.length > 0) {
				self.instanceDetails.planEntity = { planId: self.selectedProfileList[0].id };
				self.showPlanError = false;
			} else {
				//for edit instance plan is optional
				self.showPlanError = !self.edit;
			}
			self.newInstanceName = self.instance.instanceName;

			self.serverMessage = {
				message: '',
				type: ''
			};
		}

		let isvalidEntry = function(data) {
			if (data == undefined || data == '') {
				return false;
			}
			return true;
		};

		self.validateInputs = function(fromController) {
			var formValid = true;
			if (!fromController.$valid && fromController.$error) {
				angular.forEach(fromController.$error.required, function(field) {
					field.$setDirty();
				});
				formValid = false;
			}

			//check for Accordian1
			if (
				!isvalidEntry(self.instanceDetails.postGreSQLInstance.SAUser.userName) ||
				(!self.edit && !isvalidEntry(self.instanceDetails.postGreSQLInstance.SAUser.password)) ||
				!isvalidEntry(self.instanceDetails.postGreSQLInstance.port) ||
				!isvalidEntry(self.instanceDetails.postGreSQLInstance.MaintainenceDB)
			) {
				self.openAccordian1 = true;
			}
			//check for Accordian2
			if (
				!isvalidEntry(self.instanceDetails.postGreSQLInstance.BinaryDirectory) ||
				!isvalidEntry(self.instanceDetails.postGreSQLInstance.LibDirectory)
			) {
				self.openAccordian2 = true;
			}

			return formValid;
		};

		function updateData() {
			if (self.newInstanceName != self.instance.instanceName) {
				if (self.instance.instanceId <= 0) {
					self.instance.instanceName = self.newInstanceName;
				}
			}
			//set the password as Byte array
			if (
				self.instanceDetails.postGreSQLInstance.SAUser.password != undefined &&
				self.instanceDetails.postGreSQLInstance.SAUser.password != ''
			) {
				self.dbPassword = self.instanceDetails.postGreSQLInstance.SAUser.password;
				self.instanceDetails.postGreSQLInstance.SAUser.password = cvUtil.getBytes(
					self.instanceDetails.postGreSQLInstance.SAUser.password
				);
			} else {
				self.isShowPasswordError = false;
				self.instanceDetails.postGreSQLInstance.SAUser.password = null;
			}

			//set plan
			if (self.selectedProfileList && self.selectedProfileList.length > 0) {
				self.instanceDetails.planEntity = { planId: self.selectedProfileList[0].id };
				self.showPlanError = false;
			} else {
				//for edit instance plan is optional
				self.showPlanError = !self.edit;
			}

			//set standby instance
			if (self.isStandbySettingApplicable) {
				if (self.selectedStandbyList && self.selectedStandbyList.length > 0) {
					self.instanceDetails.postGreSQLInstance.standbyOptions.standbyInstance = self.selectedStandbyList[0];
					self.showStandbyError = false;
				} else {
					self.showStandbyError = true;
				}
			}
		}

		function submitData() {
			self.updateData();

			if (self.showPlanError) {
				return;
			}

			//In case of add instance dialog check for the client selection validation
			if (self.addInstance) {
				if (!self.clientSelection.valideClientSelection) {
					return;
				}
				if (self.clientSelection.selectedClients) {
					self.instance.clientName = self.clientSelection.selectedClients[0].clientName;
					self.instance.clientId = self.clientSelection.selectedClients[0].clientId;
				}
			}
			var reqParams = {
				instanceEntity: angular.toJson(self.instance),
				instanceProps: angular.toJson(self.instanceDetails),
				password: '',
				osUserPassword: ''
			};
			if (self.instance.instanceId > 0) {
				reqParams['newInstanceName'] = self.newInstanceName;
			}

			idaService
				.createInstance(reqParams, self.instance.instanceId > 0)
				.success(function(successData) {
					globalCacheFactory.refreshCacheId();
					if (successData.errorCode && successData.errorCode > 0) {
						cvToaster.showErrorMessage({
							ttl: '10000', //10 sec
							message: successData.errorString
						});
					}
					self.modalInstance.close();
					if (self.edit) {
						$state.forceReload();
					} else {
						let instanceId = _.get(successData, 'entity.instanceId');
						if (instanceId && instanceId > 0) {
							$state.go('databaseDetails', { instanceId: successData.entity.instanceId });
						}
					}
				})
				.error(function(errorReason) {
					//On error we need to set password back as it is already encrypted.
					if (self.dbPassword != '') {
						self.instanceDetails.postGreSQLInstance.SAUser.password = self.dbPassword;
					}
					self.isShowPasswordError = true;
					self.serverMessage = {
						message: errorReason,
						type: 'error'
					};
				});
		}
		self.parseIStevenOutput = function() {
			if (self.selectedProfileList && self.selectedProfileList.length == 1) {
				self.showPlanError = false;
			} else {
				//for edit instance plan is optional
				self.showPlanError = !self.edit;
			}
		};
	};
}

//-----------BACKUP------------------------------------------------------
PgBackupController.$inject = [
	'$q',
	'$rootScope',
	'$scope',
	'$location',
	'$uibModalInstance',
	'$state',
	'$log',
	'$uibModalStack',
	'idaService',
	'cvLoc',
	'data',
	'cvToaster'
];
function PgBackupController(
	$q,
	$rootScope,
	$scope,
	$location,
	$modalInstance,
	$state,
	$log,
	$modalStack,
	idaService,
	cvLoc,
	data,
	cvToaster
) {
	$scope.entityType = data.entityType;
	$scope.genericEntity = data.entity;
	var deferred = data.deferred;
	$scope.incrementalDataWithLogs = false;
	if (data.otherOptions.subclientTypeFlag != 0) {
		$scope.backupType = 'INCREMENTAL';
	} else {
		$scope.backupType = 'FULL';
	}

	$scope.otherOptions = data.otherOptions;

	var getBackupOption = function() {
		var backupOptions = {};
		backupOptions.incrementalDataWithLogs = $scope.incrementalDataWithLogs;
		return backupOptions;
	};

	$scope.updateFlags = function() {
		if ($scope.backupType === 'FULL' || $scope.backupType === 'SYNTHETIC_FULL') {
			$scope.incrementalDataWithLogs = false;
		}
	};

	// TODO: Move this common code to other file.
	$scope.backup = function() {
		var deferred = $q.defer();
		var backupOptions = getBackupOption();
		idaService
			.backup($scope.entityType, angular.toJson($scope.genericEntity), $scope.backupType, angular.toJson(backupOptions))
			.success(function(wr) {
				var jobIds = wr.jobIds;
				var jobSummary = {
					jobId: jobIds[0],
					percentComplete: 0,
					status: 'Starting',
					sizeOfMediaOnDisk: 0,
					totalNumOfFiles: 0,
					jobElapsedTime: 0
				};
				var job = {
					jobSummary: jobSummary,
					showProgress: true,
					kill: true,
					suspend: true,
					resume: false
				};
				$scope.backupMsg = cvLoc('notification.backup.started');
				deferred.resolve(job);
			})
			.error(function(data, status, headers, config) {
				if (data !== null && data.trim() === 'Backup in progress') {
					$scope.backupMsg = data.trim();
					deferred.reject({
						running: true,
						data: data.trim()
					});
				} else {
					$scope.backupMsg = 'Failed: ' + data.trim();
					deferred.reject({
						running: false,
						data: data.trim()
					});
				}
			});
		return deferred.promise;
	};

	$scope.goToJob = function() {
		var top = $modalStack.getTop();
		if (top) {
			$modalStack.dismiss(top.key);
			event.preventDefault();
		}
		$location.path('jobs/' + $scope.backupJobId);
	};

	$scope.startBackup = function() {
		var result = {};
		result.backupType = $scope.backupType;
		$scope.loading = true;
		$scope.backup().then(
			function(resp) {
				$scope.loading = false;
				$scope.backupJobId = resp.jobSummary.jobId;
				$scope.closeModal(resp);
				var backupMsg = cvLoc('notification.backupJob', $scope.backupJobId);
				var viewMsg = cvLoc('notification.jobDetails');
				cvToaster.showSuccessMessage({
					ttl: '7000',
					message: backupMsg + ' <br><a href=#/jobs/' + $scope.backupJobId + '>' + viewMsg + '</a>'
				});
			},
			function(resp) {
				$scope.loading = false;
				$scope.backupMsg = resp.data;
				$scope.serverMessage = {
					type: 'error',
					message: resp.data
				};
				$scope.failAndCloseModal(resp);
			}
		);
	};

	$scope.cancel = function() {
		$modalInstance.dismiss();
	};

	$scope.closeModal = function(resp) {
		deferred.resolve(resp);
		$modalInstance.dismiss();
	};

	$scope.failAndCloseModal = function(resp) {
		deferred.reject(resp);
	};
}

export default app;
