import { commonAllAgentsModule } from 'common/js/modules';
import 'modules/ida/js/services/idaService.svc.js';
import 'adminConsole/js/factories/associateSchedulePolicy.factory.js';
import 'adminConsole/js/directives/cv-entity-plan-policy-tiles.js';
import 'adminConsole/js/factories/planPolicyModel.factory.js';

let app = commonAllAgentsModule;

app.controller('oracleUpdateSubclientCtrl', [
	'$log',
	'idaService',
	'$state',
	'AppTypes',
	'cvLoc',
	'cvUtil',
	'$uibModalInstance',
	'data',
	function($log, idaService, $state, AppTypes, cvLoc, cvUtil, $modalInstance, data) {
		let self = this;
		self.entity = angular.copy(data.entity);
		self.editing = data.editing;
		self.isOracleRac = self.entity.applicationId == AppTypes.ORACLE_RAC;

		self.sizeTypes = [cvLoc('label.maximumSize'), cvLoc('label.sectionSize')];

		self.sizeModes = [cvLoc('label.MB'), cvLoc('label.GB')];

		let oracleSubclientProp = _.get(data, 'subclientDetails.oracleSubclientProp', {});
		let dataSelected = _.get(oracleSubclientProp, 'data', false);
		let selectiveFullSelected = _.get(oracleSubclientProp, 'selectiveOnlineFull', false);
		if ((_.get(data, 'subclientDetails.status', 0) & 0x40000) != 0 || (!selectiveFullSelected && !dataSelected)) {
			self.isOracleArchiveLogSubclient = true;
		}

		self.subclientInfo = {
			streams: _.get(oracleSubclientProp, 'dataThresholdStreams', 2),
			maxOpenFiles: _.get(oracleSubclientProp, 'maxOpenFiles', 3),
			archiveFiles: _.get(oracleSubclientProp, 'archiveFilesPerBFS', 32),
			dataFiles: _.get(oracleSubclientProp, 'dataFilesPerBFS', 8),
			sizeValue: 0,
			sizeType: self.sizeTypes[0],
			backupMode: self.sizeModes[0]
		};

		let sectionSizeInKB = _.get(oracleSubclientProp, 'sectionSizeInKB', 0);
		let backupSetSize = 0;
		if (sectionSizeInKB > 0) {
			self.subclientInfo.sizeType = self.sizeTypes[1];
			backupSetSize = sectionSizeInKB;
		} else {
			backupSetSize = _.get(oracleSubclientProp, 'maxBackupSetSizeInKB', 0);
		}

		if (backupSetSize > 1048576) {
			self.subclientInfo.backupMode = self.sizeModes[1];
			self.subclientInfo.sizeValue = backupSetSize / 1048576;
		} else {
			self.subclientInfo.sizeValue = backupSetSize / 1024;
		}

		let getMaxBackupSetSize = function() {
			let sizeInKbs = self.subclientInfo.sizeValue;
			let sizeIndex = 1;
			if (self.subclientInfo.backupMode === self.sizeModes[1]) {
				sizeIndex = 2;
			}
			sizeInKbs = sizeInKbs * Math.pow(1024, sizeIndex);
			return sizeInKbs;
		};

		self.updateSubclient = function() {
			self.serverMessage = {
				message: '',
				type: ''
			};

			let commonProperties = new Object();

			let subPropInfo = new Object();
			subPropInfo.commonProperties = commonProperties;

			//Oracle Option setting
			let oracleSubclientProp = new Object();

			oracleSubclientProp.dataFilesPerBFS = self.subclientInfo.dataFiles;
			oracleSubclientProp.archiveFilesPerBFS = self.subclientInfo.archiveFiles;
			oracleSubclientProp.maxOpenFiles = self.subclientInfo.maxOpenFiles;
			let sectionSizeInKB = 0;
			let maxBackupSetSizeInKB = 0;
			if (self.subclientInfo.sizeType === self.sizeTypes[1]) {
				sectionSizeInKB = getMaxBackupSetSize();
			} else {
				maxBackupSetSizeInKB = getMaxBackupSetSize();
			}
			oracleSubclientProp.sectionSizeInKB = sectionSizeInKB;
			oracleSubclientProp.maxBackupSetSizeInKB = maxBackupSetSizeInKB;
			oracleSubclientProp.dataThresholdStreams = self.subclientInfo.streams;

			subPropInfo.oracleSubclientProp = oracleSubclientProp;

			let subClientEntity = self.entity;
			let scEntity = angular.toJson(subClientEntity);
			let subInfo = angular.toJson(subPropInfo);

			let content = [];
			let serverObject = {
				subClientEntity: scEntity,
				subclientInfo: subInfo,
				content: JSON.stringify(content),
				planId: null
			};

			idaService
				.createSubclient(serverObject, self.editing)
				.success(function(data) {
					self.closeModal();
					$state.forceReload();
				})
				.error(function(e) {
					self.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		self.closeModal = function() {
			$modalInstance.close();
		};
	}
]);

export default app;
