import { commonAllAgentsModule } from 'common/js/modules';

let app = commonAllAgentsModule;

class oracleTableLevelRestoreOptions {
	constructor(
		cvLoc,
		cvUtil,
		AppTypes,
		jobService,
		dbsUtil,
		$dialogs,
		$modalInstance,
		cvToaster,
		idaService,
		$log,
		cvTableOptions,
		data
	) {
		//we give an option to restore this VM if we have a guid
		let self = this;
		self.entity = data.entity;
		self.entityType = data.entityType;
		self.selectedRows = data.selectedRows;
		self.isFullDataRestore = data.isFullDataRestore;
		self.toTime = data.toTime;
		self.fromTimeValue = data.fromTimeValue;

		self.isOracleRac = self.entity.applicationId == AppTypes.ORACLE_RAC;
		self.isTableLevelRestore = data.isTableLevelRestore;
		self.appTypes = AppTypes;

		self.restoreData = {
			destinationServerList: [],
			auxilariyInstance: true,
			spfile: false,
			database: true,
			snapRestoreType: 'true',
			pitDate: new Date(),
			pitType: '1',
			streams: 2,
			dataPump: true,
			importInstance: false
		};

		self.isPITValide = function() {
			if (
				self.restoreData.pitType == '1' &&
				(!self.restoreData.pitDate || new Date(self.restoreData.pitDate) == 'Invalid Date')
			) {
				return false;
			} else {
				return true;
			}
		};

		if (self.toTime && self.toTime > 0) {
			self.restoreData.pitType = '1';
			let dateObject = new Date(parseInt(self.toTime) * 1000);
			self.restoreData.pitDate = cvUtil.convertUTCDateToLocalDate(dateObject);
		}

		let loadJobDetails = function(jobId) {
			jobService.getJobDetail(
				{
					jobId: jobId,
					commcellId: 2
				},
				function(data) {
					let oracleJob = _.get(data, 'jobDetail.detailInfo.xmlJobInfo.bkpJobInfo.oracleJob');
					if (oracleJob) {
						self.restoreData.controlFileBackupPiece = oracleJob.controlFileBackupPiece;
						//For the Oracle RAC SCN number will be more than one, we need to get the least number for the string value
						if (self.isOracleRac && oracleJob.nextChange) {
							let lsnNumbersStr = oracleJob.nextChange.split(',');
							let lsnNumbers = [];
							lsnNumbersStr.forEach(function(lsnNumberStr) {
								if (lsnNumberStr.indexOf('-') !== -1) {
									lsnNumberStr = lsnNumberStr.substr(3, lsnNumberStr.length).trim();
								}
								lsnNumbers.push(parseInt(lsnNumberStr));
							});
							lsnNumbers = _.sortBy(lsnNumbers);
							self.restoreData.pitScn = lsnNumbers[0];
						} else {
							self.restoreData.pitScn = oracleJob.nextChange;
						}
						self.restoreData.pitType = '2';
					}
				},
				function(data) {
					$log.error('job could not be loaded for Id : ' + self.jobId);
				}
			);
		};
		if (data.jobId) {
			loadJobDetails(data.jobId);
		}

		let loadSourceDetails = function(sourceInstance) {
			idaService.getInstanceDetails(sourceInstance.instanceId).success(function(data) {
				if (data) {
					let useCatalogConnecProp = 'oracleInstance.useCatalogConnect';
					let sourceCatalogProp = 'oracleInstance.catalogConnect';
					if (self.isOracleRac) {
						useCatalogConnecProp = 'oracleRACInstance.useCatalogConnect';
						sourceCatalogProp = 'oracleRACInstance.connectString';
					}
					let useCatalogConnect = _.get(data, useCatalogConnecProp);
					if (useCatalogConnect) {
						self.sourceCatalog = _.get(data, sourceCatalogProp);
					}
				}
			});
		};
		//loadSourceDetails(self.entity);

		self.pFileResuleFunction = function(result) {
			if (result) {
				self.restoreData.pFile = result.path;
			}
		};

		self.stagingPathResuleFunction = function(result) {
			if (result) {
				self.restoreData.stagingPath = result.path;
			}
		};

		let loadDestinationServerList = function() {
			idaService
				.getRestoreDestinations(
					self.entity.clientId,
					self.entity.applicationId,
					self.entity.instanceName,
					self.entity.instanceId
				)
				.then(
					function(data) {
						let serverList = [];
						data.data.sort((a, b) => {
							return a.clientName.localeCompare(b.clientName);
						});
						for (let i = 0; i < data.data.length; i++) {
							serverList.push(data.data[i]);
							if (data.data[i].clientId == self.entity.clientId) {
								self.inplaceDestinationServer = data.data[i];
							}
						}
						self.restoreData.destinationServerList = serverList;
					},
					function(e) {
						$log.error(e);
					}
				);
		};
		loadDestinationServerList();

		self.destinationServerChanged = function(destClient) {
			// When destination is changed, server-specific options like path become invalid and must be cleared:
			//self.oraInstanceStatus = cvLoc('status.GETTINGSTATUS');
			let instanceEntity = new Object();
			instanceEntity.clientId = destClient.clientId;
			instanceEntity.applicationId = destClient.applicationId;
			instanceEntity.instanceId = 0;
			self.populateInstanceList(destClient.clientId, destClient.applicationId);
		};

		self.importServerChanged = function(destClient, event) {
			//event.preventDefault();
			self.restoreData.importInstanceList = [];
			idaService
				.getInstances(destClient.clientId, destClient.applicationId)
				.success(function(data) {
					if (data != null) {
						let instanceList = [];
						angular.forEach(data, function(instance) {
							let instanceName = instance.instance.instanceName;
							let isASM = instanceName.indexOf('+ASM') == 0 || instanceName == '-MGMTDB';
							if (!isASM && !_.get(instance, 'oracleInstance.isOnDemand', false)) {
								instanceList.push(instance.instance);
							}
						});
						self.restoreData.importInstanceList = cvUtil.sortAscending(instanceList, 'instanceName');
					}
				})
				.error(function(e) {
					self.serverMessage = {
						message: e.data,
						type: 'error'
					};
					$log.error('Error loading instances');
				});
		};

		self.shouldDisableInstance = function(instanceId) {
			return instanceId === self.entity.instanceId;
		};

		self.populateInstanceList = function(clientId, applicationId) {
			let sourceInstanceId = 0;
			self.restoreData.destinationInstanceList = [];
			idaService
				.getInstances(clientId, applicationId)
				.success(function(data) {
					if (data != null) {
						let instanceList = [];

						angular.forEach(data, function(instance) {
							let instanceName = instance.instance.instanceName;
							let isASM = instanceName.indexOf('+ASM') == 0 || instanceName == '-MGMTDB';
							if (!isASM && !_.get(instance, 'oracleInstance.isOnDemand', false)) {
								let catalogConnect = _.get(instance, 'oracleRACInstance.connectString', null);
								if (!catalogConnect) {
									catalogConnect = _.get(instance, 'oracleInstance.catalogConnect', null);
								}
								instance.instance.catalogConnect = catalogConnect;
								instance.instance.dbname = _.get(instance, 'oracleInstance.dbname');
								instanceList.push(instance.instance);
								if (instance.instance.instanceId == self.entity.instanceId) {
									instance.instance.disabled = true;
									self.inplaceDestinationInstance = instance.instance;
								}
							}
						});
						self.restoreData.destinationInstanceList = cvUtil.sortAscending(instanceList, 'instanceName');
					}
				})
				.error(function(e) {
					self.serverMessage = {
						message: e.data,
						type: 'error'
					};
					$log.error('Error loading instances');
				});
		};

		self.cancelModel = function() {
			$modalInstance.close();
		};

		let createRestoreObject = function() {
			self.pitError = false;
			if (!self.isPITValide()) {
				self.pitError = true;
				return;
			}

			let genericEntity = angular.copy(self.entity);

			let browseOption = composeBrowseOption();
			let destination = composeDestination();
			let commonOptions = composeCommonOptions();
			let agentSpecificOptions = composeAgentSpecificOptions();
			if (_.get(self.entity, 'clientId', 0) !== _.get(destination, 'destClient.clientId', 0)) {
				//If the source and destination are different set the duplicateNoFileNamecheck flag
				agentSpecificOptions.duplicateNoFileNamecheck = true;
			}
			let rdsOption = {};
			let sourceItems = getSourceItems();

			let restoreObject = {
				entityType: self.entityType,
				genericEntity: angular.toJson(genericEntity),
				browseOption: angular.toJson(browseOption),
				destination: angular.toJson(destination),
				commonOptions: angular.toJson(commonOptions),
				sourceItemsToRestore: angular.toJson(sourceItems),
				agentSpecificOptions: angular.toJson(agentSpecificOptions),
				dmOptions: undefined,
				rdsOption: undefined
			};
			return restoreObject;
		};

		self.submitRestore = function() {
			idaService
				.submitRestoreJob(createRestoreObject())
				.success(function(data) {
					dbsUtil.showRestoreToaster(data);
					self.cancelModel();
				})
				.error(function(err) {
					cvToaster.showErrorMessage({
						message: err
					});
				});
		};

		self.doRestore = function() {
			self.confirmRestore(destination, self.submitRestore);
			let sClient = self.entity.clientName;
			let sInstance = self.entity.instanceName;
			let dClient = destination.destClient.clientName;
			let dInstance = _.get(destination, 'destinationInstance.instanceName', null);
			let isInplace = true;
			let message = isInplace
				? cvLoc('label.confirmOracleRestoreInPlace', sClient, sInstance)
				: cvLoc('label.confirmOracleRestoreOutOfPlace', sClient, sInstance, dClient, dInstance, dInstance);
			$dialogs.confirm(cvLoc('label.confirm'), message, {
				yesFunction: self.submitRestore,
				noFunction: function() {}
			});
		};

		let composeCommonOptions = function() {
			let commonOptions = {};
			return commonOptions;
		};

		let composeBrowseOption = function() {
			let browseOption = {
				commCellId: 2,
				timeRange: {
					fromTimeValue: self.fromTimeValue,
					toTimeValue: self.toTime
				}
			};

			if (data.copyPrecedence) {
				angular.extend(browseOption, {
					mediaOption: {
						copyPrecedence: {
							copyPrecedenceApplicable: true,
							copyPrecedence: data.copyPrecedence
						}
					}
				});
			}

			return browseOption;
		};

		let composeDestination = function() {
			let destination = {};
			destination.destClient = {
				clientId: self.restoreData.destinationServer.clientId,
				clientName: self.restoreData.destinationServer.clientName
			};

			destination.destinationInstance = {
				instanceId: 0
			};
			/*
			 * if (!self.restoreData.auxilariyInstance) { destination.destinationInstance =
			 * self.restoreData.destinationInstance; }
			 */

			return destination;
		};

		let composeAgentSpecificOptions = function() {
			let agentSpecificOptions = {};

			agentSpecificOptions.cleanupAuxiliary = false;
			agentSpecificOptions.fileName = self.restoreData.pFile;
			agentSpecificOptions.stagingPath = self.restoreData.stagingPath;
			agentSpecificOptions.dropTable = true;
			agentSpecificOptions.auxiliaryInstance = !self.restoreData.auxilariyInstance;
			if (agentSpecificOptions.auxiliaryInstance) {
				agentSpecificOptions.databaseName = self.restoreData.destinationInstance.instanceName;
			}
			agentSpecificOptions.importToWhere = self.restoreData.importOption ? '1' : '0';
			if (agentSpecificOptions.importToWhere === '2') {
				agentSpecificOptions.importDatabase = self.restoreData.importInstanceList[0].instanceName;
				agentSpecificOptions.importDbClient = self.restoreData.importServer;
			}
			agentSpecificOptions.oracleTableRstOption = {
				additionalExportParameter: self.restoreData.exportParamValue,
				useAdditionalExportParameters: self.restoreData.exportParam,
				useDataPump: self.restoreData.dataPump
			};
			agentSpecificOptions.sourcePaths = getSourceItems();

			return agentSpecificOptions;
		};

		//This will format the list of source items,as list of strings, from selectionArray and return the same.
		let getSourceItems = function() {
			let sourceItems = [];
			angular.forEach(self.selectedRows, function(selectedItem) {
				sourceItems.push(selectedItem.pathValue + '/**');
			});
			return sourceItems;
		};
	}
}

oracleTableLevelRestoreOptions.$inject = [
	'cvLoc',
	'cvUtil',
	'AppTypes',
	'jobService',
	'dbsUtil',
	'$dialogs',
	'$uibModalInstance',
	'cvToaster',
	'idaService',
	'$log',
	'cvTableOptions',
	'data'
];
app.controller('oracleTableLevelRestoreOptionsCtrl', oracleTableLevelRestoreOptions);
