import { commonAllAgentsModule } from 'common/js/modules';

var app = commonAllAgentsModule;

app.directive('cvOracleDatafilesTable', [
	'cvLoc',
	'cvTableOptions',
	function(cvLoc, cvTableOptions) {
		return {
			restrict: 'AE',
			scope: {},
			bindToController: {
				datafiles: '=',
				entity: '=',
				storageGroup: '@'
			},
			//template: '<cv-grid cv-grid-options="datafileCtrl.gridOptions" > </cv-grid>',
			templateUrl: appUtil.appRoot + 'modules/ida/partials/redirectDatafilesTemplate.jsp',
			controllerAs: 'datafileCtrl',
			controller: [
				'cvLoc',
				'AppTypes',
				'AppTypesUtil',
				function(cvLoc, AppTypes, AppTypesUtil) {
					var self = this;
					this.$onInit = function() {
						self.showAdd = false;
						self.showDelete = true;
						self.dataFiles = self.datafiles;
						self.entity = self.entity;
						self.dataFileLabel = cvLoc('label.datafiles');
						self.errorMessage = self.storageGroup ? cvLoc('error.paths') : cvLoc('error.datafile');
						self.tooltipMessage = self.storageGroup ? cvLoc('label.deletePath') : cvLoc('label.deleteDatafile');
						self.addTooltipMessage = cvLoc('label.addDatafile');
						if (AppTypesUtil.isDB2Agent(self.entity.applicationId)) {
							self.dataFileLabel = cvLoc('label.storageGroupPaths');
							self.addTooltipMessage = cvLoc('label.addPath');
							if (self.storageGroup) {
								self.showAdd = true;
							}
						}
						self.addTableSpace = function() {
							var newDataFile = {
								dataFile: '',
								oldDataFile: ''
							};
							self.dataFiles.push(newDataFile);
						};
						self.removeTableSpace = function(dataFile) {
							dataFile.deleted = true;
							var index = self.dataFiles.indexOf(dataFile);
							self.dataFiles.splice(index, 1);
						};
					};
				}
			]
		};
	}
]);

app.directive('cvOracleTablespace', [
	'cvLoc',
	'cvTableOptions',
	function(cvLoc, cvTableOptions) {
		return {
			restrict: 'AE',
			scope: {},
			bindToController: {
				tablespaces: '=',
				entity: '='
			},
			templateUrl: appUtil.appRoot + 'modules/ida/partials/oracleRedirectTablesapceTemplate.jsp',
			controllerAs: 'tablespaceCtrl',
			controller: [
				'cvLoc',
				function(cvLoc) {
					var self = this;
					//self.tablespaceList = self.tablespaces;
				}
			]
		};
	}
]);

app.controller('oracleRestoreRedirectCtrl', [
	'$scope',
	'$log',
	'cvTableOptions',
	'cvLoc',
	'$uibModal',
	'$uibModalInstance',
	'idaService',
	'profileService',
	'data',
	function($scope, $log, cvTableOptions, cvLoc, $modal, $modalInstance, idaService, profileService, data) {
		var self = this;

		//status will store the accordion open and close states
		self.entity = data.entity;
		self.selectedRows = data.selectedRows;
		self.clientEntity = data.clientEntity;
		self.data = {
			redirectOption: 'ALL',
			redirectAllPath: '',
			isPDBInstance: false
		};
		self.data.rmanDuplicate = data.rmanDuplicate;
		if (data.redirectOption) {
			self.data.redirectOption = data.redirectOption;
		}
		self.data.redoLogs = data.redoLogs;
		self.data.onlineLogDest = data.onlineLogDest;
		if (data.redirectAllPath) {
			self.data.redirectAllPath = data.redirectAllPath;
		}
		self.dataFilesList = [];
		var dataFilesModel = {};

		var createPDBNode = function(dataFilesModel, dataFileNode) {
			var databaseNode = dataFilesModel[dataFileNode.database];
			if (!databaseNode) {
				databaseNode = {
					database: dataFileNode.database,
					tableSpace: {}
				};
				dataFilesModel[dataFileNode.database] = databaseNode;
			}
			var tableSp = createTableSpace(databaseNode.tableSpace, dataFileNode);
		};

		var createTableSpace = function(dataFilesModel, dataFileNode) {
			var tableSpaceNode = dataFilesModel[dataFileNode.tableSpace];
			if (!tableSpaceNode) {
				tableSpaceNode = {
					tableSpace: dataFileNode.tableSpace,
					datafiles: []
				};
				dataFilesModel[dataFileNode.tableSpace] = tableSpaceNode;
			}
			tableSpaceNode.datafiles.push(dataFileNode);
			return tableSpaceNode;
		};

		var isDatafileSelected = function(dataFileNode) {
			return true;
		};

		var populateData = function(data) {
			var firstNode = data[0];
			if (firstNode.database) {
				self.data.isPDBInstance = true;
			}
			self.dataFilesList = [];
			var dataFilesModel = {};
			data.forEach(function(dataFileNode) {
				if (dataFileNode.deleted) {
					return;
				}
				if (isDatafileSelected(dataFileNode)) {
					self.dataFilesList.push(dataFileNode);
					if (!dataFileNode.oldDataFile) {
						dataFileNode.oldDataFile = angular.copy(dataFileNode.dataFile);
					}
					if (self.data.isPDBInstance) {
						createPDBNode(dataFilesModel, dataFileNode);
					} else {
						createTableSpace(dataFilesModel, dataFileNode);
					}
				}
			});
			self.dataFilesModel = dataFilesModel;
			//Setting one state for the accordion
			if (firstNode.database) {
				self.dataFilesModel[firstNode.database].status = true;
				self.dataFilesModel[firstNode.database].tableSpace[firstNode.tableSpace].status = true;
			} else if (firstNode.tableSpace) {
				self.dataFilesModel[firstNode.tableSpace].status = true;
			}
		};

		var loadData = function() {
			idaService.getOracleDatafilesList(self.entity.instanceId).success(function(data) {
				if (data && data.length > 0) {
					populateData(data);
				}
			});
		};

		if (!data.dataFilesList) {
			loadData();
		} else {
			populateData(data.dataFilesList);
		}

		self.redoLogsSelected = function() {
			self.data.redoLogs = !self.data.redoLogs;
		};
		self.redoLogsPathResuleFunction = function(result) {
			if (result) {
				self.data.onlineLogDest = result.path;
			}
		};

		self.redirectAllPathResuleFunction = function(result) {
			if (result) {
				self.data.redirectAllPath = result.path;
			}
		};
		self.closeDialogBox = function(result) {
			//self.$close();
			$modalInstance.close();
		};

		self.showFinsAndReplaceDialog = function() {
			var findAndReplaceCtrl = [
				'cvLoc',
				'$uibModalInstance',
				'$dialogs',
				function(cvLoc, $modalInstance, $dialogs) {
					var self = this;
					self.data = {
						findStr: '',
						replaceStr: ''
					};

					self.closeDialogBox = function(result) {
						$modalInstance.close();
					};

					self.save = function() {
						var callBackFunctions = {
							noFunction: function() {},
							yesFunction: function() {
								$modalInstance.close(self.data);
							}
						};
						$dialogs.confirm(
							cvLoc('label.findAndReplace'),
							cvLoc('label.frConfirmation', '<b>' + self.data.findStr + '</b>', '<b>' + self.data.replaceStr + '</b>'),
							callBackFunctions
						);
					};
				}
			];
			var modelInsta = $modal.open({
				controller: findAndReplaceCtrl,
				controllerAs: 'fReplace',
				backdrop: 'static',
				templateUrl: appUtil.appRoot + 'modules/ida/partials/oracleRedirectFindAndReplace.jsp'
			});
			modelInsta.result.then(function(replaceOptions) {
				if (replaceOptions && replaceOptions.findStr && replaceOptions.replaceStr) {
					self.dataFilesList.forEach(function(dataFileNode) {
						dataFileNode.dataFile = dataFileNode.dataFile.replace(replaceOptions.findStr, replaceOptions.replaceStr);
					});
				}
			});
		};

		var isValidData = function() {
			var isValid = true;
			self.dataFilesList.forEach(function(dataFileNode) {
				if (_.isEmpty(dataFileNode.dataFile)) {
					isValid = false;
					dataFileNode.error = true;
					var firstNode = dataFileNode;
					if (firstNode.database) {
						self.dataFilesModel[firstNode.database].status = true;
						self.dataFilesModel[firstNode.database].tableSpace[firstNode.tableSpace].status = true;
					} else if (firstNode.tableSpace) {
						self.dataFilesModel[firstNode.tableSpace].status = true;
					}
				} else {
					dataFileNode.error = false;
				}
			});
			return isValid;
		};
		self.savePaths = function() {
			if (!isValidData()) {
				return;
			}
			var redirectOptions = {
				redirectAllItemsSelected: self.data.redirectOption === 'ALL' ? true : false,
				renamePathForAllTablespaces: self.data.redirectAllPath,
				dataFilesList: self.dataFilesList,
				redoLogs: self.data.redoLogs,
				onlineLogDest: self.data.onlineLogDest
			};
			$modalInstance.close(redirectOptions);
		};
		//
	}
]);

export default app;
