import { commonAllAgentsModule } from 'common/js/modules';

var app = commonAllAgentsModule;
app.controller('mySqlBackupController', [
	'$q',
	'$rootScope',
	'$location',
	'$uibModalInstance',
	'$state',
	'$log',
	'$uibModalStack',
	'idaService',
	'cvLoc',
	'data',
	'cvToaster',
	function($q, $rootScope, $location, $modalInstance, $state, $log, $modalStack, idaService, cvLoc, data, cvToaster) {
		var self = this;
		var deferred = data.deferred;

		self.entityType = data.entityType;
		self.genericEntity = data.entity;
		self.isUseBlockLevelBackup = false;
		self.dummyLog = true;
		//default
		self.backupType = 'FULL';
		self.doNotTruncateLog = true;
		self.incrementalDataWithLogs = false;
		self.isProxyEnabled = false;
		self.truncateLogsOnSource = false;
		if (data.otherOptions.subclientTypeFlag == 1) {
			self.isUseBlockLevelBackup = true;
		} else if (data.otherOptions.subclientTypeFlag == 2) {
			self.isProxyEnabled = true;
		}
		self.isCloudDB = data.otherOptions.subclientTypeFlag == 3;
		self.isMEBSelected = _.get(data, 'otherOptions.isMEBSelected', false);

		self.otherOptions = data.otherOptions;

		var getBackupOption = function() {
			var backupOptions = {};
			backupOptions.doNotTruncateLog = !self.doNotTruncateLog;
			backupOptions.truncateLogsOnSource = self.truncateLogsOnSource;
			backupOptions.backupLevel = self.backupType;
			backupOptions.incrementalDataWithLogs = self.incrementalDataWithLogs;
			backupOptions.incLevel = 1;
			return backupOptions;
		};

		self.updateFlags = function() {
			if (self.backupType === 'FULL' || self.backupType === 'SYNTHETIC_FULL') {
				self.incrementalDataWithLogs = false;
			}
		};

		self.backup = function() {
			var deferred = $q.defer();
			var backupOptions = getBackupOption();
			idaService
				.backup(self.entityType, angular.toJson(self.genericEntity), self.backupType, angular.toJson(backupOptions))
				.success(function(wr) {
					var jobIds = wr.jobIds;
					var jobSummary = {
						jobId: jobIds[0],
						percentComplete: 0,
						status: 'Starting',
						sizeOfMediaOnDisk: 0,
						totalNumOfFiles: 0,
						jobElapsedTime: 0
					};
					var job = {
						jobSummary: jobSummary,
						showProgress: true,
						kill: true,
						suspend: true,
						resume: false
					};
					self.backupMsg = cvLoc('notification.backup.started');
					deferred.resolve(job);
				})
				.error(function(data, status, headers, config) {
					if (data !== null && data.trim() === 'Backup in progress') {
						self.backupMsg = data.trim();
						deferred.reject({
							running: true,
							data: data.trim()
						});
					} else {
						self.backupMsg = 'Failed: ' + data.trim();
						deferred.reject({
							running: false,
							data: data.trim()
						});
					}
				});
			return deferred.promise;
		};

		self.goToJob = function() {
			var top = $modalStack.getTop();
			if (top) {
				$modalStack.dismiss(top.key);
				event.preventDefault();
			}
			$location.path('jobs/' + self.backupJobId);
		};

		self.startBackup = function() {
			var result = {};
			result.backupType = self.backupType;
			self.loading = true;
			self.backup().then(
				function(resp) {
					self.loading = false;
					self.backupJobId = resp.jobSummary.jobId;
					self.closeModal(resp);
					var backupMsg = cvLoc('notification.backupJob', self.backupJobId);
					var viewMsg = cvLoc('notification.jobDetails');
					cvToaster.showSuccessMessage({
						ttl: '7000',
						message: backupMsg + ' <br><a href=#/jobs/' + self.backupJobId + '>' + viewMsg + '</a>'
					});
				},
				function(resp) {
					self.loading = false;
					self.backupMsg = resp.data;
					self.serverMessage = {
						type: 'error',
						message: resp.data
					};
					self.failAndCloseModal(resp);
				}
			);
		};

		self.cancel = function() {
			$modalInstance.dismiss();
		};

		self.closeModal = function(resp) {
			deferred.resolve(resp);
			$modalInstance.dismiss();
		};

		self.failAndCloseModal = function(resp) {
			deferred.reject(resp);
		};
	}
]);

export default app;
