import { commonAllAgentsModule } from 'common/js/modules';
import 'modules/ida/js/services/idaService.svc.js';
import 'adminConsole/js/factories/associateSchedulePolicy.factory.js';
import 'adminConsole/js/directives/cv-entity-plan-policy-tiles.js';
import 'adminConsole/js/factories/planPolicyModel.factory.js';

var app = commonAllAgentsModule;

app.controller('informixCreateSubclientCtrl', [
	'$log',
	'idaService',
	'$state',
	'cvLoc',
	'cvUtil',
	'$uibModalInstance',
	'data',
	'associateSchedulePolicy',
	'planPolicyModel',
	'TREE_NODE_STATE',
	'AppTypes',
	function(
		$log,
		idaService,
		$state,
		cvLoc,
		cvUtil,
		$modalInstance,
		data,
		associateSchedulePolicy,
		planPolicyModel,
		TREE_NODE_STATE,
		AppTypes
	) {
		var self = this;
		self.entity = angular.copy(data.entity);
		self.editing = data.editing;
		self.showPlan = cv.sessionContext.showPlans;
		self.selectedcontentList = [];
		self.idaService = idaService;

		let BACKUP_MODES = {
			WHOLE_SYSTEM: 1,
			ENTIRE_INSTANCE: 2,
			SELECTIVE: 3,
			FULLLOG: 4,
			FULLANDCURRENT: 5
		};

		self.restoreModeList = [
			{
				name: cvLoc('label.entireInstance'),
				value: 2,
				enumName: 'Entire_Instance'
			},
			{
				name: cvLoc('label.wholeSystem'),
				value: 1,
				enumName: 'Whole_System'
			},
			{
				name: cvLoc('label.selective'),
				value: 3,
				enumName: 'Selective'
			},
			{
				name: cvLoc('label.fullLogicalLogs'),
				value: 4,
				enumName: 'Fulllog'
			},
			{
				name: cvLoc('label.fullCurrentLogicalLogs'),
				value: 5,
				enumName: 'FullAndCurrent'
			}
		];

		var loadContentData = function() {
			idaService
				.getSubClientContent({
					genericEntity: JSON.stringify(self.entity)
				})
				.success(function(data) {
					if (data && data.content) {
						self.selectedcontentList = data.content;
					}
					if (self.subclientInfo.backupMode === BACKUP_MODES.SELECTIVE) {
						self.toggle(self.tree);
					}
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		if (self.editing) {
			self.showPlan = true;
			let informixSubclientProp = data.subclientDetails.informixSubclientProp;
			self.subclientInfo = {
				backupMode: 2,
				incrementalLevel: informixSubclientProp.incrementalLevel,
				numberBackupStreams: informixSubclientProp.numberBackupStreams
			};
			let backupMode = _.filter(self.restoreModeList, function(mode) {
				return mode.enumName === informixSubclientProp.backupMode;
			});
			if (backupMode) {
				self.subclientInfo.backupMode = backupMode[0].value;
			}

			if (data.subclientDetails && data.subclientDetails.content) {
				self.selectedcontentList = data.subclientDetails.content;
			}
			//loadContentData();
		} else {
			self.subclientInfo = {
				selectedPlan: null,
				content: [],
				dataBackup: true,
				incrementalLevel: 1,
				logBackup: false,
				archiveDelete: false,
				backupMode: BACKUP_MODES.ENTIRE_INSTANCE,
				numberBackupStreams: 2
			};
			self.entity.subclientName = '';
			self.planPolicyModel = planPolicyModel.get('Default');
			self.planPolicyModel.plan = {
				selected: _.get(data, 'subclientDetails.planEntity', null)
			};
		}

		self.tree = {
			id: self.entity.instanceName,
			label: self.entity.instanceName,
			parent: '',
			isSelected: false,
			userObject: {},
			state: 'collapsed'
		};

		self.folderDrilledDown = function(item, event) {
			event.preventDefault();
			self.toggle(item);
			//item.state = item.state == 'expanded' ? 'collapsed' : 'expanded';
		};

		self.isParentSelected = function(item) {
			if (!item || !item.parent) {
				return false;
			}
			if (item.parent.isSelected) {
				return true;
			} else {
				return self.isParentSelected(item.parent);
			}
		};

		self.isNodeSelected = function(item) {
			if (item.isSelected) {
				return true;
			} else {
				return false;
			}
		};
		self.updateChildrenStatue = function(items, state) {
			angular.forEach(items, function(item) {
				item.isSelected = state;
				if (item.children) {
					self.updateChildrenStatue(item.children, state);
				}
			});
		};

		self.folderSelected = function(item) {
			var nodeState = false;
			if (item.isSelected == false) {
				nodeState = true;
			} else {
				nodeState = false;
			}
			item.isSelected = nodeState;
			if (item.children) {
				self.updateChildrenStatue(item.children, nodeState);
			}
			self.updateParentStatus(item.parent);
			self.expand(item);
		};

		self.updateParentStatus = function(item) {
			if (item) {
				item.isSelected = true;
				angular.forEach(item.children, function(child) {
					if (!child.isSelected) {
						item.isSelected = false;
					}
				});
				self.updateParentStatus(item.parent);
			}
		};

		/*
		 */
		self.toggle = function(item) {
			if (item.state == 'expanded') {
				item.state = 'collapsed';
			} else {
				self.expand(item);
			}
		};
		self.expand = function(item) {
			if (!item.loaded) {
				self.loadChildren(item);
			}
			item.state = 'expanded';
		};

		//Loading children for the content tree.
		self.loadChildren = function(item, refresh) {
			if (item.fileType && item.fileType == 'DBSPACE') {
				item.loaded = true;
				return;
			}
			var options = new Object();
			options['path'] = '/';
			if (refresh) {
				options['refreshData'] = true;
			} else {
				delete options['refreshData'];
			}
			idaService.getIdaBrowseData(self.entity.instanceId, 'INSTANCE_ENTITY', options).then(function(data) {
				var subItems = data.browseData; //acBrowseUtils.getBrowswItems('oracleBrowse',data.browseData);
				/*
				 * Default selection is not needed if (!self.editing && item.id === self.entity.instanceName &&
				 * subItems && subItems.length > 0) { // for the root node, in case children's present, then
				 * mark it as selected item.isSelected = true; }
				 */
				var isNodeSelected = function(nodeName) {
					if (self.selectedcontentList) {
						for (var i = 0; i < self.selectedcontentList.length; i++) {
							var tableSpace = _.get(self.selectedcontentList[i], 'informixContent.tableSpace');
							if (tableSpace === nodeName) {
								return true;
							}
						}
					}
					return false;
				};
				var parentNodeList = [];
				var parentNodeMap = {};
				angular.forEach(subItems, function(browseItem) {
					browseItem.parent = item;
					browseItem.state = 'collapsed';
					browseItem.isSelected = false;
					if (item.isSelected || isNodeSelected(browseItem.label)) {
						browseItem.isSelected = true;
					}
				});

				item.children = subItems;
				item.loaded = true;
			});
		};

		var selectedNodes = function(treeNode) {
			var selectedList = [];
			if (treeNode.isSelected === true) {
				selectedList.push(treeNode);
			} else if (treeNode.children) {
				angular.forEach(treeNode.children, function(childTreeNode) {
					if (childTreeNode.isSelected === true) {
						selectedList.push(childTreeNode);
					} else if (childTreeNode.children) {
						var childSelection = selectedNodes(childTreeNode);
						angular.forEach(childSelection, function(node) {
							selectedList.push(node);
						});
					}
				});
			}
			return selectedList;
		};

		var getSelecteNodes = function(tree) {
			var selectedList = selectedNodes(tree);
			return selectedList;
		};

		/**
		 * associate schedule policy to sub client param: (wr) subclient id
		 */
		self.associateScheduleToSubclient = function(data, showPlan) {
			if (!showPlan) {
				/* association obj */
				let subclientDetails = {
					appId: self.entity.applicationId,
					clientId: self.entity.clientId,
					subclientId: data
				};
				let schedules = self.planPolicyModel.schedulePolicy;
				if (schedules && schedules.selected) {
					associateSchedulePolicy
						.associateSchedulePolicyToSubClient(subclientDetails, schedules.selected)
						.success(function(successData) {
							$state.forceReload();
							self.closeModal();
						})
						.error(function(errorMessage) {
							self.serverMessage = {
								message: errorMessage,
								type: 'error'
							};
						});
				}
			} else {
				$state.forceReload();
				self.closeModal();
			}
		};

		self.updateSelectiveOption = function() {
			if (self.subclientInfo.backupMode === BACKUP_MODES.SELECTIVE) {
				self.toggle(self.tree);
			}
		};

		self.updateLogBackupSelection = function() {
			if (!self.subclientInfo.logBackup && self.subclientInfo.archiveDelete) {
				self.subclientInfo.archiveDelete = false;
			} else {
				self.subclientInfo.archiveDelete = true;
			}
		};

		if (self.subclientInfo.backupMode === BACKUP_MODES.SELECTIVE) {
			self.toggle(self.tree);
		}
		self.createSubclient = function() {
			if (!self.editing) {
				let showPlan = planPolicyModel.getPlanModeState();
				self.serverMessage = {
					message: '',
					type: ''
				};
				$log.log('Creating new subclient.');
				if (showPlan) {
					self.planPolicyModel.plan.showError = false;
				}
				self.planPolicyModel.storagePolicy.showError = false;
				var storageDevice = new Object();
				if (showPlan) {
					if (self.planPolicyModel.plan.selected == null) {
						self.planPolicyModel.plan.showError = true;
						return;
					}
					self.subclientInfo.selectedPlan = self.planPolicyModel.plan.selected.id;
				} else {
					if (self.planPolicyModel.storagePolicy.selected == null) {
						self.planPolicyModel.storagePolicy.showError = true;
						return;
					}
					storageDevice.dataBackupStoragePolicy = self.planPolicyModel.storagePolicy.selected.obj;
					storageDevice.logBackupStoragePolicy = self.planPolicyModel.storagePolicy.selected.obj;
				}
			}

			var commonProperties = new Object();
			commonProperties.storageDevice = storageDevice;

			var subPropInfo = new Object();
			subPropInfo.commonProperties = commonProperties;

			//DB2 Option setting
			var informixSubclientProp = new Object();
			informixSubclientProp.backupMode = self.subclientInfo.backupMode;

			if (!self.editing) {
				subPropInfo.planEntity = {
					planId: self.subclientInfo.selectedPlan
				};
				informixSubclientProp.maxBarStreams = self.subclientInfo.numberBackupStreams;
			}

			informixSubclientProp.incrementalLevel = self.subclientInfo.incrementalLevel;
			subPropInfo.informixSubclientProp = informixSubclientProp;

			if (self.subclientInfo.backupMode === BACKUP_MODES.SELECTIVE) {
				var informixContentList = [];
				self.selectedcontentList = getSelecteNodes(self.tree);
				angular.forEach(self.selectedcontentList, function(nodeData) {
					var informixContent = new Object();
					informixContent.tableSpace = nodeData.label;
					var content = new Object();
					content.informixContent = informixContent;
					informixContentList.push(content);
				});
				subPropInfo.content = informixContentList;
				subPropInfo.contentOperationType = 2;
			}

			var scEntity = angular.toJson(self.entity);
			var subInfo = angular.toJson(subPropInfo);

			var serverObject = {
				subClientEntity: scEntity,
				subclientInfo: subInfo,
				content: '',
				planId: null
			};

			self.idaService
				.createSubclient(serverObject, self.editing)
				.success(function(data) {
					//associate schedule
					self.associateScheduleToSubclient(data, self.showPlan);
				})
				.error(function(e) {
					self.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		self.closeModal = function() {
			$modalInstance.close();
		};
	}
]);

export default app;
