import 'modules/ida/js/services/idaService.svc.js';
import 'storage/js/services/storage.svc.js';

import { commonAllAgentsModule } from 'common/js/modules';

var app = commonAllAgentsModule;

app.controller('informixCreateInstanceCtrl', [
	'$state',
	'cvLoc',
	'$uibModalInstance',
	'$log',
	'data',
	'cvToaster',
	'idaService',
	'cvUtil',
	'mbService',
	'AppTypes',
	'profileService',
	function(
		$state,
		cvLoc,
		$modalInstance,
		$log,
		data,
		cvToaster,
		idaService,
		cvUtil,
		mbService,
		AppTypes,
		profileService
	) {
		var self = this;

		if (!data.editDialog) {
			data.idaEntity.appName = 'Informix';
		}

		var populateDefaultValues = function(serverInstanceInfo) {
			var instInfo = new Object();

			var commandLineStoragePolicy = new Object();
			var logBackupStoragePolicy = new Object();
			var storageDevice = new Object();

			instInfo.password = '';
			instInfo.availableStoragePolicies = {};
			instInfo.dbUserName = '';
			instInfo.dbUserPassword = '';

			instInfo.dbHome = '';
			instInfo.onConfigFile = '';
			instInfo.sqlHostfile = '';

			self.instanceEntity = data.idaEntity;
			self.instanceEntity.instanceName = '';
			self.instanceEntity.instanceId = -1;
			//Default storage policy values.

			commandLineStoragePolicy.storagePolicyId = null;
			commandLineStoragePolicy.storagePolicyName = null;

			logBackupStoragePolicy.storagePolicyId = null;
			logBackupStoragePolicy.storagePolicyName = null;

			storageDevice.commandLineStoragePolicy = commandLineStoragePolicy;
			storageDevice.logBackupStoragePolicy = logBackupStoragePolicy;
			self.storageDev = storageDevice;

			return instInfo;
		};

		var populateInstanceValues = function(serverInstanceInfo) {
			var instInfo = new Object();
			self.instanceEntity = angular.copy(serverInstanceInfo.instance);
			instInfo.dbUserName = serverInstanceInfo.informixInstance.informixUser.userName;
			if (serverInstanceInfo.informixInstance.informixUser.domainName) {
				instInfo.dbUserName = serverInstanceInfo.informixInstance.informixUser.domainName + '\\' + instInfo.dbUserName;
			}
			instInfo.dbHome = serverInstanceInfo.informixInstance.informixDir;
			instInfo.onConfigFile = serverInstanceInfo.informixInstance.onConfigFile;
			instInfo.sqlHostfile = serverInstanceInfo.informixInstance.sqlHostfile;
			self.instancePlan = serverInstanceInfo.planEntity;
			return instInfo;
		};

		self.editDialog = data.editDialog;
		if (self.editDialog && self.editDialog === 'Add_Instance') {
			self.addInstance = true;
			self.editDialog = false;
			data.idaEntity.appName = 'Informix';
			self.clientSelection = {
				selectedClients: [],
				valideClientSelection: false,
				selectionChanged: function(clientEntity) {
					if (self.instanceEntity && clientEntity && clientEntity.clientId) {
						self.instanceEntity.clientId = clientEntity.clientId;
					}
					loadClientOsType(clientEntity.clientId);
				}
			};
		}

		var loadClientOsType = function(clientId) {
			self.isUnixClient = false;
			mbService.getOSType(clientId).then(function successCallBack(response) {
				self.isUnixClient = response.data.toLowerCase() == 'unix';
			});
		};

		if (self.editDialog && self.editDialog == true) {
			self.instInfo = populateInstanceValues(data.instanceDetails);
			loadClientOsType(self.instanceEntity.clientId);
		} else {
			self.showPlanError = true;
			self.instInfo = populateDefaultValues({});
		}

		self.openAccordian1 = true;
		self.selectedProfileList = [];
		self.dbHomeResuleFunction = function(result) {
			if (result) {
				self.instInfo.dbHome = result.path;
			}
		};
		self.oncOnfigFileResuleFunction = function(result) {
			if (result) {
				let separater = '\\';
				if (self.isUnixClient) {
					separater = '/';
				}
				self.instInfo.onConfigFile = result.path.split(separater).pop();
			}
		};
		self.SqlHostsFileResuleFunction = function(result) {
			if (result) {
				self.instInfo.sqlHostfile = result.path;
			}
		};
		self.parseIStevenOutput = function() {
			if (self.selectedProfileList && self.selectedProfileList.length > 0) {
				self.showPlanError = false;
			} else {
				self.showPlanError = true;
			}
		};

		self.loadPlans = function() {
			self.profileList = [];
			profileService
				.getEligiblePlansForApp(AppTypes.INFORMIX_DATABASE)
				.success(function(data) {
					self.addServerMessage = cvUtil.emptyMsg();
					if (data.length > 0) {
						var planList = [];
						self.planListByTypes = {};
						angular.forEach(data, planData => {
							planData = planData.planSummary ? planData.planSummary : planData;
							const planObj = {
								name: planData.plan.planName,
								id: planData.plan.planId,
								type: planData.subtype,
								numAssocEntities: planData.numAssocEntities,
								numCopies: planData.numCopies,
								rpoInMinutes: planData.rpoInMinutes,
								planSummary: _.get(planData, 'plan.planSummary')
							};

							planList.push(planObj);
							if (self.planListByTypes[planObj.type]) {
								self.planListByTypes[planObj.type].push(planObj);
							} else {
								self.planListByTypes[planObj.type] = [planObj];
							}
						});
						var tempPlanList = [];
						for (var planType in self.planListByTypes) {
							tempPlanList.push({
								name: planType,
								msGroup: true
							});
							var plansByType = cvUtil.sortAscending(self.planListByTypes[planType], 'name');
							tempPlanList = tempPlanList.concat(plansByType);
							tempPlanList.push({
								msGroup: false
							});
						}
						self.profileList.push(...tempPlanList);
						if (self.editDialog && self.editDialog == true && self.instancePlan && self.instancePlan.planId) {
							let selectedPlans = self.profileList.filter(function(planNode) {
								return planNode.id == self.instancePlan.planId;
							});
							if (selectedPlans) {
								selectedPlans.forEach(function(planNode) {
									planNode.selected = true;
								});
								self.selectedProfileList.push(selectedPlans);
								self.showPlanError = false;
							}
						}
					} else {
						self.showPlan = false;
					}
				})
				.error(function(e) {
					self.serverMessage = cvUtil.errMsg(e);
				});
		};

		self.loadPlans();

		self.updateUserName = function() {
			if (self.isUnixClient) {
				self.instInfo.dbUserName = self.instanceEntity.instanceName;
			}
		};

		self.closeDialogBox = function(entity) {
			$modalInstance.close(entity);
		};

		// method to create the instance.
		self.createInstance = function() {
			var instanceEntity = self.instanceEntity;
			//In case of add instance dialog check for the client selection validation
			if (self.addInstance) {
				if (!self.clientSelection.valideClientSelection) {
					return;
				}
				if (self.clientSelection.selectedClients) {
					instanceEntity.clientName = self.clientSelection.selectedClients[0].clientName;
					instanceEntity.clientId = self.clientSelection.selectedClients[0].clientId;
				}
			}
			var instanceProperties = new Object();

			if (self.editDialog === false && (!self.selectedProfileList || self.selectedProfileList.length <= 0)) {
				return;
			}

			self.errorWindowsUser = false;
			if (!self.isUnixClient) {
				let userName = _.get(self, 'instInfo.dbUserName', '');
				if (userName.indexOf('\\') === -1 && userName.indexOf('/') === -1) {
					self.errorWindowsUser = true;
					return;
				}
			}
			self.populateInformixProps(instanceProperties);

			if (self.selectedProfileList && self.selectedProfileList.length > 0) {
				instanceProperties.planEntity = {
					planId: self.selectedProfileList[0].id
				};
			}

			idaService
				.createInstance(
					{
						instanceEntity: angular.toJson(instanceEntity),
						instanceProps: angular.toJson(instanceProperties),
						password: null,
						osUserPassword: null
					},
					self.editDialog
				)
				.success(function(data) {
					if (data != null && data.errorCode != undefined && data.errorCode != 0) {
						var msgStr = data.errorString;
						cvToaster.showErrorMessage({
							ttl: '10000', //10 sec
							message: msgStr
						});
						self.closeDialogBox(data.entity);
						if (self.editDialog) {
							$state.forceReload();
						} else {
							let instanceId = _.get(data, 'entity.instanceId');
							if (instanceId && instanceId > 0) {
								$state.go('databaseDetails', { instanceId: instanceId });
							}
						}
						return;
					}

					var msg = cvLoc('msg.createInstance');
					if (self.editDialog) {
						msg = cvLoc('msg.updateInstance');
					}

					cvToaster.showSuccessMessage({
						ttl: '15000',
						message: msg
					});

					if (self.editDialog) {
						$state.forceReload();
					}
					self.closeDialogBox(data.entity);
				})
				.error(function(e) {
					cvToaster.showErrorMessage({
						ttl: '15000',
						message: e
					});
					self.closeDialogBox();
					$state.forceReload();
				});
		};

		// Utility method to populate Informix specific values.
		self.populateInformixProps = function(instanceProperties) {
			var informixInstance = new Object();
			informixInstance.informixDir = self.instInfo.dbHome;
			informixInstance.sqlHostfile = self.instInfo.sqlHostfile;
			informixInstance.onConfigFile = self.instInfo.onConfigFile;

			var userAccount = new Object();
			var userName = self.instInfo.dbUserName;
			if (userName.indexOf('\\') != -1) {
				var userValues = userName.split('\\');
				userAccount.domainName = userValues[0];
				userAccount.userName = userValues[1];
			} else if (userName.indexOf('/') != -1) {
				var userValues = userName.split('/');
				userAccount.domainName = userValues[0];
				userAccount.userName = userValues[1];
			} else {
				userAccount.userName = userName;
			}
			if (self.instInfo.dbUserPassword) {
				userAccount.password = cvUtil.getBytes(self.instInfo.dbUserPassword);
			}

			informixInstance.informixUser = userAccount;

			informixInstance.informixStorageDevice = {
				dataBackupStoragePolicy: {
					storagePolicyId: 1
				},
				logBackupStoragePolicy: {
					storagePolicyId: 1
				},
				commandLineStoragePolicy: {
					storagePolicyId: 1
				}
			};
			instanceProperties.informixInstance = informixInstance;
		};
	}
]);

export default app;
