import 'adminConsole/js/directives/acDirectives.js';
import 'capps/js/cappsUtil.js';
import 'exchange/js/services/exchDbSubClients.svc.js';
import 'exchange/js/exchDBCommon.js';
import 'modules/ida/js/services/idas.factory.js';
import 'modules/ida/js/services/idaService.svc.js';
import 'adminConsole/js/constants/browseTypes.constant.js';
import 'adminConsole/js/services/browseForAgents.svc.js';
import 'browse/js/services/browse.svc.js';
import 'modules/ida/js/services/idaBrowse.svc.js';
import 'bigData/js/constants/distributedClusterType.constant.js';
import 'cloudStorageApp/js/factory/cloudStorageApp.factory.js';
import 'bigData/js/constants/hadoopDefaults.constant.js';
import 'storage/js/services/storage.svc.js';
import 'modules/ida/js/controllers/cloudMigrate.ctrl.js';

import { commonAllAgentsModule } from 'common/js/modules';

var browseMod = commonAllAgentsModule;

browseMod.controller('idaBrowseCtrl', [
	'storageService',
	'$scope',
	'idaService',
	'$stateParams',
	'$state',
	'AppTypes',
	'acIDABrowseUtils',
	'BrowseTypes',
	'cvLoc',
	'$log',
	'cvToaster',
	'cvBreadcrumbsTabsFactory',
	'cvTableOptions',
	'$uibModal',
	'$timeout',
	'idasFactory',
	'$filter',
	'CAPPS_CONSTANTS',
	'EX_DB_CONSTANTS',
	'cvUtil',
	'exchUtil',
	'exDbSubClientService',
	'$parse',
	'cvEscapeRegExp',
	'selectionService',
	'browseForAgentsService',
	'AppTypesUtil',
	'distributedClusterType',
	'hadoopDefaults',
	'cloudStorageAppFactory',
	'$location',
	'gitAppFactory',
	'backupSetFactory',
	'bigDataUtils',
	function(
		storageService,
		$scope,
		idaService,
		$stateParams,
		$state,
		AppTypes,
		acIDABrowseUtils,
		BrowseTypes,
		cvLoc,
		$log,
		cvToaster,
		cvBreadcrumbsTabsFactory,
		cvTableOptions,
		$uibModal,
		$timeout,
		idasFactory,
		$filter,
		CAPPS_CONSTANTS,
		EX_DB_CONSTANTS,
		cvUtil,
		exchUtil,
		exDbSubClientService,
		$parse,
		cvEscapeRegExp,
		selectionService,
		browseForAgentsBrowseService,
		AppTypesUtil,
		distributedClusterType,
		hadoopDefaults,
		cloudStorageAppFactory,
		$location,
		gitAppFactory,
		backupSetFactory,
		bigDataUtils
	) {
		//$scope.path = $stateParams["path"];

		idaService.clearSessionId();
		$scope.clusterView = $stateParams.clusterView === 'true';
		$scope.dummyModel = {
			clusterView: $scope.clusterView,
			dbsTableView: false
		};
		$scope.applicationId = parseInt($stateParams['applicationId']);
		$scope.entityType = $stateParams['entityType'];
		$scope.entityId = parseInt($stateParams['entityId']);
		$scope.jobId = $stateParams['jobId'];
		$scope.hideTree = false;
		$scope.isLiveBrowse = $stateParams['isLiveBrowse'];
		$scope.options = angular.copy($stateParams);
		$scope.isHBase = $stateParams['backupsetName'] == hadoopDefaults.hadoopApps.hbase ? true : false;
		$scope.options['showDeletedFiles'] = $stateParams['showDeletedItems'] == 'true' ? true : false;
		$scope.options['pageSize'] = 20;
		$scope.options['currentPage'] = 0;
		$scope.clusterType = $stateParams['clusterType'];
		$scope.options['sortingInfo'] = 'asc:Flags,FileName'; //Default sorting options setting
		$scope.search = {
			text: ''
		};
		if (CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE[$scope.options['cloudAppType']]) {
			$scope.options['cloudAppType'] = CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE[
				$scope.options['cloudAppType']
			].value.toString();
		}
		$scope.cloudAppType = Number.parseInt($scope.options['cloudAppType']);
		let cloudStorageAppType = !!$scope.cloudAppType
			? cloudStorageAppFactory.getGetCloudAppTypeByValue(parseInt($scope.cloudAppType)) ||
			  gitAppFactory.getGetCloudAppTypeByValue(parseInt($scope.cloudAppType))
			: '';
		$scope.isGitApp =
			!!cloudStorageAppType && _.get(cloudStorageAppType, 'value')
				? gitAppFactory.validCloudAppTypeCheck(cloudStorageAppType.value)
				: false;
		$scope.isCloudStorageApp =
			!!cloudStorageAppType && !!cloudStorageAppType.value
				? cloudStorageAppFactory.validCloudAppTypeCheck(cloudStorageAppType.value) || $scope.isGitApp
				: false;

		$scope.createRecoveryPoint = $scope.options['createRecoveryPoint'];
		$scope.restoreType = $scope.options['restoreType'];
		$scope.selectedRows = [];
		$scope.copyPrecedenceIndex = 0;
		$scope.isMigrate = $stateParams['isMigrate'] === 'true';
		let isMySQLMEBInstance = false;
		$scope.isAmazonDb =
			$scope.cloudAppType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.value ||
			$scope.cloudAppType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_RDS.value ||
			$scope.cloudAppType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DOCUMENTDB.value ||
			$scope.cloudAppType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_REDSHIFT.value;

		$scope.isAzureDb =
			$scope.cloudAppType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_TABLE_STORAGE.value ||
			$scope.cloudAppType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_COSMOS_DB_SQL_API.value;

		selectionService.clearSelection();
		if (!acIDABrowseUtils.isBrowseSupported($scope.applicationId)) {
			$log.error('Browse is not supported for this appType');
			return; //stop the flow.
		}

		if ($scope.applicationId == AppTypes.SQL_SERVER) {
			$scope.useUIGridPagination = true;
			$scope.showSearch = true;
		} else if (
			AppTypesUtil.isDB2Agent($scope.applicationId) ||
			AppTypesUtil.isOracleAgent($scope.applicationId) ||
			$scope.isAmazonDb ||
			$scope.applicationId == AppTypes.SAP_FOR_ORACLE ||
			$scope.isAzureDb
		) {
			$scope.useUIGridPagination = true;
			//NOTE: Currently multi level selection is supposed to work only when useUIGridPagination is true
			$scope.allowMultiLevelSelection = true;
			$scope.showSearch = false;

			if ($scope.applicationId == AppTypes.SAP_FOR_ORACLE) {
				$scope.useCorrectTimeStamp = true;
			}
		} else if (
			$scope.applicationId == AppTypes.MYSQL ||
			$scope.applicationId == AppTypes.POSTGRESQL ||
			$scope.applicationId == AppTypes.CV_APPTYPE_SYBASE
		) {
			$scope.useUIGridPagination = true;
		} else {
			$scope.showSearch = false;
			$scope.useUIGridPagination = false;
		}

		$scope.showCopyPrecedence =
			AppTypesUtil.isOracleAgent($scope.applicationId) ||
			$scope.applicationId == AppTypes.POSTGRESQL ||
			$scope.applicationId == AppTypes.INFORMIX_DATABASE ||
			AppTypesUtil.isDB2Agent($scope.applicationId) ||
			$scope.isAmazonDb ||
			$scope.applicationId == AppTypes.SAP_FOR_ORACLE ||
			$scope.applicationId == AppTypes.MYSQL ||
			$scope.applicationId == AppTypes.CV_APPTYPE_SYBASE ||
			$scope.isAzureDb ||
			$scope.applicationId == AppTypes.DISTRIBUTED_APPS ||
			$scope.isCloudStorageApp;

		if ($scope.isAmazonDb) {
			$scope.filterNonSnapCopies =
				$scope.cloudAppType !== CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.value;
			$scope.filterSnapCopies = $scope.cloudAppType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.value;
			$scope.useCorrectTimeStamp = true;
			$scope.singleSelect =
				$scope.cloudAppType !== CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.value && !$scope.isAzureDb;
			$scope.disableSelectAll = true;
			if ($scope.options.path) {
				const tokens = $scope.options.path.replace(']', '[').split('[');
				$scope.forRegion = tokens[1].trim();
				$scope.forTable = tokens[0].trim();
			}
		}

		if ($scope.clusterType == distributedClusterType.HADOOP) {
			$scope.showSearchModel = true;
		}

		if ($scope.clusterType == distributedClusterType.MONGODB) {
			$scope.filterSnapCopies = !$scope.clusterView;
		}

		//Filter snap copy.. Not applicable for CASSANDRA
		if ($scope.clusterType == distributedClusterType.CASSANDRA) {
			$scope.filterSnapCopies = true;
		}

		if ($scope.isAzureDb) {
			$scope.filterNonSnapCopies = false;
			$scope.filterSnapCopies = true;
			$scope.useCorrectTimeStamp = true;
			$scope.singleSelect = false;
			$scope.disableSelectAll = true;
			if ($scope.options.path) {
				const lastIndex = $scope.options.path.trim().lastIndexOf('/');
				$scope.forRegion = $scope.options.path.trim().substring(0, lastIndex);
				$scope.forTable = $scope.options.path.trim().substring(lastIndex + 1);
			}
		}

		if ($scope.isHBase) {
			$scope.hbaseNamespace = true;
		}

		$scope.initTree = function() {
			var rootPath = acIDABrowseUtils.getRootPath($scope);

			let label = $scope.entityName;
			if (($scope.isAmazonDb || $scope.isAzureDb) && $scope.forRegion) {
				rootPath = rootPath + $scope.forRegion;
				label = $scope.forRegion;
			}
			if ($scope.clusterType === distributedClusterType.MONGODB) {
				label = $scope.entity.displayName;
			}
			if ($scope.entity.applicationId == AppTypes.SAP_FOR_ORACLE) {
				label = $scope.entity.instanceName;
			}
			var pageData = new Object();
			$scope.tree = {
				id: rootPath,
				label: label,
				path: rootPath,
				pageData: pageData,
				currentPage: 0,
				state: 'collapsed'
			};

			if (
				$scope.allowMultiLevelSelection &&
				!$scope.isAmazonDb &&
				!$scope.isAzureDb &&
				!$scope.dummyModel.dbsTableView
			) {
				$scope.tree.isSelected = true;
			}

			$scope.selectedItem = $scope.tree;
			$scope.expand($scope.tree);
		};

		$scope.initCopyPrecedence = function() {
			$scope.copyPrecedenceLabel = cvLoc('label.restoreFromDefaultCopy');
			$scope.defaultCopyPrecedenceLabel = cvLoc('label.restoreFromDefaultCopy');
			$scope.copyPrecedencePrefix = cvLoc('label.restoreFrom');

			if ($scope.isMigrate) {
				$scope.copyPrecedenceLabel = cvLoc('label.migrateFromDefaultCopy');
				$scope.defaultCopyPrecedenceLabel = cvLoc('label.migrateFromDefaultCopy');
				$scope.copyPrecedencePrefix = cvLoc('label.migrateFrom');
			}
			$scope.copyPrecedenceIdLabel = cvLoc('label.copyPrecedenceId');
			storageService
				.getStoragePolicyDetailsForEntity($scope.entityType, $scope.entityId)
				.success(function(data) {
					$scope.storage = data;
					$scope.storage.copy = data.copy.filter(copy => {
						if ($scope.filterNonSnapCopies && copy.isSnapCopy === 'SET_FALSE') {
							return false;
						}
						if ($scope.filterSnapCopies && copy.isSnapCopy === 'SET_TRUE') {
							return false;
						}
						return true;
					});
				})
				.error(function(e) {
					$log.error(e);
				});

			const copyTypeMap = {
				SNAP: cvLoc('label.copyType.snap'),
				NONE: cvLoc('label.copyType.none'),
				SYNCHRONOUS: cvLoc('label.copyType.sync'),
				SELECTIVE: cvLoc('label.copyType.selective'),
				VAULT: cvLoc('label.copyType.vault'),
				MIRROR: cvLoc('label.copyType.mirror'),
				TRANSITIVE: cvLoc('label.copyType.transitive'),
				SILO: cvLoc('label.copyType.silo'),
				TAPEIMPORT: cvLoc('label.copyType.tapeImport'),
				BLOCKREPLICATION: cvLoc('label.copyType.blockReplication')
			};

			$scope.getCopyTypeInfo = function(copyType) {
				var copyTypeInfo = '';
				if (copyType) {
					var copyTypeValue = copyTypeMap[copyType];
					if (copyTypeValue) {
						copyTypeInfo = cvLoc('label.copyType') + ': ' + copyTypeValue;
					}
				}
				return copyTypeInfo;
			};

			$scope.setSelectedCopy = function(selectedCopyPrecedenceIndex, selectedCopyPrecedenceLabel) {
				$scope.copyPrecedenceIndex = selectedCopyPrecedenceIndex;
				if (selectedCopyPrecedenceIndex == 0) {
					$scope.copyPrecedenceLabel = cvLoc('label.restoreFromDefaultCopy');
					if ($scope.isMigrate) {
						$scope.copyPrecedenceLabel = cvLoc('label.migrateFromDefaultCopy');
					}
				} else {
					$scope.copyPrecedenceLabel = cvLoc('label.restoreFrom') + ' ' + selectedCopyPrecedenceLabel;
					if ($scope.isMigrate) {
						$scope.copyPrecedenceLabel = cvLoc('label.migrateFrom') + ' ' + selectedCopyPrecedenceLabel;
						$scope.selectedCopyPrecedenceLabel = selectedCopyPrecedenceLabel;
					}
				}
				$scope.initTree();
			};
		};

		if ($scope.showCopyPrecedence) {
			$scope.initCopyPrecedence();
		}

		$scope.initSearchBoxModel = function() {
			$scope.searchModel = {
				query: '',
				customClass: 'browse-search margin-bottom-20',
				fieldDefs: bigDataUtils.getSearchModel()
			};

			$scope.onSearch = function(query, fields) {
				let showDeletedFilesstatus = _.find(fields, { tag: 'showDeletedFiles:' }).model;
				query = backupSetFactory.getUpdatedQuery(query, fields);
				$state.go('bigDataBrowse', {
					applicationId: $scope.applicationId,
					entityId: $scope.entityId,
					entityType: $scope.entityType,
					path: '/',
					keywords: query,
					showDeletedItems: showDeletedFilesstatus,
					instanceId: $stateParams.instanceId,
					clusterType: $scope.clusterType
				});
			};
		};

		if ($scope.showSearchModel) {
			$scope.initSearchBoxModel();
		}
		var updateSelection = function() {
			if ($scope.allowMultiLevelSelection) {
				return;
			}
			if (
				$scope.applicationId == AppTypes.DB2 ||
				$scope.applicationId == AppTypes.DB2_On_Unix ||
				$scope.applicationId == AppTypes.DB2_MultiNode ||
				$scope.applicationId == AppTypes.INFORMIX_DATABASE ||
				isBlockPartialRestores()
			) {
				selectAllRows();
			}
		};

		function selectAllRows() {
			$timeout(function() {
				$scope.gridApi.selection.selectAllRows();
			});
		}

		//For multi level selection
		function updateChildrenAndParentStatus(item) {
			if ($scope.allowMultiLevelSelection) {
				if (item.logicalChildren) {
					updateChildrenStatue(item.logicalChildren, !!item.isSelected);
				}
				updateParentStatus(item.parent);
				$scope.selectedRows = [];

				if (
					$scope.isAmazonDb &&
					$scope.cloudAppType !== CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.value
				) {
					getAllSelectedLeafNodes($scope.tree, $scope.selectedRows);
					$scope.restoreAllowed = $scope.selectedRows.length === 1;
				} else {
					getAllSelectedItems($scope.tree, $scope.selectedRows);
					$scope.restoreAllowed = $scope.selectedRows.length > 0;
				}
			}
		}

		//For multi level selection
		function updateChildrenStatue(items, state) {
			angular.forEach(items, function(item) {
				item.isSelected = state;
				if (item.logicalChildren) {
					updateChildrenStatue(item.logicalChildren, state);
				}
			});
		}

		//For multi level selection
		function updateParentStatus(item) {
			if (item) {
				item.isSelected = true;
				angular.forEach(item.logicalChildren, function(child) {
					if (!child.isSelected) {
						item.isSelected = false;
					}
				});
				updateParentStatus(item.parent);
			}
		}

		//For multi level selection
		function getAllSelectedItems(node, selectedItemList) {
			if (node.isSelected) {
				selectedItemList.push(node);
				return;
			}
			if (node.logicalChildren) {
				for (var i = 0; i < node.logicalChildren.length; ++i) {
					getAllSelectedItems(node.logicalChildren[i], selectedItemList);
				}
			}
		}

		//For multi level selection
		function getAllSelectedLeafNodes(node, selectedItemList) {
			if (node.leafNode) {
				if (node.isSelected) {
					selectedItemList.push(node);
				}
				return;
			}
			if (node.logicalChildren) {
				for (var i = 0; i < node.logicalChildren.length; ++i) {
					getAllSelectedLeafNodes(node.logicalChildren[i], selectedItemList);
				}
			}
		}

		var isFUllDataRestore = function() {
			//For Sybase, no pagination support
			if ($scope.applicationId === AppTypes.INFORMIX_DATABASE || $scope.applicationId === AppTypes.CV_APPTYPE_SYBASE) {
				return $scope.tree.totalItems === $scope.selectedRows.length;
			}
			//For MongoDB, no pagination support
			if (
				$scope.applicationId === AppTypes.CV_APPTYPE_SGI_FS &&
				$scope.options['clusterType'] === distributedClusterType.MONGODB
			) {
				return $scope.tree.totalItems === $scope.selectedRows.length;
			}

			if (!$scope.tree || !$scope.tree.children) {
				return false;
			}

			if ($scope.allowMultiLevelSelection) {
				return $scope.tree.isSelected;
			}
			if ($scope.tree.children.length != $scope.selectedRows.length) {
				return false;
			}
			for (var int = 0; int < $scope.tree.children.length; int++) {
				if (!$scope.tree.children[int].isSelected) {
					return false;
				}
			}
			return true;
		};

		$scope.isRowSelectable = function(row) {
			if ($scope.isAmazonDb && $scope.cloudAppType !== CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.value) {
				if (!row.entity.leafNode) {
					return false;
				}
			}
			return true;
		};

		$scope.doShowRestoreDialog = function() {
			var toTime = 0;
			if ($scope.options['toTime']) {
				var localToTime = new Date($scope.options['toTime']);
				//Some idas are using incorrect timestamp and fix in the backend. To avoid regression, only fix for new idas.
				if ($scope.useCorrectTimeStamp) {
					localToTime = $scope.ConvertUTCTimeToLocalTime(localToTime);
				}
				toTime = localToTime.getTime() / 1000;
			}

			var fromTime = 0;
			if ($scope.options['fromTime']) {
				var localFromTime = new Date($scope.options['fromTime']);
				//Some idas are using incorrect timestamp and fix in the backend. To avoid regression, only fix for new idas.
				if ($scope.useCorrectTimeStamp) {
					localFromTime = $scope.ConvertUTCTimeToLocalTime(localFromTime);
				}
				fromTime = localFromTime.getTime() / 1000;
			}

			var parms = {
				entity: $scope.entity,
				entityType: $scope.entityType,
				selectedRows: $scope.selectedRows,
				//cloudAppType has to be passed to showRestoreOptions() because based on cloudAppType the jsp for popup and its controller is defined.
				cloudAppType: $scope.options['cloudAppType'],
				//clusterType has to be passed to showRestoreOptions() because based on clusterType the jsp for popup and its controller is defined.
				clusterType: $scope.options['clusterType'],
				toTime: toTime,
				fromTime: fromTime,
				toTimeValue: $scope.options['toTime'],
				fromTimeValue: $scope.options['fromTime'],
				isFullDataRestore: isFUllDataRestore(),
				restoreType: $scope.restoreType,
				createRecoveryPoint: $scope.createRecoveryPoint,
				isLiveBrowse: $scope.isLiveBrowse,
				isCloudStorageApp: $scope.isCloudStorageApp
			};

			if ($scope.jobId) {
				parms.jobId = $scope.jobId;
			}

			if ($scope.showCopyPrecedence) {
				parms.copyPrecedence = $scope.copyPrecedenceIndex;
			}
			//For MySQL/PostgreSQL Cloud Instance
			if ($scope.options.isCloudDBInstance) {
				parms.isCloudDBInstance = $scope.options.isCloudDBInstance;
			}
			if (isMySQLMEBInstance) {
				parms.isMySQLMEBInstance = isMySQLMEBInstance;
			}
			if ($scope.dummyModel.dbsTableView) {
				parms.isTableLevelRestore = true;
			}

			idasFactory.showRestoreOptions(parms);
		};

		$scope.doCloudMigrate = function() {
			const sourceItems = [];
			$scope.selectedRows.forEach(row => {
				sourceItems.push({
					name: row.userObject.name,
					path: row.userObject.path,
					displayName: row.userObject.displayName
				});
			});

			const modalInstance = $uibModal.open({
				templateUrl: appUtil.appRoot + 'modules/ida/partials/cloudMigrate.jsp',
				windowClass: 'mega-modal',
				backdrop: 'static',
				controller: 'cloudMigrateCtrl',
				controllerAs: 'ctrl',
				resolve: {
					migrateParams: function() {
						return {
							applicationId: $scope.applicationId,
							entityId: $scope.entity.instanceId,
							entityType: $scope.entityType,
							toTimeValue: $scope.options['toTime'] ? $scope.options['toTime'] : null,
							fromTimeValue: $scope.options['fromTime'] ? $scope.options['fromTime'] : null,
							sourceItems: sourceItems,
							backupsetId: $scope.entity.backupsetId,
							copyPrecedence: $scope.copyPrecedenceIndex
						};
					}
				}
			});
		};

		var addParenBreadcrumb = function(item, breadcrumbModel) {
			if (item.parent != null) {
				addParenBreadcrumb(item.parent, breadcrumbModel);
			}

			breadcrumbModel.push({
				display: item.label,
				node: item
			});
		};
		var updateBreadcrumbs = function(item) {
			$scope.breadcrumbModel = [];
			addParenBreadcrumb(item, $scope.breadcrumbModel);
		};

		var isBlockPartialRestores = function() {
			return (
				$scope.restoreType > 0 &&
				($scope.applicationId == AppTypes.POSTGRESQL || $scope.applicationId == AppTypes.MYSQL)
			);
		};

		$scope.browseData = [];
		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

		angular.extend(globalGridOptions, {
			data: 'browseData',
			useExternalPagination: !$scope.useUIGridPagination,
			paginationPageSizes: [5, 10, 15, 20, 25, 50, 100, 250, 500],
			paginationPageSize: $scope.options['pageSize'],
			multiSelect: !$scope.singleSelect,
			isRowSelectable: $scope.isRowSelectable,
			showGridFooter: true,
			enableSelectAll: !$scope.disableSelectAll,
			columnDefs: acIDABrowseUtils.getColumnDefs($scope.applicationId, $scope),
			onRegisterApi: function(gridApi) {
				$scope.gridApi = gridApi;
				gridApi.selection.on.rowSelectionChanged($scope, function(row) {
					row.entity.isSelected = row.isSelected;
					if ($scope.useUIGridPagination) {
						if (row.isSelected) {
							$scope.selectedRows.push(row.entity);
						} else {
							for (var i = 0; i < $scope.selectedRows.length; i++) {
								if ($scope.selectedRows[i].id === row.entity.id) {
									$scope.selectedRows.splice(i, 1);
									break;
								}
							}
						}
					} else {
						$scope.selectedRows = gridApi.selection.getSelectedRows();
					}

					updateChildrenAndParentStatus(row.entity);

					if (!$scope.allowMultiLevelSelection) {
						$scope.restoreAllowed = $scope.selectedRows.length > 0;
					}

					if (isBlockPartialRestores() || isMySQLMEBInstance) {
						if (row.entity.isSelected) {
							$scope.gridApi.selection.selectAllRows();
						} else {
							$scope.gridApi.selection.clearSelectedRows();
						}
					}
					if (
						$scope.applicationId == AppTypes.EXCHANGE_DATABASE &&
						$scope.createRecoveryPoint &&
						$scope.createRecoveryPoint == 1
					) {
						$scope.restoreAllowed =
							$scope.selectedRows.length == 1 && '\\' + row.entity.label != EX_DB_CONSTANTS.EXCH_DB_BROWSE_PATH_STORE;
					} else if ($scope.isAmazonDb || $scope.isAzureDb) {
						if (
							row.isSelected &&
							$scope.cloudAppType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_COSMOS_DB_SQL_API.value
						) {
							let selectedPath = _.get(row, 'entity.path', '/');
							if (selectedPath.split('/').filter(a => a.length !== 0).length == 1) {
								$scope.folderSelected(row.entity);
							}
						} else if (row.isSelected && !row.entity.leafNode) {
							$scope.folderSelected(row.entity);
						}
					}
				});
				gridApi.selection.on.rowSelectionChangedBatch($scope, function(rows) {
					$scope.selectedRows = gridApi.selection.getSelectedRows();
					if ($scope.useUIGridPagination && !$scope.allowMultiLevelSelection) {
						// Deselect all dbs manually, since there may be some dbs that are selected
						// but not visible (so they would not be part of the rows array):
						$scope.selectedItem.pageData[$scope.options.currentPage].forEach(function(data) {
							data.isSelected = false;
						});
					}
					angular.forEach(rows, function(row) {
						row.entity.isSelected = row.isSelected;
						updateChildrenAndParentStatus(row.entity);
					});
					//$scope.restoreAllowed = $scope.selectedRows.length > 0;
					if (!$scope.allowMultiLevelSelection && $scope.createRecoveryPoint != 1) {
						$scope.restoreAllowed = $scope.selectedRows.length > 0;
					}
				});

				if ($scope.useUIGridPagination) {
					// Preserve selection between searches:
					gridApi.grid.registerRowsProcessor(function(renderableRows) {
						var allRowsSelected = true;
						renderableRows.forEach(function(row) {
							row.isSelected = row.entity.isSelected;
							if (!row.isSelected) {
								allRowsSelected = false;
							}
						});
						//Select the header box to indicate everything is selected
						if ($scope.allowMultiLevelSelection && allRowsSelected) {
							selectAllRows();
						}
						return renderableRows;
					}, 600);
				} else {
					// External pagination:
					gridApi.pagination.on.paginationChanged($scope, function(newPage, pageSize) {
						var item = $scope.selectedItem;
						var currentPage = newPage - 1; //back end page numbers are starting from 0.
						var currentPageSize = $scope.options['pageSize'];
						if (currentPageSize === pageSize && item.pageData[currentPage] != null) {
							$scope.browseData = item.pageData[currentPage];
							return;
						}

						$scope.options['pageSize'] = pageSize;
						$scope.options['path'] = item.path;
						$scope.options['currentPage'] = currentPage;
						$scope.doBrowse(item, $scope.options);
					});
				}

				//Hide pagination on conditions same as cvGrid
				gridApi.core.on.rowsRendered($scope, function() {
					const dataLength = gridApi.grid.options.totalItems;
					if (dataLength <= 20 && $scope.gridOptions.paginationPageSize >= dataLength) {
						$scope.gridOptions.enablePaginationControls = false;
					} else {
						$scope.gridOptions.enablePaginationControls = true;
					}
				});
			}
		});

		$scope.gridOptions = globalGridOptions;

		$scope.errorMessageToShow = '';

		$scope.folderDrilledDown = function(item) {
			$scope.toggle(item);
		};

		$scope.showHideMongoDBCollectionColumns = function(item) {
			let sField = '';
			let sFieldToRemove = '';
			let sDisplayName = '';
			let sCellTemplate = '';

			if (item.label === $scope.entityName) {
				sField = 'userObject.advancedData.browseMetaData.mongoDBDatabaseInfo.dbName';
				sFieldToRemove = 'userObject.advancedData.browseMetaData.mongoDBCollectionInfo.collectionName';
				sDisplayName = cvLoc('header.mongoDB.database');
				// prettier-ignore
				sCellTemplate = '<a ng-if="!row.entity.leafNode" data-ng-click="grid.appScope.folderSelected(row.entity)">{{row.entity.' + sField + '}}</a>';
			} else if (item.label != $scope.entityName) {
				sField = 'userObject.advancedData.browseMetaData.mongoDBCollectionInfo.collectionName';
				sFieldToRemove = 'userObject.advancedData.browseMetaData.mongoDBDatabaseInfo.dbName';
				sDisplayName = cvLoc('header.mongoDB.collection');
				sCellTemplate = '<span class="crop">{{row.entity.' + sField + '}}</span>';
			}

			if (sField != '') {
				var sColumn = {
					field: sField,
					displayName: sDisplayName,
					cellToolTip: true,
					cellTemplate: sCellTemplate,
					enableSorting: true,
					width: '*'
				};

				if (_.findIndex($scope.gridOptions.columnDefs, { field: sField }) <= -1) {
					$scope.gridOptions.columnDefs.unshift(sColumn);
				}
				_.remove($scope.gridOptions.columnDefs, { field: 'row.entity.' + sFieldToRemove });
				_.remove($scope.gridOptions.columnDefs, { field: sFieldToRemove });
			}
		};

		$scope.folderSelected = function(item) {
			//For hadoop folder selection remove any keywords
			if ($scope.clusterType === distributedClusterType.HADOOP && $scope.options && $scope.options['keywords']) {
				$scope.options['keywords'] = undefined;
			}
			if ($scope.clusterType === distributedClusterType.HADOOP) {
				if (item.userObject && item.userObject.path) {
					item.path = item.userObject.path;
				}
			}
			if ($scope.clusterType === distributedClusterType.MONGODB) $scope.options['currentPage'] = 0;

			$scope.selectedItem = item;
			$scope.expand(item);
			//Show hide columns based on the MongodDB collection, database
			if ($scope.options['clusterType'] === distributedClusterType.MONGODB && $scope.clusterView === false) {
				$scope.showHideMongoDBCollectionColumns(item);
			}
		};
		$scope.$watch('selectedItem', function(newValue, oldValue) {
			if (newValue != oldValue) {
				//this triggers even at page initialization so this check is required
				//var currentPage = $scope.options['currentPage'];
				if (
					$scope.cloudAppType == CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.SALESFORCE.value ||
					$scope.isAmazonDb ||
					$scope.applicationId == AppTypes.EXCHANGE_DATABASE ||
					$scope.isAzureDb ||
					$scope.applicationId == AppTypes.SAP_FOR_ORACLE
				) {
					$scope.gridOptions.columnDefs = acIDABrowseUtils.getColumnDefs($scope.applicationId, $scope);
					if ($scope.applicationId == AppTypes.SAP_FOR_ORACLE) {
						newValue.currentPage = 0;
					}
				}
				var rowData = newValue.pageData[newValue.currentPage];
				if ($scope.useUIGridPagination && !$scope.allowMultiLevelSelection) {
					$scope.selectedRows = []; // Clear selection
				}
				$scope.browseData = rowData;
				$scope.gridOptions.totalItems = newValue.totalItems;
				//When the data is not there we need to update with the message
				if ($scope.applicationId == AppTypes.SAP_FOR_ORACLE && (!rowData || rowData.length === 0)) {
					if (newValue.label === 'Logs') {
						$scope.errorMessageToShow = cvLoc('error.noLogDataAvailable');
					} else {
						$scope.errorMessageToShow = cvLoc('error.noDataAvailableForChosenTimeRange');
					}
				}
				updateSelection();
				$scope.onSearchTextChange();
				updateBreadcrumbs(newValue);
			}
		});

		$scope.toggle = function(item) {
			if (item.state == 'expanded') {
				item.state = 'collapsed';
			} else {
				$scope.expand(item);
			}
		};

		$scope.expand = function(item) {
			if (!item.loaded) {
				if (item.path) {
					$scope.options['path'] = item.path;
				}

				$scope.doBrowse(item, $scope.options);
			}
			item.state = 'expanded';
		};

		$scope.loadMore = function(item) {
			//When load more is clicked, items from next page should be retrieved
			var currentPage = item.currentPage + 1;
			$scope.options['currentPage'] = currentPage;
			$scope.doBrowse(item, $scope.options);
		};

		$scope.hideLoadMore = function() {
			if (
				$scope.cloudAppType == CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.SALESFORCE.value ||
				$scope.applicationId == AppTypes.EXCHANGE_DATABASE ||
				$scope.isCassandraEntity ||
				$scope.isCloudStorageApp ||
				$scope.clusterType == distributedClusterType.HADOOP ||
				$scope.applicationId == AppTypes.SAP_FOR_ORACLE
			) {
				return true;
			}
			return false;
		};

		var filterData = function(data, applicationId, searchText) {
			if (!Array.isArray(data)) {
				return [];
			}
			if (!searchText) {
				return data.slice(0); // Return full data if no search text given
			}

			// Choose fields to search based on app type:
			var fieldGetters = [];
			if (applicationId == AppTypes.SQL_SERVER) {
				// Only sql server is currently supported by search
				fieldGetters.push($parse('userObject.databaseName'));
			} else {
				return data.slice(0); // Return full data by default
			}

			// Reduce the browseData to the data that contains a field that contains the searchText:
			var matcher = new RegExp(cvEscapeRegExp(searchText), 'i');
			var matchingData = data.filter(function(data) {
				var isMatch = fieldGetters.some(function(fieldGetter) {
					var fieldValue = fieldGetter(data);
					return matcher.test(fieldValue);
				});
				return isMatch;
			});
			return matchingData;
		};

		$scope.onSearchTextChange = function() {
			if ($scope.applicationId == AppTypes.SQL_SERVER) {
				$scope.browseData = filterData(
					$scope.selectedItem.pageData[$scope.options.currentPage],
					$scope.applicationId,
					$scope.search.text
				);
				$scope.gridOptions.totalItems = $scope.browseData.length;
				if ($scope.gridOptions.totalItems <= $scope.gridOptions.paginationPageSize) {
					// Disable pagination if the number of total items is lower than the page size
					$scope.gridOptions.enablePagination = false;
					$scope.gridOptions.enablePaginationControls = false;
				} else {
					$scope.gridOptions.enablePagination = true;
					$scope.gridOptions.enablePaginationControls = true;
				}
			}
			// Do nothing for other app types, they are not yet supported by search
		};

		$scope.clearSearch = function() {
			$scope.search.text = '';
			$scope.onSearchTextChange();
		};

		$scope.showDeletedItems = function(showDeletedItems) {
			var item = $scope.selectedItem;
			$scope.options['showDeletedFiles'] = showDeletedItems;
			$scope.options['path'] = item.path;
			$scope.deletedMenuClicked = true;
			$scope.doBrowse(item, $scope.options);
		};

		$scope.doBrowse = function(item, options) {
			$scope.errorMessageToShow = '';
			var currentPage = options['currentPage'];
			var pagingInfo = currentPage + ',' + options['pageSize'];
			options['pagingInfo'] = pagingInfo;
			if (
				($scope.useUIGridPagination &&
					($scope.cloudAppType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.value ||
						$scope.isAzureDb)) ||
				$scope.applicationId == AppTypes.SAP_FOR_ORACLE
			) {
				options['pagingInfo'] = '0,-1';
			}
			if ($scope.showCopyPrecedence) {
				options.copyPrecedence = $scope.copyPrecedenceIndex;
			}

			if ($scope.options['clusterType'] == distributedClusterType.CASSANDRA) {
				$scope.options['computeFolderSize'] = true;
			}

			if (
				($scope.applicationId == AppTypes.SAP_FOR_ORACLE && item.label != 'Logs') ||
				$scope.applicationId != AppTypes.SAP_FOR_ORACLE
			) {
				idaService.getIdaBrowseData($scope.entityId, $scope.entityType, options).then(
					function(data) {
						if (data.browseData.length === 0) {
							$scope.errorMessageToShow = cvLoc('error.noDataAvailableForChosenTimeRange');
						}
						var separator = acIDABrowseUtils.getFileSeparater($scope);

						//list of folders and files received as browse result
						//subItems is actually list of objects of type BrowseItem
						var subItems = data.browseData;

						if (subItems && subItems.length > 1 && subItems[0].sessionId) {
							idaService.sessionId = subItems[0].sessionId;
						}

						if (options.keywords && $scope.clusterType == distributedClusterType.HADOOP) {
							// If its a find query, then do not use sessionId from its response for Hadoop
							idaService.clearSessionId();
						}

						//setting parent path so that child's path can be forme as parentPath + child's Id
						var parentPath = '';
						if (item.path == separator) {
							var applicationId = options['applicationId'];

							//CloudApps clients have a prefix based on its type. Setting parent path when browsing root node with the orefix so atht subsequent paths are formed correctly
							if (applicationId == AppTypes.CLOUD_APPS) {
								var cloudAppType = options['cloudAppType'];
								var initialPath = acIDABrowseUtils.getPathPrefixForCloudApps(cloudAppType);
								parentPath = initialPath + item.path;
							} else {
								parentPath = item.path;
							}
						} else {
							parentPath = item.path + separator;
						}

						var children = [];
						//LogicalChildren includes leafnodes
						var logicalChildren = [];
						angular.forEach(subItems, function(childeItem) {
							var pageData = new Object();
							childeItem['currentPage'] = 0;
							childeItem['totalItems'] = 0;
							childeItem['pageData'] = pageData;
							childeItem['parent'] = item;
							childeItem['path'] = parentPath + childeItem.id;
							childeItem['state'] = 'collapsed';

							if ($scope.dummyModel.dbsTableView) {
								let fileType = item.fileType;
								if ($scope.applicationId == AppTypes.ORACLE) {
									if (fileType === 'TABLE') {
										childeItem.pathValue = item.pathValue + '/' + childeItem.userObject.name;
										childeItem.fileType = 'TABLESPACE';
									} else if (fileType === 'USER') {
										childeItem.fileType = 'TABLE';
										childeItem.pathValue = item.pathValue + '/' + childeItem.userObject.name;
										childeItem.leafNode = true;
									} else {
										childeItem.fileType = 'USER';
										childeItem.pathValue = '/' + $scope.entity.instanceName + '/' + childeItem.userObject.name;
									}
								}
							}

							if ($scope.isCloudStorageApp) {
								if (!childeItem.display) {
									childeItem.display = childeItem.userObject.displayName;
								}
								if (!childeItem.label) {
									childeItem.label = childeItem.userObject.displayName;
								}
							}
							if ($scope.clusterType === distributedClusterType.MONGODB && $scope.clusterView == false) {
								if (
									childeItem.userObject.advancedData.browseMetaData &&
									childeItem.userObject.advancedData.browseMetaData.mongoDBDatabaseInfo
								) {
									if (!childeItem.display) {
										childeItem.display = childeItem.userObject.advancedData.browseMetaData.mongoDBDatabaseInfo.dbName;
									}
									childeItem.label = childeItem.userObject.advancedData.browseMetaData.mongoDBDatabaseInfo.dbName;
								}
							}

							if ($scope.clusterType === distributedClusterType.SPLUNK) {
								if (
									childeItem.userObject.advancedData.browseMetaData &&
									childeItem.userObject.advancedData.browseMetaData.splunkMetadata &&
									childeItem.userObject.advancedData.browseMetaData.splunkMetadata.objectLevel === 'Item'
								) {
									childeItem['leafNode'] = true;
									var readableOldTime = $scope.formatDateForBackend(
										childeItem.userObject.advancedData.browseMetaData.splunkMetadata.splunkIndexMetadata
											.oldestRecordTime
									);
									childeItem.userObject.advancedData.browseMetaData.splunkMetadata.splunkIndexMetadata.oldestRecordTime = readableOldTime;
								}
							}

							if ($scope.isHBase && $scope.hbaseNamespace) {
								childeItem['fileType'] = 'Namespace';
							} else if ($scope.isHBase && !$scope.hbaseNamespace) {
								childeItem['fileType'] = 'Table';
								childeItem['leafNode'] = true;
							}
							//Only expandable nodes need to add the tree.
							if (!childeItem.leafNode) {
								children.push(childeItem);
							}
							logicalChildren.push(childeItem);
						});

						if ($scope.isHBase && $scope.hbaseNamespace) {
							$scope.hbaseNamespace = false;
						}
						if (item.partiallyLoaded) {
							item.children = item.children.concat(children);
						} else {
							item.children = children;
						}
						//Sorting the list
						item.children = item.children.sort((a, b) => a.label > b.label);
						if ($scope.allowMultiLevelSelection) {
							item.logicalChildren = logicalChildren;
							if (item.isSelected) {
								selectAllRows();
							}
						}
						item.loaded = true;

						var totalItems = data.totalItems;
						var curentPage = options['currentPage'];
						//For the oracle we dont have back end pagination, following code is added for UI pagination
						var pageSize = options['pageSize'];
						//				if (AppTypesUtil.isOracleAgent($scope.applicationId) && totalItems > pageSize) {
						//					var noOfPages = totalItems / pageSize;
						//					for (var int = 0; int < noOfPages; int++) {
						//						var pageData = subItems.slice(0, pageSize);
						//						subItems = subItems.slice(pageSize, totalItems);
						//						item.pageData[int] = pageData;
						//					}
						//				} else {
						item.pageData[curentPage] = subItems;
						//				}
						item.currentPage = curentPage;
						item.totalItems = totalItems;
						if ($scope.clusterType == distributedClusterType.HADOOP && $scope.options.showDeletedFiles) {
							var deletedItemStatus = {
								field: 'userObject.deleted',
								displayName: cvLoc('label.status'),
								headerTooltip: cvLoc('label.deletedItem') + ' ' + cvLoc('label.status'),
								cellToolTip: true,
								enableSorting: false,
								cellTemplate:
									'<span data-ng-show="{{row.entity.userObject.flags.deleted}}" class="glyphicon glyphicon-trash"/>',
								width: '10%'
							};
							if (_.findIndex($scope.gridOptions.columnDefs, { field: 'userObject.deleted' }) <= -1) {
								$scope.gridOptions.columnDefs.unshift(deletedItemStatus);
							}
							$scope.deletedMenuClicked = false;
							item.children = children;
						} else if ($scope.clusterType == distributedClusterType.HADOOP && !$scope.options.showDeletedFiles) {
							_.remove($scope.gridOptions.columnDefs, { field: 'userObject.deleted' });
							item.children = children;
							$scope.deletedMenuClicked = false;
						}

						$scope.onSearchTextChange();
						$scope.browseData = item.pageData[curentPage];
						$scope.gridOptions.totalItems = totalItems;

						var itemsRecieved = 0;
						angular.forEach(item.pageData, function(value, key) {
							if (!_.isUndefined(value)) {
								itemsRecieved = itemsRecieved + value.length;
							}
						});
						if (totalItems > itemsRecieved) {
							item.partiallyLoaded = true;
						} else {
							item.partiallyLoaded = false;
						}

						if (($scope.isAmazonDb || $scope.isAzureDb) && $scope.forTable) {
							let nodeToSelect = undefined;
							let nEqual = 0;
							subItems.forEach(child => {
								const compareWith =
									$scope.cloudAppType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.value ||
									$scope.isAzureDb
										? child.userObject.displayName
										: child.dbName;
								if (compareWith === $scope.forTable) {
									nodeToSelect = child;
									nEqual = nEqual + 1;
								}
							});
							if (nEqual === 1) {
								nodeToSelect.isSelected = true;
								updateChildrenAndParentStatus(nodeToSelect);
							}
						}

						//set all selected by default.
						updateSelection();
						updateBreadcrumbs(item);
						if ($scope.isMigrate) {
							if ($scope.copyPrecedenceIndex == 0) {
								$scope.copyPrecedenceLabel = cvLoc('label.migrateFromDefaultCopy');
							} else {
								$scope.copyPrecedenceLabel = cvLoc('label.migrateFrom') + ' ' + $scope.selectedCopyPrecedenceLabel;
							}
						}
					},
					function(errorMessage) {
						$scope.browseData = [];
						errorMessage = errorMessage === undefined ? cvLoc('generic_error') : errorMessage;
						$log.error(errorMessage);
						$scope.errorMessageToShow = errorMessage;
					}
				);
			}

			if ($scope.applicationId == AppTypes.SAP_FOR_ORACLE && item.label == 'Logs') {
				idaService.getIdaBrowseLogData($scope.entityId, $scope.entityType, options).then(
					function(data) {
						if (data.length === 0) {
							$scope.errorMessageToShow = cvLoc('error.noLogDataAvailable');
						}
						var separator = acIDABrowseUtils.getFileSeparater($scope);
						var parentPath = '';
						if (item.path == separator) {
							parentPath = item.path;
						} else {
							parentPath = item.path + separator;
						}

						var logicalChildrenTemp = [];
						for (var value in data) {
							var logData = data[value];
							var childItem = {};
							var pageData = new Object();
							childItem.id = logData.jobId + ':' + logData.commcellId;
							childItem.label = logData.jobId + ':' + logData.commcellId;
							childItem.leafNode = true;
							logData.xmlJobInfo = JSON.parse(logData.xmlJobInfo);
							let startTimeUTC = _.get(logData, 'xmlJobInfo.startUtc', 0);
							let formatedStartTime = '';
							if (startTimeUTC) {
								startTimeUTC = startTimeUTC - _.get(logData, 'xmlJobInfo.clockSkew', 0);
								formatedStartTime = $filter('customDateTime')(startTimeUTC);
							}
							childItem.formatedStartTime = formatedStartTime;
							let endTimeUTC = _.get(logData, 'xmlJobInfo.endUtc', 0);
							let formatedEndTime = '';
							if (endTimeUTC) {
								endTimeUTC = endTimeUTC - _.get(logData, 'xmlJobInfo.clockSkew', 0);
								formatedEndTime = $filter('customDateTime')(endTimeUTC);
							}
							let logRange = _.get(logData, 'xmlJobInfo.logRange');
							if (logRange) {
								childItem.logRange = parseInt(_.split(logRange, '-')[0]);
							}
							childItem.formatedEndTime = formatedEndTime;
							childItem.userObject = logData;
							childItem.currentPage = 0;
							childItem.totalItems = 0;
							childItem.pageData = pageData;
							childItem.parent = item;
							childItem.path = parentPath + childItem.id;
							childItem.state = 'collapsed';
							logicalChildrenTemp.push(childItem);
						}
						let logicalChildren = logicalChildrenTemp.sort(function(a, b) {
							return a.logRange > b.logRange;
						});

						if ($scope.allowMultiLevelSelection) {
							item.logicalChildren = logicalChildren;
							if (item.isSelected) {
								selectAllRows();
							}
						}
						item.loaded = true;

						var totalItems = logicalChildren.length;
						var curentPage = options['currentPage'];
						//For the sap oracle we don't have back end pagination, following code is added for UI pagination
						var pageSize = options['pageSize'];
						item.pageData[curentPage] = logicalChildren;
						item.currentPage = curentPage;
						item.totalItems = totalItems;
						$scope.onSearchTextChange();
						$scope.browseData = item.pageData[curentPage];
						$scope.gridOptions.totalItems = totalItems;

						var itemsRecieved = 0;
						angular.forEach(item.pageData, function(value, key) {
							if (!_.isUndefined(value)) {
								itemsRecieved = itemsRecieved + value.length;
							}
						});
						if (totalItems > itemsRecieved) {
							item.partiallyLoaded = true;
						} else {
							item.partiallyLoaded = false;
						}

						//set all selected by default.
						updateSelection();
						updateBreadcrumbs(item);
					},
					function(errorMessage) {
						$scope.browseData = [];
						errorMessage = errorMessage === undefined ? cvLoc('generic_error') : errorMessage;
						$log.error(errorMessage);
						$scope.errorMessageToShow = errorMessage;
					}
				);
			}
		};

		$scope.tree = {
			id: '',
			label: 'Loading...',
			state: 'collapsed'
		};

		$scope.switchDBsTableViews = function(showTableView) {
			$scope.dummyModel.dbsTableView = false;
			if (showTableView) {
				$scope.dummyModel.dbsTableView = true;
			}
			idaService.clearSessionId();
			$scope.selectedRows = [];
			$scope.restoreAllowed = false;
			$scope.databaseContentView = cvLoc('label.tablespaceView');
			if ($scope.dummyModel.dbsTableView) {
				$scope.databaseContentView = cvLoc('label.tableView');
				$scope.options['tableView'] = true;
				$scope.options['pageSize'] = 10000; //JAVA GUI is using this value
				$scope.gridOptions.columnDefs.splice(2, 0, $scope.actionColumn);
			} else {
				$scope.options['pageSize'] = 20;
				delete $scope.options['tableView'];
				$scope.gridOptions.columnDefs.splice(2, 1);
			}
			$scope.initTree();
		};

		$scope.switchMongoDBReplicasetView = function(showRepsetView) {
			// No need to refresh the page on the same view.
			if (showRepsetView === $scope.clusterView) {
				return;
			}
			$scope.clusterView = showRepsetView;
			idaService.clearSessionId();
			if ($scope.clusterView) {
				delete $scope.options['browseViewName'];
				if ($scope.removedColumns && $scope.removedColumns.length > 0) {
					$scope.gridOptions.columnDefs.splice(2, 0, $scope.removedColumns[0]);
				}
			} else {
				$scope.options['browseViewName'] = 'DBView';
				$scope.removedColumns = $scope.gridOptions.columnDefs.splice(2, 1);
			}
			$scope.initTree();
			// Do dummy state.go to update url
			$state.go('bigDataBrowse', { clusterView: $scope.clusterView }, { notify: false });
		};

		$scope.switchViews = function() {
			$scope.clusterView = !$scope.clusterView;
			idaService.clearSessionId();
			if ($scope.clusterView) {
				delete $scope.options['browseViewName'];
				if ($scope.removedColumns && $scope.removedColumns.length > 0) {
					$scope.gridOptions.columnDefs.splice(2, 0, $scope.removedColumns[0]);
				}
			} else {
				$scope.options['browseViewName'] = 'DBView';
				$scope.removedColumns = $scope.gridOptions.columnDefs.splice(2, 1);
			}
			$scope.initTree();
			// Do dummy state.go to update url
			$state.go('bigDataBrowse', { clusterView: $scope.clusterView }, { notify: false });
		};

		//Table controller section :
		/*
		 * $scope.gridOptions = { cvIsPageTitle : false, cvIsSearchable : false, cvTableName :
		 * "browseTableTemp12", cvSearchFields : [ 'fileName' ], cvGridDirectives : { 'cvPageHeight' : false,
		 * 'uiGridSelection' : true }, gridOptions : globalGridOptions, enablePaginationControls : true };
		 */

		let loadInstanceDetails = function() {
			idaService.getInstanceDetails($scope.entity.instanceId).success(function(instanceData) {
				let isMEBSelected = _.get(instanceData, 'mySqlInstance.mebSettings.enableMEB', false);
				if ($scope.applicationId === AppTypes.MYSQL && isMEBSelected) {
					isMySQLMEBInstance = true;
				}
				if (instanceData.clientAppType === 'CLOUDDB') {
					$scope.options.isCloudDBInstance = true;
				}
			});
		};

		//updateDB flags for job based browse
		let updateDbFlags = function() {
			if (
				($scope.applicationId === AppTypes.POSTGRESQL || $scope.applicationId === AppTypes.MYSQL) &&
				$scope.entityType == 'SUBCLIENT_ENTITY' &&
				$scope.jobId
			) {
				if ($scope.entityId && $scope.restoreType === undefined) {
					$scope.restoreType = 0; //default value
					//Load Subclient details to set restore type flag
					idaService.getSubClientDetails($scope.entityId).success(function(subclientData) {
						if ($scope.applicationId == AppTypes.POSTGRESQL) {
							$scope.restoreType = _.get(subclientData, 'postgreSQLSubclientProp.subclientTypeFlag', 0);
						} else if ($scope.applicationId == AppTypes.MYSQL) {
							if (_.get(subclientData, 'commonProperties.snapCopyInfo.isSnapBackupEnabled', false)) {
								$scope.restoreType = 1;
							}
						}
					});
				}
				if ($scope.entity && $scope.entity.instanceId && $scope.options.isCloudDBInstance === undefined) {
					$scope.options.isCloudDBInstance = false; //default value
					//Load instance details to check cloud DB instance
					loadInstanceDetails();
				}
			}
		};

		idaService
			.getNodeEntity($scope.entityType, parseInt($scope.entityId))
			.success(function(data) {
				$scope.entity = data;

				if ($scope.entityType == 'INSTANCE_ENTITY') {
					$scope.entityName = $scope.entity.instanceName;
				} else if ($scope.entityType == 'BACKUPSET_ENTITY') {
					if (AppTypesUtil.isDB2Agent($scope.applicationId)) {
						$scope.entityName = $scope.entity.instanceName + '/' + $scope.entity.backupsetName;
					} else {
						$scope.entityName = $scope.entity.backupsetName;
					}
				} else if ($scope.cloudAppType == CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.SALESFORCE.value) {
					$scope.entityName = $scope.entity.backupsetName;
				} else {
					$scope.entityName = $scope.entity.subclientName;
				}

				if ($scope.cloudAppType == CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_RDS.value) {
					browseForAgentsBrowseService.entity = $scope.entity;
				}
				/*
				 * if ($scope.applicationId == AppTypes.ORACLE) { $scope.showDBsTableViewToggle = true;
				 * $scope.databaseContentView = cvLoc('label.tablespaceView'); }
				 */
				var breadCrumbsParams = {};
				//add appId for all the apps. use this manipulate the urls later on.
				breadCrumbsParams.appId = $scope.applicationId;
				if ($scope.applicationId == AppTypes.CLOUD_APPS) {
					breadCrumbsParams.cloudAppType = $scope.options['cloudAppType'];
					if ($scope.isCloudStorageApp) {
						breadCrumbsParams.isCloudStorageApp = $scope.isCloudStorageApp;
					}
				}
				//Adding cluster type for Distributed apps
				if ($scope.applicationId == AppTypes.DISTRIBUTED_APPS) {
					breadCrumbsParams.clusterType = $scope.clusterType;
				}
				breadCrumbsParams.isGitApp = $scope.isGitApp;
				var breadCrumbs = acIDABrowseUtils.loadBreadCrumbs($scope.entity, $scope.entityType, breadCrumbsParams);
				cvBreadcrumbsTabsFactory.clearBc();
				cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);

				updateDbFlags();
				if ($scope.applicationId === AppTypes.MYSQL) {
					loadInstanceDetails();
				}

				if (
					($scope.entityType == 'INSTANCE_ENTITY' || $scope.entityType == 'SUBCLIENT_ENTITY') &&
					$scope.applicationId == AppTypes.DISTRIBUTED_APPS
				) {
					Promise.all([
						idaService.getClientProps($scope.entity.clientId),
						idaService.getInstanceDetails(_.get($scope.entity, 'instanceId', $scope.entityId))
					])
						.then(results => {
							$scope.clientProps = results[0].data;
							if (
								_.get(results[1].data, 'distributedClusterInstance.clusterType') == distributedClusterType.CASSANDRA
							) {
								$scope.isCassandraEntity = true;
								$scope.showClusterViewToggle = true;
								$scope.clusterViewHelpText = cvLoc('helpText.clusterView');
								$scope.options['clusterType'] = distributedClusterType.CASSANDRA;
								if (!$scope.clusterView) {
									let sizeCol = _.findIndex($scope.gridOptions.columnDefs, { field: 'userObject.size' });
									if (sizeCol > -1) {
										$scope.removedColumns = $scope.gridOptions.columnDefs.splice(sizeCol, 1);
									}
									$scope.options['browseViewName'] = 'DBView';
								}
							} else if (
								_.get(results[1].data, 'distributedClusterInstance.clusterType') == distributedClusterType.SPLUNK
							) {
								$scope.options['browseViewName'] = 'DBView';
								$scope.options['clusterType'] = distributedClusterType.SPLUNK;
							} else if (
								_.get(results[1].data, 'distributedClusterInstance.clusterType') == distributedClusterType.MONGODB
							) {
								$scope.showMongoDBClusterViewToggle = true;
								$scope.options['browseViewName'] = 'SHARDView';
								$scope.options['clusterType'] = distributedClusterType.MONGODB;
								if (!$scope.clusterView) {
									$scope.replicaSetView = cvLoc('label.browseFilter.restoreCollections');
									$scope.options['browseViewName'] = 'DBView';
								} else {
									$scope.replicaSetView = cvLoc('label.browseFilter.restorecluster');
								}
							}

							$scope.initTree();
							$scope.breadcrumbModel = [];
						})
						.catch(error => {
							cvToaster.showErrorMessageWrapper(error);
						});
				} else {
					idaService
						.getClientProps($scope.entity.clientId)
						.success(function(data) {
							$scope.clientProps = data;

							$scope.initTree();

							$scope.breadcrumbModel = [];
						})
						.error(function() {
							cvToaster.showErrorMessage({
								ttl: '5000', //5 sec
								message: cvLoc('generic_error')
							});
						});
				}
			})
			.error(function() {
				cvToaster.showErrorMessage({
					ttl: '5000', //5 sec
					message: cvLoc('generic_error')
				});
			});

		$scope.showFromTimeSelection = function() {
			if (
				AppTypesUtil.isDB2Agent($scope.applicationId) ||
				AppTypesUtil.isOracleAgent($scope.applicationId) ||
				$scope.applicationId == AppTypes.MYSQL ||
				$scope.applicationId == AppTypes.CV_APPTYPE_SYBASE ||
				$scope.applicationId == AppTypes.POSTGRESQL ||
				$scope.isHBase
			) {
				return false;
			}
			return true;
		};
		//Time range options logic
		$scope.resultFunction = function(result) {
			idaService.clearSessionId();
			if (result != null) {
				var fromDateString = result.fromDateString;
				if (fromDateString != null) {
					fromDateString = $scope.formatDateForBackend(fromDateString);
					$scope.options['fromTime'] = fromDateString;
					$location.search('fromTime', fromDateString);
				} else {
					$scope.options['fromTime'] = null;
					$location.search('fromTime', null);
				}
				var toDateString = result.toDateString;
				if (toDateString != null) {
					toDateString = $scope.formatDateForBackend(toDateString);
					$scope.options['toTime'] = toDateString;
					$location.search('toTime', toDateString);
				} else {
					$scope.options['toTime'] = null;
					$location.search('toTime', null);
				}
				$scope.initTree();
				//Conversion of the UTC date to browser specific date
				var tempToDate = null;
				var tempFromDate = null;
				if (result.toDateString) {
					tempToDate = $scope.ConvertUTCTimeToLocalTime(result.toDateString);
				}
				if (result.fromDateString) {
					tempFromDate = $scope.ConvertUTCTimeToLocalTime(result.fromDateString);
				}
				$scope.updateTimeRangeLabel(tempFromDate, tempToDate);
			}
		};

		$scope.ConvertUTCTimeToLocalTime = function(UTCDate) {
			// var now = new Date();
			var convertdLocalTime = new Date(UTCDate.getTime() - UTCDate.getTimezoneOffset() * 60000);
			return convertdLocalTime;
		};

		$scope.formatDateForBackend = function(toUtcDate) {
			//return cvUtil.formatDate(toUtcDate,'yyyy-MM-ddTHH:mm:ss',null);
			return $filter('date')(toUtcDate, 'yyyy-MM-ddTHH:mm:ss');
		};

		$scope.formatDate = function(dt) {
			var utcDate = $filter('date')(dt * 1000, 'MM-dd-yyyy');
			return new Date(utcDate).toLocaleDateString();
		};

		$scope.getUserDisplayableDate = function(dt) {
			if (!dt) {
				return '';
			}
			var d = null;
			if (typeof dt === 'string') {
				d = new Date(dt + 'Z');
			} else {
				d = dt;
			}
			//return cvUtil.formatDate(dt, 'yyyy-MM-dd HH:mm:ss', null);
			return $filter('date')(d, 'yyyy-MM-dd HH:mm:ss');
		};

		$scope.updateTimeRangeLabel = function(fromTime, toTime) {
			if (fromTime) {
				$scope.timeRangeLabel = cvLoc(
					'Showing_backups_range',
					$scope.getUserDisplayableDate(fromTime),
					$scope.getUserDisplayableDate(toTime)
				);
			} else if (toTime) {
				$scope.timeRangeLabel = cvLoc('Showing_backups_asof', $scope.getUserDisplayableDate(toTime));
			} else {
				$scope.timeRangeLabel = cvLoc('Showing_latest_backups');
			}
		};

		$scope.updateTimeRangeLabel($scope.options['fromTime'], $scope.options['toTime']);

		let updateRowSelection = function(rowTable, selection) {
			if (selection) {
				$scope.gridApi.selection.selectRow(rowTable);
			} else {
				$scope.gridApi.selection.unSelectRow(rowTable);
			}
		};

		let updateTableSelection = function(selectedNode, refTable, selection, recursively) {
			let depTabAttr = refTable ? 'oraDepTables.refTables' : 'oraDepTables.depTables';
			let depTables = _.get(selectedNode, depTabAttr, []);
			if (depTables && depTables.length > 0) {
				updateRowSelection(selectedNode, selection);
			}
			depTables.forEach(dTable => {
				let allTables = _.get(selectedNode, 'parent.logicalChildren', []);
				allTables.forEach(mainTable => {
					if (dTable.tableName === mainTable.id) {
						mainTable.isSelected = selection;
						updateRowSelection(mainTable, selection);
						if (recursively) {
							updateTableSelection(mainTable, refTable, selection, recursively);
						}
					}
				});
			});
		};

		$scope.updateDependentSelection = function(selectedNode, selection, recursively) {
			let oraDepTables = selectedNode.oraDepTables;
			if (oraDepTables) {
				updateTableSelection(selectedNode, true, selection, recursively);
			}
		};

		$scope.updateReferencedSelection = function(selectedNode, selection, recursively) {
			let oraDepTables = selectedNode.oraDepTables;
			if (oraDepTables) {
				updateTableSelection(selectedNode, false, selection, recursively);
			}
		};
	}
]);

browseMod.factory('acIDABrowseUtils', [
	'AppTypes',
	'$log',
	'cvLoc',
	'BrowseTypes',
	'AppTypesUtil',
	'CAPPS_CONSTANTS',
	'cappsUtil',
	'EX_DB_CONSTANTS',
	'exchUtil',
	'distributedClusterType',
	function acIDABrowseUtils(
		AppTypes,
		$log,
		cvLoc,
		BrowseTypes,
		AppTypesUtil,
		CAPPS_CONSTANTS,
		cappsUtil,
		EX_DB_CONSTANTS,
		exchUtil,
		distributedClusterType
	) {
		acIDABrowseUtils.isBrowseSupported = function(applicationId) {
			//applicationId can be int or string. parseInt will handle that internally.
			if (applicationId === undefined) {
				$log.error('Missing applicationId.');
				return false;
			}
			switch (parseInt(applicationId)) {
				case AppTypes.SQL_SERVER:
				case AppTypes.WINDOWS_FILESYSTEM:
				case AppTypes.MAC_FILESYSTEM:
				case AppTypes.UNIX_FILESYSTEM:
				case AppTypes.ORACLE:
				case AppTypes.SAP_FOR_ORACLE:
				case AppTypes.ORACLE_RAC:
				case AppTypes.DB2:
				case AppTypes.DB2_On_Unix:
				case AppTypes.CLOUD_APPS:
				case AppTypes.EXCHANGE_DATABASE:
				case AppTypes.POSTGRESQL:
				case AppTypes.MYSQL:
				case AppTypes.CV_APPTYPE_SYBASE:
				case AppTypes.NAS:
				case AppTypes.DISTRIBUTED_APPS:
				case AppTypes.INFORMIX_DATABASE:
				case AppTypes.DB2_MultiNode:
					return true;
					/*
					 * case AppTypes.SAP_HANA: browseType = BrowseTypes.SAPHANA_BROWSE;
					 */
					break;
				default:
					$log.warn('Invalid applicationId or not implemented yet.AppId=' + applicationId);
			}
			return false;
		};

		acIDABrowseUtils.loadBreadCrumbs = function(entity, entityType, params) {
			var breadCrumbs = [];
			var appType = '';
			const isAmazonDb =
				Number.parseInt(params.cloudAppType) === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.value ||
				Number.parseInt(params.cloudAppType) === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_RDS.value ||
				Number.parseInt(params.cloudAppType) === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_REDSHIFT.value ||
				Number.parseInt(params.cloudAppType) === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DOCUMENTDB.value;

			const isAzureDb =
				Number.parseInt(params.cloudAppType) === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_TABLE_STORAGE.value;

			if (params.appId == AppTypes.CLOUD_APPS && !isAmazonDb && !isAzureDb) {
				appType = 'capps';
			} else if (params.appId == AppTypes.EXCHANGE_DATABASE) {
				appType = 'exchange';
			} else if (AppTypesUtil.isDBAgent(params.appId) || isAmazonDb || isAzureDb) {
				appType = 'dbs';
			} else if (params.appId == AppTypes.DISTRIBUTED_APPS) {
				appType = 'bigData';
			} else if (
				params.appId == AppTypes.NAS ||
				params.appId == AppTypes.WINDOWS_FILESYSTEM ||
				params.appId == AppTypes.UNIX_FILESYSTEM
			) {
				appType = 'nas';
			}

			var switchEntityType = appType + '_' + entityType;
			switch (switchEntityType) {
				case 'dbs_INSTANCE_ENTITY':
					var instanceNode = {
						title: cvLoc('label.instance'),
						link: '#instances'
					};

					var dbDetails = {
						title: entity.instanceName,
						link: '#databaseDetails' + '/' + entity.instanceId
					};
					breadCrumbs.push(instanceNode);
					breadCrumbs.push(dbDetails);
					break;
				case 'capps_INSTANCE_ENTITY':
					if (params.isCloudStorageApp) {
						let app = {};
						let clientNode = {};
						if (params.isGitApp) {
							appsNode = {
								title: cvLoc('label.gitapps'),
								link: '#/cappsClients'
							};
							clientNode = {
								title: entity.instanceName,
								link: '#/gitAppsAccountDetails/' + entity.instanceId
							};
						} else {
							appsNode = {
								title: cvLoc('pageHeader.cloudStorage'),
								link: '#/cloudStorageAccounts'
							};
							clientNode = {
								title: entity.instanceName,
								link: '#/cloudStorageAccountDetails/' + entity.instanceId
							};
						}
						breadCrumbs.push(appsNode);
						breadCrumbs.push(clientNode);
					}
					break;
				case 'bigData_INSTANCE_ENTITY':
					var bigData = {
						title: cvLoc('label.nav.bigDataApps'),
						link: '#/bigDataApps'
					};
					var instanceDetails = {
						title: entity.clientName,
						link: '#/bigDataInstanceDetails/' + entity.clientId + '/' + entity.instanceId
					};
					breadCrumbs.push(bigData);
					breadCrumbs.push(instanceDetails);
					break;
				case 'bigData_SUBCLIENT_ENTITY':
					var bigData = {
						title: cvLoc('label.nav.bigDataApps'),
						link: '#/bigDataApps'
					};
					var instanceDetails = {
						title: entity.clientName,
						link: '#/bigDataInstanceDetails/' + entity.clientId + '/' + entity.instanceId
					};
					var subclientDetails = {
						title: entity.subclientName,
						link: '#/bigDataSubclientDetails/' + entity.subclientId
					};
					breadCrumbs.push(bigData);
					breadCrumbs.push(instanceDetails);

					if (params.clusterType === distributedClusterType.HADOOP) {
						var backupsetDetails = {
							title: entity.backupsetName,
							link:
								'#/bigDataBackupsetDetails/' +
								entity.backupsetId +
								'?clientId=' +
								entity.clientId +
								'&instanceId=' +
								entity.instanceId
						};
						breadCrumbs.push(backupsetDetails);
					}
					breadCrumbs.push(subclientDetails);
					break;
				case 'dbs_BACKUPSET_ENTITY':
					var instanceNode = {
						title: cvLoc('label.instance'),
						link: '#instances'
					};

					var dbDetails = {
						title: entity.instanceName,
						link: '#databaseDetails' + '/' + entity.instanceId
					};

					var dbBackupsetDetails = {
						title: entity.backupsetName,
						link: '#dbBackupsetDetails' + '/' + entity.backupsetId
					};

					breadCrumbs.push(instanceNode);
					breadCrumbs.push(dbDetails);
					breadCrumbs.push(dbBackupsetDetails);
					break;

				case 'dbs_SUBCLIENT_ENTITY':
				case 'postgres_SUBCLIENT_ENTITY':
					var instanceNode = {
						title: cvLoc('label.instance'),
						link: '#instances'
					};
					breadCrumbs.push(instanceNode);
					breadCrumbs.push({
						title: entity.instanceName,
						link: '#databaseDetails/' + entity.instanceId
					});

					if (
						params.appId != AppTypes.MYSQL &&
						params.appId != AppTypes.CV_APPTYPE_SYBASE &&
						params.appId != AppTypes.SAP_FOR_ORACLE &&
						params.appId != AppTypes.CLOUD_APPS
					) {
						breadCrumbs.push({
							title: entity.backupsetName,
							link: '#dbBackupsetDetails/' + entity.backupsetId
						});
					}

					breadCrumbs.push({
						title: entity.subclientName,
						link: '#dbCollectionDetails/' + entity.subclientId
					});

					break;

				case 'capps_SUBCLIENT_ENTITY':
					var cloudAppType = params.cloudAppType;
					var appsNode = {
						//title : cvLoc('label.accounts'),
						//link : '#/cappsClients'
						title: cvLoc('All_Clients'),
						link: '#clientGroupDetails/'
					};
					var clientNode = {
						title: entity.clientName,
						link: '#/' + cloudAppType + '/' + entity.clientId
					};

					var subclientNode = {
						title: entity.subclientName,
						link: '#/' + cloudAppType + '/' + entity.clientId + '/' + entity.subclientId + '/' + entity.clientName
					};

					if (params.isCloudStorageApp) {
						if (params.isGitApp) {
							appsNode = {
								title: cvLoc('label.gitapps'),
								link: '#/cappsClients'
							};
							clientNode = {
								title: entity.instanceName,
								link: '#/gitAppsAccountDetails/' + entity.instanceId
							};
							subclientNode = {
								title: entity.subclientName,
								link: '#/gitAppsSubClientDetails/' + entity.subclientId
							};
						} else {
							appsNode = {
								title: cvLoc('pageHeader.cloudStorage'),
								link: '#/cloudStorageAccounts'
							};
							clientNode = {
								title: entity.instanceName,
								link: '#/cloudStorageAccountDetails/' + entity.instanceId
							};
							subclientNode = {
								title: entity.subclientName,
								link: '#/contentGroupDetails/' + entity.subclientId
							};
						}
					}
					breadCrumbs.push(appsNode);
					breadCrumbs.push(clientNode);
					breadCrumbs.push(subclientNode);
					break;

				case 'exchange_SUBCLIENT_ENTITY':
					exchUtil.setBreadCrumbs('', entity);
					breadCrumbs = [];
					break;

				case 'nas_SUBCLIENT_ENTITY':
					breadCrumbs.push({
						title: entity.clientName,
						link: '#nasClientDetails/' + entity.clientId
					});
					breadCrumbs.push({
						title: entity.subclientName,
						link: '#fsSubclientDetails/' + entity.subclientId
					});

					break;
			}

			if (params.cloudAppType == CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.SALESFORCE.value) {
				cappsUtil.setBreadCrumbsSF(entity);
				breadCrumbs = [];
			}

			return breadCrumbs;
		};

		acIDABrowseUtils.getColumnDefs = function(applicationId, pScope) {
			var columnDefs = [];
			switch (parseInt(applicationId)) {
				case AppTypes.SQL_SERVER:
					var databaseNameColumn = {
						field: 'userObject.databaseName',
						displayName: cvLoc('label.DatabaseName'),
						cellTemplate:
							'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.userObject.databaseName" title="{{row.entity.userObject.databaseName}}"></div>',
						width: '55%'
					};
					var versionColumn = {
						field: 'userObject.version',
						displayName: cvLoc('header.Version'),
						cellTemplate:
							'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.userObject.version" title="{{row.entity.userObject.version}}"></div>',
						width: '40%'
					};
					columnDefs.push(databaseNameColumn);
					columnDefs.push(versionColumn);
					break;
				case AppTypes.DB2:
				case AppTypes.DB2_On_Unix:
				case AppTypes.DB2_MultiNode:
					var fileNameColumn = {
						field: 'label',
						displayName: cvLoc('Name'),
						cellTemplate:
							'<a ng-hide="row.entity.leafNode" data-ng-click="grid.appScope.folderSelected(row.entity)">{{row.entity.label}}</a>' +
							'<span ng-show="row.entity.leafNode">{{row.entity.label}}</span>',
						width: '55%'
					};
					var fileTypeColumn = {
						field: 'fileType',
						displayName: cvLoc('header.type'),
						cellTemplate: '<div><span>{{row.entity.fileType}}</span></div>',
						width: '40%'
					};
					columnDefs.push(fileNameColumn);
					columnDefs.push(fileTypeColumn);
					break;
				case AppTypes.ORACLE_RAC:
				case AppTypes.ORACLE:
				case AppTypes.INFORMIX_DATABASE:
					var fileNameColumn = {
						field: 'label',
						displayName: cvLoc('Name'),
						cellTemplate:
							'<a ng-hide="row.entity.leafNode" data-ng-click="grid.appScope.folderSelected(row.entity)">{{row.entity.label}}</a>' +
							'<span ng-show="row.entity.leafNode">{{row.entity.label}}</span>',
						//cellTemplate : '<div><span> {{row.entity.fileName}}</span></div>',
						width: '55%'
					};
					var fileTypeColumn = {
						field: 'fileType',
						displayName: cvLoc('header.type'),
						cellTemplate: '<div><span>{{row.entity.fileType}}</span></div>',
						width: '30%'
					};
					columnDefs.push(fileNameColumn);
					columnDefs.push(fileTypeColumn);

					var actionColumn = {
						field: 'action',
						displayName: cvLoc('header.actions'),
						cellTemplate:
							'<div class="btn-group cv-permitted-actions" uib-dropdown dropdown-append-to-body>' +
							' <a href class="uib-dropdown-toggle" uib-dropdown-toggle >' +
							' 	<span class="grid-action-icon"></span>' +
							' </a>' +
							' <ul uib-dropdown-menu class="dropdown-menu cv-dropdown-style-2 cv-permitted-actions-append-to-body dropdown-menu-right" role="menu">' +
							' 		<li >' +
							' 			<a data-ng-click="grid.appScope.updateDependentSelection(row.entity,true,false)">' +
							cvLoc('label.selectAllDependentTables') +
							' </a>' +
							' 		</li>' +
							' 		<li >' +
							' 			<a data-ng-click="grid.appScope.updateDependentSelection(row.entity,false,true)">' +
							cvLoc('label.deselectAllDependentTables') +
							'  </a>' +
							' 		</li>' +
							' 		<li >' +
							' 			<a data-ng-click="grid.appScope.updateDependentSelection(row.entity,true,true)">' +
							cvLoc('label.selectAllDependentTablesRec') +
							'</a>' +
							' 		</li>' +
							' 		<li >' +
							' 			<a data-ng-click="grid.appScope.updateReferencedSelection(row.entity,true,false)">' +
							cvLoc('label.selectAllReferencedTables') +
							'</a>' +
							' 		</li>' +
							' 		<li >' +
							' 			<a data-ng-click="grid.appScope.updateReferencedSelection(row.entity,false,true)">' +
							cvLoc('label.deselectAllReferencedTables') +
							'</a>' +
							' 		</li>' +
							' 		<li >' +
							' 			<a data-ng-click="grid.appScope.updateReferencedSelection(row.entity,true,true)">' +
							cvLoc('label.selectAllReferencedRecTables') +
							'</a>' +
							' 		</li>' +
							'	</ul>' +
							'</div>',
						width: '*'
					};
					pScope.actionColumn = actionColumn;
					//columnDefs.push(actionColumn);
					break;
				case AppTypes.SAP_FOR_ORACLE:
					const isRoot = !pScope.selectedItem || !pScope.selectedItem.parent;
					const isTableSpace = _.get(pScope, 'selectedItem.parent.id') === 'Tablespace';
					const sapFileNameColumn = {
						field: 'label',
						displayName: isTableSpace ? cvLoc('label.ID') : cvLoc('Name'),
						cellTemplate:
							'<a ng-hide="row.entity.leafNode" data-ng-click="grid.appScope.folderSelected(row.entity)">{{row.entity.label}}</a>' +
							'<div class="ellipsis-parent ellipsis-content" title="{{row.entity.label}}" ng-show="row.entity.leafNode"><span >{{row.entity.label}}</span></div>',
						width: isTableSpace ? '10%' : '55%'
					};
					const sapFileTypeColumn = {
						field: 'fileType',
						displayName: cvLoc('header.type'),
						cellTemplate:
							'<div class="ellipsis-parent ellipsis-content" title="{{row.entity.fileType}}"><span>{{row.entity.fileType}}</span></div>',
						width: isTableSpace ? '10%' : '40%'
					};

					const sapSizeColumn = {
						field: 'userObject.size',
						displayName: cvLoc('Size'),
						type: 'number',
						headerTooltip: true,
						cellTemplate:
							'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.userObject.size|capacity" title="{{row.entity.userObject.size|capacity}}"></div>',
						width: '10%'
					};

					const sapPathColumn = {
						field: 'userObject.advancedData.browseMetaData.sap.osPath',
						displayName: cvLoc('label.osPath'),
						cellTemplate:
							'<div class="ellipsis-parent ellipsis-content" title="row.entity.userObject.advancedData.browseMetaData.sap.osPath"><span>{{row.entity.userObject.advancedData.browseMetaData.sap.osPath}}</span></div>',
						width: '70%'
					};

					if (pScope.selectedItem && pScope.selectedItem.label == 'Logs') {
						const sapJobIdColumn = {
							field: 'userObject.jobId',
							displayName: cvLoc('label.jobID'),
							headerTooltip: true,
							cellTemplate:
								'<div class="ellipsis-parent ellipsis-content" title="{{row.entity.userObject.jobId}}"><span>{{row.entity.userObject.jobId}}</span></div>',
							width: '10%'
						};

						const sapDetailFileNameColumn = {
							field: 'userObject.xmlJobInfo.detailFileName',
							displayName: cvLoc('label.detailFileName'),
							cellTemplate:
								'<div class="ellipsis-parent ellipsis-content" title="{{row.entity.userObject.xmlJobInfo.detailFileName}}"><span>{{row.entity.userObject.xmlJobInfo.detailFileName}}</span></div>',
							width: '*'
						};

						const sapStartTimeColumn = {
							field: 'userObject.xmlJobInfo.startUtc',
							displayName: cvLoc('label.startTime'),
							cellTemplate:
								'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.formatedStartTime" title="{{row.entity.formatedStartTime}}"></div>',
							width: '*'
						};

						const sapEndTimeColumn = {
							field: 'userObject.xmlJobInfo.endUtc',
							displayName: cvLoc('label.endTime'),
							cellTemplate:
								'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.formatedEndTime"  title="{{row.entity.formatedEndTime}}"></div>',
							width: '*'
						};

						const sapBackupDeviceColumn = {
							field: 'userObject.xmlJobInfo.backupdevice',
							displayName: cvLoc('label.backupDevice'),
							cellTemplate:
								'<div class="ellipsis-parent ellipsis-content" title="{{row.entity.userObject.xmlJobInfo.backupdevice}}"><span>{{row.entity.userObject.xmlJobInfo.backupdevice}}</span></div>',
							width: isTableSpace ? '10%' : '15%'
						};

						const sapLogRangeColumn = {
							field: 'userObject.xmlJobInfo.logRange',
							displayName: cvLoc('label.logRange'),
							cellTemplate:
								'<div class="ellipsis-parent ellipsis-content" title="{{row.entity.userObject.xmlJobInfo.logRange}}"><span>{{row.entity.userObject.xmlJobInfo.logRange}}</span></div>',
							width: isTableSpace ? '10%' : '15%'
						};

						columnDefs.push(sapJobIdColumn);
						columnDefs.push(sapDetailFileNameColumn);
						columnDefs.push(sapStartTimeColumn);
						columnDefs.push(sapEndTimeColumn);
						columnDefs.push(sapBackupDeviceColumn);
						columnDefs.push(sapLogRangeColumn);
					} else {
						columnDefs.push(sapFileNameColumn);
						if (!isRoot) {
							columnDefs.push(sapFileTypeColumn);
						}
						if (isTableSpace) {
							columnDefs.push(sapSizeColumn);
							columnDefs.push(sapPathColumn);
						}
					}
					return columnDefs;
					break;
				case AppTypes.POSTGRESQL:
					var databaseNameColumn = {
						field: 'userObject.displayName',
						displayName: cvLoc('label.DatabaseName'),
						cellTemplate:
							'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.userObject.displayName" title="{{row.entity.userObject.displayName}}"></div>',
						width: '40%'
					};
					var sizeColumn = {
						field: 'userObject.size',
						displayName: cvLoc('Size'),
						type: 'number',
						headerTooltip: true,
						cellTemplate:
							'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.userObject.size|capacity" title="{{row.entity.userObject.size|capacity}}"></div>',
						width: '30%'
					};
					var backupTimeColumn = {
						field: 'advancedData.backupTime',
						displayName: cvLoc('Backup_Time'),
						headerTooltip: true,
						cellTemplate:
							'<div class="time ellipsis-parent ellipsis-content" val="{{row.entity.userObject.advancedData.backupTime}}"></div>',
						width: '*'
					};
					columnDefs.push(databaseNameColumn);
					//columnDefs.push(sizeColumn);
					//For indexing v2 backup time is not setting in the response
					//columnDefs.push(backupTimeColumn);
					break;
				case AppTypes.MYSQL:
					var databaseNameColumn = {
						field: 'userObject.displayName',
						displayName: cvLoc('label.DatabaseName'),
						cellTemplate:
							'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.userObject.displayName" title="{{row.entity.userObject.displayName}}"></div>',
						width: '*'
					};
					columnDefs.push(databaseNameColumn);
					break;
				case AppTypes.CV_APPTYPE_SYBASE:
					var databaseNameColumn = {
						field: 'label',
						displayName: cvLoc('label.DatabaseName'),
						cellTemplate:
							'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.label" title="{{row.entity.label}}"></div>',
						width: '*'
					};
					columnDefs.push(databaseNameColumn);
					break;

				case AppTypes.WINDOWS_FILESYSTEM:
				case AppTypes.MAC_FILESYSTEM:
				case AppTypes.UNIX_FILESYSTEM:
					var displayNameColumn = {
						field: 'userObject.displayName',
						displayName: cvLoc('Name'),
						headerTooltip: true,
						cellTemplate:
							'<a ng-hide="row.entity.leafNode" data-ng-click="grid.appScope.folderSelected(row.entity)">{{row.entity.userObject.displayName}}</a>' +
							'<span title="{{row.entity.userObject.displayName}}" class="crop" ng-show="row.entity.leafNode">{{row.entity.userObject.displayName}}</span>',
						width: '*'
					};
					var fileTypeColumn = {
						field: 'fileType',
						displayName: cvLoc('header.type'),
						cellTemplate: '<div><span>{{row.entity.fileType}}</span></div>',
						width: '*'
					};
					var sizeColumn = {
						field: 'userObject.size',
						displayName: cvLoc('Size'),
						type: 'number',
						headerTooltip: true,
						cellTemplate:
							'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.userObject.size|capacity" title="{{row.entity.userObject.size|capacity}}"></div>',
						width: '*'
					};
					var backupTimeColumn = {
						field: 'userObject.advancedData.backupTime',
						displayName: cvLoc('Backup_Time'),
						headerTooltip: true,
						cellTemplate:
							'<div class="time ellipsis-parent ellipsis-content" val="{{row.entity.userObject.advancedData.backupTime}}"></div>',
						width: '*'
					};
					var deletedItemStatus = {
						field: 'userObject.flags.deleted',
						displayName: cvLoc('label.status'),
						headerTooltip: cvLoc('label.deletedItem') + ' ' + cvLoc('label.status'),
						cellToolTip: true,
						cellTemplate: '<span data-ng-show="{{row.entity.userObject.flags.deleted}}" class="disable"/>',
						width: '10%'
						//TODO:@Mano get a new image for disable and use here. show image tool tip to it.
					};

					columnDefs.push(displayNameColumn);
					columnDefs.push(fileTypeColumn);
					columnDefs.push(sizeColumn);
					columnDefs.push(backupTimeColumn);
					break;
				case AppTypes.DISTRIBUTED_APPS:
					if (pScope.clusterType === distributedClusterType.HADOOP) {
						var displayNameColumn = {
							field: 'userObject.displayName',
							displayName: cvLoc('Name'),
							headerTooltip: true,
							cellTemplate:
								'<a class="crop" ng-if="!row.entity.leafNode" data-ng-click="grid.appScope.folderSelected(row.entity)" data-ng-bind="row.entity.userObject.displayName" title="{{row.entity.userObject.displayName}}"></a>' +
								'<span class="crop" ng-show="row.entity.leafNode" data-ng-bind="row.entity.userObject.displayName" title="{{row.entity.userObject.displayName}}"></span>',
							width: '*'
						};
						var fileTypeColumn = {
							field: 'fileType',
							displayName: cvLoc('header.type'),
							cellTemplate: '<div><span>{{row.entity.fileType}}</span></div>',
							width: '*'
						};
						var sizeColumn = {
							field: 'userObject.size',
							type: 'number',
							displayName: cvLoc('Size'),
							headerTooltip: true,
							cellTemplate:
								'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.userObject.size|capacity" title="{{row.entity.userObject.size|capacity}}"></div>',
							width: '*'
						};
						var backupTimeColumn = {
							field: 'userObject.advancedData.backupTime',
							displayName: cvLoc('Backup_Time'),
							headerTooltip: true,
							cellTemplate:
								'<div class="time ellipsis-parent ellipsis-content" val="{{row.entity.userObject.advancedData.backupTime}}"></div>',
							width: '*'
						};
						columnDefs.push(displayNameColumn);
						columnDefs.push(fileTypeColumn);
						columnDefs.push(sizeColumn);
						columnDefs.push(backupTimeColumn);
					} else if (pScope.clusterType === distributedClusterType.MONGODB) {
						var mongoDBDatabaseColumn = {
							field: 'userObject.advancedData.browseMetaData.mongoDBDatabaseInfo.dbName',
							displayName: cvLoc('header.mongoDB.database'),
							headerTooltip: true,
							cellTemplate:
								'<a ng-if="!row.entity.leafNode" data-ng-click="grid.appScope.folderSelected(row.entity)">{{row.entity.userObject.advancedData.browseMetaData.mongoDBDatabaseInfo.dbName}}</a>' +
								'<span ng-show="row.entity.leafNode">{{row.entity.userObject.advancedData.browseMetaData.mongoDBCollectionInfo.collectionName}}</span>',
							width: '*'
						};

						var mongoDBReplicaSet = {
							field: 'userObject.displayName',
							displayName: cvLoc('header.replicaSet'),
							headerTooltip: true,
							cellTemplate:
								'<a ng-hide="row.entity.leafNode" data-ng-click="grid.appScope.folderSelected(row.entity)">{{row.entity.userObject.displayName}}</a>' +
								'<span ng-show="row.entity.leafNode">{{row.entity.userObject.displayName}}</span>',
							width: '*'
						};

						var mongoDBprimaryMongoHost = {
							field: 'primaryMongoHost',
							displayName: cvLoc('header.BackupHostPort'),
							cellTemplate:
								'<div><span>{{row.entity.userObject.advancedData.browseMetaData.mongoDBShardInfo.secondaryMongoHost}}</span>::<span>{{row.entity.userObject.advancedData.browseMetaData.mongoDBShardInfo.secondaryPort}}</span></div>',
							width: '*'
						};

						var mongoDBfileTypeColumn = {
							field: 'fileType',
							displayName: cvLoc('header.serverType'),
							cellTemplate:
								'<span class="crop">{{row.entity.userObject.advancedData.browseMetaData.mongoDBShardInfo.isConfigServer ?"' +
								cvLoc('string.configServer') +
								'":"' +
								cvLoc('string.shard') +
								'"}}</span>',
							width: '*'
						};

						var parentReplicaSet = {
							field: 'userObject.advancedData.browseMetaData.mongoDBDatabaseInfo.parentReplicaSet',
							displayName: cvLoc('header.replicaSet'),
							cellTemplate:
								'<span ng-show="!row.entity.leafNode">{{row.entity.userObject.advancedData.browseMetaData.mongoDBDatabaseInfo.parentReplicaSet}}</span>' +
								'<span ng-show="row.entity.leafNode">{{row.entity.userObject.advancedData.browseMetaData.mongoDBCollectionInfo.parentReplicaSet}}</span>',

							width: '*'
						};

						var mongoDBfilepathColumn = {
							field: 'fileType',
							displayName: cvLoc('header.dbPathDir'),
							cellTemplate:
								'<span class="crop">{{row.entity.userObject.advancedData.browseMetaData.mongoDBShardInfo.secondaryDataPathDir}}</span>',
							width: '*'
						};

						var mongoDBbackupTimeColumn = {
							field: 'userObject.advancedData.backupTime',
							displayName: cvLoc('Backup_Time'),
							headerTooltip: true,
							cellTemplate:
								'<div class="time ellipsis-parent ellipsis-content" val="{{row.entity.userObject.advancedData.backupTime}}"></div>',
							width: '*'
						};

						var mongoDBoplogSyncTime = {
							field: 'userObject.advancedData.backupTime',
							displayName: cvLoc('header.OplogSyncTime'),
							headerTooltip: true,
							cellTemplate:
								'<div class="time ellipsis-parent ellipsis-content" val="{{row.entity.userObject.advancedData.browseMetaData.mongoDBShardInfo.oplogSyncTime}}"></div>',
							width: '*',
							visible: true
						};
						var mongoDBsizeColumn = {
							field: 'userObject.size',
							displayName: cvLoc('Size'),
							type: 'number',
							headerTooltip: true,
							cellTemplate:
								'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.userObject.size|capacity" title="{{row.entity.userObject.size|capacity}}"></div>',
							width: '*'
						};

						if (pScope.clusterView == true) {
							columnDefs.push(mongoDBReplicaSet); //Replica set
							columnDefs.push(mongoDBprimaryMongoHost); //Host
							columnDefs.push(mongoDBfileTypeColumn); //Server Type
							columnDefs.push(mongoDBfilepathColumn); //DB Path
							columnDefs.push(mongoDBbackupTimeColumn); //Backup time
							columnDefs.push(mongoDBoplogSyncTime); //Oplog sync time
							columnDefs.push(mongoDBsizeColumn); //Size
						} else {
							columnDefs.push(mongoDBDatabaseColumn); //Database
							//columnDefs.push(mongoDBReplicaSet);     //Replica set
							columnDefs.push(parentReplicaSet); //Parent Replica set
							columnDefs.push(mongoDBbackupTimeColumn); //Backup time
							columnDefs.push(mongoDBsizeColumn); //Size
						}
					} else if (pScope.clusterType === distributedClusterType.SPLUNK) {
						var displayNameColumn = {
							field: 'userObject.displayName',
							displayName: cvLoc('Name'),
							headerTooltip: true,
							cellTemplate:
								'<a ng-hide="row.entity.leafNode" data-ng-click="grid.appScope.folderSelected(row.entity)">{{row.entity.userObject.displayName}}</a>' +
								'<span ng-show="row.entity.leafNode">{{row.entity.userObject.displayName}}</span>',
							width: '*'
						};

						var sizeColumn = {
							field: 'userObject.advancedData.browseMetaData.splunkMetadata.splunkIndexMetadata.size',
							displayName: cvLoc('Size'),
							type: 'number',
							headerTooltip: true,
							cellTemplate:
								'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.userObject.advancedData.browseMetaData.splunkMetadata.splunkIndexMetadata.size|capacity" title="{{row.entity.userObject.advancedData.browseMetaData.splunkMetadata.splunkIndexMetadata.size|capacity}}"></div>',
							width: '*'
						};

						var recordsColumn = {
							field: 'userObject.advancedData.browseMetaData.splunkMetadata.splunkIndexMetadata.totalRecords',
							displayName: cvLoc('label.totalRecords'),
							type: 'number',
							headerTooltip: true,
							cellTemplate:
								'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.userObject.advancedData.browseMetaData.splunkMetadata.splunkIndexMetadata.totalRecords" title="{{row.entity.userObject.advancedData.browseMetaData.splunkMetadata.splunkIndexMetadata.totalRecords}}"></div>',
							width: '*'
						};

						/*
						 * var backupTimeColumn = { field: 'userObject.advancedData.backupTime', displayName:
						 * cvLoc('label.oldRecordTime'), headerTooltip: true, cellTemplate: '<div class="time
						 * ellipsis-parent ellipsis-content"
						 * val="{{row.entity.userObject.advancedData.browseMetaData.splunkMetadata.splunkIndexMetadata.oldestRecordTime}}"></div>',
						 * width: '*' };
						 */

						var newestTimeColumn = {
							field: 'userObject.advancedData.backupTime',
							displayName: cvLoc('label.newRecordTime'),
							headerTooltip: true,
							//cellTemplate:
							//'<div class="crop" title="row.entity.userObject.advancedData.browseMetaData.splunkMetadata.splunkIndexMetadata.newestRecordTime"> {{row.entity.userObject.advancedData.browseMetaData.splunkMetadata.splunkIndexMetadata.newestRecordTime}}</div>',
							//width: '*',
							cellTemplate:
								'<div class="time ellipsis-parent ellipsis-content" val="{{row.entity.userObject.advancedData.browseMetaData.splunkMetadata.splunkIndexMetadata.newestRecordTime}}"></div>',
							width: '*',
							visible: true
						};

						columnDefs.push(displayNameColumn);
						columnDefs.push(sizeColumn);
						columnDefs.push(recordsColumn);
						//columnDefs.push(backupTimeColumn);
						columnDefs.push(newestTimeColumn);
					} else {
						var displayNameColumn = {
							field: 'userObject.displayName',
							displayName: cvLoc('Name'),
							headerTooltip: true,
							cellTemplate:
								'<a ng-hide="row.entity.leafNode" data-ng-click="grid.appScope.folderSelected(row.entity)">{{row.entity.userObject.displayName}}</a>' +
								'<span ng-show="row.entity.leafNode">{{row.entity.userObject.displayName}}</span>',
							width: '*'
						};
						var fileTypeColumn = {
							field: 'fileType',
							displayName: cvLoc('header.type'),
							cellTemplate: '<div><span>{{row.entity.fileType}}</span></div>',
							width: '*'
						};
						var sizeColumn = {
							field: 'userObject.size',
							displayName: cvLoc('Size'),
							type: 'number',
							headerTooltip: true,
							cellTemplate:
								'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.userObject.size|capacity" title="{{row.entity.userObject.size|capacity}}"></div>',
							width: '*'
						};
						var backupTimeColumn = {
							field: 'userObject.advancedData.backupTime',
							displayName: cvLoc('Backup_Time'),
							headerTooltip: true,
							cellTemplate:
								'<div class="time ellipsis-parent ellipsis-content" val="{{row.entity.userObject.advancedData.backupTime}}"></div>',
							width: '*'
						};

						columnDefs.push(displayNameColumn);
						columnDefs.push(fileTypeColumn);
						columnDefs.push(sizeColumn);
						columnDefs.push(backupTimeColumn);
					}
					break;
				case AppTypes.NAS:
					var displayNameColumn = {
						field: 'userObject.displayName',
						displayName: cvLoc('Name'),
						headerTooltip: true,
						cellTemplate:
							'<a ng-hide="row.entity.leafNode" data-ng-click="grid.appScope.folderSelected(row.entity)">{{row.entity.userObject.displayName}}</a>' +
							'<span ng-show="row.entity.leafNode">{{row.entity.userObject.displayName}}</span>',
						width: '*'
					};
					var fileTypeColumn = {
						field: 'fileType',
						displayName: cvLoc('header.type'),
						cellTemplate: '<div><span>{{row.entity.fileType}}</span></div>',
						width: '*'
					};
					var sizeColumn = {
						field: 'userObject.size',
						displayName: cvLoc('Size'),
						type: 'number',
						headerTooltip: true,
						cellTemplate:
							'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.userObject.size|capacity" title="{{row.entity.userObject.size|capacity}}"></div>',
						width: '*'
					};
					var backupTimeColumn = {
						field: 'userObject.advancedData.backupTime',
						displayName: cvLoc('Backup_Time'),
						headerTooltip: true,
						cellTemplate:
							'<div class="time ellipsis-parent ellipsis-content" val="{{row.entity.userObject.advancedData.backupTime}}"></div>',
						width: '*'
					};

					columnDefs.push(displayNameColumn);
					columnDefs.push(fileTypeColumn);
					columnDefs.push(sizeColumn);
					columnDefs.push(backupTimeColumn);

					break;
				case AppTypes.CLOUD_APPS:
					if (
						pScope.cloudAppType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_RDS.value ||
						pScope.cloudAppType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DOCUMENTDB.value ||
						pScope.cloudAppType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_REDSHIFT.value
					) {
						const selectedPath = pScope.selectedItem ? pScope.selectedItem.path : '/';
						const isRootLevel = selectedPath === '/';
						if (isRootLevel) {
							const displayNameColumn = {
								field: 'regionCode',
								displayName: cvLoc('label.region'),
								headerTooltip: true,
								cellTemplate: `<a class="crop" title="{{row.entity.regionCode}}" data-ng-click="grid.appScope.folderSelected(row.entity)">{{row.entity.regionCode}}</a>`,
								width: '*',
								enableSorting: false
							};
							columnDefs.push(displayNameColumn);
						} else {
							var displayNameColumn = {
								field: 'snapShotName',
								displayName: cvLoc('label.SnapShot'),
								headerTooltip: true,
								cellTemplate:
									'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.snapShotName" title="{{row.entity.snapShotName}}"></div>',
								width: '25%'
							};
							var dbNameColumn = {
								field: 'dbName',
								displayName: cvLoc(
									pScope.cloudAppType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_REDSHIFT.value
										? 'label.clusterName'
										: 'label.dbName'
								),
								headerTooltip: true,
								cellTemplate:
									'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.dbName" title="{{row.entity.dbName}}"></div>',
								width: '*'
							};
							var createTimeColumn = {
								field: 'createTime',
								displayName: cvLoc('label.createTime'),
								headerTooltip: true,
								cellTemplate:
									'<div class="time ellipsis-parent ellipsis-content" val="{{row.entity.createTime}}"></div>',
								width: '*'
							};
							var dbTypeColumn = {
								field: 'dbType',
								displayName: cvLoc('label.dbType'),
								headerTooltip: true,
								cellTemplate:
									'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.dbType" title="{{row.entity.dbType}}"></div>',
								width: '*'
							};
							var zoneNameColumn = {
								field: 'rdsAttributes.availabilityZone',
								displayName: cvLoc('label.availabilityZone'),
								headerTooltip: true,
								cellTemplate:
									'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.rdsAttributes.availabilityZone" title="{{row.entity.rdsAttributes.availabilityZone}}"></div>',
								width: '25%'
							};
							columnDefs.push(displayNameColumn);
							columnDefs.push(dbNameColumn);
							columnDefs.push(createTimeColumn);
							columnDefs.push(dbTypeColumn);
							columnDefs.push(zoneNameColumn);
						}
					} else if (pScope.cloudAppType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.value) {
						//Only two levels: region -> table
						let selectedPath = pScope.selectedItem ? pScope.selectedItem.path : '/';
						let level = 0;
						level = selectedPath.split('/').filter(a => a.length !== 0).length;

						const displayNameColumn = {
							field: 'label',
							displayName: level > 0 ? cvLoc('label.table') : cvLoc('label.region'),
							headerTooltip: true,
							cellTemplate: `<a class="crop" title="{{row.entity.label}}" ng-hide="row.entity.leafNode" data-ng-click="grid.appScope.folderSelected(row.entity)">{{row.entity.label}}</a>
									<span class="crop" title="{{row.entity.label}}" ng-show="row.entity.leafNode">{{row.entity.label}}</span>`,
							width: '*',
							enableSorting: false
						};
						const sizeColumn = {
							field: 'description.table.TableSizeBytes',
							displayName: cvLoc('Size'),
							type: 'number',
							headerTooltip: true,
							cellTemplate: `<div class="crop" data-ng-bind="row.entity.description.table.TableSizeBytes|capacity" title="{{row.entity.description.table.TableSizeBytes|capacity}}"></div>`,
							width: '*',
							enableSorting: false
						};
						const partitionKeyColumn = {
							field: 'description.table.KeySchema[0].AttributeName',
							displayName: cvLoc('label.partitionKey'),
							headerTooltip: true,
							cellTemplate: `<div class="crop" data-ng-bind="row.entity.description.table.KeySchema[0].AttributeName" title="{{row.entity.description.table.KeySchema[0].AttributeName}}"></div>`,
							width: '*',
							enableSorting: false
						};
						const totalReadColumn = {
							field: 'description.table.ProvisionedThroughput.ReadCapacityUnits',
							displayName: cvLoc('label.totalReadCapacity'),
							headerTooltip: true,
							cellTemplate: `<div class="crop" data-ng-bind="row.entity.description.table.ProvisionedThroughput.ReadCapacityUnits" title="{{row.entity.description.table.ProvisionedThroughput.ReadCapacityUnits}}"></div>`,
							width: '*',
							enableSorting: false
						};
						const totalWriteColumn = {
							field: 'description.table.ProvisionedThroughput.WriteCapacityUnits',
							displayName: cvLoc('label.totalWriteCapacity'),
							headerTooltip: true,
							cellTemplate: `<div class="crop" data-ng-bind="row.entity.description.table.ProvisionedThroughput.WriteCapacityUnits" title="{{row.entity.description.table.ProvisionedThroughput.WriteCapacityUnits}}"></div>`,
							width: '*',
							enableSorting: false
						};

						const backupTimeColumn = {
							field: 'userObject.advancedData.backupTime',
							displayName: cvLoc('Backup_Time'),
							headerTooltip: true,
							cellTemplate: `<div class="time" val="{{row.entity.userObject.advancedData.backupTime}}"></div>`,
							width: '*',
							enableSorting: false
						};

						columnDefs.push(displayNameColumn);
						if (level > 0) {
							columnDefs.push(sizeColumn);
							columnDefs.push(partitionKeyColumn);
							columnDefs.push(totalReadColumn);
							columnDefs.push(totalWriteColumn);
						}
						columnDefs.push(backupTimeColumn);
					} else if (
						pScope.cloudAppType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_TABLE_STORAGE.value ||
						pScope.cloudAppType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_COSMOS_DB_SQL_API.value
					) {
						// Table Storage -> 2 levels -> Storage account -> table
						// Cosmos DB -> 3 levels -> Cosmos DB account -> database -> container
						let selectedPath = pScope.selectedItem ? pScope.selectedItem.path : '/';
						let level = 0;
						level = selectedPath.split('/').filter(a => a.length !== 0).length;

						let lastParentLevel = 0;
						if (pScope.cloudAppType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_COSMOS_DB_SQL_API.value) {
							lastParentLevel = 1;
						}

						let displayNameLabel = cvLoc('label.storageAccount');
						switch (pScope.cloudAppType) {
							case CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_TABLE_STORAGE.value:
								displayNameLabel = level > 0 ? cvLoc('label.table') : cvLoc('label.storageAccount');
							case CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_COSMOS_DB_SQL_API.value:
								displayNameLabel =
									level > 0
										? level > 1
											? cvLoc('label.cosmosdb.container')
											: cvLoc('label.cosmosdb.database')
										: cvLoc('label.cosmosDbAccount');
						}

						const displayNameColumn = {
							field: 'label',
							displayName: displayNameLabel,
							headerTooltip: true,
							cellTemplate: `<a class="crop" title="{{row.entity.label}}" ng-hide="row.entity.leafNode" data-ng-click="grid.appScope.folderSelected(row.entity)">{{row.entity.label}}</a>
									<span class="crop" title="{{row.entity.label}}" ng-show="row.entity.leafNode">{{row.entity.label}}</span>`,
							width: '*',
							enableSorting: false
						};
						var sizeColumn = {
							field: 'userObject.size',
							displayName: cvLoc('Size'),
							type: 'number',
							headerTooltip: true,
							cellTemplate:
								'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.userObject.size|capacity" title="{{row.entity.userObject.size|capacity}}"></div>',
							width: '*',
							enableSorting: false
						};
						const backupTimeColumn = {
							field: 'userObject.advancedData.backupTime',
							displayName: cvLoc('Backup_Time'),
							headerTooltip: true,
							cellTemplate: `<div class="time" val="{{row.entity.userObject.advancedData.backupTime}}"></div>`,
							width: '*',
							enableSorting: false
						};
						const noOfItemsColumn = {
							field: 'description.numItems',
							displayName: cvLoc('column.noOfItems'),
							headerTooltip: true,
							cellTemplate: `<div><span class="crop" title="{{row.entity.description.numItems}}">{{row.entity.description.numItems}}</span></div>`,
							width: '*',
							enableSorting: true
						};
						const cosmosDbSizeColumn = {
							field: 'description.sizeInBytes',
							displayName: cvLoc('Size'),
							headerTooltip: true,
							cellTemplate:
								'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.description.sizeInBytes|capacity" title="{{row.entity.description.sizeInBytes|capacity}}"></div>',
							width: '*',
							enableSorting: false
						};

						columnDefs.push(displayNameColumn);
						if (level > lastParentLevel) {
							if (pScope.cloudAppType === CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_COSMOS_DB_SQL_API.value) {
								columnDefs.push(noOfItemsColumn);
								columnDefs.push(cosmosDbSizeColumn);
							} else {
								columnDefs.push(sizeColumn);
							}
						}
						columnDefs.push(backupTimeColumn);
					} else {
						var selectedPath = pScope.selectedItem ? pScope.selectedItem.path : '/';

						var isSalesforce = pScope.cloudAppType == CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.SALESFORCE.value;
						var isSfRoot = isSalesforce && selectedPath == '/';
						var isSfFiles = isSalesforce && selectedPath.indexOf('/Files/') == 0;
						var isSfObjects = isSalesforce && selectedPath == '/Objects';

						var displayNameColumn = {
							field: 'label',
							displayName: isSfFiles ? cvLoc('label.ID') : cvLoc('Name'),
							headerTooltip: true,
							cellTemplate:
								'<a class="crop" title="{{row.entity.label}}" ng-hide="row.entity.leafNode" data-ng-click="grid.appScope.folderSelected(row.entity)">{{row.entity.label}}</a>' +
								'<span class="crop" title="{{row.entity.label}}" ng-show="row.entity.leafNode">{{row.entity.label}}</span>',
							width: '*',
							enableSorting: false
						};
						var fileTypeColumn = {
							field: 'fileType',
							displayName: cvLoc('header.type'),
							cellTemplate: '<div><span>{{row.entity.fileType}}</span></div>',
							width: '*',
							enableSorting: false
						};
						var sizeColumn = {
							field: 'userObject.size',
							displayName: cvLoc('Size'),
							type: 'number',
							headerTooltip: true,
							cellTemplate:
								'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.userObject.size|capacity" title="{{row.entity.userObject.size|capacity}}"></div>',
							width: '*',
							enableSorting: false
						};
						var backupTimeColumn = {
							field: 'userObject.advancedData.backupTime',
							displayName: cvLoc('Backup_Time'),
							headerTooltip: true,
							cellTemplate:
								'<div class="time ellipsis-parent ellipsis-content" val="{{row.entity.userObject.advancedData.backupTime}}"></div>',
							width: '*',
							enableSorting: false
						};
						var deletedItemStatus = {
							field: 'userObject.flags.deleted',
							displayName: cvLoc('label.status'),
							headerTooltip: cvLoc('label.deletedItem') + ' ' + cvLoc('label.status'),
							cellToolTip: true,
							cellTemplate: '<span data-ng-show="{{row.entity.userObject.flags.deleted}}" class="disable"/>',
							width: '10%'
							//TODO:@Mano get a new image for disable and use here. show image tool tip to it.
						};

						var modificationTimeColumn = {
							field: 'userObject.modificationTime',
							displayName: cvLoc('label.modified'),
							headerTooltip: true,
							cellTemplate:
								'<div class="time ellipsis-parent ellipsis-content" val="{{row.entity.userObject.modificationTime}}"></div>',
							width: '*'
						};

						var sfFileNameColumn = {
							field:
								'userObject.advancedData.browseMetaData.cloudconnectorData.salesforceData.fileMetadata.displayName',
							displayName: cvLoc('Name'),
							headerTooltip: true,
							cellTemplate:
								'<span class="crop" title="{{row.entity.userObject.advancedData.browseMetaData.cloudconnectorData.salesforceData.fileMetadata.displayName}}" >{{row.entity.userObject.advancedData.browseMetaData.cloudconnectorData.salesforceData.fileMetadata.displayName}}</span>',
							width: '*'
						};

						var sfTotalRowsColumn = {
							field:
								'userObject.advancedData.browseMetaData.cloudconnectorData.salesforceData.objectMetadata.totalRows',
							displayName: cvLoc('label.totalRows'),
							cellTemplate:
								'<span>{{row.entity.userObject.advancedData.browseMetaData.cloudconnectorData.salesforceData.objectMetadata.totalRows}}</span>',
							width: '*'
						};
						var sfModifiedRowsColumn = {
							field:
								'userObject.advancedData.browseMetaData.cloudconnectorData.salesforceData.objectMetadata.modifiedRows',
							displayName: cvLoc('label.modifiedRows'),
							cellTemplate:
								'<span>{{row.entity.userObject.advancedData.browseMetaData.cloudconnectorData.salesforceData.objectMetadata.modifiedRows}}</span>',
							width: '*'
						};
						var sfDeletedRowsColumn = {
							field:
								'userObject.advancedData.browseMetaData.cloudconnectorData.salesforceData.objectMetadata.deletedRows',
							displayName: cvLoc('label.deletedRows'),
							cellTemplate:
								'<span>{{row.entity.userObject.advancedData.browseMetaData.cloudconnectorData.salesforceData.objectMetadata.deletedRows}}</span>',
							width: '*'
						};

						columnDefs.push(displayNameColumn);

						if (!isSfRoot) {
							columnDefs.push(fileTypeColumn);
						}

						if (isSfFiles) {
							columnDefs.push(sfFileNameColumn);
						}

						if (!isSfRoot && !isSfObjects) {
							columnDefs.push(sizeColumn);
						}

						if (isSfFiles) {
							columnDefs.push(modificationTimeColumn);
						}

						if (isSfObjects) {
							columnDefs.push(sfTotalRowsColumn);
							columnDefs.push(sfModifiedRowsColumn);
							columnDefs.push(sfDeletedRowsColumn);
						}

						columnDefs.push(backupTimeColumn);
					}
					break;
				case AppTypes.EXCHANGE_DATABASE:
					var selectedPath = pScope.selectedItem ? pScope.selectedItem.path : EX_DB_CONSTANTS.EXCH_DB_BROWSE_PATH_ROOT;
					var isExchDbStore = selectedPath == EX_DB_CONSTANTS.EXCH_DB_BROWSE_PATH_STORE;
					var isExchDbFiles = acIDABrowseUtils.isExchDbFilesBrowse(pScope);

					var displayNameColumn = {
						field: 'label',
						displayName: isExchDbFiles ? cvLoc('Name') + '/' + cvLoc('label.jobID') : cvLoc('Name'),
						headerTooltip: true,
						cellTemplate:
							'<a class="crop" title="{{row.entity.label}}" ng-hide="row.entity.leafNode" data-ng-click="grid.appScope.folderSelected(row.entity)">{{row.entity.label}}</a>' +
							'<span class="crop" title="{{row.entity.label}}" ng-show="row.entity.leafNode">{{row.entity.label}}</span>',
						width: '*',
						enableSorting: true
					};

					var sizeColumn = {
						field: 'userObject.size',
						displayName: cvLoc('Size'),
						type: 'number',
						cellTemplate:
							'<div class="ellipsis-parent ellipsis-content" data-ng-bind="row.entity.userObject.size|capacity" title="{{row.entity.userObject.size|capacity}}"></div>',
						width: '*',
						enableSorting: true
					};
					var backupTimeColumn = {
						field: 'userObject.advancedData.backupTime',
						displayName: cvLoc('Backup_Time'),
						cellTemplate:
							'<div class="time ellipsis-parent ellipsis-content" val="{{row.entity.userObject.advancedData.backupTime}}"></div>',
						width: '*',
						enableSorting: true
					};

					columnDefs.push(displayNameColumn);

					if (isExchDbStore) {
						columnDefs.push(sizeColumn);
					}
					if (isExchDbFiles) {
						var backupLevelColumn = {
							field: 'userObject.advancedData.browseMetaData.exchDb.exDBJobInfo.Bkuplvl',
							displayName: cvLoc('label.backupLevel'),
							headerTooltip: true,
							cellTemplate:
								'<span class="crop" title="{{row.entity.userObject.advancedData.browseMetaData.exchDb.exDBJobInfo.Bkuplvl}}" >{{row.entity.userObject.advancedData.browseMetaData.exchDb.exDBJobInfo.Bkuplvl}}</span>',
							width: '*'
						};

						columnDefs.push(sizeColumn);
						columnDefs.push(backupLevelColumn);
						columnDefs.push(backupTimeColumn);
					}

					break;
				default:
					$log.error(
						'Invalid applicationId or not implemented yet.AppId=' + applicationId + 'Column def construction failed'
					);
			}
			return columnDefs;
		};

		acIDABrowseUtils.getFileSeparater = function(scopeArg) {
			var osType = scopeArg.clientProps['osType'];
			var cloudAppType = scopeArg.cloudAppType;
			var applicationId = scopeArg.applicationId;
			var isCloudStorageApp = scopeArg.isCloudStorageApp;

			const isUnixPathCloudApp =
				cloudAppType &&
				cloudAppType !== CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GOOGLE_DRIVE.value &&
				cloudAppType !== CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GOOGLE_MAIL.value;
			var rootPath = '\\';
			if (
				osType === 'Unix' ||
				applicationId == AppTypes.UNIX_FILESYSTEM ||
				applicationId == AppTypes.NAS ||
				applicationId == AppTypes.DISTRIBUTED_APPS ||
				isCloudStorageApp ||
				isUnixPathCloudApp
			) {
				rootPath = '/';
			}
			if (scopeArg.applicationId == AppTypes.POSTGRESQL) {
				if (osType === 'Unix') {
					rootPath = '/TblView';
				} else {
					rootPath = '\\TblView';
				}
			}
			return rootPath;
		};

		acIDABrowseUtils.getRootPath = function(scopeArg) {
			if (scopeArg.applicationId == AppTypes.SAP_FOR_ORACLE) {
				const sep = acIDABrowseUtils.getFileSeparater(scopeArg);
				return sep + '+BROWSE+';
			}
			return acIDABrowseUtils.getFileSeparater(scopeArg);
		};

		acIDABrowseUtils.getPathPrefixForCloudApps = function(cloudAppType) {
			var initialPath = '';

			if (cloudAppType == CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GOOGLE_DRIVE.value) {
				initialPath = CAPPS_CONSTANTS.BROWSE_PATH_PREFIX_GDRIVE;
			} else if (cloudAppType == CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GOOGLE_MAIL.value) {
				initialPath = CAPPS_CONSTANTS.BROWSE_PATH_PREFIX_GMAIL;
			}

			return initialPath;
		};
		acIDABrowseUtils.isExchDbFilesBrowse = function(pScope) {
			var selectedPath = pScope.selectedItem ? pScope.selectedItem.path : EX_DB_CONSTANTS.EXCH_DB_BROWSE_PATH_ROOT;
			var isExchDbRoot = selectedPath == EX_DB_CONSTANTS.EXCH_DB_BROWSE_PATH_ROOT;
			var isExchDbStore = selectedPath == EX_DB_CONSTANTS.EXCH_DB_BROWSE_PATH_STORE;
			var isExchDbFiles = isExchDbRoot == false && isExchDbStore == false;

			return isExchDbFiles;
		};
		return acIDABrowseUtils;
	}
]);

export default browseMod;
