import 'modules/ida/js/services/idaService.svc.js';
import 'storage/js/services/storage.svc.js';
import 'modules/ida/js/controllers/addDB2PartitionNodes.ctrl.js';
import 'modules/ida/js/directives/cv-db2-partition-nodes.ctrl.js';

import { commonAllAgentsModule } from 'common/js/modules';

var app = commonAllAgentsModule;

app.controller('db2dpfCreateInstanceCtrl', [
	'$state',
	'cvLoc',
	'$uibModalInstance',
	'$uibModal',
	'$log',
	'data',
	'cvToaster',
	'idaService',
	'cvUtil',
	'dbsUtil',
	'mbService',
	'AppTypes',
	'profileService',
	'clientService',
	'cvTableOptions',
	'$scope',
	'globalCacheFactory',
	function(
		$state,
		cvLoc,
		$modalInstance,
		$modal,
		$log,
		data,
		cvToaster,
		idaService,
		cvUtil,
		dbsUtil,
		mbService,
		AppTypes,
		profileService,
		clientService,
		cvTableOptions,
		$scope,
		globalCacheFactory
	) {
		var self = this;
		$scope.isReadyForAPICall = false;

		if (!data.editDialog) {
			data.idaEntity.appName = 'DB2';
		}

		self.dbHomeResuleFunction = function(result) {
			if (result) {
				self.instInfo.dbHome = result.path;
			}
		};
		self.newServerSelected = function() {
			self.instInfo.newServer = !self.instInfo.newServer;
		};
		var populateDefaultValues = function(serverInstanceInfo) {
			var instInfo = new Object();

			var commandLineStoragePolicy = new Object();
			var logBackupStoragePolicy = new Object();
			var storageDevice = new Object();

			instInfo.password = '';
			instInfo.availableStoragePolicies = {};
			instInfo.dbUserName = '';
			instInfo.dbUserPassword = '';

			self.instanceEntity = data.idaEntity;
			self.instanceEntity.instanceName = '';
			self.instanceEntity.instanceId = -1;
			//Default storage policy values.

			commandLineStoragePolicy.storagePolicyId = null;
			commandLineStoragePolicy.storagePolicyName = null;

			logBackupStoragePolicy.storagePolicyId = null;
			logBackupStoragePolicy.storagePolicyName = null;

			storageDevice.commandLineStoragePolicy = commandLineStoragePolicy;
			storageDevice.logBackupStoragePolicy = logBackupStoragePolicy;
			self.storageDev = storageDevice;

			return instInfo;
		};

		var populateInstanceValues = function(serverInstanceInfo) {
			var instInfo = new Object();
			self.instanceEntity = angular.copy(serverInstanceInfo.instance);
			instInfo.instanceEntity = angular.copy(serverInstanceInfo.instance);
			instInfo.dbUserName = serverInstanceInfo.db2Instance.userAccount.userName;
			if (serverInstanceInfo.db2Instance.userAccount.domainName) {
				instInfo.dbUserName = serverInstanceInfo.db2Instance.userAccount.domainName + '/' + instInfo.dbUserName;
			}

			let partitionNodes = _.get(serverInstanceInfo, 'db2Instance.dpfpartitionclients', []);
			instInfo.partitionNodeList = partitionNodes;
			instInfo.dbHome = serverInstanceInfo.db2Instance.homeDirectory;
			self.instancePlan = serverInstanceInfo.planEntity;
			return instInfo;
		};

		self.editDialog = data.editDialog;
		if (self.editDialog && self.editDialog === 'Add_Instance') {
			self.addInstance = true;
			self.editDialog = false;
			data.idaEntity.appName = 'DB2 DPF';
		}

		if (self.editDialog && self.editDialog == true) {
			self.instInfo = populateInstanceValues(data.instanceDetails);
		} else {
			self.instInfo = populateDefaultValues({});
			self.instInfo.partitionNodeList = [];
		}

		self.showServerNameError = false;
		self.instInfo.newServer = self.addInstance;
		self.showPlanError = self.addInstance;
		self.selectedProfileList = [];
		self.parseIStevenOutput = function() {
			if (self.selectedProfileList && self.selectedProfileList.length > 0) {
				self.showPlanError = false;
			} else {
				self.showPlanError = self.addInstance;
			}
		};

		self.loadPlans = function() {
			self.profileList = [];
			profileService
				.getEligiblePlansForApp(AppTypes.DB2_MultiNode)
				.success(function(data) {
					self.addServerMessage = cvUtil.emptyMsg();
					if (data.length > 0) {
						var planList = [];
						self.planListByTypes = {};
						angular.forEach(data, planData => {
							planData = planData.planSummary ? planData.planSummary : planData;
							const planObj = {
								name: planData.plan.planName,
								id: planData.plan.planId,
								type: planData.subtype,
								numAssocEntities: planData.numAssocEntities,
								numCopies: planData.numCopies,
								rpoInMinutes: planData.rpoInMinutes,
								planSummary: _.get(planData, 'plan.planSummary')
							};

							planList.push(planObj);
							if (self.planListByTypes[planObj.type]) {
								self.planListByTypes[planObj.type].push(planObj);
							} else {
								self.planListByTypes[planObj.type] = [planObj];
							}
						});
						var tempPlanList = [];
						for (var planType in self.planListByTypes) {
							tempPlanList.push({
								name: planType,
								msGroup: true
							});
							var plansByType = cvUtil.sortAscending(self.planListByTypes[planType], 'name');
							tempPlanList = tempPlanList.concat(plansByType);
							tempPlanList.push({
								msGroup: false
							});
						}
						self.profileList.push(...tempPlanList);
						if (self.editDialog && self.editDialog == true && self.instancePlan && self.instancePlan.planId) {
							let selectedPlans = self.profileList.filter(function(planNode) {
								return planNode.id == self.instancePlan.planId;
							});
							if (selectedPlans) {
								selectedPlans.forEach(function(planNode) {
									planNode.selected = true;
								});
								self.selectedProfileList.push(selectedPlans);
								self.showPlanError = false;
							}
						}
					} else {
						self.showPlan = false;
					}
				})
				.error(function(e) {
					self.db2dpfServerMessage = cvUtil.errMsg(e);
				});
		};

		self.loadPlans();

		self.updateUserName = function() {
			self.instInfo.dbUserName = self.instanceEntity.instanceName;
		};

		self.closeDialogBox = function() {
			$modalInstance.close();
		};

		// method to create the instance.
		self.createInstance = function() {
			self.showServerNameError = false;
			var instanceEntity = self.instanceEntity;
			if (self.addInstance && !dbsUtil.isValidClientName(self.instanceEntity.clientName)) {
				self.showServerNameMesage = cvLoc('error.serverNameChars', cvLoc('label.db2MultiNode'));
				self.showServerNameError = true;
				return;
			}
			if (self.instInfo.partitionNodeList.length === 0) {
				self.db2dpfServerMessage = {
					message: cvLoc('error.db2PartitionNode'),
					type: 'error'
				};
				return;
			} else {
				self.db2dpfServerMessage = cvUtil.emptyMsg();
			}
			var instanceProperties = new Object();

			if (self.addInstance && (!self.selectedProfileList || self.selectedProfileList.length <= 0)) {
				return;
			}

			self.populateDB2Props(instanceProperties);
			if (self.selectedProfileList && self.selectedProfileList.length > 0) {
				var plan = self.selectedProfileList[0].id;
				instanceProperties.planEntity = {
					planId: plan
				};
			}
			var osPassword;
			if (self.editDialog && self.editDialog == true && self.instInfo.osUserPassword === '*****') {
				osPassword = null;
			} else {
				osPassword = self.instInfo.osUserPassword;
			}

			var password;
			if (self.editDialog && self.editDialog == true && self.instInfo.password === '*****') {
				password = null;
			} else {
				password = self.instInfo.password;
			}

			let editOperation = self.editDialog;
			if (self.instInfo.newServer) {
				editOperation = 'ADD_CLIENT';
			}
			idaService
				.createInstance(
					{
						instanceEntity: angular.toJson(instanceEntity),
						instanceProps: angular.toJson(instanceProperties),
						password: password,
						osUserPassword: osPassword
					},
					editOperation
				)
				.success(function(data) {
					if (data != null && data.errorCode != undefined && data.errorCode != 0) {
						var msgStr = data.errorString;
						self.db2dpfServerMessage = {
							message: msgStr,
							type: 'error'
						};
						self.instanceEntity.instanceId = data.entity.instanceId;
						self.editDialog = true;
						//$state.forceReload();
						return;
					}

					var msg = cvLoc('msg.createInstance');
					if (self.editDialog) {
						msg = cvLoc('msg.updateInstance');
					}

					cvToaster.showSuccessMessage({
						ttl: '15000',
						message: msg
					});
					globalCacheFactory.refreshCacheId();
					$state.forceReload();
					self.closeDialogBox();
				})
				.error(function(e) {
					self.db2dpfServerMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		// Utility method to populate db2 specific values.
		self.populateDB2Props = function(instanceProperties) {
			var db2Instance = new Object();
			db2Instance.homeDirectory = self.instInfo.dbHome;

			var userAccount = new Object();
			var userName = self.instInfo.dbUserName;
			if (userName.indexOf('\\') != -1) {
				var userValues = userName.split('\\');
				userAccount.domainName = userValues[0];
				userAccount.userName = userValues[1];
			} else {
				userAccount.userName = userName;
			}
			if (self.instInfo.dbUserPassword) {
				userAccount.password = cvUtil.getBytes(self.instInfo.dbUserPassword);
			}

			db2Instance.dpfpartitionclients = self.instInfo.partitionNodeList;
			db2Instance.userAccount = userAccount;

			db2Instance.DB2StorageDevice = {
				dataBackupStoragePolicy: {
					storagePolicyId: 1
				},
				logBackupStoragePolicy: {
					storagePolicyId: 1
				},
				commandLineStoragePolicy: {
					storagePolicyId: 1
				}
			};
			instanceProperties.db2Instance = db2Instance;
		};
	}
]);

export default app;
