import { commonAllAgentsModule } from 'common/js/modules';
import 'modules/ida/js/services/idaService.svc.js';

var app = commonAllAgentsModule;
app.controller('db2SubclientContentController', [
	'$state',
	'cvUtil',
	'cvLoc',
	'$uibModalInstance',
	'$log',
	'idaService',
	'data',
	function($state, cvUtil, cvLoc, $modalInstance, $log, idaService, data) {
		var self = this;
		self.entity = angular.copy(data.subclientDetails.subClientEntity);
		self.entity.subclientName = '';

		let db2SubclientProp = data.subclientDetails.db2SubclientProp;
		self.subclientInfo = {
			dataBackup: db2SubclientProp.db2BackupData ? true : false,
			logBackup: db2SubclientProp.db2BackupLogFiles ? true : false,
			archiveDelete: db2SubclientProp.db2DeleteLogFilesAfter ? true : false,
			onlineSubset: db2SubclientProp.db2BackupType === 'DATABASE_SUBSET'
		};

		if (db2SubclientProp.db2BackupMode && db2SubclientProp.db2BackupMode === 'ONLINE_BACKUP') {
			self.subclientInfo.backupMode = '0';
		} else {
			self.subclientInfo.backupMode = '1';
		}

		self.contentList = [];
		self.localLang = cvUtil.getIStevenLocLabels();
		self.selectedcontentList = [];

		self.tree = {
			id: self.entity.backupsetName,
			label: self.entity.backupsetName,
			parent: '',
			isSelected: false,
			userObject: {},
			state: 'collapsed'
		};

		self.folderDrilledDown = function(item, event) {
			event.preventDefault();
			self.toggle(item);
			//item.state = item.state == 'expanded' ? 'collapsed' : 'expanded';
		};

		self.isParentSelected = function(item) {
			if (!item || !item.parent) {
				return false;
			}
			if (item.parent.isSelected) {
				return true;
			} else {
				return self.isParentSelected(item.parent);
			}
		};

		self.isNodeSelected = function(item) {
			if (item.isSelected) {
				return true;
			} else {
				return false;
			}
		};
		self.updateChildrenStatue = function(items, state) {
			angular.forEach(items, function(item) {
				item.isSelected = state;
				if (item.children) {
					self.updateChildrenStatue(item.children, state);
				}
			});
		};

		self.folderSelected = function(item) {
			var nodeState = false;
			if (item.isSelected == false) {
				nodeState = true;
			} else {
				nodeState = false;
			}
			item.isSelected = nodeState;
			if (item.children) {
				self.updateChildrenStatue(item.children, nodeState);
			}
			self.updateParentStatus(item.parent);
			self.expand(item);
		};

		self.updateParentStatus = function(item) {
			if (item) {
				item.isSelected = true;
				angular.forEach(item.children, function(child) {
					if (!child.isSelected) {
						item.isSelected = false;
					}
				});
				self.updateParentStatus(item.parent);
			}
		};

		/*
		 */
		self.toggle = function(item) {
			if (item.state == 'expanded') {
				item.state = 'collapsed';
			} else {
				self.expand(item);
			}
		};
		self.expand = function(item) {
			if (!item.loaded) {
				self.loadChildren(item);
			}
			item.state = 'expanded';
		};

		//Loading children for the content tree.
		self.loadChildren = function(item) {
			if (item.fileType && item.fileType == 'TABLESPACE') {
				item.loaded = true;
				return;
			}
			var instanceId = self.entity.instanceId;
			var options = new Object();
			options['path'] = '/';
			idaService.getIdaBrowseData(self.entity.backupsetId, 'BACKUPSET_ENTITY', options).then(function(data) {
				var isNodeSelected = function(nodeName) {
					if (self.selectedcontentList) {
						for (var i = 0; i < self.selectedcontentList.length; i++) {
							var db2TableSpace = _.get(self.selectedcontentList[i], 'db2Content.db2TableSpace');
							if (db2TableSpace === nodeName) {
								return true;
							}
						}
					}
					return false;
				};
				var subItems = data.browseData;
				if (
					item.id === self.entity.instanceName &&
					subItems &&
					subItems.length > 0 &&
					self.subclientInfo.onlineSubset &&
					!self.selectedcontentList
				) {
					// for the root node, in case children's present, then mark it as selected
					item.isSelected = true;
				}
				angular.forEach(subItems, function(browseItem) {
					browseItem.parent = item;
					browseItem.state = 'collapsed';
					if (item.isSelected || isNodeSelected(browseItem.label)) {
						browseItem.isSelected = true;
					}
				});

				item.children = subItems;
				item.loaded = true;
			});
		};

		var selectedNodes = function(treeNode) {
			var selectedList = [];
			if (treeNode.isSelected === true) {
				selectedList.push(treeNode);
			} else if (treeNode.children) {
				angular.forEach(treeNode.children, function(childTreeNode) {
					if (childTreeNode.isSelected === true) {
						selectedList.push(childTreeNode);
					} else if (childTreeNode.children) {
						var childSelection = selectedNodes(childTreeNode);
						angular.forEach(childSelection, function(node) {
							selectedList.push(node);
						});
					}
				});
			}
			return selectedList;
		};

		var getSelecteNodes = function(tree) {
			var selectedList = selectedNodes(tree);
			return selectedList;
		};

		self.onlineSubsetSelected = function(onlineSubset) {
			if (onlineSubset) {
				self.toggle(self.tree);
			}
		};

		var loadContentData = function() {
			idaService
				.getSubClientContent({
					genericEntity: JSON.stringify(self.entity)
				})
				.success(function(data) {
					if (data) {
						let skipLogs = _.get(data, 'db2SubclientProp.skipLogsInBackupImage');
						self.subclientInfo.excludeLogImage = skipLogs === 1;
						if (data.content) {
							self.selectedcontentList = data.content;
						}
					}
					//self.selectedcontentList = ['TBSPFIVE21','TBSPFIVE31']
					self.toggle(self.tree);
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		loadContentData();

		let isValideContent = function() {
			self.serverMessage = cvUtil.emptyMsg();
			if (!self.subclientInfo.dataBackup && !self.subclientInfo.logBackup) {
				self.serverMessage = cvUtil.errMsg(cvLoc('label.dataSelectionMessage'));
				return false;
			}

			self.selectedcontentList = getSelecteNodes(self.tree);
			if (
				self.subclientInfo.dataBackup &&
				self.subclientInfo.onlineSubset &&
				self.selectedcontentList &&
				self.selectedcontentList.length <= 0
			) {
				self.serverMessage = cvUtil.errMsg(cvLoc('label.contentSelectionMessage'));
				return false;
			}
			return true;
		};
		self.modifySubclientContent = function() {
			if (!isValideContent()) {
				return;
			}
			$log.debug('modifying subclient Content');

			// update only content specific info.

			var subPropInfo = new Object();

			//DB2 Option setting
			var db2SubclientProp = new Object();
			db2SubclientProp.db2BackupData = self.subclientInfo.dataBackup;
			db2SubclientProp.db2BackupMode = self.subclientInfo.backupMode;
			db2SubclientProp.db2BackupLogFiles = self.subclientInfo.logBackup;
			db2SubclientProp.db2DeleteLogFilesAfter = self.subclientInfo.archiveDelete;
			db2SubclientProp.numberOfBackupStreams = self.subclientInfo.numberBackupStreams;
			var skipLogsInBackupImage = 0;
			if (self.subclientInfo.excludeLogImage) {
				skipLogsInBackupImage = 1;
			}
			db2SubclientProp.skipLogsInBackupImage = skipLogsInBackupImage;

			subPropInfo.db2SubclientProp = db2SubclientProp;

			subPropInfo.planEntity = {
				planId: self.subclientInfo.selectedPlan
			};
			var db2ContentList = [];
			angular.forEach(self.selectedcontentList, function(nodeData) {
				var db2Content = new Object();
				db2Content.db2TableSpace = nodeData.label;
				var content = new Object();
				content.db2Content = db2Content;
				db2ContentList.push(content);
			});
			if (self.subclientInfo.onlineSubset) {
				subPropInfo.content = db2ContentList;
				subPropInfo.contentOperationType = 1;
				subPropInfo.db2SubclientProp.db2BackupType = 1;
			} else {
				subPropInfo.db2SubclientProp.db2BackupType = 0;
			}

			idaService
				.updateSubclient({
					subClientEntity: JSON.stringify(self.entity),
					contentInJson: null,
					subclientInfo: JSON.stringify(subPropInfo)
				})
				.success(function(data) {
					if (data) {
						$log.debug('Subclient content modified');
						$state.forceReload();
						self.closeModal();
					} else {
						$log.debug('Failure in Content Modification');
						$state.forceReload();
						$modalInstance.dismiss('cancel');
					}
				})
				.error(function(e) {
					if (!e) {
						e = cvLoc('generic_error');
					}
					$log.error(e);
					self.serverMessage1 = cvUtil.errMsg(e);
				});
		};

		self.cancel = function() {
			$modalInstance.dismiss();
		};
		self.closeModal = function(result) {
			$modalInstance.close();
		};
	}
]);

export default app;
