import { commonAllAgentsModule } from 'common/js/modules';

var app = commonAllAgentsModule;

app.directive('cvDb2DatafilesTable', [
	'cvLoc',
	'cvTableOptions',
	function(cvLoc, cvTableOptions) {
		return {
			restrict: 'AE',
			scope: {},
			bindToController: {
				datafiles: '='
			},
			template: '<cv-grid cv-grid-options="datafileCtrl.gridOptions" > </cv-grid>',
			controllerAs: 'datafileCtrl',
			controller: [
				'cvLoc',
				function(cvLoc) {
					var self = this;
					this.$onInit = function() {
						self.dataFiles = self.datafiles;
					};
					var getContentList = function() {
						var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
						angular.extend(globalGridOptions, {
							data: 'dataFiles',
							enableGridMenu: false,
							columnDefs: [
								{
									field: 'dataFile',
									displayName: cvLoc('label.paths'),
									cellTemplate: '<input name="dateFilePath" id="dateFilePath" data-ng-model="row.entity" />'
								}
							]
						});

						self.gridOptions = {
							cvHasTitle: false,
							cvAppScope: self,
							cvTableName: 'redirectStorageGroupsTable',
							cvHasViews: false,
							cvIsSearchable: false,
							gridOptions: globalGridOptions
						};
					};
					getContentList();
				}
			]
		};
	}
]);

app.controller('db2StorageGroupsCtrl', [
	'$scope',
	'$log',
	'cvTableOptions',
	'cvLoc',
	'$uibModal',
	'$uibModalInstance',
	'idaService',
	'profileService',
	'data',
	function($scope, $log, cvTableOptions, cvLoc, $modal, $modalInstance, idaService, profileService, data) {
		var self = this;

		//status will store the accordion open and close states
		self.entity = data.entity;
		self.selectedRows = data.selectedRows;
		self.clientEntity = data.clientEntity;
		self.showStorageGroups = true;

		self.storageGroup = [];

		var loadData = function() {
			idaService.getDb2StorageGroups(self.entity.backupsetId).success(function(data) {
				if (data && data.groupInfo && data.groupInfo.storageGroup && data.groupInfo.storageGroup.length > 0) {
					self.storageGroup = data.groupInfo.storageGroup;
					self.storageGroup[0].status = true;
				}
			});
		};

		if (!data.storageGroup) {
			loadData();
		} else {
			self.storageGroup = data.storageGroup;
		}

		self.closeDialogBox = function(result) {
			//self.$close();
			$modalInstance.close();
		};

		self.showFinsAndReplaceDialog = function() {
			var findAndReplaceCtrl = [
				'cvLoc',
				'$uibModalInstance',
				'$dialogs',
				function(cvLoc, $modalInstance, $dialogs) {
					var self = this;
					self.data = {
						findStr: '',
						replaceStr: ''
					};

					self.closeDialogBox = function(result) {
						$modalInstance.close();
					};

					self.save = function() {
						var callBackFunctions = {
							noFunction: function() {},
							yesFunction: function() {
								$modalInstance.close(self.data);
							}
						};
						$dialogs.confirm(
							cvLoc('label.findAndReplace'),
							cvLoc('label.frConfirmation', '<b>' + self.data.findStr + '</b>', '<b>' + self.data.replaceStr + '</b>'),
							callBackFunctions
						);
					};
				}
			];
			var modelInsta = $modal.open({
				controller: findAndReplaceCtrl,
				controllerAs: 'fReplace',
				backdrop: 'static',
				templateUrl: appUtil.appRoot + 'modules/ida/partials/oracleRedirectFindAndReplace.jsp'
			});
			modelInsta.result.then(function(replaceOptions) {
				if (replaceOptions && replaceOptions.findStr && replaceOptions.replaceStr) {
					self.showStorageGroups = false;
					self.storageGroup.forEach(function(sGroup) {
						let paths = [];
						sGroup.stoPaths.forEach(function(dataFileNode) {
							dataFileNode = dataFileNode.replace(replaceOptions.findStr, replaceOptions.replaceStr);
							paths.push(dataFileNode);
						});
						sGroup.stoPaths = paths;
					});
					self.showStorageGroups = true;
				}
			});
		};

		self.savePaths = function() {
			$modalInstance.close(self.storageGroup);
		};
		//
	}
]);

export default app;
