import { commonAllAgentsModule } from 'common/js/modules';
import 'modules/ida/js/services/idaService.svc.js';
import 'adminConsole/js/factories/associateSchedulePolicy.factory.js';
import 'adminConsole/js/directives/cv-entity-plan-policy-tiles.js';
import 'adminConsole/js/factories/planPolicyModel.factory.js';

var app = commonAllAgentsModule;

app.controller('db2CreateSubclientCtrl', [
	'$log',
	'idaService',
	'$state',
	'cvLoc',
	'cvUtil',
	'$uibModalInstance',
	'data',
	'associateSchedulePolicy',
	'planPolicyModel',
	'TREE_NODE_STATE',
	'AppTypes',
	function(
		$log,
		idaService,
		$state,
		cvLoc,
		cvUtil,
		$modalInstance,
		data,
		associateSchedulePolicy,
		planPolicyModel,
		TREE_NODE_STATE,
		AppTypes
	) {
		var self = this;
		self.entity = angular.copy(data.entity);
		self.editing = data.editing;
		self.isStreamsApplicable = self.entity.applicationId !== AppTypes.DB2_MultiNode && !self.editing;
		self.contentList = [];
		self.selectedcontentList = [];
		self.isSnapBackupEnabled = false;
		self.showStreams = false;
		self.db2dpfdata = {};
		var loadContentData = function() {
			idaService
				.getSubClientContent({
					genericEntity: JSON.stringify(self.entity)
				})
				.success(function(data) {
					if (data) {
						let skipLogs = _.get(data, 'db2SubclientProp.skipLogsInBackupImage');
						self.subclientInfo.excludeLogImage = skipLogs === 1;
						if (data.content) {
							self.selectedcontentList = data.content;
						}
					}
					self.toggle(self.tree);
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		if (self.editing) {
			self.isSnapBackupEnabled = _.get(
				data,
				'subclientDetails.commonProperties.snapCopyInfo.isSnapBackupEnabled',
				false
			);
			let db2SubclientProp = data.subclientDetails.db2SubclientProp;
			self.subclientInfo = {
				dataBackup: db2SubclientProp.db2BackupData ? true : false,
				logBackup: db2SubclientProp.db2BackupLogFiles ? true : false,
				archiveDelete: db2SubclientProp.db2DeleteLogFilesAfter ? true : false,
				onlineSubset: db2SubclientProp.db2BackupType === 'DATABASE_SUBSET',
				numberBackupStreams: db2SubclientProp.numberBackupStreams
			};

			if (db2SubclientProp.db2BackupMode && db2SubclientProp.db2BackupMode === 'ONLINE_BACKUP') {
				self.subclientInfo.backupMode = '0';
			} else {
				self.subclientInfo.backupMode = '1';
			}
			loadContentData();
		} else {
			self.entity.subclientName = '';
			self.entity.subclientId = 0;
			self.subclientInfo = {
				selectedPlan: null,
				content: [],
				dataBackup: true,
				logBackup: false,
				archiveDelete: false,
				backupMode: '0',
				numberBackupStreams: 2,
				commonProperties: {
					description: '',
					enableBackup: true
				}
			};
			self.showExcludeLogImage = self.entity.applicationId === AppTypes.DB2_MultiNode ? false : true;
			self.showStreams = self.entity.applicationId === AppTypes.DB2_MultiNode;
			self.planPolicyModel = planPolicyModel.get('Default');
			self.planPolicyModel.plan = {
				selected: _.get(data, 'subclientDetails.planEntity', null)
			};
			self.showPlan = cv.sessionContext.showPlans;
		}

		self.tree = {
			id: self.entity.backupsetName,
			label: self.entity.backupsetName,
			parent: '',
			isSelected: false,
			userObject: {},
			state: 'collapsed'
		};

		self.folderDrilledDown = function(item, event) {
			event.preventDefault();
			self.toggle(item);
			//item.state = item.state == 'expanded' ? 'collapsed' : 'expanded';
		};

		self.isParentSelected = function(item) {
			if (!item || !item.parent) {
				return false;
			}
			if (item.parent.isSelected) {
				return true;
			} else {
				return self.isParentSelected(item.parent);
			}
		};

		self.isNodeSelected = function(item) {
			if (item.isSelected) {
				return true;
			} else {
				return false;
			}
		};
		self.updateChildrenStatue = function(items, state) {
			angular.forEach(items, function(item) {
				item.isSelected = state;
				if (item.children) {
					self.updateChildrenStatue(item.children, state);
				}
			});
		};

		self.folderSelected = function(item) {
			var nodeState = false;
			if (item.isSelected == false) {
				nodeState = true;
			} else {
				nodeState = false;
			}
			item.isSelected = nodeState;
			if (item.children) {
				self.updateChildrenStatue(item.children, nodeState);
			}
			self.updateParentStatus(item.parent);
			self.expand(item);
		};

		self.updateParentStatus = function(item) {
			if (item) {
				item.isSelected = true;
				angular.forEach(item.children, function(child) {
					if (!child.isSelected) {
						item.isSelected = false;
					}
				});
				self.updateParentStatus(item.parent);
			}
		};

		/*
		 */
		self.toggle = function(item) {
			if (item.state == 'expanded') {
				item.state = 'collapsed';
			} else {
				self.expand(item);
			}
		};
		self.expand = function(item) {
			if (!item.loaded) {
				self.loadChildren(item);
			}
			item.state = 'expanded';
		};

		//Loading children for the content tree.
		self.loadChildren = function(item) {
			if (item.fileType && item.fileType == 'TABLESPACE') {
				item.loaded = true;
				return;
			}
			var options = new Object();
			options['path'] = '/';
			idaService.getIdaBrowseData(self.entity.backupsetId, 'BACKUPSET_ENTITY', options).then(function(data) {
				var subItems = data.browseData; //acBrowseUtils.getBrowswItems('oracleBrowse',data.browseData);
				if (!self.editing && item.id === self.entity.backupsetName && subItems && subItems.length > 0) {
					// for the root node, in case children's present, then mark it as selected
					item.isSelected = true;
				}
				var parentNodeList = [];
				var parentNodeMap = {};
				angular.forEach(subItems, function(browseItem) {
					var isNodeSelected = function(nodeName) {
						if (self.selectedcontentList) {
							for (var i = 0; i < self.selectedcontentList.length; i++) {
								var db2TableSpace = _.get(self.selectedcontentList[i], 'db2Content.db2TableSpace');
								if (db2TableSpace === nodeName) {
									return true;
								}
							}
						}
						return false;
					};
					var parentNode = null;
					if (self.entity.applicationId === AppTypes.DB2_MultiNode) {
						var nodeName = browseItem.label;
						var nodeName = nodeName.substring(nodeName.indexOf('_') + 1);
						parentNode = parentNodeMap[nodeName];
						if (parentNode) {
							parentNode.children.push(browseItem);
						} else {
							parentNode = {
								id: nodeName,
								label: nodeName,
								fileType: 'PDB',
								state: 'collapsed',
								isSelected: item.isSelected,
								leafNode: false,
								loaded: true,
								children: [browseItem],
								parent: item
							};
							parentNodeMap[nodeName] = parentNode;
							parentNodeList.push(parentNode);
						}
						browseItem.parent = parentNode;
						browseItem.state = 'collapsed';
						if (item.isSelected || isNodeSelected(browseItem.label)) {
							browseItem.isSelected = true;
						} else {
							browseItem.isSelected = false;
						}
					} else {
						browseItem.parent = item;
						browseItem.state = 'collapsed';
						if (item.isSelected || isNodeSelected(browseItem.label)) {
							browseItem.isSelected = true;
						} else {
							browseItem.isSelected = false;
						}
					}
				});

				if (self.entity.applicationId === AppTypes.DB2_MultiNode) {
					item.children = parentNodeList;
				} else {
					item.children = subItems;
				}
				item.loaded = true;
			});
		};

		var selectedNodes = function(treeNode) {
			var selectedList = [];
			if (treeNode.isSelected === true) {
				selectedList.push(treeNode);
			} else if (treeNode.children) {
				angular.forEach(treeNode.children, function(childTreeNode) {
					if (childTreeNode.isSelected === true) {
						selectedList.push(childTreeNode);
					} else if (childTreeNode.children) {
						var childSelection = selectedNodes(childTreeNode);
						angular.forEach(childSelection, function(node) {
							selectedList.push(node);
						});
					}
				});
			}
			return selectedList;
		};

		var getSelecteNodes = function(tree) {
			var selectedList = selectedNodes(tree);
			return selectedList;
		};

		/**
		 * associate schedule policy to sub client param: (wr) subclient id
		 */
		self.associateScheduleToSubclient = function(data, showPlan) {
			if (!showPlan) {
				/* association obj */
				let subclientDetails = {
					appId: self.entity.applicationId,
					clientId: self.entity.clientId,
					subclientId: data
				};
				let schedules = self.planPolicyModel.schedulePolicy;
				if (schedules && schedules.selected) {
					associateSchedulePolicy
						.associateSchedulePolicyToSubClient(subclientDetails, schedules.selected)
						.success(function(successData) {
							$state.forceReload();
							self.closeModal();
						})
						.error(function(errorMessage) {
							self.serverMessage = {
								message: errorMessage,
								type: 'error'
							};
						});
				}
			} else {
				$state.forceReload();
				self.closeModal();
			}
		};

		let isValideContent = function() {
			self.serverMessage = cvUtil.emptyMsg();
			if (!self.subclientInfo.dataBackup && !self.subclientInfo.logBackup) {
				self.serverMessage = cvUtil.errMsg(cvLoc('label.dataSelectionMessage'));
				return false;
			}
			self.selectedcontentList = getSelecteNodes(self.tree);
			if (
				self.subclientInfo.dataBackup &&
				self.subclientInfo.onlineSubset &&
				self.selectedcontentList &&
				self.selectedcontentList.length <= 0
			) {
				self.serverMessage = cvUtil.errMsg(cvLoc('error.contentTSSelectionMessage'));
				return false;
			}
			return true;
		};

		self.dataBackupSelected = function() {
			if (!self.subclientInfo.dataBackup) {
				self.subclientInfo.onlineSubset = false;
			}
		};
		self.updateExcludeLogs = function() {
			if (
				self.entity.applicationId === AppTypes.DB2_MultiNode ||
				self.subclientInfo.backupMode === '1' ||
				self.subclientInfo.onlineSubset
			) {
				self.showExcludeLogImage = false;
			} else {
				self.showExcludeLogImage = true;
			}

			self.subclientInfo.logBackup = self.subclientInfo.backupMode === '0';
			self.updateLogBackupSelection();

			if (self.subclientInfo.onlineSubset) {
				if (!self.editing) {
					self.toggle(self.tree);
				}
			}
		};

		self.updateLogBackupSelection = function() {
			if (!self.subclientInfo.logBackup && self.subclientInfo.archiveDelete) {
				self.subclientInfo.archiveDelete = false;
			}
		};

		self.createSubclient = function() {
			let showPlan = true;
			if (!self.editing) {
				showPlan = planPolicyModel.getPlanModeState();
				self.serverMessage = {
					message: '',
					type: ''
				};
				$log.log('Creating new subclient.');
				if (showPlan) {
					self.planPolicyModel.plan.showError = false;
				}
				self.planPolicyModel.storagePolicy.showError = false;
				var storageDevice = new Object();
				if (showPlan) {
					if (self.planPolicyModel.plan.selected == null) {
						self.planPolicyModel.plan.showError = true;
						return;
					}
					self.subclientInfo.selectedPlan = self.planPolicyModel.plan.selected.id;
				} else {
					if (self.planPolicyModel.storagePolicy.selected == null) {
						self.planPolicyModel.storagePolicy.showError = true;
						return;
					}
					/*
					 * if (self.planPolicyModel.logStoragePolicy.selected == null) {
					 * self.planPolicyModel.logStoragePolicy.showError = true; return; }
					 */
					storageDevice.dataBackupStoragePolicy = self.planPolicyModel.storagePolicy.selected.obj;
					storageDevice.logBackupStoragePolicy = self.planPolicyModel.storagePolicy.selected.obj;
				}
			}

			if (!isValideContent()) {
				return;
			}
			var commonProperties = new Object();
			commonProperties.storageDevice = storageDevice;

			var subPropInfo = new Object();
			subPropInfo.commonProperties = commonProperties;

			//DB2 Option setting
			var db2SubclientProp = new Object();
			db2SubclientProp.db2UseDedupeDevice = true;

			db2SubclientProp.db2BackupData = self.subclientInfo.dataBackup;
			db2SubclientProp.db2BackupMode = self.subclientInfo.backupMode;
			db2SubclientProp.db2BackupLogFiles = self.subclientInfo.logBackup;
			db2SubclientProp.db2DeleteLogFilesAfter = self.subclientInfo.archiveDelete;
			db2SubclientProp.numberOfBackupStreams = self.subclientInfo.numberBackupStreams;
			if (self.entity.applicationId === AppTypes.DB2_MultiNode && self.db2dpfdata.db2DpfStreams) {
				db2SubclientProp.db2DpfStreams = self.db2dpfdata.db2DpfStreams;
				db2SubclientProp.numberOfBackupStreams = self.db2dpfdata.numberOfBackupStreams;
			}

			var skipLogsInBackupImage = 0;
			if (self.subclientInfo.excludeLogImage) {
				skipLogsInBackupImage = 1;
			}
			db2SubclientProp.skipLogsInBackupImage = skipLogsInBackupImage;

			subPropInfo.db2SubclientProp = db2SubclientProp;

			if (!self.editing) {
				subPropInfo.planEntity = {
					planId: self.subclientInfo.selectedPlan
				};
			}
			var db2ContentList = [];
			var tempSelectedList = [];
			if (self.entity.applicationId === AppTypes.DB2_MultiNode) {
				angular.forEach(self.selectedcontentList, function(nodeData) {
					if (nodeData.children) {
						tempSelectedList = tempSelectedList.concat(nodeData.children);
					} else {
						tempSelectedList.push(nodeData);
					}
				});
			} else {
				tempSelectedList = self.selectedcontentList;
			}
			angular.forEach(tempSelectedList, function(nodeData) {
				var db2Content = new Object();
				db2Content.db2TableSpace = nodeData.label;
				var content = new Object();
				content.db2Content = db2Content;
				db2ContentList.push(content);
			});
			if (self.subclientInfo.dataBackup) {
				if (self.subclientInfo.onlineSubset) {
					subPropInfo.content = db2ContentList;
					subPropInfo.contentOperationType = 2;
					subPropInfo.db2SubclientProp.db2BackupType = 1;
				} else {
					subPropInfo.db2SubclientProp.db2BackupType = 0;
				}
			}

			var subClientEntity = self.entity;
			var scEntity = angular.toJson(subClientEntity);
			var subInfo = angular.toJson(subPropInfo);

			var content = [];
			var serverObject = {
				subClientEntity: scEntity,
				subclientInfo: subInfo,
				content: JSON.stringify(content),
				planId: null
			};

			idaService
				.createSubclient(serverObject, self.editing)
				.success(function(data) {
					//associate schedule
					self.associateScheduleToSubclient(data, showPlan);
				})
				.error(function(e) {
					self.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		self.closeModal = function() {
			$modalInstance.close();
		};
	}
]);

export default app;
