import 'modules/ida/js/services/idaService.svc.js';
import 'storage/js/services/storage.svc.js';

import { commonAllAgentsModule } from 'common/js/modules';

var app = commonAllAgentsModule;

app.controller('db2CreateInstanceCtrl', [
	'$state',
	'cvLoc',
	'$uibModalInstance',
	'$log',
	'data',
	'cvToaster',
	'idaService',
	'cvUtil',
	'mbService',
	'AppTypes',
	'profileService',
	function(
		$state,
		cvLoc,
		$modalInstance,
		$log,
		data,
		cvToaster,
		idaService,
		cvUtil,
		mbService,
		AppTypes,
		profileService
	) {
		var self = this;

		if (!data.editDialog) {
			data.idaEntity.appName = 'DB2';
		}

		self.dbHomeResuleFunction = function(result) {
			if (result) {
				self.instInfo.dbHome = result.path;
			}
		};
		var populateDefaultValues = function(serverInstanceInfo) {
			var instInfo = new Object();

			var commandLineStoragePolicy = new Object();
			var logBackupStoragePolicy = new Object();
			var storageDevice = new Object();

			instInfo.password = '';
			instInfo.availableStoragePolicies = {};
			instInfo.dbUserName = '';
			instInfo.dbUserPassword = '';

			self.instanceEntity = data.idaEntity;
			self.instanceEntity.instanceName = '';
			self.instanceEntity.instanceId = -1;
			//Default storage policy values.

			commandLineStoragePolicy.storagePolicyId = null;
			commandLineStoragePolicy.storagePolicyName = null;

			logBackupStoragePolicy.storagePolicyId = null;
			logBackupStoragePolicy.storagePolicyName = null;

			storageDevice.commandLineStoragePolicy = commandLineStoragePolicy;
			storageDevice.logBackupStoragePolicy = logBackupStoragePolicy;
			self.storageDev = storageDevice;

			return instInfo;
		};

		var populateInstanceValues = function(serverInstanceInfo) {
			var instInfo = new Object();
			self.instanceEntity = angular.copy(serverInstanceInfo.instance);
			instInfo.dbUserName = serverInstanceInfo.db2Instance.userAccount.userName;
			if (serverInstanceInfo.db2Instance.userAccount.domainName) {
				instInfo.dbUserName = serverInstanceInfo.db2Instance.userAccount.domainName + '/' + instInfo.dbUserName;
			}
			instInfo.dbHome = serverInstanceInfo.db2Instance.homeDirectory;
			self.instancePlan = serverInstanceInfo.planEntity;
			return instInfo;
		};

		self.editDialog = data.editDialog;
		if (self.editDialog && self.editDialog === 'Add_Instance') {
			self.addInstance = true;
			self.editDialog = false;
			data.idaEntity.appName = 'DB2';
			self.clientSelection = {
				selectedClients: [],
				valideClientSelection: false,
				selectionChanged: function(clientEntity) {
					loadClientOsType(clientEntity.clientId);
				}
			};
		}

		var loadClientOsType = function(clientId) {
			self.isUnixClient = false;
			if (self.instanceEntity && clientId) {
				self.instanceEntity.clientId = clientId;
			}
			mbService.getOSType(clientId).then(function successCallBack(response) {
				self.isUnixClient = response.data.toLowerCase() == 'unix';

				if (self.isUnixClient) {
					self.instanceEntity.applicationId = AppTypes.DB2_On_Unix;
				} else {
					self.instanceEntity.applicationId = AppTypes.DB2;
				}
			});
		};

		if (self.editDialog && self.editDialog == true) {
			self.instInfo = populateInstanceValues(data.instanceDetails);
			loadClientOsType(self.instanceEntity.clientId);
			self.showPlanError = false;
		} else {
			self.showPlanError = true;
			self.instInfo = populateDefaultValues({});
		}

		self.selectedProfileList = [];
		self.parseIStevenOutput = function() {
			if (self.selectedProfileList && self.selectedProfileList.length > 0) {
				self.showPlanError = false;
			} else {
				self.showPlanError = true;
			}
		};

		self.loadPlans = function() {
			self.profileList = [];
			profileService
				.getEligiblePlansForApp(AppTypes.DB2)
				.success(function(data) {
					self.addServerMessage = cvUtil.emptyMsg();
					if (data.length > 0) {
						var planList = [];
						self.planListByTypes = {};
						angular.forEach(data, planData => {
							planData = planData.planSummary ? planData.planSummary : planData;
							const planObj = {
								name: planData.plan.planName,
								id: planData.plan.planId,
								type: planData.subtype,
								numAssocEntities: planData.numAssocEntities,
								numCopies: planData.numCopies,
								rpoInMinutes: planData.rpoInMinutes,
								planSummary: _.get(planData, 'plan.planSummary')
							};

							planList.push(planObj);
							if (self.planListByTypes[planObj.type]) {
								self.planListByTypes[planObj.type].push(planObj);
							} else {
								self.planListByTypes[planObj.type] = [planObj];
							}
						});
						var tempPlanList = [];
						for (var planType in self.planListByTypes) {
							tempPlanList.push({
								name: planType,
								msGroup: true
							});
							var plansByType = cvUtil.sortAscending(self.planListByTypes[planType], 'name');
							tempPlanList = tempPlanList.concat(plansByType);
							tempPlanList.push({
								msGroup: false
							});
						}
						self.profileList.push(...tempPlanList);
						if (self.editDialog && self.editDialog == true && self.instancePlan && self.instancePlan.planId) {
							let selectedPlans = self.profileList.filter(function(planNode) {
								return planNode.id == self.instancePlan.planId;
							});
							if (selectedPlans) {
								selectedPlans.forEach(function(planNode) {
									planNode.selected = true;
								});
								self.selectedProfileList.push(selectedPlans);
								self.showPlanError = false;
							}
						}
					} else {
						self.showPlan = false;
					}
				})
				.error(function(e) {
					self.serverMessage = cvUtil.errMsg(e);
				});
		};

		self.loadPlans();

		self.updateUserName = function() {
			if (self.isUnixClient) {
				self.instInfo.dbUserName = self.instanceEntity.instanceName;
			}
		};

		self.closeDialogBox = function(entity) {
			$modalInstance.close(entity);
		};

		// method to create the instance.
		self.createInstance = function() {
			var instanceEntity = self.instanceEntity;
			//In case of add instance dialog check for the client selection validation
			if (self.addInstance) {
				if (!self.clientSelection.valideClientSelection) {
					return;
				}
				if (self.clientSelection.selectedClients) {
					instanceEntity.clientName = self.clientSelection.selectedClients[0].clientName;
					instanceEntity.clientId = self.clientSelection.selectedClients[0].clientId;
				}
			}
			var instanceProperties = new Object();

			if (self.editDialog == false && (!self.selectedProfileList || self.selectedProfileList.length <= 0)) {
				return;
			}

			self.populateDB2Props(instanceProperties);
			if (self.selectedProfileList && self.selectedProfileList.length > 0) {
				var plan = self.selectedProfileList[0].id;
				instanceProperties.planEntity = {
					planId: plan
				};
			}
			var osPassword;
			if (self.editDialog && self.editDialog == true && self.instInfo.osUserPassword === '*****') {
				osPassword = null;
			} else {
				osPassword = self.instInfo.osUserPassword;
			}

			var password;
			if (self.editDialog && self.editDialog == true && self.instInfo.password === '*****') {
				password = null;
			} else {
				password = self.instInfo.password;
			}

			idaService
				.createInstance(
					{
						instanceEntity: angular.toJson(instanceEntity),
						instanceProps: angular.toJson(instanceProperties),
						password: password,
						osUserPassword: osPassword
					},
					self.editDialog
				)
				.success(function(data) {
					if (data != null && data.errorCode != undefined && data.errorCode != 0) {
						var msgStr = data.errorString;
						self.serverMessage = {
							message: msgStr,
							type: 'error'
						};
						self.instanceEntity.instanceId = data.entity.instanceId;
						self.editDialog = true;
						//$state.forceReload();
						return;
					}

					var msg = cvLoc('msg.createInstance');
					if (self.editDialog) {
						msg = cvLoc('msg.updateInstance');
					}

					cvToaster.showSuccessMessage({
						ttl: '15000',
						message: msg
					});

					//$state.forceReload();
					self.closeDialogBox(data.entity);
				})
				.error(function(e) {
					self.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		// Utility method to populate db2 specific values.
		self.populateDB2Props = function(instanceProperties) {
			var db2Instance = new Object();
			db2Instance.homeDirectory = self.instInfo.dbHome;

			var userAccount = new Object();
			var userName = self.instInfo.dbUserName;
			if (userName.indexOf('\\') != -1) {
				var userValues = userName.split('\\');
				userAccount.domainName = userValues[0];
				userAccount.userName = userValues[1];
			} else if (userName.indexOf('/') != -1) {
				var userValues = userName.split('/');
				userAccount.domainName = userValues[0];
				userAccount.userName = userValues[1];
			} else {
				userAccount.userName = userName;
			}
			if (self.instInfo.dbUserPassword) {
				userAccount.password = cvUtil.getBytes(self.instInfo.dbUserPassword);
			}

			db2Instance.userAccount = userAccount;

			db2Instance.DB2StorageDevice = {
				dataBackupStoragePolicy: {
					storagePolicyId: 1
				},
				logBackupStoragePolicy: {
					storagePolicyId: 1
				},
				commandLineStoragePolicy: {
					storagePolicyId: 1
				}
			};
			instanceProperties.db2Instance = db2Instance;
		};
	}
]);

export default app;
