import { commonAllAgentsModule } from 'common/js/modules';

import 'modules/ida/js/services/idaService.svc.js';

var app = commonAllAgentsModule;

app.controller('db2BackupOptionsCtrl', [
	'$q',
	'$rootScope',
	'$scope',
	'$location',
	'idaService',
	'$uibModalInstance',
	'$state',
	'cvLoc',
	'$log',
	'$uibModalStack',
	'data',
	'cvToaster',
	function(
		$q,
		$rootScope,
		$scope,
		$location,
		idaService,
		$modalInstance,
		$state,
		cvLoc,
		$log,
		$modalStack,
		data,
		cvToaster
	) {
		var self = this;

		self.entityType = data.entityType;
		self.genericEntity = data.entity;
		var deferred = data.deferred;

		self.backupType = 'FULL';
		self.showTransactionLogOption = false;
		self.showDifferentialOption = false;
		self.isSnapEnabled = _.get(data, 'otherOptions.isSnapEnabledBackup', false);
		self.isLogOnly = _.get(data, 'otherOptions.isLogOnly', false);

		self.cancel = function() {
			$modalInstance.dismiss();
		};

		self.closeModal = function(resp) {
			deferred.resolve(resp);
			$modalInstance.dismiss();
		};

		self.failAndCloseModal = function(resp) {
			deferred.reject(resp);
		};

		var getBackupOption = function() {
			var backupOptions = {};

			return backupOptions;
		};
		self.backup = function() {
			var deferred = $q.defer();
			var backupOptions = getBackupOption();
			idaService
				.backup(self.entityType, angular.toJson(self.genericEntity), self.backupType, angular.toJson(backupOptions))
				.success(function(wr) {
					var jobIds = wr.jobIds;
					var jobSummary = {
						jobId: jobIds[0],
						percentComplete: 0,
						status: 'Starting',
						sizeOfMediaOnDisk: 0,
						totalNumOfFiles: 0,
						jobElapsedTime: 0
					};
					var job = {
						jobSummary: jobSummary,
						showProgress: true,
						kill: true,
						suspend: true,
						resume: false
					};
					self.backupMsg = cvLoc('notification.backup.started');
					deferred.resolve(job);
				})
				.error(function(data, status, headers, config) {
					if (data !== null && data.trim() === 'Backup in progress') {
						self.backupMsg = data.trim();
						deferred.reject({
							running: true,
							data: data.trim()
						});
					} else {
						self.backupMsg = 'Failed: ' + data.trim();
						deferred.reject({
							running: false,
							data: data.trim()
						});
					}
				});
			return deferred.promise;
		};

		self.goToJob = function() {
			var top = $modalStack.getTop();
			if (top) {
				$modalStack.dismiss(top.key);
				event.preventDefault();
			}
			$location.path('jobs/' + self.backupJobId);
		};

		self.startBackup = function() {
			var result = {};
			result.backupType = self.backupType;
			self.loading = true;
			self.backup().then(
				function(resp) {
					self.loading = false;
					self.backupJobId = resp.jobSummary.jobId;
					self.closeModal(resp);
					var backupMsg = cvLoc('notification.backupJob', self.backupJobId);
					var viewMsg = cvLoc('notification.jobDetails');
					cvToaster.showSuccessMessage({
						ttl: '7000',
						message: backupMsg + ' <br><a href=#/jobs/' + self.backupJobId + '>' + viewMsg + '</a>'
					});
				},
				function(resp) {
					self.loading = false;
					self.backupMsg = resp.data;
					self.serverMessage = {
						type: 'error',
						message: resp.data
					};
					self.failAndCloseModal(resp);
				}
			);
		};
	}
]);

export default app;
