import 'adminConsole/js/controllers/instances.ctrl.js';
import 'modules/ida/js/services/sqlService.svc.js';
import 'modules/ida/js/services/idaService.svc.js';
import 'dbs/js/services/server.svc.js';
import 'modules/ida/js/services/dataMasking.svc.js';

import { acAppInstanceModule } from 'common/js/modules';

var dataMaskingMod = acAppInstanceModule;

var controllers = {};

controllers.dataMaskingController = [
	'idasFactory',
	'$stateParams',
	'cvTableOptions',
	'$uibModal',
	'$dialogs',
	'dataMaskingService',
	'dbServerService',
	'idaService',
	'instanceFactory',
	'cvLoc',
	'cvUtil',
	'cvBreadcrumbsTabsFactory',
	'cvToaster',
	'sqlService',
	'AppTypes',
	function(
		idasFactory,
		$stateParams,
		cvTableOptions,
		$uibModal,
		$dialogs,
		dataMaskingService,
		dbServerService,
		idaService,
		instanceFactory,
		cvLoc,
		cvUtil,
		cvBreadcrumbsTabsFactory,
		cvToaster,
		sqlService,
		AppTypes
	) {
		var self = this;

		self.policies = [];

		function refreshPolicies() {
			self.dataLoaded = false;
			self.policies.length = 0;
			self.serverMessage = {
				message: cvLoc('Loading')
			};

			dataMaskingService.getPoliciesForInstance($stateParams.instanceId).then(
				function(resp) {
					self.policies.push.apply(self.policies, resp.data);
					self.serverMessage = {};

					self.dataLoaded = true;
				},
				function(err) {
					self.serverMessage = cvUtil.errMsg(err.data || cvLoc('connection.error'));
				}
			);
		}
		refreshPolicies();

		self.instance = {};
		self.subclient = {};
		instanceFactory.getInstanceDetails($stateParams.instanceId).then(function() {
			self.instance = instanceFactory.instanceDetail.instance;

			instanceFactory
				.getSubclientsList(self.instance.clientId, self.instance.applicationId, self.instance.instanceId)
				.then(function() {
					self.subclient = instanceFactory.subclients[0].subClientEntity;
				});

			idasFactory.loadBreadCrumbs(self.instance, 'DBS_SUBCLIENT_ENTITY');
		});

		function openEditModal(oldPolicy, isNew, instance) {
			$uibModal.open({
				templateUrl: appUtil.appRoot + 'modules/ida/partials/maskingEditModal.jsp',
				//windowClass: 'masking-modal-window',
				//disable dismissing on clicking outside / escape
				backdrop: 'static',
				keyboard: false,
				controllerAs: 'modCtrl',
				controller: [
					'$uibModalInstance',
					function($modalInstance) {
						var modScope = this;
						modScope.maskingTypes = {
							SHUFFLING: {
								id: 'SHUFFLING',
								name: cvLoc('label.type.shuffling.name'),
								params: []
							},
							NUMERIC_RANGE: {
								id: 'NUMERIC_RANGE',
								name: cvLoc('label.type.numeric_range.name'),
								params: [
									{
										name: cvLoc('label.type.numeric_range.min'),
										type: 'number',
										value: 1000
									},
									{
										name: cvLoc('label.type.numeric_range.max'),
										type: 'number',
										value: 2000
									}
								]
							},
							NUMERIC_VARIANCE: {
								id: 'NUMERIC_VARIANCE',
								name: cvLoc('label.type.numeric_variance.name'),
								params: [
									{
										name: cvLoc('label.type.numeric_variance.max_percent'),
										type: 'number',
										value: 50
									}
								]
							},
							FPE_ALPHANUMERIC: {
								id: 'FPE_ALPHANUMERIC',
								name: cvLoc('label.type.fpe_alphanumeric.name'),
								params: []
							},
							FIXED_STRING: {
								id: 'FIXED_STRING',
								name: cvLoc('label.type.fixed_string.name'),
								params: [
									{
										name: cvLoc('label.type.fixed_string.string'),
										type: 'text',
										value: 'none'
									}
								]
							}
						};
						var numberTypes = ['INT', 'FLOAT', 'DOUBLE'];
						var fpeNumberTypes = ['NUMBER', 'NUMERIC', 'DECIMAL'];
						var charTypes = ['CHAR'];
						var foreignKeys = {};
						//Separator for table paths, e.g. database + SEP + schema + SEP + table
						var SEP = '\t';

						//Change this for different IDAs
						modScope.isMultiDatabase = function() {
							return instance.applicationId == AppTypes.SQL_SERVER;
						};

						//Change this for different IDAs,
						//E.g. Oracle uses schema.table
						//SQL might use schema.table or [schema].[table]
						function splitSchemaTable(schemaTable) {
							if (instance.applicationId == AppTypes.SQL_SERVER && schemaTable.indexOf('[') == 0) {
								return {
									schema: schemaTable.substring(schemaTable.indexOf('[') + 1, schemaTable.indexOf(']')),
									table: schemaTable.substring(schemaTable.lastIndexOf('[') + 1, schemaTable.lastIndexOf(']'))
								};
							} else {
								var tokens = schemaTable.split('.');
								return {
									schema: tokens[0],
									table: tokens[1]
								};
							}
						}

						modScope.modalOptions = {
							headerText: isNew ? cvLoc('label.createPolicy') : cvLoc('label.editPolicy'),
							closeButtonText: cvLoc('Cancel'),
							actionButtonText: isNew ? cvLoc('label.create') : cvLoc('action.save'),
							ok: function() {
								if (modScope.flattenedConfig.length === 0) {
									modScope.serverMessage = cvUtil.errMsg(cvLoc('help.no_masks'));
									return;
								} else if (modScope.confirmButtonDisabledReason()) {
									return;
								}

								var tables = {};
								angular.forEach(modScope.flattenedConfig, function(c) {
									const key = `${c.database}${SEP}${c.schema}${SEP}${c.table}`;
									if (!(key in tables)) {
										tables[key] = {
											columns: [],
											name: c.table,
											schema: c.schema
										};
										if (modScope.isMultiDatabase()) {
											tables[key].database = c.database;
										}
									}
									var newCol = {
										name: c.column,
										type: c.type
									};
									if (c.arguments && c.arguments.length > 0) {
										newCol.arguments = c.arguments;
									}
									tables[key].columns.push(newCol);
								});

								modScope.policy.config = {
									tables: []
								};
								//Convert object to array
								angular.forEach(tables, function(value) {
									modScope.policy.config.tables.push(value);
								});

								var saveFunc = isNew
									? dataMaskingService.createNewPolicyForInstance
									: dataMaskingService.modifyPolicyForInstance;

								saveFunc($stateParams.instanceId, modScope.policy).then(
									function(resp) {
										refreshPolicies();
										$modalInstance.close();

										var message = 'label.policyEditSuccess';
										if (isNew) {
											message = 'label.policyCreateSuccess';
										}
										cvToaster.showSuccessMessage({
											message: cvLoc(message, '<b>' + modScope.policy.policy.policyName + '</b>')
										});
									},
									function(err) {
										modScope.serverMessage = cvUtil.errMsg(err.data);
									}
								);

								modScope.serverMessage = {
									message: cvLoc('Loading')
								};
							},
							close: function() {
								$modalInstance.close();
							}
						};

						modScope.policy = angular.extend(
							{
								policy: {
									policyName: ''
								},
								config: []
							},
							angular.copy(oldPolicy)
						);

						modScope.columnSelectText = cvUtil.getIStevenLocLabels();
						modScope.columnSelectText.nothingSelected = cvLoc('help.column');

						modScope.serverMessage = {};

						modScope.databaseLoading = modScope.isMultiDatabase();
						modScope.schemaLoading = false;
						modScope.columnsLoading = false;

						modScope.databaseOptions = [];
						modScope.schemaOptions = [];

						dataMaskingService.invalidateCache();

						modScope.tableOptions = [];
						//For isteven input model can't be a list of strings.
						modScope.tableOptionsObjectList = [];
						modScope.columnOptions = [];

						modScope.selectedDatabase = '';
						modScope.selectedSchema = '';
						modScope.selectedTable = '';
						modScope.selectedColumns = [];
						modScope.selectedMaskType = '';
						modScope.requiredParams = [];
						modScope.maskTypeOptions = [];

						var columnPromise, allColumns;

						//convert to list of column configurations for easier display
						modScope.flattenedConfig = [];
						angular.forEach(modScope.policy.config.tables, function(t) {
							//We are using a new format from SP12, i.e. put schema and table in different fields,
							//Older policies have empty schema field, so we need to check if schema is empty to handle both formats
							if (!t.schema) {
								var schemaTable = splitSchemaTable(t.name);
								t.schema = schemaTable.schema;
								t.name = schemaTable.table;
							}
							angular.forEach(t.columns, function(c) {
								modScope.flattenedConfig.push({
									database: t.database ? t.database : '',
									schema: t.schema,
									table: t.name,
									column: c.name,
									type: c.type,
									arguments: c.arguments
								});
							});
						});

						//Different IDAs have different ways to get databases, add code here for new IDAs
						modScope.updateDatabases = function() {
							if (AppTypes.SQL_SERVER == instance.applicationId) {
								modScope.databaseLoading = true;
								sqlService
									.getSQLDatabases(instance.clientId, instance.instanceId)
									.success(function(data) {
										modScope.databaseOptions = data;
										modScope.databaseLoading = false;
										modScope.serverMessage = cvUtil.emptyMsg();
									})
									.error(function(e) {
										modScope.databaseLoading = false;
										modScope.serverMessage = cvUtil.errMsg(e);
									});
							}
						};

						modScope.updateSchemas = function() {
							modScope.selectedSchema = undefined;
							modScope.schemaOptions = [];
							modScope.tableOptions = [];
							modScope.schemaLoading = true;
							dataMaskingService.getSchemasForInstance($stateParams.instanceId, modScope.selectedDatabase).then(
								function(data) {
									modScope.schemaOptions = data;
									modScope.schemaLoading = false;
								},
								function(err) {
									modScope.schemaLoading = false;
									modScope.serverMessage = cvUtil.errMsg(err.data || cvLoc('connection.error'));
								}
							);
						};

						if (modScope.isMultiDatabase()) {
							modScope.updateDatabases();
						} else {
							modScope.updateSchemas();
						}

						modScope.updateTables = function() {
							modScope.selectedTable = undefined;
							if (modScope.selectedSchema) {
								modScope.tableOptions = modScope.selectedSchema.table;
								modScope.tableOptionsObjectList = modScope.tableOptions.map(t => {
									return { value: t };
								});
								//start loading this schema's columns even before user selects a table
								columnPromise = dataMaskingService.getColumnsForSchema(
									$stateParams.instanceId,
									modScope.selectedDatabase,
									modScope.selectedSchema.schema
								);
								modScope.columnsLoading = true;
							}
							modScope.columnOptions = [];
						};

						function addForeignKey(stable, column) {
							if (!foreignKeys[stable]) {
								foreignKeys[stable] = {};
							}
							foreignKeys[stable][column] = true;
						}

						function isForeignKey(stable, column) {
							if (foreignKeys[stable]) {
								return foreignKeys[stable][column];
							}
							return false;
						}
						modScope.updateColumns = function() {
							modScope.selectedColumns.forEach(column => {
								column.checked = false;
							});
							modScope.columnOptions = [];
							if (modScope.columnsLoading) {
								columnPromise.then(
									function(data) {
										if (
											data.databaseName == modScope.selectedDatabase &&
											data.schemaName == modScope.selectedSchema.schema
										) {
											allColumns = {};
											angular.forEach(data.data, function(i) {
												var schemaTable = splitSchemaTable(i.name);
												angular.forEach(i.column, column => {
													//Strong is used to tell isteven select to treat this as template
													column.nameTypeTemlate =
														column.name + ' <i class="italic">(' + column.type.toLowerCase() + ')</i><strong></strong>';
												});

												allColumns[data.databaseName + SEP + schemaTable.schema + SEP + schemaTable.table] = i.column;

												//Find all foreign keys
												angular.forEach(i.foreignKey, function(fk) {
													angular.forEach(fk.reference, function(ref) {
														addForeignKey(
															data.databaseName + SEP + schemaTable.schema + SEP + schemaTable.table,
															ref.local
														);

														var foreignSt = splitSchemaTable(fk.foreignTable);
														addForeignKey(
															data.databaseName + SEP + foreignSt.schema + SEP + foreignSt.table,
															ref.foreign
														);
													});
												});
											});
											modScope.columnsLoading = false;
											modScope.columnOptions =
												allColumns[
													modScope.selectedDatabase +
														SEP +
														modScope.selectedSchema.schema +
														SEP +
														modScope.selectedTable
												];
											disableAlreadySelectedColumns();
										}
									},
									function(err) {
										modScope.columnsLoading = false;
										modScope.serverMessage = cvUtil.errMsg(err.data || cvLoc('connection.error'));
									}
								);
							} else {
								modScope.columnOptions =
									allColumns[
										modScope.selectedDatabase + SEP + modScope.selectedSchema.schema + SEP + modScope.selectedTable
									];
								disableAlreadySelectedColumns();
							}
						};

						function clearMaskType() {
							modScope.selectedMaskType = '';
							modScope.requiredParams = [];
							modScope.maskTypeOptions = [];
						}

						function disableAlreadySelectedColumns() {
							var selectedCols = modScope.flattenedConfig
								.filter(function(pol) {
									return (
										modScope.selectedDatabase === pol.database &&
										modScope.selectedSchema.schema === pol.schema &&
										modScope.selectedTable === pol.table
									);
								})
								.map(function(pol) {
									return pol.column;
								});

							if (modScope.columnOptions) {
								modScope.columnOptions.forEach(function(i) {
									if (selectedCols.indexOf(i.name) > -1) {
										i.disabled = true;
									} else {
										i.disabled = false;
									}
								});
							}
						}

						//Return true if column type is considered number types.
						function isNumberType(type) {
							for (var i = 0; i < numberTypes.length; i++) {
								if (type.indexOf(numberTypes[i]) >= 0) {
									return true;
								}
							}
							if (isFPENumberType(type)) {
								return true;
							}
							return false;
						}

						//Return true if column type is FPE compatible number types.
						function isFPENumberType(type) {
							for (var i = 0; i < fpeNumberTypes.length; i++) {
								if (type == fpeNumberTypes[i]) {
									return true;
								}
							}
							return false;
						}

						//Return true if column type is considered char types.
						function isCharType(type) {
							for (var i = 0; i < charTypes.length; i++) {
								if (type.indexOf(charTypes[i]) >= 0) {
									return true;
								}
							}
							return false;
						}

						//Return precision given the size string, size format example: "0", "1", or "0,0", "1,1", "1,2"
						function getPrecision(size) {
							var tokens = size.split(',');
							if (tokens.length > 0) {
								return parseInt(tokens[0]);
							}
							return 0;
						}

						modScope.updateMaskTypes = function() {
							clearMaskType();
							if (modScope.selectedColumns.length > 0) {
								//determine type of all selected to get valid options
								var nNumber = 0;
								var nFPENumber = 0;
								var nString = 0;
								var nKeys = 0;
								var nSize0Number = 0;
								var nColumn = modScope.selectedColumns.length;

								for (var i = 0; i < nColumn; i++) {
									var column = modScope.selectedColumns[i];
									if (isNumberType(column.type)) {
										++nNumber;
										if (isFPENumberType(column.type)) {
											++nFPENumber;
										}
										if (getPrecision(column.size) == 0) {
											++nSize0Number;
										}
									} else if (isCharType(column.type)) {
										++nString;
									}

									if (
										column.primaryKey == 'true' ||
										isForeignKey(
											modScope.selectedDatabase + SEP + modScope.selectedSchema.schema + SEP + modScope.selectedTable,
											column.name
										)
									) {
										++nKeys;
									}
								}
								modScope.maskTypeOptions = [modScope.maskingTypes.SHUFFLING];

								//If all selected columns are number types
								if (nNumber == nColumn) {
									modScope.maskTypeOptions.push(modScope.maskingTypes.NUMERIC_RANGE);
									modScope.maskTypeOptions.push(modScope.maskingTypes.NUMERIC_VARIANCE);
								}

								//If all selected columns are string types
								if (nString == nColumn) {
									modScope.maskTypeOptions.push(modScope.maskingTypes.FIXED_STRING);
								}

								//If all columns are either string types or number types with non 0 precision
								if (nString + nNumber == nColumn && nSize0Number == 0 && nFPENumber == nNumber) {
									modScope.maskTypeOptions.push(modScope.maskingTypes.FPE_ALPHANUMERIC);
								}

								//If there are primary keys or foreign keys
								if (nKeys != 0) {
									modScope.maskTypeOptions = modScope.maskTypeOptions.filter(function(dmType) {
										return (
											dmType == modScope.maskingTypes.FPE_ALPHANUMERIC || dmType == modScope.maskingTypes.SHUFFLING
										);
									});
								}
							}
						};

						modScope.updateRequiredParams = function() {
							modScope.requiredParams = angular.copy(modScope.selectedMaskType).params;
						};

						modScope.addMask = function() {
							if (modScope.selectedMaskType) {
								angular.forEach(modScope.selectedColumns, function(i) {
									modScope.flattenedConfig.push({
										database: modScope.selectedDatabase,
										schema: modScope.selectedSchema.schema,
										table: modScope.selectedTable,
										column: i.name,
										type: modScope.selectedMaskType.id,
										arguments: modScope.requiredParams.map(function(p) {
											return p.value.toString();
										})
									});
								});
							}
							modScope.columnOptions.forEach(function(i) {
								i.checked = false;
							});
							disableAlreadySelectedColumns();
							clearMaskType();
							modScope.serverMessage = {};
						};

						modScope.addButtonDisabledReason = function() {
							//check that all required fields are set
							if (!modScope.selectedSchema) {
								return 'schema';
							} else if (!modScope.selectedTable) {
								return 'table';
							} else if (modScope.selectedColumns.length === 0) {
								return 'column';
							} else if (!modScope.selectedMaskType) {
								return 'masking_type';
							}

							//check that there are no duplicates for this column
							var selectedColumnNames = modScope.selectedColumns.map(function(i) {
								return i.name;
							});
							for (var i = 0; i < modScope.flattenedConfig.length; i++) {
								var pol = modScope.flattenedConfig[i];
								if (
									modScope.selectedDatabase === pol.database &&
									modScope.selectedSchema.schema === pol.schema &&
									modScope.selectedTable === pol.table &&
									selectedColumnNames.indexOf(pol.column) > -1
								) {
									return 'dupe_col';
								}
							}

							//check that all parameters are filled
							for (var i = 0; i < modScope.requiredParams.length; i++) {
								if (
									modScope.requiredParams[i].value === null ||
									modScope.requiredParams[i].value === '' ||
									modScope.requiredParams[i].value === undefined
								) {
									return 'missing_param';
								}
							}

							//check that min <= max for a range
							if (modScope.selectedMaskType.id === 'NUMERIC_RANGE') {
								if (modScope.requiredParams[0].value > modScope.requiredParams[1].value) {
									return 'invalid_range';
								}
							}

							if (modScope.selectedMaskType.id === 'NUMERIC_VARIANCE') {
								if (modScope.requiredParams[0].value < 0) {
									return 'invalid_variance';
								}
							}

							return '';
						};

						modScope.removeMask = function(entity) {
							angular.forEach(modScope.flattenedConfig, function(value, index) {
								if (value === entity) {
									modScope.flattenedConfig.splice(index, 1);
								}
							});
							disableAlreadySelectedColumns();
						};

						var allNames = self.policies.map(function(i) {
							return i.policy.policyName;
						});

						modScope.isDupePolicyName = function() {
							return (
								allNames.indexOf(modScope.policy.policy.policyName) > -1 &&
								(isNew || oldPolicy.policy.policyName !== modScope.policy.policy.policyName)
							);
						};

						modScope.confirmButtonDisabledReason = function() {
							//check for name
							if (!modScope.policy.policy.policyName) {
								return 'no_name';
							}

							//check that name doesn't already exist
							if (modScope.isDupePolicyName()) {
								return 'dupe_name';
							}

							//check that there's at least one mask type
							if (modScope.flattenedConfig.length === 0) {
								return 'no_masks';
							}
							return '';
						};

						modScope.typeArgDescription = function(entity) {
							if (entity.arguments && entity.arguments.length > 0) {
								var ret = '(';
								var args = modScope.maskingTypes[entity.type].params;
								for (var i = 0; i < entity.arguments.length; i++) {
									ret += args[i].name + ' = ' + entity.arguments[i];
									if (i < entity.arguments.length - 1) {
										ret += ', ';
									}
								}
								ret += ')';
								return ret;
							}
							return '';
						};

						function croppedTitleCellTemplate(val) {
							return '<span class="crop" title="' + val + '">' + val + '</span>';
						}

						modScope.policySettingsGridOptions = {
							cvGridCssClass: {
								'policy-settings-grid': true
							},
							cvIsSearchable: false,
							cvOnGridEmpty: {
								message: cvLoc('help.no_masks')
							},
							cvHasTitle: false,
							cvAppScope: modScope,
							gridOptions: angular.extend({}, cvTableOptions.commonNgGridOptions, {
								data: 'flattenedConfig',
								columnDefs: [
									{
										field: 'database',
										displayName: cvLoc('label.database'),
										cellTemplate: croppedTitleCellTemplate('{{row.entity.database}}'),
										visible: modScope.isMultiDatabase(),
										width: '15%'
									},
									{
										field: 'schema',
										displayName: cvLoc('label.schema'),
										cellTemplate: croppedTitleCellTemplate('{{row.entity.schema}}'),
										width: '13%'
									},
									{
										field: 'table',
										displayName: cvLoc('label.table'),
										cellTemplate: croppedTitleCellTemplate('{{row.entity.table}}'),
										width: '15%'
									},
									{
										field: 'column',
										displayName: cvLoc('label.column'),
										cellTemplate: croppedTitleCellTemplate('{{row.entity.column}}')
									},
									{
										field: 'type',
										displayName: cvLoc('label.dataMaskingType'),
										cellTemplate: croppedTitleCellTemplate(
											'{{grid.appScope.maskingTypes[row.entity.type].name}} {{grid.appScope.typeArgDescription(row.entity)}}'
										),
										width: '27%',
										enableSorting: false
									},
									{
										field: 'remove',
										displayName: cvLoc('label.remove'),
										cellTemplate:
											'<a class="policy-settings-grid__remove" ng-click="grid.appScope.removeMask(row.entity)"' +
											' title="' +
											cvLoc('label.remove') +
											' {{row.entity.table}}.{{row.entity.column}}">' +
											'<span class="glyphicon glyphicon-remove"></span>' +
											'</a>',
										width: '13%',
										enableSorting: false
									}
								]
							})
						};
					}
				]
			});
		}

		self.deletePolicy = function(entity) {
			$dialogs.confirm(
				cvLoc('label.deletePolicy'),
				cvLoc('label.deletePolicyBody', '<b>' + entity.policy.policyName + '</b>'),
				{
					noFunction: function() {},
					yesFunction: function() {
						dataMaskingService.deletePolicyForInstance($stateParams.instanceId, entity).then(
							function(resp) {
								refreshPolicies();
								cvToaster.showSuccessMessage({
									message: cvLoc('label.policyDeleteSuccess', '<b>' + entity.policy.policyName + '</b>')
								});
							},
							function(err) {
								cvToaster.showErrorMessage({
									message: err.data || cvLoc('connection.error')
								});
							}
						);
					}
				}
			);
		};

		self.clonePolicy = function(entity) {
			var allNames = self.policies.map(function(i) {
				return i.policy.policyName;
			});

			var newName = entity.policy.policyName + '_Clone';
			// if name_Clone is taken, try adding a number
			// i.e. _Clone1, _Clone2, _Clone3...
			if (allNames.indexOf(newName) > -1) {
				var i = 1;
				while (allNames.indexOf(newName + i) !== -1) {
					i++;
				}
				newName = newName + i;
			}

			var newPolicy = angular.copy(entity);
			newPolicy.policy.policyName = newName;

			openEditModal(newPolicy, true, self.instance);
		};

		self.modifyPolicy = function(entity) {
			openEditModal(entity, false, self.instance);
		};

		function openRunModal() {
			$uibModal.open({
				templateUrl: appUtil.appRoot + 'modules/ida/partials/maskingRunModal.jsp',
				windowClass: 'masking-modal-window',
				controllerAs: 'modCtrl',
				backdrop: 'static',
				keyboard: false,
				controller: [
					'$uibModalInstance',
					function($modalInstance) {
						var modScope = this;

						modScope.istevenSelectText = cvUtil.getIStevenLocLabels();
						modScope.modalOptions = {
							headerText: cvLoc('label.runDataMasking'),
							closeButtonText: cvLoc('Cancel'),
							actionButtonText: cvLoc('label.run'),
							ok: function() {
								var instance = modScope.selectedClient[0].instances.filter(function(i) {
									return i.entityInfo.instanceId === modScope.selectedInstance[0].id;
								})[0];

								var policy = self.policies.filter(function(i) {
									return i.policy.policyId === modScope.selectedPolicy[0].id;
								})[0];

								var options = {
									entityType: 'INSTANCE_ENTITY',
									genericEntity: angular.toJson(
										angular.extend({}, self.subclient, {
											subclientId: -1,
											subclientName: ''
										})
									),
									browseOption: angular.toJson({
										commCellId: 2
									}),
									destination: angular.toJson({
										destClient: modScope.selectedClient[0],
										destinationInstance: instance.entityInfo
									}),
									agentSpecificOptions: angular.toJson({}),
									dmOptions: angular.toJson({
										dbDMPolicy: {
											association: {
												instanceId: self.instance.instanceId
											},
											policy: policy.policy
										},
										enabled: true,
										isStandalone: true
									})
								};

								idaService.submitRestoreJob(options).then(
									function(resp) {
										var jobId = resp.data;
										cvToaster.showInfoMessage({
											ttl: '10000',
											message:
												cvLoc('notification.dataMasking.started', jobId) +
												'<br><a href="#/jobs/' +
												jobId +
												'">' +
												cvLoc('notification.jobDetails') +
												'</a>'
										});

										$modalInstance.close();
									},
									function(err) {
										modScope.serverMessage = cvUtil.errMsg(err.data || cvLoc('connection.error'));
									}
								);
							},
							close: $modalInstance.close
						};

						modScope.policyOptions = self.policies;

						modScope.instancesLoading = true;
						dbServerService.getDBInstances().then(
							function(resp) {
								modScope.instancesLoading = false;

								var clients = {};
								angular.forEach(resp.data, function(i) {
									if (i.entityInfo.applicationId !== self.instance.applicationId) {
										return;
									}

									if (!(i.entityInfo.clientId in clients)) {
										clients[i.entityInfo.clientId] = {
											clientId: i.entityInfo.clientId,
											clientName: i.entityInfo.clientName,
											instances: [],
											checked: i.entityInfo.clientId === self.instance.clientId
										};
									}

									clients[i.entityInfo.clientId].instances.push(i);
								});

								modScope.clientOptions = [];
								angular.forEach(clients, function(i) {
									modScope.clientOptions.push(i);
								});
								modScope.clientOptions.sort(function(a, b) {
									return a.clientName.localeCompare(b.clientName);
								});

								modScope.selectedClient = [clients[self.instance.clientId]];
								modScope.updateInstances();

								angular.forEach(modScope.instanceNames, function(i) {
									i.checked = i.id === self.instance.instanceId;
								});
							},
							function(err) {
								modScope.serverMessage = cvUtil.errMsg(err.data || cvLoc('connection.error'));
							}
						);

						modScope.updateInstances = function() {
							//the isteven doesn't support retrieving names from nested objects, so we need to make a list of names
							modScope.instanceNames = modScope.selectedClient[0].instances.map(function(i) {
								return {
									name: i.entityInfo.instanceName,
									id: i.entityInfo.instanceId,
									checked: false
								};
							});

							modScope.instanceNames.sort(function(a, b) {
								return a.name.localeCompare(b.name);
							});
						};

						modScope.policyNames = self.policies.map(function(i) {
							return {
								name: i.policy.policyName,
								id: i.policy.policyId,
								checked: false
							};
						});
					}
				]
			});
		}

		//Use new grid
		self.gridOptions = {
			enableCheckBoxColumn: false,
			enableColumnResizing: true,
			columns: getColumns(),
			data: self.policies,
			gridTitle: cvLoc('pageHeader.dataMaskingPolicies'),
			tableName: 'dbDataMaskingTable',
			hasViews: false,
			idField: 'policy.policyName',
			sortDirection: {
				field: 'policy.policyName',
				dir: 'asc'
			},
			onGridSelectionChange: onGridSelectionChange,
			beforeGridInitialize: ({ grid }) => {
				self.grid = grid;
			}
		};

		self.gridOptions.actionMenu = [
			{
				id: 'EDIT',
				label: cvLoc('label.edit'),
				onSelect: onActionMenuSelect
			},
			{
				id: 'CLONE',
				label: cvLoc('label.clone'),
				onSelect: onActionMenuSelect
			},
			{
				id: 'DELETE',
				label: cvLoc('Delete'),
				onSelect: onActionMenuSelect
			}
		];
		self.gridOptions.gridToolbarMenu = [
			{
				id: 'CREATE_POLICY',
				label: cvLoc('label.createPolicy'),
				onSelect: function() {
					openEditModal(null, true, self.instance);
				}
			},
			{
				id: 'RUN_POLICY',
				label: cvLoc('label.runDataMasking'),
				onSelect: openRunModal
			}
		];
		function getColumns() {
			return {
				'policy.policyName': {
					title: cvLoc('label.maskingPolicyName'),
					type: 'string',
					width: '100%',
					template: `<span class="crop" cv-toggle-content="#:policy.policyName#" cv-toggle="tooltip">#:policy.policyName#</span>`
				}
			};
		}

		function onActionMenuSelect(method) {
			var row = method.selectedRowValues[0];
			switch (method.optionId) {
				case 'EDIT':
					self.modifyPolicy(row);
					break;
				case 'CLONE':
					self.clonePolicy(row);
					break;
				case 'DELETE':
					self.deletePolicy(row);
					break;
			}
		}

		function onGridSelectionChange(e, instances, rows) {
			if (e.rows.length == 1) {
				self.grid.showActionMenuOption('EDIT');
				self.grid.showActionMenuOption('CLONE');
				self.grid.showActionMenuOption('DELETE');
			} else {
				self.grid.hideActionMenuOption('EDIT');
				self.grid.hideActionMenuOption('CLONE');
				self.grid.hideActionMenuOption('DELETE');
			}
		}
	}
];

dataMaskingMod.controller(controllers);

export default dataMaskingMod;
