import { commonAllAgentsModule } from 'common/js/modules';

var app = commonAllAgentsModule;

var controllers = {};
controllers.commonTreeBrowseController = [
	'browseParams',
	'$uibModalInstance',
	function(browseParams, $modalInstance) {
		var self = this;
		self.prepareModel = function() {
			self.browseModel = {
				applicationId: browseParams['applicationId'],
				entityId: browseParams['entityId'],
				entityType: browseParams['entityType'],
				bTreeOnly: browseParams['bTreeOnly'],
				cloudAppType: browseParams['cloudAppType']
			};
		};
		self.selectTreeNode = function() {
			var result = {};
			result.item = self.selectedItem.path;
			$modalInstance.close(result);
		};
		self.cancelTreeNodeSelection = function() {
			$modalInstance.dismiss();
		};
		self.prepareModel();
	}
];
app.controller(controllers);

export default app;
