import 'modules/ida/js/controllers/sqlAgent.ctrl.js';
import 'adminConsole/js/directives/acDirectives.js';
import 'webScale/js/controllers/storagePool.ctrl.js';
import 'modules/servers/js/services/servers.svc.js';
import 'adminConsole/js/services/clientGroups.svc.js';
import 'dlo/js/services/profile.svc.js';
import 'modules/ida/js/services/appMigration.svc.js';
import 'modules/ida/js/services/sqlService.svc.js';
import 'modules/ida/js/services/idaService.svc.js';
import 'modules/genApp/js/directives/cv-compute-node.js';
import 'modules/genApp/js/directives/cv-firewall-options.js';

import { commonAppMigrationModule } from 'common/js/modules';

var appMigration = commonAppMigrationModule;

appMigration.controller('appMigrationCtrl', [
	'$scope',
	'$stateParams',
	'cvToaster',
	'cvBreadcrumbsTabsFactory',
	'$log',
	'idaService',
	'sqlService',
	'$dialogs',
	'appMigrationService',
	'profileService',
	'$state',
	'cvLoc',
	'$timeout',
	'cvUtil',
	'cvTableOptions',
	'clientGroupService',
	'serverService',
	function(
		$scope,
		$stateParams,
		cvToaster,
		cvBreadcrumbsTabsFactory,
		$log,
		idaService,
		sqlService,
		$dialogs,
		appMigrationService,
		profileService,
		$state,
		cvLoc,
		$timeout,
		cvUtil,
		cvTableOptions,
		clientGroupService,
		serverService
	) {
		$scope.instanceId = $stateParams.instanceId;
		$scope.applicationId = $stateParams.applicationId;
		$scope.entity = null;
		$scope.isCrossPlatfrom = false;
		$scope.isOracleCloudPolicy = false;
		$scope.appMigrate = {
			destInstanceName: '',
			cloudType: 'AMAZON',
			policyId: 0,
			oracleHomePath: 0,
			createNewMachine: false,
			srcInst: {},
			stagingPath: '',
			validationScript: '',
			cloudAllocationPolicy: {},
			machineConfig: {
				vmTemplate: {},
				vmInstType: {},
				storageVol_list: {},
				vmUser: {
					userName: '',
					password: null
				},
				advVMProperties: {
					networkCards: null
				}
			},
			targetCloudMachine: {},
			softwareConfig: {
				softwareInstallDir: '',
				softConfigType: 0
			},
			osCredentials: {
				user: {}
			}
		};

		$scope.tileState = {
			dataConfigState: true,
			backupConfigState: false
		};
		$scope.restoreOptions = {
			copyPreceDencSect: false,
			copyPrecedence: 1,
			disableMaxNoOfStreams: false,
			commonOptions: {
				baselineBackup: 0,
				syncRestore: true
			},
			oracleOpt: {
				restoreStream: 1,
				ctrlFileBackupType: 0,
				cloneEnv: false,
				ctrlRestoreFrom: true,
				partialRestore: false,
				recoverFrom: 3,
				restoreControlFile: true,
				noCatalog: true,
				liveSyncOpt: {
					restoreInStandby: false
				}
			},
			sqlServerRstOption: {
				restoreSource: null,
				database: null,
				sqlRecoverType: 0
			},
			destination: {
				destinationInstance: {
					instanceName: null
				}
			}
		};
		$scope.pattern = {
			freq_type: 1
		};

		$scope.errors = {};
		var generalPage = {
			completed: false,
			template: appUtil.appRoot + 'modules/ida/partials/appMigrationGeneralPage.jsp',
			name: cvLoc('label.appInfo')
		};

		var configPage = {
			completed: false,
			template: appUtil.appRoot + 'modules/ida/partials/appMigrationConfigPage.jsp',
			name: cvLoc('label.machineConfig')
		};
		var swPage = {
			completed: false,
			template: appUtil.appRoot + 'modules/ida/partials/appMigrationSoftwareConfiPage.jsp',
			name: cvLoc('label.swConfig')
		};

		var fConfigPage = {
			completed: false,
			template: appUtil.appRoot + 'modules/ida/partials/appMigrationFirewallOptionsPage.jsp',
			name: cvLoc('label.firewallConfg')
		};

		var restorePage = {
			completed: false,
			template: appUtil.appRoot + 'modules/ida/partials/appMigrationRestoreOptionsPage.jsp',
			name: cvLoc('label.migrationOpt')
		};

		var steps = [];
		steps.push(generalPage);
		$scope.isSqlMigration = false;
		if ($scope.applicationId == 81) {
			$scope.isSqlMigration = true;
			var contentPage = {
				completed: false,
				template: appUtil.appRoot + 'modules/ida/partials/appMigrationContentPage.jsp',
				name: cvLoc('label.contentSelt')
			};
			steps.push(contentPage);
			steps.push(configPage);
		} else {
			steps.push(configPage);
			steps.push(swPage);
		}
		steps.push(fConfigPage);
		steps.push(restorePage);

		$scope.steps = steps;

		$scope.getCurrentStep = function() {
			return $scope.step;
		};

		var breadCrumbs = [];

		var instanceNode = {
			title: cvLoc('label.instance'),
			link: '#instances'
		};
		breadCrumbs.push(instanceNode);
		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
		$scope.step = 0;

		$scope.title = cvLoc('pageHeader.migrateToCloud');

		var cloudTypes = [];
		cloudTypes.push({
			name: cvLoc('label.amazon'),
			cloudId: 'AMAZON'
		});
		cloudTypes.push({
			name: cvLoc('label.azure'),
			cloudId: 'AZURE_RESOURCE_MANAGER'
		});
		cloudTypes.push({
			name: cvLoc('label.oralceCloud'),
			cloudId: 'ORACLE_CLOUD'
		});

		if ($scope.applicationId == 22) {
			/*cloudTypes.push({
				name: cvLoc('label.oralceDbaas'),
				cloudId: 'ORACLE_AS_SERVICE'
			});*/
			cloudTypes.push({
				name: cvLoc('label.oracleCI'),
				cloudId: 'ORACLE_CLOUD_INFRASTRUCTURE'
			});
		}
		$scope.cloudTypes = cloudTypes;

		var removeCloudType = function(cloudId) {
			var removeIndex = -1;
			for (var int = 0; int < $scope.cloudTypes.length; int++) {
				if ($scope.cloudTypes[int].cloudId == cloudId) {
					removeIndex = int;
				}
			}
			if (removeIndex >= 0) {
				$scope.cloudTypes.splice(removeIndex, 1);
			}
		};

		var createTable = function() {
			var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
			var columnDefs = [];
			columnDefs.push({
				field: 'mntPoint',
				displayName: cvLoc('label.mountPoints'),
				cellTemplate: '<span class="crop" >{{row.entity.mntPoint.mountPathName}}</span>',
				enableHiding: false,
				cellTooltip: true,
				width: '20%'
			});
			columnDefs.push({
				field: 'volumeSize',
				displayName: cvLoc('label.sizeGB'),
				cellTemplate: '<span class="crop">{{row.entity.volumeSize | volumeSize}}</span>',
				width: '15%'
			});

			if (!$scope.isOracleCloudPolicy) {
				columnDefs.push({
					field: 'clientName',
					displayName: cvLoc('label.volumeType'),
					cellTemplate: '<span class="crop" >{{row.entity.amazonVolConfig.volumeType | volumeType}}</span>',
					width: '20%'
				});
				columnDefs.push({
					field: 'amazonVolConfig.iopsLimit',
					displayName: cvLoc('label.iopsLimit'),
					cellTemplate: '<span class="crop" >{{row.entity.amazonVolConfig.iopsLimit}}</span>',
					width: '15%'
				});
			}
			columnDefs.push({
				field: 'volumeTag',
				displayName: cvLoc('label.description'),
				cellTemplate: '<span title="{{row.entity.volumeTag}}" class="crop" >{{row.entity.volumeTag}}</span>',
				width: '20%'
			});

			columnDefs.push({
				field: 'edit',
				displayName: '',
				cellTemplate:
					'<span title="Edit volume"  class="edit-volume" data-ng-click="grid.appScope.editVolume(row.entity)" >&nbsp;<//span>',
				width: '5%'
			});
			columnDefs.push({
				field: 'delete',
				displayName: '',
				cellTemplate:
					'<span title="Delete volume"  class="delete-row" data-ng-click="grid.appScope.deleteVolume(row.entity)" > × </span>',
				width: '5%'
			});

			angular.extend(globalGridOptions, {
				data: 'storageDetails',
				columnDefs: columnDefs
			});

			$scope.gridOptions = globalGridOptions;
		};

		$scope.deleteVolume = function(volumeObj) {
			var volumeName = volumeObj.mntPoint.mountPathName;
			for (var i = 0; i < $scope.storageDetails.length; i++) {
				if ($scope.storageDetails[i].mntPoint.mountPathName == volumeName) {
					$scope.storageDetails.splice(i, 1);
					return;
				}
			}
		};

		$scope.editVolume = function(volumeObj) {
			$scope.addVolume(volumeObj);
		};

		$scope.addStorage = function() {
			$scope.addVolume(null);
		};
		$scope.addVolume = function(volumeObj) {
			var templateUrl = 'modules/ida/partials/appMigrationAddStorage.jsp';
			var controller = [
				'$scope',
				'cvUtil',
				'$rootScope',
				'data',
				'$uibModalInstance',
				function($scope, cvUtil, $rootScope, data, $modalInstance) {
					if (!data) {
						$scope.isEditing = false;
						$scope.storage = {
							mntPoint: {
								mountPathName: ''
							},
							volumeSize: 10,
							amazonVolConfig: {
								volumeType: 0,
								iopsLimit: 100
							}
						};
					} else {
						$scope.isEditing = true;
						$scope.storage = angular.copy(data);
					}
					$scope.volumeTypes = [
						{
							name: cvLoc('label.standard'),
							volumeId: 0
						},
						{
							name: cvLoc('label.provsIOPS'),
							volumeId: 1
						}
					];

					$scope.closeModal = function() {
						$modalInstance.close(null);
					};
					$scope.saveModle = function() {
						$modalInstance.close($scope.storage);
					};
				}
			];
			var opts = new Object();

			var modelInsta = $dialogs.create(appUtil.appRoot + templateUrl, controller, volumeObj, opts);
			modelInsta.result.then(function(dataObject) {
				if (dataObject) {
					//In Edit case volumeObj will not be null, so remove it and add new one.
					if (volumeObj) {
						$scope.deleteVolume(volumeObj);
					}
					$scope.storageDetails.push(dataObject);
				}
			});
		};
		$scope.getDestOsType = function() {
			var appId = $scope.applicationId;
			var osType = '';
			if (appId == 22 || appId == 134) {
				osType = 'Linux';
			} else if (appId == 81) {
				osType = 'Windows';
			}
			return osType;
		};

		$scope.showRedirctPathDialog = function() {
			var templateUrl = 'modules/ida/partials/sqlRedirectPathsModel.jsp';
			var controller = [
				'$scope',
				'cvUtil',
				'$rootScope',
				'$uibModalInstance',
				'data',
				function($scope, cvUtil, $rootScope, $modalInstance, data) {
					$scope.entity = data.entity;
					$scope.databases = data.selectedDBs;

					$scope.cancelModel = function() {
						$modalInstance.close(null);
					};
					$scope.saveModle = function(sqlDbDeviceItemInfo) {
						$modalInstance.close(sqlDbDeviceItemInfo);
					};
				}
			];
			var opts = new Object();
			var dataModel = {
				entity: $scope.entity,
				selectedDBs: $scope.databases
			};
			var modelInsta = $dialogs.create(appUtil.appRoot + templateUrl, controller, dataModel, opts);
			modelInsta.result.then(function(sqlDbDeviceItemInfo) {
				if (sqlDbDeviceItemInfo) {
					if ($scope.restoreOptions.sqlServerRstOption) {
						$scope.restoreOptions.sqlServerRstOption.device = sqlDbDeviceItemInfo.device;
						$scope.restoreOptions.sqlServerRstOption.deviceInfo = sqlDbDeviceItemInfo.deviceInfo;
					}
				}
			});
		};

		var createContentTable = function() {
			var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
			var columnDefs = [];

			columnDefs.push({
				field: 'id',
				displayName: cvLoc('label.DatabaseName'),
				cellTemplate: '<div class="crop" title="{{row.entity.databaseName}}">{{row.entity.databaseName}}</div>',
				enableHiding: false,
				cellTooltip: true,
				width: '60%'
			});
			columnDefs.push({
				field: 'userObject.version',
				displayName: 'Version' /*cvLoc('label.sizeGB')*/,
				cellTemplate: '<div class="crop" title="{{row.entity.version}}">{{row.entity.version}}</div>',
				width: '15%'
			});

			angular.extend(globalGridOptions, {
				data: 'databases',
				columnDefs: columnDefs,
				paginationPageSize: 5,
				paginationPageSizes: [5, 10, 20, 50],
				onRegisterApi: function(gridApi) {
					//$scope.gridApi = gridApi;
					gridApi.selection.enableVerticalScrollbar = 0;

					gridApi.selection.on.rowSelectionChangedBatch($scope, function(rows) {
						var isSelectAll = gridApi.selection.getSelectAllState();

						$scope.databases.forEach(function(entity) {
							entity.isSelected = !isSelectAll;
						});
					});

					gridApi.selection.on.rowSelectionChanged($scope, function(row) {
						row.entity.isSelected = row.isSelected;
					});
					$timeout(function() {
						gridApi.selection.selectAllRows();
					});
				}
			});

			$scope.gridContentOptions = {
				cvHasTitle: false,
				cvTableName: 'dbContentTable',
				cvSearchFields: ['databaseName', 'version'],
				cvHasViews: false,
				cvGridDirectives: {
					uiGridSelection: true,
					uiGridPagination: true
				},
				cvShowSelectedOption: true,
				cvOnGridEmpty: cvUtil.errMsgLoc('label.noDBBackup'),
				gridOptions: globalGridOptions
			};
		};

		$scope.instanceDetails;

		var getClientDetails = function(clientId) {
			idaService.getClientDetails(clientId).success(function(data) {
				$scope.clientDetails = data;
				$scope.osInfo = data.client.osInfo;
				if ($scope.osInfo.osId == 83) {
					$scope.isCrossPlatfrom = true;
					$scope.appMigrate.softwareConfig.softConfigType = 1;
				} else if ($scope.osInfo.osId == 210) {
					$scope.osInfo.SubType = $scope.osInfo.Type; // For Windows server os SubType is comming as server, updated to Windows
				}

				if ($scope.osInfo.osId == 83 || $scope.osInfo.osId == 47 || $scope.osInfo.osId == 97) {
					removeCloudType('ORACLE_AS_SERVICE');
				}
			});
		};

		var getDatabases = function(instanceId) {
			var options = new Object();
			idaService.getIdaBrowseData(instanceId, 'INSTANCE_ENTITY', options).then(function(data) {
				if (data && data.browseData) {
					var databases = [];
					data.browseData.forEach(function(entity) {
						var dbName = entity.userObject.databaseName;
						//System databases need to filter
						if (!(dbName === 'master' || dbName === 'model' || dbName === 'msdb')) {
							databases.push(entity.userObject);
						}
					});
					$scope.databases = databases;
				} else {
					$scope.databases = [];
				}
			});
		};

		var getInstanceDetails = function(instanceId) {
			idaService
				.getInstanceDetails(instanceId)
				.success(function(data) {
					if (data) {
						$scope.instanceDetails = data;
						$scope.entity = $scope.instanceDetails.instance;
						$scope.appMigrate.srcInst = $scope.entity;
						getClientDetails($scope.entity.clientId);
						if ($scope.entity.applicationId == 22) {
							if (!$scope.isCrossPlatfrom) {
								$scope.appMigrate.softwareConfig.softwareInstallDir = $scope.instanceDetails.oracleInstance.oracleHome;
							}

							if ($scope.instanceDetails.version) {
								var srcVersion = $scope.instanceDetails.version;
								var versionNumber = 0;
								if (srcVersion.startsWith('12.1')) {
									versionNumber = 1;
								} else if (srcVersion.startsWith('12.2')) {
									versionNumber = 2;
								}
								$scope.appMigrate.cloudDBService.oraSoftwareRelease = versionNumber;
								/*if (srcVersion.startsWith("11.2")) {
       	removeCloudType('ORACLE_AS_SERVICE');
       }*/
							}
							$scope.getStorageDetails($scope.entity, null);
						}
					}
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		getInstanceDetails(parseInt($scope.instanceId));
		getDatabases(parseInt($scope.instanceId));
		$scope.networkNameSelection = function() {
			if ($scope.appMigrate.machineConfig.advVMProperties.networkCards.length) {
				$scope.subnetList = $scope.appMigrate.machineConfig.advVMProperties.networkCards[0].subnetNames;
				if ($scope.subnetList) {
					$scope.subnetList.forEach(function(subNet) {
						subNet.ticked = false;
					});
					if ($scope.subnetList.length) {
						$scope.subnetList[0].ticked = true;
						if ($scope.appMigrate.machineConfig.advVMProperties.subnetList) {
							$scope.appMigrate.machineConfig.advVMProperties.subnetList = [];
						}
						$scope.appMigrate.machineConfig.advVMProperties.subnetList.push($scope.subnetList[0]);
					}
				}
			} else {
				$scope.subnetList = [];
			}
		};

		var getPolicyDetails = function(policyId) {
			appMigrationService
				.getPolicyDetails({
					policyId: policyId
				})
				.success(function(data) {
					if (data) {
						$scope.vmTeplPolicy = data;
						$scope.appMigrate.cloudAllocationPolicy = data;
						$scope.migrationType = 'appMigration';
						$scope.configPageEdting = false;
					}
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		$scope.localLang = cvUtil.getIStevenLocLabels();
		$scope.networkSettingsList = [];

		var loadNetworkSettings = function(clientId) {
			var dummyHostName = 'dummy';
			var serverDetailsInfo = {
				clientId: clientId,
				serverName: '',
				username: null,
				password: null
			};
			//load network info
			serverService
				.getNetworkInfo(serverDetailsInfo, dummyHostName)
				.success(function(data) {
					$scope.networkSettingsList = data;
					$scope.networkSettingsList.forEach(function(networkSetting) {
						networkSetting.ticked = false;
					});
				})
				.error(function(err) {
					$log.error(err);
				});
		};

		$scope.isNetworkSettingsListAvailable = function() {
			return true;
			/*if ($scope.appMigrate.machineConfig.advVMProperties.networkCards &&
   		$scope.appMigrate.machineConfig.advVMProperties.networkCards.length > 0)
   	return true;
   else
   	return false;*/
		};

		/**
		 * firewall related code
		 * Start
		 */
		$scope.appMigrate.firewallConfig = {
			enableFirewallConfig: false,
			firewallConnectionType: 0,
			httpProxyConfigurationType: 0,
			proxyClientName: '',
			portNumber: 8603
		};
		$scope.proxyClients = null;
		$scope.populatProxyClients = function() {
			var firewallConnectionType = 0;
			if ($scope.isOracleAsService) {
				firewallConnectionType = 1;
			}
			if ($scope.appMigrate.firewallConfig) {
				$scope.appMigrate.firewallConfig.firewallConnectionType = firewallConnectionType;
			}
			if ($scope.proxyClients == null) {
				$scope.updateTunnerlPortSelection(firewallConnectionType);
				// client group id is 0 means all the clients
				clientGroupService
					.getClientsForClientGroup(0)
					.success(function(data) {
						$scope.serverMessage = cvUtil.emptyMsg();
						if (data.length) {
							$scope.proxyClients = data.map(function(obj) {
								return {
									value: obj.client.clientEntity.clientId + '',
									label: obj.client.clientEntity.clientName
								};
							});
							$scope.proxyClients.sort(function(a, b) {
								return (
									+(a.label.toLowerCase() > b.label.toLowerCase()) ||
									+(a.label.toLowerCase() === b.label.toLowerCase()) - 1
								);
							});
						}
					})
					.error(function(data) {
						$scope.serverMessage = cvUtil.errMsgLoc('error.getServers');
					});
			}
		};

		$scope.updateTunnerlPortSelection = function(connectionType) {
			var labelString = cvLoc('label.noteFirewallConnectionType2');
			var portNumber = 0;
			if (connectionType == 0) {
				labelString = cvLoc('label.noteFirewallConnectionType0');
				portNumber = 8603;
			} else if (connectionType == 1) {
				labelString = cvLoc('label.noteFirewallConnectionType1');
				portNumber = 8403;
			}
			$scope.appMigrate.firewallConfig.portNumber = portNumber;
			$scope.firewallConnetionLabel = labelString;
		};
		/**
		 * firewall related code
		 * End
		 */

		/**
		 * Oracle cloud database service related code
		 * start
		 */
		$scope.appMigrate.instanceBackupType = 1;
		$scope.appMigrate.cloudDBService = {
			serviceName: '',
			oraServiceLevel: 1,
			mFrequency: 0,
			oraSoftwareRelease: 0,
			oraSoftwareEdition: 0,
			oraDatabaseType: 0,
			dbConfig: {
				dbSizeGB: 15,
				totalDataStorageGB: 1,
				listenerPort: 1521
			},
			dbBackupConfig: {
				dbBackupDestination: 3,
				createInstanceFromBackup: true,
				cloudStorageContainer: 'https://??.storage.oraclecloud.com/v1/Storage-/??'
			},
			dbRecoveryConfig: {
				onPremisesBackup: true,
				decMethod: 1
			},
			accessRule:
				'{  ' +
				'	"ruleName": "CV-Conn-Rule", ' +
				'	"description": "CV Connection Rule", ' +
				'	"source": "PUBLIC-INTERNET", ' +
				'	"destination": "DB", ' +
				'	"ports": "443", ' +
				'	"status": "enabled" ' +
				'} '

			//Service levels
		};
		$scope.dbBaseServiceLevels = [
			{
				serviceType: 1,
				serviceName: cvLoc('label.oralceDdCloud')
			}
		];

		$scope.meteringFrequencys = [
			{
				meteringType: 0,
				meteringName: 'Monthly'
			},
			{
				meteringType: 1,
				meteringName: 'Hourly'
			}
		];

		$scope.softwareReleases = [
			{
				releaseType: 0,
				releaseName: cvLoc('label.oracleDb11gRel')
			},
			{
				releaseType: 1,
				releaseName: cvLoc('label.oracleDb12cRel1')
			},
			{
				releaseType: 2,
				releaseName: cvLoc('label.oracleDb12cRel2')
			}
		];

		$scope.softwareEditions = [
			{
				editionType: 0,
				editionName: cvLoc('label.standardEdition')
			},
			{
				editionType: 1,
				editionName: cvLoc('label.enterpriseEdition')
			},
			{
				editionType: 2,
				editionName: cvLoc('label.enterpriseEditionExper')
			},
			{
				editionType: 2,
				editionName: cvLoc('label.enterpriseEditionHigper')
			}
		];

		$scope.databseTypes = [
			{
				dbTypeValue: 0,
				dbTypeName: cvLoc(
					'label.singleInst'
				) /*,{
                                         dbTypeValue : 1,
                                         dbTypeName : cvLoc('label.dbClusterWthRac')
                                         }*/
			}
		];

		$scope.backupTypes = [
			/*{
                        backupType : 1,
                        backupName : cvLoc('label.bothCloudStorege')
                        },*/ {
				backupType: 2,
				backupName: cvLoc('label.cloudStoreOnly')
			},
			{
				backupType: 3,
				backupName: cvLoc('label.none')
			}
		];

		$scope.instanceBackupTypes = [
			{
				instanceBackupType: 1,
				instanceBackupName: cvLoc('label.commvault')
			},
			{
				instanceBackupType: 2,
				instanceBackupName: cvLoc('label.oracleAsCloud')
			}
		];

		/**
		 * Oracle cloud database service related code
		 * end
		 */

		$scope.saveContentPage = function() {
			var sourceItems = [];
			$scope.databases.forEach(function(entity) {
				if (entity.isSelected) {
					sourceItems.push(entity);
				}
			});
			$scope.getStorageDetails($scope.entity, sourceItems);
			//$scope.getDiviceList(sourceItems);

			$scope.steps[$scope.step].completed = true;
			$scope.step++;
		};

		$scope.initDataBackupChanged = function(dataBackupFrom) {
			var createInstanceFromBackup = false;
			if (dataBackupFrom && dataBackupFrom === 2) {
				createInstanceFromBackup = true;
			}
			if ($scope.appMigrate.cloudDBService && $scope.appMigrate.cloudDBService.dbRecoveryConfig) {
				$scope.appMigrate.cloudDBService.dbRecoveryConfig.createInstanceFromBackup = createInstanceFromBackup;
			}
		};

		$scope.isValidAdminPassword = function() {
			var isValid = true;
			if ($scope.isOracleAsService) {
				var passwordPatternRegex = /^[A-Za-z](?=.*[0-9])([a-zA-Z0-9#_]){7,29}$/;
				var password = $scope.appMigrate.cloudDBService.dbConfig.dbPasswordValue;
				if (password != undefined && passwordPatternRegex.test(password)) {
					$scope.errors.adminPassword = false;
				} else {
					$scope.errors.adminPassword = true;
					isValid = false;
				}
			}
			return isValid;
		};

		$scope.isValidStorageContainer = function() {
			var isValid = true;
			if ($scope.isOracleAsService && $scope.appMigrate.cloudDBService.dbBackupConfig.dbBackupDestination != 3) {
				if (
					$scope.appMigrate.cloudDBService.dbBackupConfig.cloudStorageContainer ==
					'https://??.storage.oraclecloud.com/v1/Storage-/??'
				) {
					$scope.errors.cloudStorageContainer = true;
					isValid = false;
				} else {
					$scope.errors.cloudStorageContainer = false;
				}
			}
			return isValid;
		};

		$scope.isValidDatabaseName = function() {
			var isValid = true;
			if ($scope.isOracleAsService) {
				if (!$scope.appMigrate.cloudDBService.dbConfig.dbName) {
					$scope.errors.dbName = true;
					isValid = false;
				} else {
					$scope.errors.dbName = false;
				}
			}
			return isValid;
		};
		$scope.isValidDBSize = function() {
			var isValid = true;
			if ($scope.isOracleAsService) {
				var dbSize = $scope.appMigrate.cloudDBService.dbConfig.dbSizeGB;
				if (!dbSize || (dbSize < 15 && dbSize > 2048)) {
					isValid = false;
				}
			}
			return isValid;
		};

		$scope.isValidListenerPort = function() {
			var isValid = true;
			if ($scope.isOracleAsService) {
				var listenerPort = $scope.appMigrate.cloudDBService.dbConfig.listenerPort;
				if (!listenerPort || (listenerPort < 1521 && listenerPort > 5499)) {
					isValid = false;
				}
			}
			return isValid;
		};

		$scope.isValidComputeShape = function() {
			var isValid = true;
			if ($scope.isOracleAsService) {
				var vmInstType = $scope.appMigrate.cloudDBService.dbConfig.vmInstType;
				if (!vmInstType) {
					$scope.errors.vmInstType = true;
					isValid = false;
				} else {
					$scope.errors.vmInstType = false;
				}
			}
			return isValid;
		};

		$scope.validateNodePage = function() {
			if (
				$scope.isValidDatabaseName() &&
				$scope.isValidAdminPassword() &&
				$scope.isValidStorageContainer() &&
				$scope.isValidDBSize() &&
				$scope.isValidListenerPort() &&
				$scope.isValidComputeShape()
			) {
				$scope.goNextPage();
			}
			if ($scope.appMigrate.cloudDBService.oraSoftwareEdition == 0) {
				$scope.restoreOptions.disableMaxNoOfStreams = true;
				$scope.restoreOptions.oracleOpt.restoreStream = 1;
			} else {
				$scope.restoreOptions.disableMaxNoOfStreams = false;
			}
			if (!$scope.tileState.dataConfigState) {
				$scope.tileState.dataConfigState = true;
				$scope.tileState.backupConfigState = false;
			}
		};

		$scope.isRestoreStepValid = function() {
			var isValid = true;
			if ($scope.isOracleAsService && $scope.appMigrate.instanceBackupType == 2) {
				if ($scope.appMigrate.cloudDBService.dbRecoveryConfig.onPremisesBackup) {
					var dbidPatternRegex = /^[0-9]{0,15}$/;
					var dbidValue = $scope.appMigrate.cloudDBService.dbRecoveryConfig.dbID;
					if (dbidValue && dbidPatternRegex.test(dbidValue)) {
						$scope.errors.cloudStorageDBID = false;
					} else {
						$scope.errors.cloudStorageDBID = true;
						isValid = false;
					}
				}
			}

			return isValid;
		};

		$scope.saveGeneralPage = function() {
			var errors = {};

			if ($scope.appMigrate.preRegistore) {
				if ($scope.appMigrate.cloudMachineName == null) {
					errors.registoredServers = true;
					return;
				} else {
					errors.registoredServers = false;
				}
			} else {
				if ($scope.appMigrate.cloudType == null) {
					errors.cloudType = true;
				} else {
					errors.cloudType = false;
				}

				if ($scope.appMigrate.policyId == null) {
					errors.policyName = true;
				} else {
					errors.policyName = false;
				}

				if ($scope.isOracleAsService) {
					var namePatternRegex = /^[A-Za-z][A-Za-z0-9\-]{6,48}[A-Za-z0-9]$/;
					var instanceNameValue = $scope.appMigrate.vmNameText;
					if (instanceNameValue != undefined && namePatternRegex.test(instanceNameValue)) {
						errors.instanceName = false;
					} else {
						errors.instanceName = true;
					}
				} else if (
					$scope.appMigrate.targetCloudMachine == null ||
					$scope.appMigrate.targetCloudMachine.vm == null ||
					$scope.appMigrate.targetCloudMachine.vm.vmName == ''
				) {
					errors.instanceName = true;
				} else {
					errors.instanceName = false;
				}

				$scope.errors = errors;
				if (errors.cloudType || errors.instanceName || errors.policyName) {
					return;
				}
			}
			getPolicyDetails($scope.appMigrate.policyId);
			if ($scope.isSqlMigration) {
				createContentTable();
			}
			createTable();
			$scope.steps[$scope.step].completed = true;
			$scope.step++;
			if ($scope.appMigrate.preRegistore) {
				$scope.step++;
			}
		};

		$scope.setCurrentStep = function(stepNumber) {
			$scope.step = stepNumber;
		};

		$scope.saveConfigPage = function() {
			$scope.configPageMessage = cvUtil.emptyMsg();
			//Storage configuration validation
			if (
				!$scope.appMigrate ||
				!$scope.appMigrate.machineConfig ||
				!$scope.appMigrate.machineConfig.storageVol_list ||
				$scope.appMigrate.machineConfig.storageVol_list.length <= 0
			) {
				$scope.configPageMessage = {
					message: cvLoc('error.storageDevices'),
					type: 'error'
				};
				return;
			}

			if ($scope.isNetworkSettingsListAvailable()) {
				$scope.goNextPage();
			}
			$scope.configPageEdting = true;
			if (
				$scope.appMigrate &&
				$scope.appMigrate.machineConfig &&
				$scope.appMigrate.machineConfig.advVMProperties &&
				$scope.appMigrate.machineConfig.advVMProperties.networkCards &&
				$scope.appMigrate.machineConfig.advVMProperties.networkCards.length > 0 &&
				$scope.appMigrate.machineConfig.advVMProperties.subnetList
			) {
				$scope.appMigrate.machineConfig.advVMProperties.networkCards[0].subnetNames =
					$scope.appMigrate.machineConfig.advVMProperties.subnetList;
			}
		};

		$scope.goNextPage = function() {
			$scope.steps[$scope.step].completed = true;
			$scope.step++;
		};

		$scope.goConfigPreviousStep = function() {
			$scope.step--;
			if ($scope.appMigrate.preRegistore) {
				$scope.step--;
			}
		};

		$scope.goPreviousStep = function() {
			if ($scope.step == 1) {
				$scope.configPageEdting = true;
			}
			$scope.step--;
		};

		$scope.updatePolicies = function(cloudType) {
			var policyList = [];
			angular.forEach($scope.policyData, function(policy) {
				if (policy.entity.policyType == cloudType) {
					policyList.push(policy);
				}
			});
			$scope.policyList = policyList;
			if ($scope.policyList.length > 0) {
				$scope.appMigrate.policyId = $scope.policyList[0].entity.vmAllocPolicyId;
			}
			$scope.policyChanged();
		};

		$scope.cloudTypechange = function(cloudType) {
			$scope.isOracleAsService = false;
			$scope.isOracleCloudPolicy = false;
			$scope.isOCIPolicy = false;
			$scope.restoreOptions.disableMaxNoOfStreams = false;

			configPage.template = appUtil.appRoot + 'modules/ida/partials/appMigrationConfigPage.jsp';
			configPage.name = cvLoc('label.machineConfig');

			swPage.template = appUtil.appRoot + 'modules/ida/partials/appMigrationSoftwareConfiPage.jsp';
			swPage.name = cvLoc('label.swConfig');

			if (cloudType === 'ORACLE_CLOUD_INFRASTRUCTURE') {
				$scope.isOCIPolicy = true;
			} else if (cloudType === 'ORACLE_AS_SERVICE') {
				cloudType = 'ORACLE_CLOUD';
				$scope.isOracleAsService = true;
				configPage.template = appUtil.appRoot + 'modules/ida/partials/appMigrationServiceConfiPage.jsp';
				configPage.name = cvLoc('label.serviceConfg');

				swPage.template = appUtil.appRoot + 'modules/ida/partials/appMigrationNodeConfiPage.jsp';
				swPage.name = cvLoc('label.nodeConfg');
			} else if (cloudType === 'ORACLE_CLOUD') {
				$scope.isOracleCloudPolicy = true;
			}

			$scope.updatePolicies(cloudType);
			$scope.loadVms(cloudType);
		};

		$scope.policyChanged = function() {
			if ($scope.appMigrate.policyId) {
				$scope.errors.policyName = false;
			} else {
				$scope.errors.policyName = true;
			}
		};

		$scope.isDummyInstance = true;
		$scope.updateOptions = function(targetVm) {
			var vmName;
			if (targetVm != null && targetVm.vm.vmGUID != null) {
				$scope.appMigrate.targetCloudMachine = targetVm;
				$scope.appMigrate.vmNameText = targetVm.vm.vmName;
				vmName = targetVm.vm.vmName;
				$scope.appMigrate.createNewMachine = false;
			} else {
				targetVm = {
					vm: {
						vmName: $scope.appMigrate.vmNameText
					}
				};
				vmName = $scope.appMigrate.vmNameText;
				$scope.appMigrate.targetCloudMachine = targetVm;
				$scope.appMigrate.createNewMachine = true;
			}

			if (vmName && vmName !== '') {
				$scope.errors.instanceName = false;
			} else {
				$scope.errors.instanceName = true;
			}
		};

		$scope.policyList = [];
		$scope.loadPolicies = function() {
			//load Policies
			appMigrationService
				.getPolicies({
					vender: 'vender'
				})
				.success(function(data) {
					if (data.length > 0) {
						$scope.policyData = data;
						$scope.cloudTypechange('AMAZON');
					}
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		$scope.loadPolicies();

		$scope.vmsMap = {};
		$scope.loadVms = function(cloudType) {
			if ($scope.isOracleAsService) {
				$scope.vmsList = [];
				return;
			}
			//load libraries only if cvConfig showPlan property is false
			$scope.vmsList = $scope.vmsMap[cloudType];
			if ($scope.vmsList == null) {
				var policyId = $scope.appMigrate.policyId;
				appMigrationService
					.getVms({
						cloudType: cloudType,
						policyID: policyId
					})
					.success(function(data) {
						if (data.length > 0) {
							var vmsList = [];
							angular.forEach(data, function(vmInfo) {
								if (vmInfo && vmInfo.vm && vmInfo.vm.vmName) {
									vmsList.push(vmInfo);
								}
							});
							$scope.vmsList = vmsList;
							$scope.vmsMap[cloudType] = $scope.vmsList;
						}
					})
					.error(function(e) {
						$scope.serverMessage = {
							message: e,
							type: 'error'
						};
					});
			}
		};

		$scope.stagingPathResuleFunction = function(result) {
			//$log.info('path : ' + result.path);
			$scope.appMigrate.stagingPath = result.path;
		};
		$scope.validationScrtResuleFunction = function(result) {
			//$log.info('path : ' + result.path);
			$scope.appMigrate.validationScript = result.path;
		};

		$scope.getStorageDetails = function(instanceEntity, sourceItems) {
			appMigrationService
				.getStorageDetails({
					instance: angular.toJson(instanceEntity),
					sourceItems: angular.toJson(sourceItems)
				})
				.success(function(data) {
					if (data) {
						if (data.totalAppSize) {
							var maxValu = Math.max(15, data.totalAppSize);
							$scope.appMigrate.cloudDBService.dbConfig.dbSizeGB = maxValu;
						}
						$scope.storageDetails = data.volume_list;
						$scope.appMigrate.machineConfig.storageVol_list = $scope.storageDetails;
						$scope.appMigrate.appMetaData_list = data.metaData_list;
					}
				})
				.error(function(e) {
					$scope.serverMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		var updateUserInputs = function() {
			if ($scope.isOracleAsService) {
				$scope.appMigrate.cloudDBService.serviceName = $scope.appMigrate.vmNameText;
				if ($scope.appMigrate.cloudDBService.dbRecoveryConfig.decMethod == '1') {
					delete $scope.appMigrate.cloudDBService.dbRecoveryConfig.walletFilePath;
				} else {
					delete $scope.appMigrate.cloudDBService.dbRecoveryConfig.rmanKey;
				}
				$scope.appMigrate.cloudType = 'ORACLE_CLOUD';
				var bytPassowrd = cvUtil.getBytes($scope.appMigrate.cloudDBService.dbConfig.dbPasswordValue);
				$scope.appMigrate.cloudDBService.dbConfig.dbPassword = bytPassowrd;

				if (
					$scope.appMigrate.cloudDBService.dbRecoveryConfig &&
					$scope.appMigrate.cloudDBService.dbRecoveryConfig.storageUser &&
					$scope.appMigrate.cloudDBService.dbRecoveryConfig.storageUser.userNamePassowrd
				) {
					var userBytPassowrd = cvUtil.getBytes(
						$scope.appMigrate.cloudDBService.dbRecoveryConfig.storageUser.userNamePassowrd
					);
					$scope.appMigrate.cloudDBService.dbRecoveryConfig.storageUser.password = userBytPassowrd;
				}

				if (
					$scope.appMigrate.cloudDBService.dbBackupConfig &&
					$scope.appMigrate.cloudDBService.dbBackupConfig.storageUser &&
					$scope.appMigrate.cloudDBService.dbBackupConfig.storageUser.userNamePassowrd
				) {
					var passValue = cvUtil.getBytes($scope.appMigrate.cloudDBService.dbBackupConfig.storageUser.userNamePassowrd);
					$scope.appMigrate.cloudDBService.dbBackupConfig.storageUser.password = passValue;
				}
			} else if ($scope.isOCIPolicy) {
				if (
					$scope.appMigrate.machineConfig &&
					$scope.appMigrate.machineConfig.advVMProperties &&
					$scope.appMigrate.machineConfig.advVMProperties.networkCards &&
					$scope.appMigrate.machineConfig.advVMProperties.networkCards.length > 0
				) {
					$scope.appMigrate.machineConfig.advVMProperties.networkCards[0].subnetNames =
						$scope.appMigrate.machineConfig.advVMProperties.subnetList;
				}
			} else {
				delete $scope.appMigrate.cloudDBService;
			}
			//if the copy precedence is selected we will set the value
			if ($scope.restoreOptions.copyPreceDencSect) {
				var browseOption = {
					mediaOption: {
						copyPrecedence: {
							copyPrecedence: $scope.restoreOptions.copyPrecedence
						}
					}
				};
				$scope.restoreOptions.browseOption = browseOption;
			}
			if ($scope.isCrossPlatfrom) {
				var appMetaData_list = $scope.appMigrate.appMetaData_list;
				if (appMetaData_list == null) {
					appMetaData_list = [];
				}

				var crossMach = new Object();
				crossMach.value = 'Y';
				crossMach.name = 'CROSS_PLATFORM';
				appMetaData_list.push(crossMach);

				var mData = new Object();
				mData.value = $scope.appMigrate.stagingPath;
				mData.name = 'STAGING_PATH';
				appMetaData_list.push(mData);
			}
			if ($scope.applicationId == 81) {
				$scope.restoreOptions.oracleOpt = null;
				updateSQLOptions();
			} else {
				$scope.restoreOptions.destination.destinationInstance.instanceName = $scope.entity.instanceName;
			}

			if ($scope.appMigrate.preRegistore) {
				var appMetaData_list = $scope.appMigrate.appMetaData_list;
				if (appMetaData_list == null) {
					appMetaData_list = [];
					$scope.appMigrate.appMetaData_list = appMetaData_list;
				}

				var crossMach = new Object();
				crossMach.value = 'YES';
				crossMach.name = 'USE_PRE_CONFIGURE_SERVER';
				appMetaData_list.push(crossMach);
			}
		};

		var gotoSourceSelection = function() {
			$state.go('instances');
		};

		$scope.wizardCancelMethod = function() {
			gotoSourceSelection();
		};

		$scope.runAppMigration = function() {
			updateUserInputs();

			var appMgrconfig = $scope.appMigrate;
			delete appMgrconfig.cloudAllocationPolicy.templates;
			if (
				appMgrconfig.cloudAllocationPolicy.amazonPolicy &&
				appMgrconfig.cloudAllocationPolicy.amazonPolicy.instanceType
			) {
				delete appMgrconfig.cloudAllocationPolicy.amazonPolicy.instanceType;
			}
			var job = {
				options: {
					restoreOptions: $scope.restoreOptions
				},
				pattern: $scope.pattern
			};

			if ($scope.pattern.freq_type == '1') {
				$scope.restoreOptions.commonOptions.syncRestore = false;
			}

			var firewallConfig = $scope.appMigrate.firewallConfig;
			if (firewallConfig.proxyClientName) {
				firewallConfig.proxyInfo = [
					{
						clientName: firewallConfig.proxyClientName
					}
				];
			}

			var liveSyncXML = angular.toJson(job);
			appMgrconfig.liveSyncOptionsXML = liveSyncXML;
			appMigrationService
				.runAppMigration({
					appMgrconfig: angular.toJson(appMgrconfig),
					firewallConfig: angular.toJson($scope.appMigrate.firewallConfig)
				})
				.success(function(successData) {
					if (successData) {
						var jobUrl = '#/jobs/' + successData;
						var responseContent =
							' <a target="_blank" href="' + jobUrl + '">' + cvLoc('label.redirectMsg') + ' ' + successData + '</a>';
						cvToaster.showSuccessMessage({
							ttl: '15000',
							message: responseContent
						});
						gotoSourceSelection();
					}
				})
				.error(function(errorReason) {
					$scope.serverMessage = {
						message: errorReason ? errorReason : cvLoc('error.sunmitAppMigration'),
						type: 'error'
					};
				});
		};

		/*SQL migration query details*/

		var updateSQLOptions = function() {
			//Updating the User info
			var appMetaData_list = $scope.appMigrate.appMetaData_list;
			if (appMetaData_list == null) {
				appMetaData_list = [];
			}

			/*var userName = new Object();
   userName.value = $scope.appMigrate.machineConfig.vmUser.userName;;
   userName.name = "USER_NAME";
               appMetaData_list.push(userName);*/
			//Following code is added in java side need to update it
			//var password = Base64.encode($scope.appMigrate.machineConfig.vmUser.passwordTest);
			/* var userPassword = new Object();
    userPassword.value = password;
    userPassword.name = "PASSWORD";
   appMetaData_list.push(userPassword);*/
			var bytPassowrd = cvUtil.getBytes($scope.appMigrate.osCredentials.password);
			delete $scope.appMigrate.osCredentials.password;
			$scope.appMigrate.osCredentials.password = bytPassowrd;

			$scope.appMigrate.appMetaData_list = appMetaData_list;

			$scope.restoreOptions.destination.destinationInstance.instanceName = $scope.appMigrate.destInstanceName;

			var daseList = [];
			var sourcePathList = [];
			$scope.databases.forEach(function(entity) {
				if (entity.isSelected) {
					var dbName = entity.databaseName;
					daseList.push(dbName);
					sourcePathList.push(dbName);
				}
			});

			if ($scope.restoreOptions.sqlServerRstOption) {
				$scope.restoreOptions.sqlServerRstOption.database = daseList;
				$scope.restoreOptions.sqlServerRstOption.restoreSource = sourcePathList;
			}
		};
	}
]);

export default appMigration;
