import 'capps/js/cappsUtil.js';
import 'capps/js/services/cappsClients.svc.js';
import 'adminConsole/js/services/instances.svc.js';
import 'modules/servers/js/services/servers.svc.js';
import 'capps/js/services/cappsClients.svc.js';
import 'adminConsole/js/services/agents.svc.js';
import 'modules/ida/js/services/idaService.svc.js';
import 'capps/js/directives/cv-capps-browse-content.js';
import 'capps/js/directives/cv-capps-optional-capacity.js';
import 'dbs/js/services/dbs.factory.js';
import 'ida/js/directives/cv-cloud-db-engine-select.js';
import 'vsa/js/factories/vendorTypes.factory.js';
import 'capps/js/directives/cv-capps-access-nodes.js';
import 'modules/ida/js/directives/GCP-spanner-input-directive.js';

import { cappsAppCappsClientModule } from 'common/js/modules';
import 'adminConsole/js/factories/planPolicyModel.factory.js';

export class addCloudDatabaseController {
	constructor(
		cvLoc,
		cvUtil,
		AppTypes,
		CAPPS_CONSTANTS,
		$uibModal,
		$uibModalInstance,
		data,
		cvToaster,
		idaService,
		$state,
		cappsContentFactory,
		CLOUD_DB_VENDOR,
		$timeout,
		$scope,
		planPolicyModel,
		globalCacheFactory,
		cappsClientService,
		vendorTypes
	) {
		this.cvLoc = cvLoc;
		this.cvUtil = cvUtil;
		this.AppTypes = AppTypes;
		this.CAPPS_CONSTANTS = CAPPS_CONSTANTS;
		this.$uibModal = $uibModal;
		this.$uibModalInstance = $uibModalInstance;
		this.data = data;
		this.cvToaster = cvToaster;
		this.idaService = idaService;
		this.$state = $state;
		this.cappsContentFactory = cappsContentFactory;
		this.CLOUD_DB_VENDOR = CLOUD_DB_VENDOR;
		this.$timeout = $timeout;
		this.$scope = $scope;
		this._planPolicyModel = planPolicyModel;
		this.planPolicyModel = angular.copy(planPolicyModel.get('Default'));
		this.globalCacheFactory = globalCacheFactory;
		this.cappsClientService = cappsClientService;
		this.vendorTypes = vendorTypes;
		this.showVendorSelection = true;
		this.isCreateRDSInstance = false;
		this._init();
	}

	_getLocLabels(placeHolder) {
		const labels = this.cvUtil.getIStevenLocLabels();
		labels.nothingSelected = placeHolder;
		return labels;
	}

	addHypervisorDialog() {
		const self = this;
		const modalInstance = this.$uibModal.open({
			templateUrl: appUtil.appRoot + 'vsa/partials/addServerContent.jsp',
			windowClass: 'addServerModal',
			backdrop: 'static',
			controller: [
				'$scope',
				'$uibModalInstance',
				function($scope, $modalInstance) {
					$scope.isSubModal = true;
					$scope.forCloudAccount = self.selectedVendor;
					$scope.cloudDbAppType = self.entity.applicationId;
					$scope.sqlCloudParam = self.sqlCloudParam;
					$scope.$on('serverAdded', function(evt, serverId) {
						self.addedServerId = serverId;
						self._loadClients();
						$modalInstance.dismiss();
					});
					$scope.$on('serverAddCancelled', function() {
						$modalInstance.dismiss();
					});
				}
			]
		});
	}

	_init() {
		this.dialogTitle = this.cvLoc('label.addCloudDbInstance', 'Cloud DB');
		this.clientLoc = this._getLocLabels(this.cvLoc('placeholder.cloudAccount'));
		this.vendorLoc = this._getLocLabels(this.cvLoc('placeholder.vendorType'));
		this.databaseServiceLoc = this._getLocLabels(this.cvLoc('placeholder.databaseService'));
		this.backupMethod = '0';
		this.entity = {};
		this.serverMessage = {
			message: '',
			type: ''
		};

		this.model = {
			instanceName: undefined,
			numberOfBackupStreams: 2,
			enableAdjustReadCapacity: false,
			adjustReadCapacity: 5
		};

		this.vendorList = this.getVendorList();
		this.clientList = [];
		this._selectedClients = [];

		this.selectedContent = [];
		this.submitAttempted = false;

		if (this.data && this.data.selectVendor) {
			let self = this;
			this.$timeout(
				function() {
					self.vendorList.forEach(function(vendor) {
						if (vendor.value === self.data.selectVendor) {
							vendor.selected = true;
							self.dialogTitle = self.cvLoc('label.addCloudDbInstance', vendor.name);
							self.onVendorChanged(vendor);
						}
					});

					self.databaseServiceList.forEach(function(engine) {
						if (engine.key === self.data.selectEngine) {
							self.isCreateRDSInstance = true;
							engine.selected = true;
							self.onDatabaseServiceChanged(engine);
						}
					});
				},
				500,
				false
			);
		}
	}

	getDatabaseServiceList(vendor) {
		let engines = [];
		if (vendor.value === this.CLOUD_DB_VENDOR.GOOGLE_CLOUD || vendor.value === this.CLOUD_DB_VENDOR.ALIBABA_CLOUD) {
			engines = [
				{
					applicationId: this.AppTypes.MYSQL,
					displayName: this.cvLoc('label.mySql'),
					tooltip: this.cvLoc('tooltip.engineMySQL'),
					key: 'MySQL'
				},
				{
					applicationId: this.AppTypes.POSTGRESQL,
					displayName: this.cvLoc('label.postgreSQL'),
					tooltip: this.cvLoc('tooltip.eginePostgreSQL'),
					key: 'PostgreSQL'
				}
			];

			cvConfig.showCloudSpanner &&
				vendor.value === this.CLOUD_DB_VENDOR.GOOGLE_CLOUD &&
				engines.push({
					applicationId: this.AppTypes.CLOUD_APPS,
					displayName: this.cvLoc('instanceType.spanner'),
					tooltip: this.cvLoc('instanceType.spanner'),
					key: this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GCP_SPANNER.key
				});
		} else if (vendor.value === this.CLOUD_DB_VENDOR.AZURE_V2) {
			engines = [
				{
					applicationId: this.AppTypes.MYSQL,
					displayName: this.cvLoc('label.mariaDb'),
					tooltip: this.cvLoc('tooltip.engineMariaDB'),
					key: 'MariaDB'
				},
				{
					applicationId: this.AppTypes.MYSQL,
					displayName: this.cvLoc('label.mySql'),
					tooltip: this.cvLoc('tooltip.engineMySQL'),
					key: 'MySQL'
				},
				{
					applicationId: this.AppTypes.POSTGRESQL,
					displayName: this.cvLoc('label.postgreSQL'),
					tooltip: this.cvLoc('tooltip.eginePostgreSQL'),
					key: 'PostgreSQL'
				},
				{
					applicationId: this.AppTypes.SQL_SERVER,
					displayName: this.cvLoc('label.sqlserver'),
					key: 'SQL Server'
				}
			];

			if (cvConfig.showAzureTableStorage) {
				engines.push({
					applicationId: this.AppTypes.CLOUD_APPS,
					cloudAppsType: this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_TABLE_STORAGE.key,
					displayName: this.cvLoc('viewname.dbInstancesTable.tableStorage'),
					key: 'Table storage'
				});
			}

			engines.push({
				applicationId: this.AppTypes.CLOUD_APPS,
				cloudAppsType: this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_COSMOS_DB_SQL_API.key,
				displayName: this.cvLoc('label.cosmosDB'),
				key: 'CosmosDB'
			});

			engines.sort((a, b) => {
				return a.displayName.localeCompare(b.displayName);
			});
		} else if (vendor.value === this.CLOUD_DB_VENDOR.AMAZON) {
			engines = [
				{
					applicationId: this.AppTypes.CLOUD_APPS,
					cloudAppsType: this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.key,
					displayName: this.cvLoc('label.dynamodb'),
					key: 'DynamoDB'
				},
				{
					applicationId: this.AppTypes.CLOUD_APPS,
					cloudAppsType: this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_RDS.key,
					displayName: this.cvLoc('label.rds'),
					tooltip: this.cvLoc('tooltip.engineRDS'),
					key: 'RDS'
				},
				{
					applicationId: this.AppTypes.CLOUD_APPS,
					cloudAppsType: this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_REDSHIFT.key,
					displayName: this.cvLoc('viewname.dbInstancesTable.redshift'),
					tooltip: this.cvLoc('tooltip.engineRedshift'),
					key: 'Redshift'
				},
				{
					applicationId: this.AppTypes.CLOUD_APPS,
					cloudAppsType: this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DOCUMENTDB.key,
					displayName: this.cvLoc('viewname.dbInstancesTable.documentdb'),
					tooltip: this.cvLoc('tooltip.engineDocumentDB'),
					key: 'DocumentDB'
				}
			];
		}
		return engines;
	}

	getVendorList() {
		const vendorTypes = this.vendorTypes.getVendorTypes({});
		const supportedVendors = [
			this.CLOUD_DB_VENDOR.AMAZON,
			this.CLOUD_DB_VENDOR.AZURE_V2,
			this.CLOUD_DB_VENDOR.GOOGLE_CLOUD,
			this.CLOUD_DB_VENDOR.ALIBABA_CLOUD
		];
		return vendorTypes
			.filter(a => {
				let index = supportedVendors.indexOf(a.value);
				//Added rank to keep the same order as supported array
				a.rank = index;
				return index >= 0;
			})
			.sort((a, b) => a.rank - b.rank);
	}

	clientSelectionChanged() {
		const selected = this._selectedClients[0] || {};

		const changed = this.entity.clientId !== selected.clientId;

		if (changed) {
			(this.entity.clientId = selected.clientId), (this.entity.clientName = selected.clientName);
			this.entity.isAccessNodeConfigured = _.get(selected, 'isAccessNodeConfigured', false);
			this.accessNodes = []; // reset the selected access nodes list
		}
		this.engineFlag = !this.engineFlag;

		this.childDirectiveData.isSQLCloudConfigured = false;
		if (this.entity.clientId && this.entity.applicationId === this.AppTypes.SQL_SERVER) {
			this._loadClientDetails(this.entity.clientId);
		} else {
			this._setUseChildDirective();
		}

		this._setupGCPSpannerOptions();
	}

	_loadClientDetails(clientId) {
		const self = this;
		this.idaService
			.getClientDetails(clientId)
			.success(this.onRetrieveClientDetailsSuccess.bind(this))
			.error(function(error) {
				self.serverMessage = {
					message: e,
					type: 'error'
				};
			});
	}

	onRetrieveClientDetailsSuccess(data) {
		this.clientDetails = data;

		if (
			_.has(this.clientDetails, 'pseudoClientInfo.idaInfo.sql61Prop') &&
			this._isSQLCloudConfigured(this.clientDetails.pseudoClientInfo.idaInfo.sql61Prop)
			//				(
			//						this.clientDetails.pseudoClientInfo.idaInfo.sql61Prop.isAwsConfigured ||
			//						this.clientDetails.pseudoClientInfo.idaInfo.sql61Prop.isAzureConfigured)
		) {
			this.childDirectiveData.isSQLCloudConfigured = true;
		}
		this._setUseChildDirective();
	}

	_isSQLCloudConfigured(sql61Prop) {
		return (
			(sql61Prop.azureInfo && sql61Prop.azureInfo.azureStorageConnectionString) ||
			(sql61Prop.awsSqlInfo && sql61Prop.awsSqlInfo.s3BucketName)
		);
	}

	showAccessNodeConfiguration() {
		return (
			(this.entity &&
				this.entity.clientId &&
				!this.entity.isAccessNodeConfigured &&
				this.cloudAppsType === this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_COSMOS_DB_SQL_API.key) ||
			_.get(this.dbService, 'key') === this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GCP_SPANNER.key
		);
	}

	_loadClients() {
		const self = this;

		this.clientList.length = 0;
		self.clientListLoaded = false;

		const params = {
			vendor: this.selectedVendor,
			instanceType: !this.cloudAppsType ? undefined : this.cloudAppsType
		};
		this.cappsClientService
			.getCloudAccounts(params)
			.success(function(data) {
				if (data && data.CloudAppsClientsList) {
					angular.forEach(data.CloudAppsClientsList, function(client) {
						client.client.isAccessNodeConfigured = _.get(client, 'isAccessNodeConfigured', false);
						if (!self.clientIdForPlans) {
							self.clientIdForPlans = client.client.clientId;
						}
						if (self.addedServerId && self.addedServerId === client.client.clientId) {
							client.client.selected = true;
							self._selectedClients[0] = client.client;
							self.clientSelectionChanged();
						}
						self.clientList.push(client.client);
					});
					self.clientList.sort((a, b) => {
						return a.clientName.localeCompare(b.clientName);
					});
				}
				self.clientListLoaded = true;
			})
			.error(function(e) {
				self.serverMessage = self.cvUtil.errMsg(e);
			});
	}

	cancel() {
		this.$uibModalInstance.close();
	}

	close(instanceId) {
		this.$uibModalInstance.close();
		//this.$state.forceReload();
		this.$state.go('databaseDetails', { instanceId: instanceId });
	}

	backupMethodChanged(backupMethod) {
		let venderSelected = this.selectedVendor;
		this.childDirectiveData = {};
		this.showCloundAccount = false;
		if (backupMethod === '0') {
			venderSelected = null;
			this.showCloundAccount = true;
			this._loadClients();
		}
		this.$scope.$broadcast('vendorChanged', venderSelected);
	}

	onDatabaseServiceChanged(dbService) {
		this.dbService = dbService;
		this.showCosmosDbApi = false;
		this.backupMethodLabel = this.cvLoc('label.snapshot');
		if (
			this.dbService.cloudAppsType === this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.key ||
			this.selectedVendor === this.CLOUD_DB_VENDOR.AZURE_V2 ||
			this.selectedVendor === this.CLOUD_DB_VENDOR.GOOGLE_CLOUD ||
			this.selectedVendor === this.CLOUD_DB_VENDOR.ALIBABA_CLOUD
		) {
			this.backupMethodLabel = this.cvLoc('label.export');
		}
		if (
			this.dbService &&
			(this.selectedVendor === this.CLOUD_DB_VENDOR.AMAZON || this.selectedVendor === this.CLOUD_DB_VENDOR.AZURE_V2)
		) {
			this.showBackupMethod = true;
		}

		if (
			this.dbService &&
			this.dbService.cloudAppsType === this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_COSMOS_DB_SQL_API.key
		) {
			this.showBackupMethod = false;
			return this.enbaleCosmosDbApiMethods();
		}
		if (
			this.selectedVendor === this.CLOUD_DB_VENDOR.AMAZON &&
			_.get(this.dbService, 'cloudAppsType') !== this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_RDS.key
		) {
			this.$scope.$broadcast('vendorChanged', null);
		}

		this._setupGCPSpannerOptions();

		this.onEngineChanged(dbService);
	}

	_getCosmosDBApiMethods() {
		let apiMethods = [
			{
				applicationId: this.AppTypes.CLOUD_APPS,
				cloudAppsType: this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_COSMOS_DB_SQL_API.key,
				displayName: this.cvLoc('viewname.dbInstancesTable.cosmosDbSQL'),
				labelName: this.cvLoc('label.sqlApi'),
				key: 'Cosmos DB'
			}
		];
		return apiMethods;
	}

	onChangeCosmosDbApi(cosmosDbApi) {
		this.showBackupMethod = true;
		this.onEngineChanged(cosmosDbApi);
	}

	enbaleCosmosDbApiMethods() {
		this.cosmosDbApis = this._getCosmosDBApiMethods();
		this.showCosmosDbApi = true;
		this.showCosmosDbApiSelection = this.cosmosDbApis.length > 1;
		this.cosmosDbApiLabel = this.cvLoc('label.api');
		this.cosmosDbApiHelpText = this.cvLoc('help.api');
		this.selectedCosmosDbApi = undefined;

		if (this.cosmosDbApis.length === 1) {
			this.selectedCosmosDbApi = this.cosmosDbApis[0].labelName;
			return this.onChangeCosmosDbApi(this.cosmosDbApis[0]);
		}
	}

	onEngineChanged(engine) {
		this.selectedEngine = engine;
		this.showCloundAccount = true;
		this.sqlCloudParam = {
			isSqlAzure: engine.applicationId == 81 && this.selectedVendor === 'AZURE_V2',
			isSqlAmazon: engine.applicationId == 81 && this.selectedVendor === 'AMAZON'
		};
		this.cloudAppsType = this.sqlCloudParam.isSqlAzure
			? this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_SQL.key
			: this.sqlCloudParam.isSqlAmazon
			? this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_SQL.key
			: engine.cloudAppsType;

		this._setShowContent();
		this._setShowReadCapacity();
		this._setUseChildDirective();
		this._setShowEntityNameFields();
		this.entity.applicationId = engine.applicationId;
		this.submitAttempted = false;

		if (engine.cloudAppsType) {
			this.entity.instanceName = engine.key;
		}
		this.entity.clientId = undefined;
		this.planPolicyModel = angular.copy(this._planPolicyModel.get('Default'));
		this.entity.cloudDBEngineType = this.getCloudDBEngineType(engine.key);

		this.childDirectiveData = {
			idaEntity: angular.copy(this.entity),
			editDialog: 'Add_Instance',
			planPolicyModel: this.planPolicyModel,
			isSQLCloudConfigured: false
		};

		this._loadClients();
	}

	onVendorChanged(vendor) {
		this.selectedVendor = vendor.value;
		this.dbService = undefined;
		this.selectedEngine = undefined;
		this.showCloundAccount = false;
		this.entity.applicationId = undefined;
		this.entity.clientId = undefined;
		this.entity.vendor = vendor.value;
		this.cloudAppsType = undefined;
		this._setShowContent();
		this._setShowReadCapacity();
		this._setUseChildDirective();
		this._setShowEntityNameFields();
		let venderSelected = vendor.value;
		let dbServiceLable = '';
		this.backupMethodLabel = this.cvLoc('label.export');
		this.showBackupMethod = true;
		this.showCosmosDbApi = false;
		this.databaseServiceList = this.getDatabaseServiceList(vendor);
		this.showDatabaseServiceSelection = this.databaseServiceList.length > 0;
		if (vendor.value === this.CLOUD_DB_VENDOR.AZURE_V2) {
			this.showBackupMethod = false;
			venderSelected = null;
		} else if (vendor.value === this.CLOUD_DB_VENDOR.GOOGLE_CLOUD) {
			dbServiceLable = this.cvLoc('label.cloudSQL');
			venderSelected = null;
		} else if (vendor.value === this.CLOUD_DB_VENDOR.ALIBABA_CLOUD) {
			dbServiceLable = this.cvLoc('label.asparaDBRDS');
			venderSelected = null;
		} else if (vendor.value === this.CLOUD_DB_VENDOR.AMAZON) {
			this.showBackupMethod = false;
			venderSelected = null;
			this.backupMethod = '0';
		} else {
			this.backupMethod = '1';
		}
		this.dbServiceLable = dbServiceLable;
		this.$scope.$broadcast('vendorChanged', venderSelected);
	}

	_setShowContent() {
		this.showContent =
			this.cloudAppsType === this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.key ||
			this.cloudAppsType === this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DOCUMENTDB.key ||
			this.cloudAppsType === this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_RDS.key ||
			this.cloudAppsType === this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_REDSHIFT.key ||
			this.cloudAppsType === this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_TABLE_STORAGE.key ||
			this.cloudAppsType === this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_COSMOS_DB_SQL_API.key;
	}

	_setShowEntityNameFields() {
		this.showInstanceName = false;
		this.showSubclientName = false;
		if (
			this.cloudAppsType === this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.key ||
			this.cloudAppsType === this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_COSMOS_DB_SQL_API.key
		) {
			this.showInstanceName = true;
			this.showSubclientName = true;
		}

		// subclient name label
		this.subclientNameLabel = this.cvLoc('label.DatabaseGroups');
		if (this.cloudAppsType === this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.key) {
			this.subclientNameLabel = this.cvLoc('label.tableGroup');
			this.subclientNameLabelError = this.cvLoc('error.tableGroup');
		} else if (this.cloudAppsType === this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_COSMOS_DB_SQL_API.key) {
			this.subclientNameLabel = this.cvLoc('label.containerGroup');
			this.subclientNameLabelError = this.cvLoc('error.containerGroup');
		}

		this.subclientName = this.cvLoc('default.subclient.name');
	}

	_setShowReadCapacity() {
		this.showReadCapacity = this.cloudAppsType === this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.key;
	}

	onAccessNodeChange(data) {
		this.enableContentBrowse = !this.enableContentBrowse;
		this._setupGCPSpannerOptions(null, data);
	}

	getCloudDBEngineType(cloudDBEngineType) {
		switch (cloudDBEngineType) {
			case 'MySQL':
				return '3';
				break;
			case 'PostgreSQL':
				return '1';
				break;
			case 'MariaDB':
				return '5';
				break;
			case 'Aurora MySQL':
				return '4';
				break;
			case 'Aurora PostgreSQL':
				return '2';
				break;
			case 'SQL Server':
				return '6';
				break;
			default:
				return '-1';
				break;
		}
	}

	getDefaultContentText() {
		if (this.cloudAppsType === this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DYNAMODB.key) {
			return this.cvLoc('label.dynamodbAllContent');
		} else if (
			this.cloudAppsType === this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_DOCUMENTDB.key ||
			this.cloudAppsType === this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_REDSHIFT.key
		) {
			return this.cvLoc('label.allClustersInAllRegions');
		} else if (this.cloudAppsType === this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AMAZON_RDS.key) {
			return this.cvLoc('label.allInstancesInAllRegions');
		} else if (this.cloudAppsType === this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_TABLE_STORAGE.key) {
			return this.cvLoc('label.azureTableStorageAllContent');
		} else if (this.cloudAppsType === this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.AZURE_COSMOS_DB_SQL_API.key) {
			return this.cvLoc('label.azureCosmosDBSQLAllContent');
		}
	}

	_setUseChildDirective() {
		/* True to hide the buttons in current controller and use buttons in children controller */
		this.useChildDirective =
			this.entity.clientId &&
			(this.entity.applicationId === this.AppTypes.POSTGRESQL ||
				this.entity.applicationId === this.AppTypes.MYSQL ||
				this.entity.applicationId === this.AppTypes.ORACLE ||
				this.entity.applicationId === this.AppTypes.SQL_SERVER);
	}

	validateInputs() {
		var formValid = true;
		if (!this.planPolicyModel.plan.selected) {
			this.submitAttempted = true;
			formValid = false;
			this.$scope.$apply();
		}

		return formValid;
	}

	disableActiveityOnInstance(instanceEntity) {
		let self = this;
		let instanceProperties = {
			instanceActivityControl: {
				activityControlOptions: [
					{
						activityType: 1,
						enableActivityType: false
					},
					{
						activityType: 2,
						enableActivityType: false
					}
				]
			}
		};
		let instanceInfo = {
			instanceEntity: angular.toJson(instanceEntity),
			instanceProps: angular.toJson(instanceProperties)
		};
		this.idaService.createInstance(instanceInfo, true).success(function(data) {
			self.cancel();
		});
	}

	submit() {
		const self = this;

		const instProps = {
			cloudAppsInstance: {
				instanceType: this.cloudAppsType,
				amazonDynamoDB: {},
				rdsInstance: {},
				azureTableStorageInstance: {}
			},
			planEntity: {
				planId: this.planPolicyModel.plan.selected.id
			}
		};

		if (self.accessNodes && self.accessNodes.length) {
			instProps['cloudAppsInstance']['generalCloudProperties'] = {
				accessNodes: {
					memberServers: self.accessNodes
				}
			};
		}

		let convertedEntity = [
			{
				type: 'ROOT'
			}
		];
		if (this.showContent && this.editContent) {
			convertedEntity = this.cappsContentFactory.convertSelectedContent(this.selectedContent, this.cloudAppsType);
		}

		const newEntity = angular.copy(this.entity);

		const subclientProps = {
			cloudAppsSubClientProp: {
				instanceType: this.cloudAppsType,
				dynamoDBSubclient: {},
				rdsSubclient: {},
				tableStorageSubclient: {}
			},
			cloudDbContent: {
				children: convertedEntity
			},
			cloudDbFilter: {},
			commonProperties: {
				numberOfBackupStreams: this.model.numberOfBackupStreams
			}
		};
		if (this.model.enableAdjustReadCapacity) {
			subclientProps.cloudAppsSubClientProp.dynamoDBSubclient.temporaryReadThroughput = this.model.adjustReadCapacity;
		}

		if (_.get(this.dbService, 'key') === this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GCP_SPANNER.key) {
			if (!_.isFunction(this.GCPInputOptions.getSpannerInputs)) {
				return;
			}

			let cloudAppsInputs = this.GCPInputOptions.getSpannerInputs();

			this.entity.instanceName = _.get(cloudAppsInputs, 'instance.name');

			instProps.instance = {
				clientId: this.GCPInputOptions.cloudAccountId,
				instanceName: _.get(cloudAppsInputs, 'instance.name'),
				applicationId: this.AppTypes.CLOUD_APPS
			};

			instProps.cloudAppsInstance = {
				instanceType: this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GCP_SPANNER.value,
				cloudSpannerInstance: {
					projectId: _.get(cloudAppsInputs, 'instance.path'),
					instanceId: _.get(cloudAppsInputs, 'instance.name'),
					cloudStagingPath: _.get(cloudAppsInputs, 'stagingBucketPath')
				},
				generalCloudProperties: {
					proxyServers: _.map(self.accessNodes, ({ client }) => ({ clientId: client.clientId }))
				}
			};

			subclientProps.cloudAppsSubClientProp = {
				instanceType: this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GCP_SPANNER.value,
				cloudSpannerSubclient: {
					backupObject: _.get(cloudAppsInputs, 'database.length')
						? _.map(cloudAppsInputs.database, ({ name }) => ({
								dbName: name
						  }))
						: [{ dbName: '/' }]
				}
			};
		}

		let paramsForApi = {
			instanceEntity: angular.toJson(this.entity),
			instanceProps: angular.toJson(instProps),
			subclientProps: angular.toJson(subclientProps)
		};

		// pass the custom subclient name only if new subclient name is not default
		if (this.showSubclientName && this.subclientName != this.cvLoc('default.subclient.name')) {
			paramsForApi.subclientName = this.subclientName;
		}

		this.idaService
			.createInstanceAndUpdateSubclient(paramsForApi)
			.success(function(data) {
				self.globalCacheFactory.refreshCacheId();
				if (self.isCreateRDSInstance) {
					//For RDS instance creation we need to disable activity controlles
					let insEntity = angular.copy(self.entity);
					insEntity.instanceId = data;
					self.disableActiveityOnInstance(insEntity);
				} else {
					self.close(data);
				}
			})
			.error(function(err) {
				self.serverMessage = self.cvUtil.errMsg(err);
			});
	}

	_setupGCPSpannerOptions(cloudAccountId, accessNodes) {
		if (_.get(this.dbService, 'key') !== this.CAPPS_CONSTANTS.CLOUD_APP_INSTANCE_TYPE.GCP_SPANNER.key) {
			this.showGCPInputs = false;
			return;
		}

		this.GCPInputOptions = {
			cloudAccountId: cloudAccountId || this.entity.clientId,
			accessNodes: accessNodes || this.accessNodes
		};

		this.showGCPInputs = !!this.GCPInputOptions.cloudAccountId && !!_.get(this.GCPInputOptions.accessNodes, 'length');
	}
}

addCloudDatabaseController.$inject = [
	'cvLoc',
	'cvUtil',
	'AppTypes',
	'CAPPS_CONSTANTS',
	'$uibModal',
	'$uibModalInstance',
	'data',
	'cvToaster',
	'idaService',
	'$state',
	'cappsContentFactory',
	'CLOUD_DB_VENDOR',
	'$timeout',
	'$scope',
	'planPolicyModel',
	'globalCacheFactory',
	'cappsClientService',
	'vendorTypes'
];

cappsAppCappsClientModule.controller('addCloudDatabase', addCloudDatabaseController);
export default cappsAppCappsClientModule;
