<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.databaseClone"></cv:cvMessages>
		<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper">
<form name="fsCloneForm" class="form-horizontal" novalidate autocomplete="off" data-cv-submit="fsCloneCtrl.submitFsClone()">
	<div class="modal-header">
		<h1><cv:msg key="label.instantClone" bundle="databaseClone"/></h1>
	</div>
	<span class="serverMessage {{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
	<div class="panel panel-default">
		<div class="panel-body">
			<div class="form-group">
				<label class="col-xs-12 col-sm-5" for="destClient">
					<cv:msg key="label.oracleVmDestinationServer" bundle="restore"/>
				</label>
				<div class="col-xs-12 col-sm-7">
					<!-- <select data-ng-model="dbClone.data.destClient" name="destClient" id="destClient"
						data-ng-change="dbClone.destClientChanged(dbClone.data.destClient)"
						data-ng-options="client as client.clientName for client in dbClone.clientsList | orderBy:'clientName'">
					</select> -->
					<cv-isteven-single-select id-name="destClient"
								input-model="fsCloneCtrl.restoreData.clientsList"
								binding-model="fsCloneCtrl.restoreData.destClient"
								track-field="clientId"
								label="clientName"
								tick-property="selected"
								place-holder='<cv:msg key="placeholder.selectDestinationServer" bundle="restoreJs"/>'
								on-change='fsCloneCtrl.destinationChanged()'
								help-text='<cv:msg key="placeholder.selectDestinationServer" bundle="restoreJs"/>'
								required = "true">
					</cv-isteven-single-select>
				</div>
			</div>
		</div>

		<!-- // clone mount path  // -->
		<div class="panel-body">
			<div class="form-group"   title='<cv:msg key="label.cloneMountPath" bundle="restore"/>' >
				<label class="col-xs-12 col-sm-5" for="cloneMountPath"><cv:msg key="label.cloneMountPath" bundle="restore" /></label>
				<div class="col-xs-12 col-sm-7">
					<div class="input-group">
						<input name="cloneMountPath" id="cloneMountPath" type="text" data-ng-model="fsCloneCtrl.restoreData.cloneMountPath" />
						<span class="input-group-btn">
							<!-- <button id="cloneMountPath" data-ng-click="fsCloneCtrl.openBrowseModel('cloneMountPath')" type="button" class="btn btn-default browse-btn margin-top-3"><cv:msg key="label.browse" bundle="restore" /></button> -->
							<div class="col-xs-1 padding-left-0 padding-right-0"><a href="" id="cloneMountPath" class="btn btn-ternary padding-3 rounded-border-radius" data-ng-click="fsCloneCtrl.openBrowseModel('cloneMountPath')" title="<cv:msg key="label.browse" bundle="restore" />"><span class="k-icon k-i-folder-more font-size-page-title"></span></a></div>
						</span>
					</div>
					 <span class="help-block" data-ng-show="fsCloneCtrl.instantCloneAttempted && !fsCloneCtrl.restoreData.cloneMountPath">
	                      <cv:msg key="error.cloneMountPath" bundle="restore" />
	                </span>
	                <span class="help-block" data-ng-show="!fsCloneCtrl.errors.isCloneMountPathValid">
	                      <cv:msg key="error.cloneMountPath.pattern" bundle="restore" />
	                </span>

				</div>
			</div>
		</div>

		<div class="panel-body">
			<div class="form-group">
				<label class="col-xs-12 col-sm-5" for="overwriteClone"><cv:msg key="label.overwriteExistingClone" bundle="servers"/></label>
		        <toggle-control  class="col-xs-12 col-sm-7"  status="fsCloneCtrl.restoreData.overwriteExistingClone ? 'enabled-activity' : 'disabled-activity'"
		        	data-ng-click="fsCloneCtrl.toggleOverwriteClone()">
		        	</toggle-control>
			</div>
		</div>


		<!--  Clone reservation  -->
		<div class="panel-body">
			<div class="form-group">
				<label class="col-xs-12 col-sm-5" for="rsvTPDays">
					<cv:msg key="label.cloneReservation" bundle="oracle"/>
				</label>
				<div class="col-xs-12 col-sm-3">
						<input type="number" id="rsvTPDays" min="0" name="rsvTPDays" data-ng-model="fsCloneCtrl.restoreData.rsvTPDays" data-ng-change="fsCloneCtrl.validateReservationTime()"/>
						<label for="rsvTPDays" class="inline-block">
							<cv:msg key="days" bundle="messagesJs"/>
						</label>
				</div>
				<div class="col-xs-12 col-sm-3">
						<input type="number" id="rsvTPHours" min="0" name="rsvTPHours" data-ng-model="fsCloneCtrl.restoreData.rsvTPHours"  data-ng-change="fsCloneCtrl.validateReservationTime()"/>
						<label for="rsvTPHours" class="inline-block">
							<cv:msg key="hours" bundle="messagesJs"/>
						</label>
				</div>
				<div>
					<div class="col-xs-12 col-sm-5" ></div>
					<div class="col-xs-12 col-sm-7" >
						<span class="help-block" data-ng-show="fsCloneCtrl.errors.rsvTPDays">
								<cv:msg key="error.cloneReservationTime" bundle="restore"/>
						</span>
					</div>
				</div>


			</div>
		</div>

		<!-- // post clone script path  // -->
		<div class="panel-body">
			<div class="form-group"   title='<cv:msg key="label.postCloneScript" bundle="restore"/>' >
				<label class="col-xs-12 col-sm-5" for="postCloneScript">
					<cv-help-text help-label="label.postCloneScript" help-text="label.postCloneScriptHelpText" />
					<span class="optional-text"><cv:msg key="label.optional" bundle="restore" /></span>
				</label>

				<div class="col-xs-12 col-sm-7">
					<div class="input-group">
						<input name="postCloneScript" id="postCloneScript" type="text" data-ng-model="fsCloneCtrl.restoreData.postCloneScript" />
						<span class="input-group-btn">
							<!-- <button id="postCloneScript"  type="button" class="btn btn-default browse-btn margin-top-3"><cv:msg key="label.browse" bundle="restore" /></button> -->
							<div class="col-xs-1 padding-left-0 padding-right-0"><a href="" id="postCloneScript" class="btn btn-ternary padding-3 rounded-border-radius" data-ng-click="fsCloneCtrl.openBrowseModel('postCloneScript')" title="<cv:msg key="label.browse" bundle="restore" />"><span class="k-icon k-i-folder-more font-size-page-title"></span></a></div>
						</span>
					</div>
				</div>
			</div>
		</div>

		<!-- // clone clean up script path  // -->
		<div class="panel-body">
			<div class="form-group"  title='<cv:msg key="label.cloneCleanupScript" bundle="restore"/>' >
				<label class="col-xs-12 col-sm-5" for="cloneCleanupScript">
					<cv-help-text help-label="label.cloneCleanupScript" help-text="label.cloneCleanupScriptHelpText" />
				 	<span class="optional-text"><cv:msg key="label.optional" bundle="restore" /></span>
				</label>

				<div class="col-xs-12 col-sm-7">
					<div class="input-group">
						<input name="cloneCleanupScript" id="cloneCleanupScript" type="text" data-ng-model="fsCloneCtrl.restoreData.cloneCleanupScript" />
						<span class="input-group-btn">
							<!-- <button id="cloneCleanupScript" data-ng-click="fsCloneCtrl.openBrowseModel('cloneCleanupScript')" type="button" class="btn btn-default browse-btn margin-top-3"><cv:msg key="label.browse" bundle="restore" /></button>-->
							<div class="col-xs-1 padding-left-0 padding-right-0"><a href="" id="cloneCleanupScript" class="btn btn-ternary padding-3 rounded-border-radius" data-ng-click="fsCloneCtrl.openBrowseModel('cloneCleanupScript')" title="<cv:msg key="label.browse" bundle="restore" />"><span class="k-icon k-i-folder-more font-size-page-title"></span></a></div>
						</span>
					</div>
				</div>
			</div>
		</div>

	</div>


<!-- --End of Clone options section -->
	<div class="modal-footer">
  		<button id="fsCloneModalCancelButton" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="fsCloneCtrl.cancelModal()">
  			<cv:msg key="Cancel" bundle="messages"/>
 		</button>
  		<button id="fsCloneModalSubmitButton" type="submit" class="btn btn-primary cvBusyOnAjax" >
  			<span> <cv:msg key="Submit" bundle="messages"/> </span>
  		</button>
	</div>
</form>
</div>
