<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
</script>
<div class="panel-body ">
	<div class="panel-body ">
		<!-- // Iscsi proxy server // -->
		<div class="form-group" title='<cv:msg key="label.IscsiProxyServer" bundle="sqlserver"/>' data-ng-if="dbClone.isSqlClone && dbClone.data.showiSCSIServer">
			<label class="col-xs-12 col-lg-4" for="proxyClient">
				<cv:msg key="label.iSCSIProxyServer" bundle="sqlserver"/> </label>
			<div class="col-xs-12 col-lg-6 uib-wrapper">
				<select data-ng-model="dbClone.data.proxyClient" name="proxyClient"
					id="proxyClient"
					data-ng-options="client as client.clientName for client in dbClone.clientsList | orderBy:'clientName'">
				</select>
			</div>
		</div>
		
		<!-- // Clone reservation // -->
		<div class="form-group">
			<label class="col-xs-12 col-lg-4" for="rsvTPDays">
				<cv:msg key="label.cloneReservation" bundle="oracle"/>
			</label>
			<div class="col-xs-12 col-lg-3">
				<input type="number" id="rsvTPDays" min="0" name="rsvTPDays" data-ng-model="dbClone.data.cloneEnv.rsvTPDays" data-ng-change="dbClone.validateValue()"/>
				<label for="rsvTPDays" class="inline-block">
					<cv:msg key="days" bundle="messagesJs"/>
				</label>
			</div>
			<div class="col-xs-12 col-lg-3">
				<input type="number" id="rsvTPHours" min="0" name="rsvTPHours" data-ng-model="dbClone.data.cloneEnv.rsvTPHours"  data-ng-change="dbClone.validateValue()"/>
				<label for="rsvTPHours" class="inline-block">
					<cv:msg key="hours" bundle="messagesJs"/>
				</label>
			</div>
			<span class="help-block" data-ng-show="cv.wizardForm.needsAttention(wizardForm.rsvTPDays) || cv.wizardForm.needsAttention(wizardForm.rsvTPHours) || dbClone.errors.rsvTPDays">
				<cv:msg key="error.rsvTime" bundle="databaseClone"/>
			</span>
		</div>
		<!-- // Copy precedence // -->
		<div data-ng-hide="dbClone.isSqlClone" class="form-group ">
			<label class="col-xs-12 col-lg-4" for="copyPrec">
				<cv:msg key="label.copyPrec" bundle="oracle"/>
			</label>
			<div class="col-xs-12 col-lg-3">
				<input  type="number" id="copyPrec" name="copyPrec" data-ng-model="dbClone.data.cloneEnv.copyPrec" min="0" />
			</div>
		</div>
		<!-- // checkbox // -->
		<div class="form-group">
			<div class="col-xs-12 col-lg-12">
				<input type="checkbox" id="forceCleanup" name="forceCleanup" data-ng-model="dbClone.data.cloneEnv.forceCleanup" />
				<label for="forceCleanup" >
					<span data-ng-hide="dbClone.isSqlClone">
						<cv:msg key="label.overfideExists" bundle="oracle"/>
					</span>
					<span data-ng-show="dbClone.isSqlClone">
						<cv:msg key="label.unconditionOver" bundle="databaseClone"/>
					</span>
				</label>
			</div>
		</div>
		
		<cv-data-masking	
			data-ng-if="dbClone.showDataMasking()"
			instance-id="dbClone.instanceId"
			is-stand-alone="false"
			masking-options="dbClone.data.dataMaskingOptions">
		</cv-data-masking>
	</div>
  <cv-tile-component data-ac-id="label_postCloneOper-databaseClone" data-ng-hide="dbClone.isSqlClone" data-title='<cv:msg key="label.postCloneOper" bundle="databaseClone"/>'>
	 <div class="panel-body">
		<%-- <div class="form-group " >
			<label class="col-xs-12 col-lg-4" for="executeOn">
				<cv:msg key="label.exeCommandOn" bundle="databaseClone"/>
			</label>
			<div class="col-xs-12 col-lg-8">
				<select data-ng-model="dbClone.data.executeOn" name="executeOn" id="executeOn"
						data-ng-options="client as client.clientName for client in dbClone.clientsList | orderBy:'clientName'">
				</select>
			</div>
		</div>	 --%>
		<div class="form-group ">
			<label class="col-xs-12 col-lg-4" for="commondFilePath">
				<cv:msg key="label.cmdFilePath" bundle="databaseClone"/>
			</label>
			<div class="col-xs-12 col-lg-7">
				<input type="text" id="commondFilePath" name="commondFilePath" data-ng-model="dbClone.data.commondFilePath"/>
			</div>
			<div class="col-xs-12 col-lg-1">
				<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>'
					folders-only = false client-id='{{dbClone.data.destClient.clientId}}' result-function="dbClone.commondFilePathResuleFunction" class="upload-button">
				</cv-machine-browse>
			</div>
		</div>
	  </div>
   </cv-tile-component>
</div>
