<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.facets"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
</script>
<div class="panel-body" data-ng-init="dbClone.loadDestinationPage()">
	<!-- // client name // -->
	<div class="form-group" title='{{dbClone.data.destClientLb}}'>
		<label class="col-xs-12 col-lg-3" for="destClient">
			{{dbClone.data.destClientLb}}
		</label>
		<div class="col-xs-12 col-lg-9 uib-wrapper" data-ng-class="{'select-label': !dbClone.isOracleClone}">
			<select data-ng-model="dbClone.data.destClient" name="destClient" id="destClient"
				data-ng-change="dbClone.destClientChanged(dbClone.data.destClient)"
				data-ng-options="client as client.clientName for client in dbClone.clientsList | orderBy:'clientName'">
			</select>
		</div>
	</div>
	<!-- // instance name // -->
	<div class="form-group" title='{{dbClone.data.instanceLb}}'>
		<label class="col-xs-12 col-lg-3" for="destInstance">
			{{dbClone.data.instanceLb}} </label>
		<div class="col-xs-12 col-lg-9 uib-wrapper"
			data-ng-class="{'select-label': !dbClone.isOracleClone}">
			<div data-ng-if="!dbClone.isOracleClone">
				<select data-ng-model="dbClone.data.instance" name="destInstance"
					id="destInstance"
					data-ng-change="dbClone.updateOptions(dbClone.data.instance)"
					data-ng-options="ins as ins.instanceName for ins in dbClone.instanceList | orderBy:'instanceName'">
				</select>
			</div>
			<div data-ng-if="dbClone.isOracleClone">
				<input type="text" id="destInstance" name="destInstance" required
					data-ng-maxlength="{{dbClone.instanceNameSize}}"
					data-ng-model="dbClone.data.instanceNameText"
					data-ng-change="dbClone.updateOptions(dbClone.dummyInstance)" />
			</div>
			<span class="help-block"
				data-ng-show="cv.wizardForm.needsAttention(wizardForm.destInstance);">
				<cv:msg key="error.instanceName" bundle="oracle" />
			</span>
		</div>
	</div>
	<!-- // oracle home // -->
	<div data-ng-if="dbClone.isOracleClone" class="form-group" title='<cv:msg key="label.oracleHome" bundle="oracle"/>'  >
		<label class="col-xs-12 col-lg-3" for="oraHome">
			<cv:msg key="label.oracleHome" bundle="oracle" />
		</label>
		<div class="col-xs-12 col-lg-8">
			<input data-ng-disabled="!dbClone.data.instance.isDummyInstance" type="text" id="oraHome" name="oraHome" required
						data-ng-model="dbClone.data.cloneEnv.oraHome" />
			<span class="help-block" data-ng-show="cv.wizardForm.needsAttention(wizardForm.oraHome);" >
				<cv:msg key="error.oracleHome" bundle="oracle"/>
			</span>
		</div>
		<div class="col-xs-12 col-lg-1">
			<cv-machine-browse class="upload-button" title="<cv:msg key='label.browse' bundle='restore' />"
				id="oracleHomeBrowse"  type="button" class="btn btn-default setup-btn--hidden float-right"
				client-id='{{dbClone.data.destClient.clientId}}' result-function="dbClone.oracleHomeResuleFunction"
				data-ng-click="dbClone.browse('oraHome')" button-label='<cv:msg key="label.browse" bundle="restore"/>' >
			</cv-machine-browse>
		</div>
	</div>
	<!-- // user name //
	<div class="form-group" title='<cv:msg key="label.userName" bundle="servers" />' >
		<label class="col-xs-12 col-lg-3" for="userName"><cv:msg key="label.userName" bundle="servers" /></label>
		<div class="col-xs-12 col-lg-9">
			<input data-ng-disabled="!dbClone.data.orclInstance.isDummyInstance" type="text" id="userName" name="userName"
					required	data-ng-model="dbClone.data.cloneEnv.oraUser" />
			<span class="help-block" data-ng-show="cv.wizardForm.needsAttention(wizardForm.userName);" >
				<cv:msg key="error.userName" bundle="users"/>
			</span>
		</div>
	</div>-->
	<!-- // staging path  // -->
	<div class="form-group"  data-ng-if="dbClone.showStagingPath" title='{{dbClone.data.cloneEnv.stagingPathLb}}' >
		<label class="col-xs-12 col-lg-3" for="stagingPath">
			{{dbClone.data.cloneEnv.stagingPathLb}}
		</label>
		<div  class="col-xs-12 col-lg-8">
			<input title="" type="text" id="stagingPath" name="stagingPath" required data-ng-model="dbClone.data.cloneEnv.stagingPath" />
			<span class="help-block" data-ng-show="cv.wizardForm.needsAttention(wizardForm.stagingPath)">
				<span>
					<cv:msg key="error.snapMountPath" bundle="sqlserver" />
				</span>
			</span>
		</div>
		<div class="col-xs-12 col-lg-1">
			<cv-machine-browse class="upload-button" title="<cv:msg key='label.browse' bundle='restore' />" button-label='<cv:msg key="label.browse" bundle="restore"/>'
					client-id='{{dbClone.data.destClient.clientId}}' result-function="dbClone.stagingPathResuleFunction">
			</cv-machine-browse>
		</div>
	</div>
	<!-- // target database  // -->
	<div class="form-group" data-ng-if="dbClone.isSqlClone"
		title="<cv:msg key='label.targetDbName' bundle='sqlserver' />">
		<label class="col-xs-12 col-lg-3" for="cloneDbName"> <cv:msg
				key="label.targetDbName" bundle="sqlserver" />
		</label>
		<div class="col-xs-12 col-lg-9">
			<input type="text" id="cloneDbName" name="cloneDbName" required
				data-ng-model="dbClone.cloneDbName" />
		</div>
	</div>
	<!-- ------------------------------------ -->
	<!-- Start of advanced options for Oracle -->
	<!-- ------------------------------------ -->
	<legend data-ng-if="dbClone.isOracleClone" class="cursor-pointer"
			data-ng-click="dbClone.openAdvancedOptions = !dbClone.openAdvancedOptions">
			{{'label.customize' | cvLoc}} <i class="float-right glyphicon"
				data-ng-class="dbClone.openAdvancedOptions ? 'glyphicon-chevron-down' : 'glyphicon-chevron-right'"></i>
	</legend>
	<div data-uib-collapse="!dbClone.openAdvancedOptions">
	<!-- // PFile  // -->
	<div data-ng-if="dbClone.isOracleClone" class="form-group" title='<cv:msg key="label.pFile" bundle="oracle"/>' >
		<label class="col-xs-12 col-lg-3" for="oraPfile">
			<cv:msg key="label.pFile" bundle="oracle"/>
		</label>
		<div class="col-xs-12 col-lg-8">
			<input type="text" id="oraPfile" name="oraPfile" data-ng-model="dbClone.data.cloneEnv.oraPfile" placeholder="<cv:msg key="label.optional" bundle="oracle"/>"/>
		</div>
		<div class="col-xs-12 col-lg-1">
			<cv-machine-browse class="upload-button" title="<cv:msg key='label.browse' bundle='restore' />"
				button-label='<cv:msg key="label.browse" bundle="restore"/>' client-id='{{dbClone.data.destClient.clientId}}'
				folders-only = false result-function="dbClone.oraPfileResuleFunction">
			</cv-machine-browse>
		</div>
	</div>
	<!-- // staging path for Oracle  // -->
	<div data-ng-if="dbClone.isOracleClone" class="form-group"   title='<cv:msg key="label.stagingPath" bundle="oracle"/>' >
		<label class="col-xs-12 col-lg-3" for="stagingPath">
			<span title='<cv:msg key="label.stagingPath" bundle="oracle"/>' >
				<cv:msg key="label.stagingPath" bundle="oracle" />
			</span>
		</label>
		<div class="col-xs-12 col-lg-8">
			<input type="text" id="stagingPath" name="stagingPath" data-ng-model="dbClone.data.cloneEnv.stagingPath" placeholder="<cv:msg key="label.optional" bundle="oracle"/>"/>
		</div>
		<div class="col-xs-12 col-lg-1">
			<cv-machine-browse class="upload-button" title="<cv:msg key='label.browse' bundle='restore' />" button-label='<cv:msg key="label.browse" bundle="restore"/>'
					client-id='{{dbClone.data.destClient.clientId}}' result-function="dbClone.stagingPathResuleFunction">
			</cv-machine-browse>
		</div>
	</div>
	<!-- // PGA SGA size // -->
	<div data-ng-if="dbClone.isOracleClone" class="form-group"  title='<cv:msg key="label.pgaSgaSize" bundle="oracle"/>' >
	    <label class="col-xs-12 col-lg-3" for="pgaSgaSize">
			<cv:msg key="label.pgaSgaSize" bundle="oracle"/>
			<cv-help-component help-text="<cv:msg key="help.pgaSgaSize" bundle="oracle"/>"></cv-help-component>
		</label>
		<div class="col-xs-12 col-lg-9">
			<input class="form-group" type="number" name="pgaSgaSize" min="1"  max="1000000" data-ng-model="dbClone.data.cloneEnv.pgaSgaSize" placeholder="<cv:msg key="label.optional" bundle="oracle"/>"/>
			<span class="help">
				<cv:msg key="size.mb" bundle="facets"/>
			</span>
			<span class="help-block" data-ng-show="cv.wizardForm.needsAttention(wizardForm.pgaSgaSize)" >
				<cv:msg key="error.invalidNumber" bundle="oracle"/>
			</span>
		</div>
	</div>
	<!-- // REDO log size // -->
	<div data-ng-if="dbClone.isOracleClone" class="form-group"  title='<cv:msg key="label.redoLogSize" bundle="oracle"/>' >
	    <label class="col-xs-12 col-lg-3" for="redoLogSize">
			<cv:msg key="label.redoLogSize" bundle="oracle"/>
		</label>
		<div class="col-xs-12 col-lg-9">
			<input class="form-group" type="number" name="redoLogSize" min="1"  max="1000000" data-ng-model="dbClone.data.cloneEnv.redoLogSize" placeholder="<cv:msg key="label.optional" bundle="oracle"/>"/>
			<span class="help">
				<cv:msg key="size.mb" bundle="facets"/>
			</span>
			<span class="help-block" data-ng-show="cv.wizardForm.needsAttention(wizardForm.redoLogSize)" >
				<cv:msg key="error.invalidNumber" bundle="oracle"/>
			</span>
		</div>
	</div>
	<!-- // Migrate DB to production storage // -->
	<div data-ng-if="dbClone.isOracleClone && dbClone.isASMStorageType" class="form-group"  title='<cv:msg key="label.migrateDbToProdStorage" bundle="oracle"/>' >
	    <div class="col-xs-12">
			<input type="checkbox" id="migrateDbToProdStorage" data-ng-model="dbClone.data.cloneEnv.migrateToProdStorage"></input>
			<label for="migrateDbToProdStorage"><cv:msg key="label.migrateDbToProdStorage" bundle="oracle"/></label>
	    </div>
	</div>
	<!-- // Disk mapping file // -->
	<div data-ng-if="dbClone.isOracleClone && dbClone.data.cloneEnv.migrateToProdStorage" class="form-group"  title='<cv:msg key="label.diskMappingFile" bundle="oracle"/>' >
		<label class="col-xs-12 col-lg-3" for="diskMappingFile">
			<span>
				<cv:msg key="label.diskMappingFile" bundle="oracle"/>
				<cv-help-component help-text="<cv:msg key="help.diskMappingFile" bundle="oracle"/>"></cv-help-component>
			</span>
		</label>
		<div class="col-xs-12 col-lg-8">
			<input type="text" name="diskMappingFile" data-ng-model="dbClone.data.cloneEnv.diskMappingFile" required/>
			<span class="help-block" data-ng-show="cv.wizardForm.needsAttention(wizardForm.diskMappingFile)" >
				<cv:msg key="error.diskMappingFile" bundle="oracle"/>
			</span>
		</div>
		<div class="col-xs-12 col-lg-1">
			<cv-machine-browse class="upload-button" title="<cv:msg key='label.browse' bundle='restore' />" button-label='<cv:msg key="label.browse" bundle="restore"/>'
					client-id='{{dbClone.data.destClient.clientId}}' result-function="dbClone.diskMappingFileResultFunction">
			</cv-machine-browse>
		</div>
	</div>
	</div>
	<!-- ------------------------------------ -->
	<!-- End of advanced options for Oracle   -->
	<!-- ------------------------------------ -->
</div>
