<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.genApp"></cv:cvMessages>
</script>
<div class="setup-title no-margin">
	<h1>
		<span data-ng-hide="addGenApp.editApp">
			<cv:msg key="label.addGenApp" bundle="genApp"/>
		</span> 
		<span data-ng-show="addGenApp.editApp">
			<cv:msg key="label.editGenApp" bundle="genApp"/>
		</span>
	</h1>
</div>
<div class="bootstrap-wrapper" >
	<div class="{{addGenApp.generalMessage.type}} serverMessage">
		{{addGenApp.generalMessage.message}} 
	</div>
	<form name="addGenAppForm" data-cv-submit="addGenApp.saveGenApp()" autocomplete="off">
		<div class="panel">
			<div class="panel-body">
				<div class="form-group">
					<label class="col-xs-12 col-lg-3" for="hostName">
						<cv:msg key="label.genAppName" bundle="genApp"/> 
					</label>
					<div class="col-xs-12 col-lg-4">
						<input type="text" id="genAppName" name="genAppName" data-ng-model="addGenApp.genAppName" data-ng-required="true"
						  autofocus />
						<span class="help-block" data-ng-show="cv.addGenAppForm.needsAttention(addGenAppForm.genAppName)">
							<cv:msg key="error.genAppName" bundle="genApp"/>
						</span>
					</div>
				</div>
			</div>
		</div>
		
		<cv-tile-component data-title='<cv:msg key="label.serverDetails" bundle="genApp"/>' >
			<div class="text-center">
				<span class="{{addGenApp.serverListMessage.type}}" data-ng-bind="addGenApp.serverListMessage.message"></span>
			</div>
			<div class="panel">
				<div class="panel-body">
					<cv-grid cv-grid-options="addGenApp.serverGridOptions">
					</cv-grid>
				</div>
			</div>
			<div class="page-details-box-links"><a data-ng-click="addGenApp.addServer()"><cv:msg key="label.addServer" bundle="genApp"/></a></div>
		</cv-tile-component>
		
		<cv-tile-component data-title='<cv:msg key="label.config" bundle="genApp"/>' >
			<div class="panel">
				<div class="panel-body">
					<cv-grid cv-grid-options="addGenApp.configGridOptions">
					</cv-grid>
				</div>
			</div>
			<div class="page-details-box-links"><a data-ng-click="addGenApp.addTag()"><cv:msg key="label.addTag" bundle="genApp"/></a></div>
		</cv-tile-component>
			
		<div class="pull-right" >
			<button id="addGenApp_button_#0042" type="submit" class="btn btn-primary cvBusyOnAjax"> 
				<span ><cv:msg key="Save" bundle="messages" /> </span>
			</button>
		</div>
		
	</form>
</div>
