import 'modules/genApp/js/services/genApp.svc.js';
import 'adminConsole/js/services/clientGroups.svc.js';

import { ebsAppServerModule } from 'common/js/modules';

var cvCommon = ebsAppServerModule;

cvCommon.directive('cvGenAppIvhTreeView', [
	'cvUtil',
	function(cvUtil) {
		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'modules/genApp/partials/genAppIvhTreeView.jsp',
			scope: {},
			bindToController: {
				treeContainer: '=',
				treeData: '=',
				initialSelection: '='
			},
			controllerAs: 'genAppIvhTree',
			controller: [
				'$scope',
				'cvUtil',
				'cvLoc',
				'$dialogs',
				'ivhTreeviewMgr',
				'TREE_NODE_STATE',
				'EntityTypesUtil',
				'genAppService',
				'clientGroupService',
				function(
					$scope,
					cvUtil,
					cvLoc,
					$dialogs,
					ivhTreeviewMgr,
					TREE_NODE_STATE,
					EntityTypesUtil,
					genAppService,
					clientGroupService
				) {
					var self = this;
					this.$onInit = function() {
						var EntitySelectionTree = function(treeData, initialSelection) {
							this.isShowOnlySelected = false;
							this.isRestoreOperation = false;
							var self = this;
							var selectedNodes = angular.copy(initialSelection);

							/**
							 * Returns list of the selected nodes
							 */
							this.getSelectedNodes = function() {
								var selectedList = null;
								if (self.tree && self.tree[0] && self.tree[0].children) {
									selectedList = getSelection(self.tree[0].children);
								}
								if (!selectedList || selectedList.length <= 0) {
									self.serverMessage = cvUtil.errMsg(cvLoc('error.content'));
								}
								return selectedList;
							};

							this.setGenAppOppType = function(genAppOppType) {
								if (genAppOppType && genAppOppType === 'RESTORE') {
									this.isRestoreOperation = true;
								} else {
									this.isRestoreOperation = false;
								}
							};

							this.setSoureceClientList = function(clientList) {
								if (clientList) {
									self.sourceClientList = clientList;
								}
							};

							this.addContentAction = function() {
								var templateUrl = 'modules/genApp/partials/genAppAddSourceServer.jsp';
								var controller = 'restoreGenAppSourceServerCtrl';
								var opts = new Object();

								var dataObject = {
									sourceClientList: self.sourceClientList
								};

								var modelInsta = $dialogs.create(appUtil.appRoot + templateUrl, controller, dataObject, opts);
								modelInsta.result.then(function(dataObject) {
									var clientId = 11944;
									if (dataObject) {
										clientId = dataObject.clientId;
									}
									loadClientIvhTreeData(clientId);
								});
							};

							var loadClientIvhTreeData = function(clientId) {
								var genEntity = {
									clientId: clientId
								};
								var parsObject = {
									genericEntity: JSON.stringify(genEntity),
									criteria: 'RestoreEditServer',
									loadChildren: true
								};

								genAppService.getGenAppIvhTreeViewData(parsObject).success(function(entityTree) {
									if (entityTree) {
										if (self.tree[0].children) {
											entityTree.parent = self.tree[0];
											self.tree[0].children.push(entityTree[0]);
											initializeTreeNodes(entityTree);
										}
									}
								});
							};

							this.initTree = function(treeData, initialSelection) {
								if (initialSelection) {
									selectedNodes = angular.copy(initialSelection);
								}
								if (treeData) {
									self.tree = initializeTreeNodes(angular.copy(treeData));
								} else {
									self.tree = [];
								}
							};

							this.nodeStateChanged = function(ivhNode) {
								if (self.serverMessage) {
									self.serverMessage = cvUtil.emptyMsg();
								}
								if (ivhNode) {
									ivhNode.touched = true;
									if (ivhNode.children && ivhNode.children.length > 0) {
										ivhNode.children.forEach(function(childNode) {
											self.nodeStateChanged(childNode);
										});
									}
								}
							};

							this.showOnlySelected = function(treeNode) {
								if (treeNode.id == 0) return true;
								if (self.isShowOnlySelected) {
									var res = treeNode.selected || treeNode.__ivhTreeviewIndeterminate;
									return res;
								}
								return true;
							};

							this.populateChildren = function(ivhNode) {
								if (!ivhNode.childrenLoaded) {
									clientGroupService
										.populateVSAEntityTree(ivhNode.entity)
										.success(function(childNodes) {
											ivhNode.children.length = 0;
											if (angular.isArray(childNodes)) {
												ivhNode.children = childNodes;
												ivhNode.childrenLoaded = true;
												initializeTreeNodes(ivhNode);
											}
										})
										.error(showErrorMessage);
								}
							};

							function initializeTreeNodes(treeNode) {
								if (treeNode && treeNode.children && treeNode.children.length > 0) {
									treeNode.children.forEach(function(childNode) {
										childNode.parent = treeNode;
										assignStateForTreeNode(childNode);
										initializeTreeNodes(childNode);
										addTemporaryChild(childNode);
									});
								}
								return [treeNode];
							}

							function addTemporaryChild(treeNode) {
								if (treeNode && treeNode.children && treeNode.children.length == 0) {
									treeNode.children.push({
										label: cvLoc('Loading').toLocaleLowerCase()
									});
								}
							}

							function getSelection(root) {
								var selected = [];
								if (root && root.length > 0) {
									root.forEach(function(node) {
										if (node.selected || node.__ivhTreeviewIndeterminate) {
											if (
												node.entity &&
												node.entity.entityTypeName === 'SUBCLIENT_ENTITY' && //This is temp fix to read only subclient node selection is allowed
												node.selected &&
												!node.__ivhTreeviewIndeterminate
											) {
												selected.push(node);
											} else {
												if (!node.childrenLoaded) {
													var selectedNodes = searchForNodesFromInitialSelection(node);
													Array.prototype.push.apply(selected, selectedNodes);
												} else {
													Array.prototype.push.apply(selected, getSelection(node.children));
												}
											}
										} else if (node && node.children && node.children.length > 0) {
											Array.prototype.push.apply(selected, getSelection(node.children));
										}
									});
								}
								return selected;
							}

							function searchForNodesFromInitialSelection(treeNode) {
								var selectedNodes = [];
								if (angular.isArray(initialSelection)) {
									initialSelection.forEach(function(entity) {
										if (treeNode.entity.clientId == entity.clientId) {
											selectedNodes.push({
												id: EntityTypesUtil.getEntityIdForType(entity),
												label: EntityTypesUtil.getEntityNameForType(entity),
												selected: true,
												parent: treeNode.parent,
												entity: entity
											});
										}
									});
								}
								return selectedNodes;
							}

							function assignStateForTreeNode(treeNode) {
								var treeNodeStatus = getTreeNodeState(treeNode);
								treeNode.selected = treeNodeStatus == TREE_NODE_STATE.FULLY_SELECTED;
								treeNode.__ivhTreeviewIndeterminate = treeNodeStatus == TREE_NODE_STATE.PARTIALLY_SELECTED;
							}

							function getTreeNodeState(newNode) {
								if (!newNode.parent.touched) {
									if (checkIfNodeIsSelectedAlready(newNode) || checkIfParentIsSelected(newNode))
										return TREE_NODE_STATE.FULLY_SELECTED;

									if (checkIfAnyChildNodeIsSelected(newNode)) return TREE_NODE_STATE.PARTIALLY_SELECTED;

									return TREE_NODE_STATE.NOT_SELECTED;
								} else {
									newNode.touched = true;
									if (newNode.parent.selected) return TREE_NODE_STATE.FULLY_SELECTED;
									else if (newNode.parent.__ivhTreeviewIndeterminate) return TREE_NODE_STATE.PARTIALLY_SELECTED;
									else return TREE_NODE_STATE.NOT_SELECTED;
								}
							}

							function checkIfNodeIsSelectedAlready(newNode) {
								var entityId = newNode.id;
								var entityType = newNode.entity.entityTypeName;
								if (angular.isArray(selectedNodes)) {
									for (var i = 0, length = selectedNodes.length; i < length; i++) {
										var node = selectedNodes[i];
										if (!node.entityTypeName) node.entityTypeName = EntityTypesUtil.getEntityType(node);
										if (node.entityTypeName == entityType) {
											var nodeId = EntityTypesUtil.getEntityIdForType(node, node.entityTypeName);
											if (nodeId == entityId) {
												selectedNodes.splice(i, 1);
												return true;
											}
										}
									}
								}
								return false;
							}

							function checkIfParentIsSelected(treeNode) {
								return treeNode && treeNode.parent && treeNode.parent.selected;
							}

							function checkIfAnyChildNodeIsSelected(treeNode) {
								if (angular.isArray(selectedNodes)) {
									for (var i = 0, length = selectedNodes.length; i < length; i++) {
										var node = selectedNodes[i];
										switch (treeNode.entity.entityTypeName) {
											case 'CLIENT_ENTITY':
												if (treeNode.id == node.clientId) return true;
												break;
											case 'APPTYPE_ENTITY':
												if (treeNode.id == node.applicationId && treeNode.parent.id == node.clientId) return true;
												break;
											case 'INSTANCE_ENTITY':
												if (treeNode.id == node.instanceId && treeNode.parent.id == node.applicationId) return true;
												break;
											case 'BACKUPSET_ENTITY':
												if (treeNode.id == node.backupsetId && treeNode.parent.id == node.instanceId) return true;
												break;
											case 'SUBCLIENT_ENTITY':
												if (treeNode.id == node.subclientId && treeNode.parent.id == node.backupsetId) return true;
												break;
										}
									}
								}
							}
						}; //end of constructor EntitySelectionTree
						self.treeContainer = new EntitySelectionTree(self.treeData, self.initialSelection);

						function showErrorMessage(errorMessage) {
							if (errorMessage) {
								if (angular.isString(errorMessage)) {
									self.serverMessage = cvUtil.errMsg(errorMessage);
								} else if (angular.isString(errorMessage.data)) {
									self.serverMessage = cvUtil.errMsg(errorMessage.data);
								} else {
									self.serverMessage = cvLoc('generic_error');
								}
							}
						}
					};
				}
			]
		};
	}
]);
export default cvCommon;
