import 'modules/ida/js/services/appMigration.svc.js';
import 'modules/servers/js/services/servers.svc.js';
import 'modules/ida/js/directives/cv-storage-config.js';

import { genAppServerModule } from 'common/js/modules';

var genAppModule = genAppServerModule;

genAppModule.filter('volumeSize', [
	function() {
		return function(value) {
			var diskSize = parseInt(value);
			diskSize = diskSize / 1024;
			diskSize = diskSize / 1024;
			diskSize = diskSize / 1024;
			diskSize = Math.round(diskSize);
			return diskSize;
		};
	}
]);

genAppModule.filter('volumeType', [
	'cvLoc',
	function(cvLoc) {
		return function(value) {
			var volumeType = parseInt(value);
			var strVolumeType = value;
			if (volumeType === 0) {
				strVolumeType = cvLoc('label.standard');
			} else if (volumeType === 1) {
				strVolumeType = cvLoc('label.provsIOPS');
			}

			return strVolumeType;
		};
	}
]);

genAppModule.controller('computeNodeCtrl', [
	'cvUtil',
	'cvLoc',
	'serverService',
	'$log',
	'appMigrationService',
	function(cvUtil, cvLoc, serverService, $log, appMigrationService) {
		var self = this;
		this.$onInit = function() {
			if (!self.editing) {
				self.editing = false;
			}
			self.isVmSelected = false;
			if (self.nodeData && self.nodeData.createNewMachine != undefined && self.nodeData.createNewMachine === false) {
				self.isVmSelected = true;
			}
			self.localLang = cvUtil.getIStevenLocLabels();
			self.isAmazonPolicy = false;
			self.isOracleAsService = false;
			self.isOracleCloudPolicy = false;
			self.isOCIPolicy = false;
			self.isAzurePolicy = false;
			//self.template = appUtil.appRoot + 'modules/genApp/partials/computeNodeTemplate.jsp';

			self.initData = function(policyData, migrationType, nodeData, editing) {
				self.policyData = policyData;
				self.migrationType = migrationType;
				self.nodeData = nodeData;
				if (editing) {
					self.editing = editing;
				}
				updateValues();
			};
			var updateValues = function() {
				self.selectAmiLabel = cvLoc('options.image');
				self.selectInstanceTypeLabel = cvLoc('options.shape');
				self.configType = self.policyData.entity.policyType;
				if (self.configType === 'ORACLE_CLOUD_INFRASTRUCTURE') {
					self.isOCIPolicy = true;
					self.isOracleCloudPolicy = true;
				} else if (self.configType === 'ORACLE_AS_SERVICE') {
					self.isOracleAsService = true;
					self.isOracleCloudPolicy = true;
				} else if (self.configType === 'ORACLE_CLOUD') {
					self.isOracleCloudPolicy = true;
				} else if (self.configType === 'AZURE_RESOURCE_MANAGER') {
					self.isAzurePolicy = true;
					self.selectAmiLabel = cvLoc('placeholder.selectTemplate');
					self.selectInstanceTypeLabel = cvLoc('options.instanceType');
					self.isSQLMigration = self.nodeData.srcInst.applicationId === 81;
				} else {
					self.isAmazonPolicy = true;
					self.selectAmiLabel = cvLoc('options.ami');
					self.selectInstanceTypeLabel = cvLoc('options.instanceType');
				}

				//Updating the default values in the node data.
				if (self.editing) {
					if (self.nodeData.nodeType === 'Database') {
						self.nodeData.database = true;
					}
					if (self.nodeData.nodeType === 'Application') {
						self.nodeData.application = true;
					}
					if (self.nodeData.machineConfig) {
						if (!self.nodeData.machineConfig.storageVol_list) {
							self.nodeData.machineConfig.storageVol_list = [];
						}
						if (
							self.nodeData.machineConfig &&
							self.nodeData.machineConfig.advVMProperties &&
							self.nodeData.machineConfig.advVMProperties.networkCards
						) {
							self.networkCards = self.nodeData.machineConfig.advVMProperties.networkCards;
						} else {
							self.nodeData.machineConfig.advVMProperties = {
								networkCards: []
							};
						}
					} else {
						self.nodeData.machineConfig = {
							storageVol_list: [],
							vmTemplate: {
								vm: ''
							},
							advVMProperties: {
								networkCards: []
							}
						};
					}
				}

				//Loading of the selection list for the Shape and Instances
				self.vmsTempList = [];
				if (self.policyData.templates) {
					self.vmsTempList = self.policyData.templates;
					if (self.isAzurePolicy) {
						if (self.isSQLMigration) {
							self.vmsTempList = self.vmsTempList.filter(template => !(template.vmGUID.split(':').length - 1));
						}
						self.vmsTempList.forEach(vms => {
							if (vms.vmName === undefined) {
								vms.vmName = vms.vmGUID;
							}
						});
					}
					self.vmsTempList.forEach(vms => {
						if (vms.vmName !== undefined) {
							let path = vms.vmName.split('/');
							vms.vmDisplayName = path[path.length - 1];
						}
					});
					self.vmsTempList = cvUtil.sortAscending(self.vmsTempList, 'vmDisplayName');
				}

				self.instanceTypeList = [];
				if (
					self.policyData.amazonPolicy &&
					self.policyData.amazonPolicy.instanceType &&
					self.policyData.amazonPolicy.instanceType.length > 0
				) {
					var instanceTypeList = cvUtil.sortAscending(
						self.policyData.amazonPolicy.instanceType,
						'instanceType.vmInstanceTypeName'
					);
					instanceTypeList.forEach(e => (e.flatLabel = e.instanceType.vmInstanceTypeName));
					instanceTypeList.sort(function(first, second) {
						var firstValue = 0;
						var secondValue = 0;
						if (first && first.memory) {
							firstValue = parseFloat(first.memory);
						}
						if (second && second.memory) {
							secondValue = parseFloat(second.memory);
						}
						if (firstValue < secondValue) {
							return -1;
						}
						if (firstValue > secondValue) {
							return 1;
						}
						return 0; //default return value (no sorting)
					});
					self.instanceTypeList = instanceTypeList;
				}

				var loadNetworkSettings = function(clientId) {
					var dummyHostName = 'dummy';
					var serverDetailsInfo = {
						clientId: clientId,
						serverName: '',
						username: null,
						password: null
					};
					//load network info
					serverService
						.getNetworkInfo(serverDetailsInfo, dummyHostName)
						.success(function(data) {
							self.networkSettingsList = data;
							self.networkSettingsList.forEach(function(networkSetting) {
								networkSetting.ticked = false;
							});
						})
						.error(function(err) {
							$log.error(err);
						});
				};

				//Polpulation of the network and subnetmask list
				if (self.policyData.networkInfo) {
					self.networkSettingsList = self.policyData.networkInfo;
					if (self.networkSettingsList) {
						self.networkSettingsList.forEach(function(networkSetting) {
							networkSetting.ticked = false;
						});
					}

					if (
						self.policyData.networkInfo &&
						self.policyData.networkInfo.length > 0 &&
						self.policyData.networkInfo[0].subnetNames
					) {
						self.subnetList = self.policyData.networkInfo[0].subnetNames;
						if (self.subnetList) {
							self.subnetList.forEach(function(subNet) {
								subNet.ticked = false;
							});
						}
					}
				} else if (self.isOracleCloudPolicy) {
					var clientId = self.policyData.dataCenter.instanceEntity.clientId;
					loadNetworkSettings(clientId);
				}

				if (self.editing) {
					//Template selection
					if (self.nodeData.machineConfig.vmTemplate && self.nodeData.machineConfig.vmTemplate.vm) {
						var vm = self.nodeData.machineConfig.vmTemplate.vm;
						self.vmsTempList.forEach(function(vmNode) {
							if (vmNode.vmName == vm.vmName) {
								self.nodeData.machineConfig.vmTemplate.vm = vmNode;
							}
						});
					} else {
						if (!self.nodeData.machineConfig.vmTemplate) {
							self.nodeData.machineConfig.vmTemplate = {};
						}
						self.nodeData.machineConfig.vmTemplate.vm = self.vmsTempList[0];
					}

					//Instance type selection
					var tempInType = self.nodeData.machineConfig.vmInstType;
					if (tempInType) {
						self.instanceTypeList.forEach(function(inType) {
							if (inType.instanceType.vmInstanceTypeName == tempInType.instanceType.vmInstanceTypeName) {
								self.nodeData.machineConfig.vmInstType = inType;
							}
						});
					} else {
						self.nodeData.machineConfig.vmInstType = self.instanceTypeList[0];
					}

					//Network selection
					//Validates for the given source network is in the selection networks list
					var isNetworkSelected = function(sourceNetwork, selectedNetworks) {
						var retFlag = false;
						selectedNetworks.forEach(function(networkInfo) {
							if (sourceNetwork.networkName === networkInfo.networkName) {
								retFlag = true;
								return;
							}
						});
						return retFlag;
					};
					var advVMProperties = self.nodeData.machineConfig.advVMProperties;
					if (
						advVMProperties &&
						advVMProperties.networkCards &&
						self.networkSettingsList &&
						self.networkSettingsList.length > 0
					) {
						self.networkSettingsList.forEach(function(networkInfo) {
							if (isNetworkSelected(networkInfo, advVMProperties.networkCards)) {
								networkInfo.ticked = true;
							} else {
								networkInfo.ticked = false;
							}
						});
						//Subnet selection

						var isSubnetSelected = function(sourceSubnet, selectedSubnet) {
							var retFlag = false;
							selectedSubnet.forEach(function(subnetInfo) {
								if (sourceSubnet.name === subnetInfo.name) {
									retFlag = true;
									return;
								}
							});
							return retFlag;
						};
						if (advVMProperties.networkCards && advVMProperties.networkCards.length > 0) {
							var selectedSubnet = advVMProperties.networkCards[0].subnetNames;
							self.subnetList.forEach(function(subnetInfo) {
								if (isSubnetSelected(subnetInfo, selectedSubnet)) {
									subnetInfo.ticked = true;
								} else {
									subnetInfo.ticked = false;
								}
							});
						}
					}
				} else {
					// enable auto selection only if there is 1 option in the list
					if (self.vmsTempList.length === 1) {
						self.nodeData.machineConfig.vmTemplate.vm = self.vmsTempList[0];
					}

					if (self.instanceTypeList.length === 1) {
						self.nodeData.machineConfig.vmInstType = self.instanceTypeList[0];
					}

					if (self.networkSettingsList && self.networkSettingsList.length > 0) {
						self.networkSettingsList[0].ticked = true;

						self.nodeData.machineConfig.advVMProperties.networkCards = [self.networkSettingsList[0]];
					}
					if (self.subnetList && self.subnetList.length) {
						self.subnetList[0].ticked = true;

						self.nodeData.machineConfig.advVMProperties.subnetList = [self.subnetList[0]];
					}
				}
			};
			updateValues();
			self.networkNameSelection = function() {
				if (self.nodeData.machineConfig.advVMProperties.networkCards && self.isOCIPolicy) {
					self.subnetList = self.nodeData.machineConfig.advVMProperties.networkCards[0].subnetNames;
					if (self.subnetList && self.subnetList.length > 0) {
						self.subnetList[0].ticked = true;
						self.nodeData.machineConfig.advVMProperties.subnetList = [self.subnetList[0]];
					}
				}
			};
		};
	}
]);
genAppModule.directive('cvComputeNode', [
	'cvUtil',
	function(cvUtil) {
		return {
			restrict: 'E',
			require: ['^^cvSubmit', '^^form'],
			templateUrl: appUtil.appRoot + 'modules/genApp/partials/computeNodeTemplate.jsp',
			scope: {},
			bindToController: {
				nodeData: '=',
				editing: '=',
				migrationType: '=',
				policyData: '=',
				modalStyle: '@'
			},
			link: function(scope, elem, attr, controllers) {
				scope.submitController = controllers[0];
				scope.formController = controllers[1];
			},
			controllerAs: 'computeNode',
			controller: 'computeNodeCtrl'
		};
	}
]);
export default genAppModule;
