import 'adminConsole/js/services/clientGroups.svc.js';
import 'modules/genApp/js/services/genApp.svc.js';
import 'modules/genApp/js/directives/cvIvhTreeView.js';
import 'modules/disasterRecovery/js/factory/drCRUD.factory.js';

import { genAppServerModule } from 'common/js/modules';

var genAppModule = genAppServerModule;

genAppModule.controller('addGenAppServerCtrl', [
	'$scope',
	'cvUtil',
	'cvLoc',
	'$timeout',
	'AppTypesUtil',
	'clientGroupService',
	'genAppService',
	'data',
	'$uibModalInstance',
	function($scope, cvUtil, cvLoc, $timeout, AppTypesUtil, clientGroupService, genAppService, data, $modalInstance) {
		$scope.selectedClientList = [];
		$scope.showLoader = true;
		$scope.genAppOppType = data.genAppOppType;
		if (!data.epNode) {
			$scope.isEditing = false;
			$scope.epNode = {
				cvClient: null,
				fsEntitySelectionTree: [],
				fsSelectedEntitiesAsReceived: [],
				fsTreeData: null
			};
		} else {
			$scope.isEditing = true;
			$scope.epNode = angular.copy(data.epNode);

			$scope.epNode.fsEntitySelectionTree = [];
			$scope.epNode.fsSelectedEntitiesAsReceived = [];
			if ($scope.epNode.appContent && $scope.epNode.appContent.length && $scope.epNode.appContent[0]) {
				$scope.epNode.appContent.forEach(function(appCont) {
					if (appCont && appCont.subclients) {
						appCont.subclients.forEach(function(subClientNode) {
							subClientNode.subclient.entityTypeName = 'SUBCLIENT_ENTITY';
							$scope.epNode.fsSelectedEntitiesAsReceived.push(subClientNode.subclient);
						});
					}
				});
			}
			if ($scope.epNode.dbContent && $scope.epNode.dbContent.length && $scope.epNode.dbContent[0]) {
				$scope.epNode.dbContent.forEach(function(dbCont) {
					if (dbCont && dbCont.dbSubclients) {
						dbCont.dbSubclients.forEach(function(subClientNode) {
							subClientNode.subclient.entityTypeName = 'SUBCLIENT_ENTITY';
							$scope.epNode.fsSelectedEntitiesAsReceived.push(subClientNode.subclient);
						});
					}
				});
			}
			$scope.epNode.oraTreeData = null;
		}

		$scope.populatClients = function() {
			if ($scope.clientList == null) {
				clientGroupService
					.getClientsForClientGroup(0)
					.success(function(data) {
						self.serverMessage = cvUtil.emptyMsg();
						if (data.length) {
							/**
							 * Validation method to return true for supporting agent types
							 * only(Ex :- FS and Oracle)
							 */
							var isClientValid = function(clientNode) {
								var returnValue = false;
								if (
									clientNode &&
									clientNode.clientProps &&
									clientNode.client &&
									clientNode.client.idaList &&
									clientNode.client.idaList.length > 0 &&
									!clientNode.clientProps.IsDeletedClient &&
									clientNode.clientProps.clientStatus != 2
								) {
									clientNode.client.idaList.forEach(function(idaInfo) {
										if (
											AppTypesUtil.isFileSystemAgent(idaInfo.idaEntity.applicationId) ||
											idaInfo.idaEntity.applicationId === 22 ||
											idaInfo.idaEntity.applicationId === 81
										) {
											returnValue = true;
											return;
										}
									});
								}
								return returnValue;
							};
							var clientList = [];
							data.forEach(function(entry) {
								if (isClientValid(entry)) {
									clientList.push(entry.client.clientEntity);
								}
							});
							var clientId;
							$scope.clientList = cvUtil.sortAscending(clientList, 'clientName');
							if (!$scope.isEditing) {
								$scope.clientList[0].ticked = true;
								clientId = $scope.clientList[0].clientId;
								$scope.epNode.cvClient = $scope.clientList[0];
							} else {
								clientId = $scope.epNode.cvClient.clientId;
								$scope.clientList.forEach(function(client) {
									if (client.clientId == clientId) {
										client.ticked = true;
									}
								});
							}
							loadTreeData(clientId);
						}
					})
					.error(function(data) {
						self.serverMessage = cvUtil.errMsgLoc('error.getServers');
					});
			}
		};

		//Creates the restore selection tree
		var createTreeData = function(genAppNode) {
			var agentNodes = [];
			if (genAppNode.appContent && genAppNode.appContent.length && genAppNode.appContent[0]) {
				genAppNode.appContent.forEach(function(appCont) {
					if (appCont && appCont.subclients) {
						var contentNodes = [];
						var subNodeEnity = null;
						appCont.subclients.forEach(function(subClientNode) {
							if (subClientNode) {
								subClientNode.subclient.entityTypeName = 'SUBCLIENT_ENTITY';
								if (subClientNode.content) {
									subClientNode.content.forEach(function(contentNode) {
										contentNodes.push({
											childrenLoaded: false,
											entity: subClientNode.subclient,
											id: subClientNode.subclient.subclientId,
											isNodeSelectable: true,
											__ivhTreeviewExpanded: true,
											label: contentNode.value,
											selected: false
										});
									});
								}
								subNodeEnity = subClientNode.subclient;
							}
						});
						if (subNodeEnity) {
							var backupSetNodes = [];
							var backupSetEntity = {
								applicationId: subNodeEnity.applicationId,
								clientId: subNodeEnity.clientId,
								backupsetId: subNodeEnity.backupsetId,
								clientName: subNodeEnity.clientName,
								entityTypeName: 'BACKUPSET_ENTITY'
							};
							backupSetNodes.push({
								children: contentNodes,
								childrenLoaded: true,
								entity: backupSetEntity,
								id: backupSetEntity.backupsetId,
								isNodeSelectable: false,
								__ivhTreeviewExpanded: true,
								label: subNodeEnity.backupsetName,
								selected: false
							});
							var agentEntity = {
								applicationId: subNodeEnity.applicationId,
								clientId: subNodeEnity.clientId,
								clientName: subNodeEnity.clientName,
								entityTypeName: 'APPTYPE_ENTITY'
							};
							agentNodes.push({
								children: backupSetNodes,
								childrenLoaded: true,
								__ivhTreeviewExpanded: true,
								entity: agentEntity,
								id: subNodeEnity.applicationId,
								isNodeSelectable: false,
								label: subNodeEnity.appName,
								selected: false
							});
						}
					}
				});
			}

			if (genAppNode.dbContent && genAppNode.dbContent.length && genAppNode.dbContent[0]) {
				genAppNode.dbContent.forEach(function(dbNode) {
					if (dbNode && dbNode.dbSubclients) {
						var contentNodes = [];
						var subNodeEnity = null;
						dbNode.dbSubclients.forEach(function(subClientNode) {
							if (subClientNode) {
								subClientNode.subclient.entityTypeName = 'SUBCLIENT_ENTITY';
								if (subClientNode.content) {
									subClientNode.content.forEach(function(contentNode) {
										contentNodes.push({
											childrenLoaded: false,
											entity: subClientNode.subclient,
											id: subClientNode.subclient.subclientId,
											isNodeSelectable: true,
											__ivhTreeviewExpanded: true,
											label: contentNode.value,
											selected: false
										});
									});
								}
								subNodeEnity = subClientNode.subclient;
							}
						});
						if (subNodeEnity) {
							var instanceList = [];
							instanceList.push({
								children: contentNodes,
								childrenLoaded: true,
								entity: dbNode.instance,
								id: dbNode.instance.instanceId,
								isNodeSelectable: false,
								__ivhTreeviewExpanded: true,
								label: dbNode.instance.instanceName,
								selected: false
							});

							var agentEntity = {
								applicationId: subNodeEnity.applicationId,
								clientId: subNodeEnity.clientId,
								clientName: subNodeEnity.clientName,
								entityTypeName: 'APPTYPE_ENTITY'
							};
							agentNodes.push({
								children: instanceList,
								childrenLoaded: true,
								entity: agentEntity,
								id: subNodeEnity.applicationId,
								isNodeSelectable: false,
								__ivhTreeviewExpanded: true,
								label: subNodeEnity.appName,
								selected: false
							});
						}
					}
				});
			}

			genAppNode.cvClient.entityTypeName = 'CLIENT_ENTITY';
			var clientNodes = [
				{
					children: agentNodes,
					childrenLoaded: true,
					entity: genAppNode.cvClient,
					id: genAppNode.cvClient.clientId,
					isNodeSelectable: false,
					__ivhTreeviewExpanded: true,
					label: genAppNode.cvClient.clientName,
					selected: false
				}
			];

			return clientNodes;
		};

		var loadTreeData = function(clientId) {
			if ($scope.genAppOppType && $scope.genAppOppType == 'RESTORE') {
				$timeout(function() {
					var treeData = {
						children: createTreeData($scope.epNode),
						childrenLoaded: true,
						entity: { entityTypeName: 'CONTENT' },
						id: 2,
						isNodeSelectable: false,
						__ivhTreeviewExpanded: true,
						label: cvLoc('label.content'),
						selected: false
					};
					$scope.epNode.fsTreeData = treeData;
					$scope.epNode.fsEntitySelectionTree.initTree(
						$scope.epNode.fsTreeData,
						$scope.epNode.fsSelectedEntitiesAsReceived
					);
				});
			} else {
				var genEntity = {
					clientId: clientId
				};
				var parsObject = {
					genericEntity: JSON.stringify(genEntity),
					criteria: 'FromAgents',
					loadChildren: true
				};

				genAppService.getGenAppIvhTreeViewData(parsObject).success(function(entityTree) {
					if (entityTree && entityTree[0]) {
						$scope.epNode.fsTreeData = entityTree[0];
						$scope.epNode.fsTreeData.label = cvLoc('label.content');
						$scope.epNode.fsEntitySelectionTree.initTree(
							$scope.epNode.fsTreeData,
							$scope.epNode.fsSelectedEntitiesAsReceived
						);
					}
					$scope.showLoader = false;
				});
			}
		};

		if (data.clientList && data.clientList.length > 0) {
			$scope.clientList = angular.copy(data.clientList);
			$scope.clientList.forEach(function(client) {
				if (
					(client.clientId && $scope.epNode.cvClient.clientId && client.clientId == $scope.epNode.cvClient.clientId) ||
					(client.clientName &&
						$scope.epNode.cvClient.clientName &&
						client.clientName == $scope.epNode.cvClient.clientName)
				) {
					client.ticked = true;
				} else {
					client.ticked = false;
				}
			});
			loadTreeData($scope.epNode.cvClient.clientId);
		} else {
			$scope.populatClients();
		}

		$scope.localLang = cvUtil.getIStevenLocLabels();
		$scope.validateClientSelection = function() {
			var isValid = $scope.clientList.some(function(curr) {
				return curr['ticked'] === true;
			});

			$scope.showAddServerErrorMessage = !isValid;
			return isValid;
		};

		$scope.parseIStevenOutput = function() {
			if ($scope.selectedClientList.length) {
				$scope.epNode.cvClient = $scope.selectedClientList[0];
			} else {
				$scope.epNode.cvClient = undefined;
			}

			if ($scope.epNode.cvClient) {
				loadTreeData($scope.epNode.cvClient.clientId);
			}
		};

		$scope.closeModal = function() {
			$modalInstance.close(null);
		};

		$scope.isInputValid = function() {
			if (!$scope.validateClientSelection()) {
				return false;
			}
			$scope.showContentErrorMessage = false;
			var fsSelectedNodes = $scope.epNode.fsEntitySelectionTree.getSelectedNodes();
			if (!fsSelectedNodes || fsSelectedNodes.length <= 0) {
				return false;
			}

			return true;
		};

		$scope.saveServer = function() {
			if ($scope.isInputValid()) {
				var dbContents = [];
				var dbSubClients = [];

				var appContent = [];
				var appSubClients = [];
				var instanceEntity = null;

				var fsSelectedNodes = $scope.epNode.fsEntitySelectionTree.getSelectedNodes();
				if (fsSelectedNodes) {
					fsSelectedNodes.forEach(function(subclientNode) {
						var subEntity = {
							subclient: subclientNode.entity
						};
						if (AppTypesUtil.isFileSystemAgent(subclientNode.entity.applicationId)) {
							appSubClients.push(subEntity);
							if ($scope.genAppOppType && $scope.genAppOppType == 'RESTORE') {
								subEntity.content = [
									{
										name: 'SUBCLIENTCONTENT',
										value: subclientNode.label,
										type: 1
									}
								];
							} else {
								subEntity.content = subclientNode.content;
							}
						} else {
							instanceEntity = subclientNode.entity;
							dbSubClients.push(subEntity);
							if ($scope.genAppOppType && $scope.genAppOppType == 'RESTORE') {
								subEntity.content = [
									{
										name: 'SUBCLIENTCONTENT',
										value: subclientNode.label,
										type: 7
									}
								];
							} else {
								subEntity.content = subclientNode.content;
							}
						}
					});
					var appCont = {
						subclients: appSubClients
					};
					appContent.push(appCont);
					var dbCont = {
						instance: instanceEntity,
						dbSubclients: dbSubClients
					};
					dbContents.push(dbCont);
				}

				var genAppNode = {
					cvClient: $scope.epNode.cvClient,
					srcClient: $scope.epNode.srcClient
				};

				if (dbSubClients && dbSubClients.length > 0) {
					genAppNode.dbContent = dbContents;
				}
				if (appSubClients && appSubClients.length > 0) {
					genAppNode.appContent = appContent;
				}
				$modalInstance.close(genAppNode);
			}
		};
	}
]);

genAppModule.controller('updateGenAppTagsCtrl', [
	'$scope',
	'cvUtil',
	'$rootScope',
	'data',
	'$uibModalInstance',
	function($scope, cvUtil, $rootScope, data, $modalInstance) {
		if (!data) {
			$scope.isEditing = false;
			$scope.tagData = [{}];
		} else {
			$scope.isEditing = true;
			$scope.tagData = angular.copy(data);
		}

		$scope.addTagItem = function() {
			$scope.tagData.push({});
		};
		$scope.deleteTag = function(tagData) {
			var removeIndex = $scope.tagData.indexOf(tagData);
			if (removeIndex >= 0) {
				$scope.tagData.splice(removeIndex, 1);
			}
		};

		$scope.closeModal = function() {
			$modalInstance.close(null);
		};
		$scope.saveModle = function() {
			$modalInstance.close($scope.tagData);
		};
	}
]);

genAppModule.controller('addGenAppCtrl', [
	'$dialogs',
	'drCRUDFactory',
	'cvBreadcrumbsTabsFactory',
	'clientGroupService',
	'$log',
	'cvLoc',
	'cvToaster',
	'$uibModal',
	'cvTableOptions',
	'cvUtil',
	'genAppService',
	'$stateParams',
	'$state',
	function(
		$dialogs,
		drCRUDFactory,
		cvBreadcrumbsTabsFactory,
		clientGroupService,
		$log,
		cvLoc,
		cvToaster,
		$modal,
		cvTableOptions,
		cvUtil,
		genAppService,
		$stateParams,
		$state
	) {
		var self = this;
		self.genAppId = $stateParams.genAppId;
		self.editApp = false;
		if (self.genAppId) {
			self.editApp = true;
		}
		var breadCrumbs = [];
		breadCrumbs.push({
			title: cvLoc('header.applications'),
			link: '#genApps'
		});
		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);

		self.genAppData = {
			appName: ''
		};
		self.genAppName = '';
		self.serverList = null;
		self.tagList = null;
		var createServersTable = function() {
			var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
			var columnDefs = [];
			columnDefs.push({
				field: 'serverName',
				displayName: cvLoc('label.serverName'),
				cellTemplate: '<span title="{{row.entity.cvClient.clientName}}" >{{row.entity.cvClient.clientName}}</span>',
				enableHiding: false,
				cellTooltip: true,
				width: '25%'
			});

			columnDefs.push({
				field: 'nodeType',
				displayName: cvLoc('label.serverType'),
				cellTemplate: '<span title="{{row.entity.nodeType}}">{{row.entity.nodeType}}</span>',
				width: '64%'
			});

			columnDefs.push({
				field: 'edit',
				displayName: '',
				cellTemplate:
					'<span title="' +
					cvLoc('label.editServer') +
					'" data-ng-click="grid.appScope.editServer(row.entity)" ><i class="fa fa-pencil"></i></span>',
				width: '5%'
			});
			columnDefs.push({
				field: 'delete',
				displayName: '',
				cellTemplate:
					'<span title="' +
					cvLoc('label.deleteServer') +
					'"  class="delete-row" data-ng-click="grid.appScope.deleteServer(row.entity)" > × </span>',
				width: '5%'
			});

			angular.extend(globalGridOptions, {
				data: 'serverList',
				columnDefs: columnDefs,
				enableGridMenu: false
			});

			var cvPageLinks = [
				{
					label: cvLoc('label.addServer'),
					id: 'tour_add_GenApps',
					onclick: self.addServer
				}
			];

			self.serverGridOptions = {
				//cvPageLinks : cvPageLinks,
				cvAppScope: self,
				cvIsSearchable: false,
				cvTableName: 'genGenAddServersTable',
				cvOnGridEmpty: {
					message: cvLoc('label.addGenAppSerEmptyMsg')
				},
				gridOptions: globalGridOptions
			};
		};

		self.deleteServer = function(epNode) {
			var clientName = epNode.cvClient.clientName;
			for (var i = 0; i < self.serverList.length; i++) {
				if (self.serverList[i].cvClient.clientName == clientName) {
					self.serverList.splice(i, 1);
					return;
				}
			}
		};

		self.editServer = function(volumeObj) {
			self.addServer(volumeObj);
		};

		self.addServer = function() {
			self.addServer(null);
		};
		self.addServer = function(epNode) {
			var templateUrl = 'modules/genApp/partials/addGenAppServer.jsp';
			var controller = 'addGenAppServerCtrl';
			var opts = new Object();

			var dataObject = {
				epNode: epNode,
				genAppOppType: 'ADD_GENAPP',
				clientList: self.clientList
			};

			var modelInsta = $dialogs.create(appUtil.appRoot + templateUrl, controller, dataObject, opts);
			modelInsta.result.then(function(dataObject) {
				if (dataObject) {
					// In Edit case volumeObj will not be null,
					// so remove it and add new one.
					if (epNode) {
						self.deleteServer(epNode);
					}
					updateNodeType(dataObject);
					var dbContents = [];
					var appContent = [];
					var genAppNode = {
						cvClient: dataObject.cvClient,
						dbContent: dbContents,
						appContent: appContent
					};
					self.serverList.push(dataObject);
				}
				if (self.serverListMessage && self.serverList && self.serverList.length > 0) {
					self.serverListMessage = cvUtil.emptyMsg();
				}
			});
		};

		var updateNodeType = function(genAppNode) {
			var nodeType = cvLoc('nodeType.app');
			if (
				genAppNode &&
				genAppNode.appContent &&
				genAppNode.dbContent &&
				genAppNode.dbContent[0].dbSubclients &&
				genAppNode.dbContent[0].dbSubclients.length > 0
			) {
				nodeType = cvLoc('nodeType.appDB');
			} else if (
				genAppNode &&
				genAppNode.dbContent &&
				genAppNode.dbContent[0].dbSubclients &&
				genAppNode.dbContent[0].dbSubclients.length > 0
			) {
				nodeType = cvLoc('nodeType.db');
			}
			genAppNode.nodeType = nodeType;
		};
		createServersTable();

		var createConfigTable = function() {
			var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
			var columnDefs = [];
			columnDefs.push({
				field: 'tagName',
				displayName: cvLoc('label.tagName'),
				cellTemplate: '<span title="{{row.entity.name}}" >{{row.entity.name}}</span>',
				enableHiding: false,
				cellTooltip: true,
				width: '25%'
			});
			columnDefs.push({
				field: 'tagValue',
				displayName: cvLoc('label.tagValue'),
				cellTemplate: '<span title="{{row.entity.value}}" >{{row.entity.value}}</span>',
				width: '64%'
			});

			columnDefs.push({
				field: 'edit',
				displayName: '',
				cellTemplate:
					'<span title="Edit server" data-ng-click="grid.appScope.editTag(row.entity)" ><i class="fa fa-pencil"></i></span>',
				width: '5%'
			});
			columnDefs.push({
				field: 'delete',
				displayName: '',
				cellTemplate:
					'<span title="Delete server"  class="delete-row" data-ng-click="grid.appScope.deleteTag(row.entity)" > × </span>',
				width: '5%'
			});

			angular.extend(globalGridOptions, {
				data: 'tagList',
				columnDefs: columnDefs,
				enableGridMenu: false
			});

			self.configGridOptions = {
				cvAppScope: self,
				cvIsSearchable: false,
				cvTableName: 'genGenAddServersTable',
				cvOnGridEmpty: {
					message: cvLoc('label.addGenAppTagsEmptyMsg')
				},
				gridOptions: globalGridOptions
			};
		};

		self.deleteTag = function(tagData) {
			var tagName = tagData.name;
			for (var i = 0; i < self.tagList.length; i++) {
				if (self.tagList[i].name == tagName) {
					self.tagList.splice(i, 1);
					return;
				}
			}
		};

		self.editTag = function(volumeObj) {
			self.addTag(volumeObj);
		};

		self.addTag = function() {
			self.addTag(null);
		};
		self.addTag = function(tagData) {
			var templateUrl = 'modules/genApp/partials/addGenAppTagConfig.jsp';
			var controller = 'updateGenAppTagsCtrl';
			var opts = new Object();
			var tagDatas = null;
			if (tagData) {
				tagDatas = [];
				tagDatas.push(tagData);
			}
			var modelInsta = $dialogs.create(appUtil.appRoot + templateUrl, controller, tagDatas, opts);
			modelInsta.result.then(function(dataObject) {
				if (dataObject) {
					// In Edit case volumeObj will not be
					// null, so remove it and add new one.
					if (tagData) {
						self.deleteTag(tagData);
					}
					dataObject.forEach(function(entry) {
						self.tagList.push(entry);
					});
				}
			});
		};

		createConfigTable();
		self.tagList = [];

		self.clientList = null;
		self.populatClients = function() {};
		self.populatClients();

		self.loadAppDetails = function(genAppId) {
			drCRUDFactory.getFailoverGroupDetails(genAppId).then(function() {
				self.serverMessage = cvUtil.emptyMsg();
				self.genAppDetails = drCRUDFactory.failoverGroupDetails.genericApp;
				if (self.genAppDetails) {
					self.genAppName = self.genAppDetails.name;
					self.serverList = self.genAppDetails.enterpriseNodes;
					self.serverList.forEach(function(entry) {
						updateNodeType(entry);
					});
					self.tagList = self.genAppDetails.tags;
				} else {
					self.serverList = [];
					self.tagList = [];
				}
			});
		};
		if (self.editApp) {
			self.loadAppDetails(self.genAppId);
		} else {
			self.serverList = [];
			self.tagList = [];
		}

		var updateGenAppNode = function() {
			var genAppDataModel = {
				enterpriseNodes: self.serverList,
				tags: self.tagList,
				name: self.genAppName,
				appType: 3
			};
			var vApp = {
				operationType: 128,
				genericApp: genAppDataModel,
				vAppEntity: {
					vAppId: self.genAppId,
					vAppName: self.genAppName
				}
			};
			failoverService
				.updateFailoverGroup({
					virtualApp: JSON.stringify(vApp)
				})
				.success(function(data) {
					cvToaster.showSuccessMessage({
						ttl: '10000',
						message: cvLoc('label.genAppUpdated')
					});
					loadGenAppDetails();
				})
				.error(function(e) {
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: e ? e : cvLoc('generic_error')
					});
				});
		};
		var saveGenAppNode = function() {
			var genAppDataModel = {
				enterpriseNodes: self.serverList,
				tags: self.tagList,
				name: self.genAppName,
				appType: 3
			};
			var modify = self.editApp;
			var genAppEntity = {
				vAppName: self.genAppName
			};
			if (self.editApp) {
				genAppEntity.vAppId = self.genAppId;
			}
			genAppService
				.saveGenApp({
					genAppData: JSON.stringify(genAppDataModel),
					genAppEntity: JSON.stringify(genAppEntity),
					modify: modify
				})
				.success(function(data) {
					cvToaster.showSuccessMessage({
						ttl: '15000',
						message: cvLoc('label.genAppAdded')
					});
					// self.cancelModel(self.data);
					$state.go('genApps');
				})
				.error(function(e) {
					self.addEBSMessage = {
						message: e,
						type: 'error'
					};
				});
		};

		self.saveGenApp = function() {
			if (self.serverList && self.serverList.length <= 0) {
				self.serverListMessage = cvUtil.errMsg(cvLoc('error.addServers'));
				return;
			}

			saveGenAppNode();
		};
	}
]);

export default genAppModule;
